/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.ArrayList;
import org.apache.poi.hssf.record.cf.CellRangeUtil;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFConditionalFormattingRule;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STConditionalFormattingOperator;

public class XSSFSheetConditionalFormatting
implements SheetConditionalFormatting {
    private final XSSFSheet _sheet;

    XSSFSheetConditionalFormatting(XSSFSheet sheet) {
        this._sheet = sheet;
    }

    @Override
    public XSSFConditionalFormattingRule createConditionalFormattingRule(byte comparisonOperation, String formula1, String formula2) {
        STConditionalFormattingOperator.Enum operator2;
        XSSFConditionalFormattingRule rule = new XSSFConditionalFormattingRule(this._sheet);
        CTCfRule cfRule = rule.getCTCfRule();
        cfRule.addFormula(formula1);
        if (formula2 != null) {
            cfRule.addFormula(formula2);
        }
        cfRule.setType(STCfType.CELL_IS);
        switch (comparisonOperation) {
            case 1: {
                operator2 = STConditionalFormattingOperator.BETWEEN;
                break;
            }
            case 2: {
                operator2 = STConditionalFormattingOperator.NOT_BETWEEN;
                break;
            }
            case 6: {
                operator2 = STConditionalFormattingOperator.LESS_THAN;
                break;
            }
            case 8: {
                operator2 = STConditionalFormattingOperator.LESS_THAN_OR_EQUAL;
                break;
            }
            case 5: {
                operator2 = STConditionalFormattingOperator.GREATER_THAN;
                break;
            }
            case 7: {
                operator2 = STConditionalFormattingOperator.GREATER_THAN_OR_EQUAL;
                break;
            }
            case 3: {
                operator2 = STConditionalFormattingOperator.EQUAL;
                break;
            }
            case 4: {
                operator2 = STConditionalFormattingOperator.NOT_EQUAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown comparison operator: " + comparisonOperation);
            }
        }
        cfRule.setOperator(operator2);
        return rule;
    }

    @Override
    public XSSFConditionalFormattingRule createConditionalFormattingRule(byte comparisonOperation, String formula) {
        return this.createConditionalFormattingRule(comparisonOperation, formula, null);
    }

    @Override
    public XSSFConditionalFormattingRule createConditionalFormattingRule(String formula) {
        XSSFConditionalFormattingRule rule = new XSSFConditionalFormattingRule(this._sheet);
        CTCfRule cfRule = rule.getCTCfRule();
        cfRule.addFormula(formula);
        cfRule.setType(STCfType.EXPRESSION);
        return rule;
    }

    @Override
    public int addConditionalFormatting(CellRangeAddress[] regions, ConditionalFormattingRule[] cfRules) {
        if (regions == null) {
            throw new IllegalArgumentException("regions must not be null");
        }
        for (CellRangeAddress range : regions) {
            range.validate(SpreadsheetVersion.EXCEL2007);
        }
        if (cfRules == null) {
            throw new IllegalArgumentException("cfRules must not be null");
        }
        if (cfRules.length == 0) {
            throw new IllegalArgumentException("cfRules must not be empty");
        }
        if (cfRules.length > 3) {
            throw new IllegalArgumentException("Number of rules must not exceed 3");
        }
        CellRangeAddress[] mergeCellRanges = CellRangeUtil.mergeCellRanges(regions);
        CTConditionalFormatting cf = this._sheet.getCTWorksheet().addNewConditionalFormatting();
        ArrayList<String> refs = new ArrayList<String>();
        for (CellRangeAddress a : mergeCellRanges) {
            refs.add(a.formatAsString());
        }
        cf.setSqref(refs);
        int priority = 1;
        for (CTConditionalFormatting cTConditionalFormatting : this._sheet.getCTWorksheet().getConditionalFormattingArray()) {
            priority += cTConditionalFormatting.sizeOfCfRuleArray();
        }
        for (ConditionalFormattingRule conditionalFormattingRule : cfRules) {
            XSSFConditionalFormattingRule xRule = (XSSFConditionalFormattingRule)conditionalFormattingRule;
            xRule.getCTCfRule().setPriority(priority++);
            cf.addNewCfRule().set((XmlObject)xRule.getCTCfRule());
        }
        return this._sheet.getCTWorksheet().sizeOfConditionalFormattingArray() - 1;
    }

    @Override
    public int addConditionalFormatting(CellRangeAddress[] regions, ConditionalFormattingRule rule1) {
        XSSFConditionalFormattingRule[] xSSFConditionalFormattingRuleArray;
        if (rule1 == null) {
            xSSFConditionalFormattingRuleArray = null;
        } else {
            XSSFConditionalFormattingRule[] xSSFConditionalFormattingRuleArray2 = new XSSFConditionalFormattingRule[1];
            xSSFConditionalFormattingRuleArray = xSSFConditionalFormattingRuleArray2;
            xSSFConditionalFormattingRuleArray2[0] = (XSSFConditionalFormattingRule)rule1;
        }
        return this.addConditionalFormatting(regions, xSSFConditionalFormattingRuleArray);
    }

    @Override
    public int addConditionalFormatting(CellRangeAddress[] regions, ConditionalFormattingRule rule1, ConditionalFormattingRule rule2) {
        XSSFConditionalFormattingRule[] xSSFConditionalFormattingRuleArray;
        if (rule1 == null) {
            xSSFConditionalFormattingRuleArray = null;
        } else {
            XSSFConditionalFormattingRule[] xSSFConditionalFormattingRuleArray2 = new XSSFConditionalFormattingRule[2];
            xSSFConditionalFormattingRuleArray2[0] = (XSSFConditionalFormattingRule)rule1;
            xSSFConditionalFormattingRuleArray = xSSFConditionalFormattingRuleArray2;
            xSSFConditionalFormattingRuleArray2[1] = (XSSFConditionalFormattingRule)rule2;
        }
        return this.addConditionalFormatting(regions, xSSFConditionalFormattingRuleArray);
    }

    @Override
    public int addConditionalFormatting(ConditionalFormatting cf) {
        XSSFConditionalFormatting xcf = (XSSFConditionalFormatting)cf;
        CTWorksheet sh = this._sheet.getCTWorksheet();
        sh.addNewConditionalFormatting().set(xcf.getCTConditionalFormatting().copy());
        return sh.sizeOfConditionalFormattingArray() - 1;
    }

    @Override
    public XSSFConditionalFormatting getConditionalFormattingAt(int index) {
        this.checkIndex(index);
        CTConditionalFormatting cf = this._sheet.getCTWorksheet().getConditionalFormattingArray(index);
        return new XSSFConditionalFormatting(this._sheet, cf);
    }

    @Override
    public int getNumConditionalFormattings() {
        return this._sheet.getCTWorksheet().sizeOfConditionalFormattingArray();
    }

    @Override
    public void removeConditionalFormatting(int index) {
        this.checkIndex(index);
        this._sheet.getCTWorksheet().removeConditionalFormatting(index);
    }

    private void checkIndex(int index) {
        int cnt = this.getNumConditionalFormattings();
        if (index < 0 || index >= cnt) {
            throw new IllegalArgumentException("Specified CF index " + index + " is outside the allowable range (0.." + (cnt - 1) + ")");
        }
    }
}

