/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream;

import aavax.xml.stream.XMLReporter;
import aavax.xml.stream.XMLResolver;
import aavax.xml.stream.util.XMLEventAllocator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class ConfigurationContextBase {
    private static HashSet supportedFeatures;
    private static String EVENT_FILTER;
    private static String STREAM_FILTER;
    private static String NOTATIONS;
    private static String ENTITIES;
    static final String REPORT_CDATA = "http://java.sun.com/xml/stream/properties/report-cdata-event";
    private Hashtable features = new Hashtable();

    public ConfigurationContextBase() {
        this.features.put("aavax.xml.stream.isValidating", Boolean.FALSE);
        this.features.put("aavax.xml.stream.isCoalescing", Boolean.FALSE);
        this.features.put("aavax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        this.features.put("aavax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.features.put("aavax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.features.put("aavax.xml.stream.supportDTD", Boolean.FALSE);
        this.features.put("aavax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
    }

    public void setEventAllocator(XMLEventAllocator a) {
        this.features.put("aavax.xml.stream.allocator", a);
    }

    public XMLEventAllocator getEventAllocator() {
        return (XMLEventAllocator)this.features.get("aavax.xml.stream.allocator");
    }

    public void setProperty(String name, Object feature) {
        if (name.equals("aavax.xml.stream.isValidating")) {
            this.setValidating((Boolean)feature);
        } else if (name.equals("aavax.xml.stream.isSupportingExternalEntities")) {
            this.setSupportExternalEntities((Boolean)feature);
        } else if (name.equals("aavax.xml.stream.isNamespaceAware")) {
            this.setNamespaceAware((Boolean)feature);
        } else {
            this.check(name);
            this.features.put(name, feature);
        }
    }

    public void check(String name) {
        if (!supportedFeatures.contains(name)) {
            throw new IllegalArgumentException("Unable to access unsupported property " + name);
        }
    }

    public Object getProperty(String name) {
        this.check(name);
        return this.features.get(name);
    }

    public void setXMLReporter(XMLReporter r) {
        this.features.put("aavax.xml.stream.reporter", r);
    }

    public XMLReporter getXMLReporter() {
        return (XMLReporter)this.features.get("aavax.xml.stream.reporter");
    }

    public void setXMLResolver(XMLResolver r) {
        this.features.put("aavax.xml.stream.resolver", r);
    }

    public XMLResolver getXMLResolver() {
        return (XMLResolver)this.features.get("aavax.xml.stream.resolver");
    }

    public boolean getBool(String name) {
        this.check(name);
        Boolean val = (Boolean)this.features.get(name);
        return val;
    }

    public void setBool(String name, boolean val) {
        this.check(name);
        this.features.put(name, val ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setCoalescing(boolean val) {
        this.setBool("aavax.xml.stream.isCoalescing", val);
    }

    public boolean isCoalescing() {
        return this.getBool("aavax.xml.stream.isCoalescing");
    }

    public void setValidating(boolean val) {
        if (val) {
            throw new IllegalArgumentException("This implementation does not support validation");
        }
    }

    public boolean isValidating() {
        return this.getBool("aavax.xml.stream.isValidating");
    }

    public void setReplacingEntities(boolean val) {
        this.setBool("aavax.xml.stream.isReplacingEntityReferences", val);
    }

    public boolean isReplacingEntities() {
        return this.getBool("aavax.xml.stream.isReplacingEntityReferences");
    }

    public void setSupportExternalEntities(boolean val) {
        if (val) {
            throw new IllegalArgumentException("This implementation does not resolve external entities ");
        }
    }

    public boolean isSupportingExternalEntities() {
        return this.getBool("aavax.xml.stream.isSupportingExternalEntities");
    }

    public void setPrefixDefaulting(boolean val) {
        this.setBool("aavax.xml.stream.isRepairingNamespaces", val);
    }

    public boolean isPrefixDefaulting() {
        return this.getBool("aavax.xml.stream.isRepairingNamespaces");
    }

    public void setNamespaceAware(boolean val) {
        if (!val) {
            throw new IllegalArgumentException("This implementation does not allow disabling namespace processing");
        }
    }

    public boolean isNamespaceAware() {
        return this.getBool("aavax.xml.stream.isNamespaceAware");
    }

    public String getVersion() {
        return "1.0";
    }

    public Enumeration getProperties() {
        return this.features.keys();
    }

    public boolean isPropertySupported(String name) {
        return supportedFeatures.contains(name);
    }

    static {
        EVENT_FILTER = "RI_EVENT_FILTER";
        STREAM_FILTER = "RI_STREAM_FILTER";
        NOTATIONS = "aavax.xml.stream.notations";
        ENTITIES = "aavax.xml.stream.entities";
        supportedFeatures = new HashSet();
        supportedFeatures.add("aavax.xml.stream.isValidating");
        supportedFeatures.add("aavax.xml.stream.isCoalescing");
        supportedFeatures.add("aavax.xml.stream.isReplacingEntityReferences");
        supportedFeatures.add("aavax.xml.stream.isSupportingExternalEntities");
        supportedFeatures.add("aavax.xml.stream.isRepairingNamespaces");
        supportedFeatures.add("aavax.xml.stream.isNamespaceAware");
        supportedFeatures.add("aavax.xml.stream.supportDTD");
        supportedFeatures.add("aavax.xml.stream.reporter");
        supportedFeatures.add("aavax.xml.stream.resolver");
        supportedFeatures.add("aavax.xml.stream.allocator");
        supportedFeatures.add(NOTATIONS);
        supportedFeatures.add(ENTITIES);
        supportedFeatures.add(REPORT_CDATA);
    }
}

