/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream;

import aavax.xml.namespace.QName;
import aavax.xml.stream.Location;
import aavax.xml.stream.XMLStreamException;
import aavax.xml.stream.events.Attribute;
import aavax.xml.stream.events.Characters;
import aavax.xml.stream.events.EndElement;
import aavax.xml.stream.events.StartElement;
import java.io.IOException;
import java.io.Writer;

public class AttributeBase
implements Attribute,
Location {
    private String value;
    private QName name;
    private QName attributeType;
    private String locationURI;
    private int eventType = -1;
    private int line = -1;
    private int column = -1;
    private int characterOffset = 0;

    public AttributeBase(String prefix, String namespaceURI, String localName, String value, String attributeType) {
        if (prefix == null) {
            prefix = "";
        }
        this.name = new QName(namespaceURI, localName, prefix);
        this.value = value;
        this.attributeType = new QName(attributeType);
    }

    public AttributeBase(String prefix, String localName, String value) {
        if (prefix == null) {
            prefix = "";
        }
        this.name = new QName("", localName, prefix);
        this.value = value;
    }

    public AttributeBase(QName name, String value) {
        this.name = name;
        this.value = value;
    }

    public String toString() {
        if (this.name.getPrefix() != null && !this.name.getPrefix().equals("")) {
            return "['" + this.name.getNamespaceURI() + "']:" + this.name.getPrefix() + ":" + this.name.getLocalPart() + "='" + this.value + "'";
        }
        return this.name.getLocalPart() + "='" + this.value + "'";
    }

    public int getLineNumber() {
        return this.line;
    }

    public void setLineNumber(int line) {
        this.line = line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public void setColumnNumber(int col) {
        this.column = col;
    }

    public int getCharacterOffset() {
        return this.characterOffset;
    }

    public void setCharacterOffset(int c) {
        this.characterOffset = c;
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String uri) {
        this.locationURI = uri;
    }

    public int getEventType() {
        return 10;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public QName getName() {
        return this.name;
    }

    public boolean isNamespaceDeclaration() {
        return false;
    }

    public String getLocalName() {
        return this.name.getLocalPart();
    }

    public String getValue() {
        return this.value;
    }

    public String getDTDType() {
        return "CDATA";
    }

    public String getNamespaceURI() {
        return this.name.getNamespaceURI();
    }

    public void setNamespaceURI(String uri) {
        this.name = new QName(uri, this.name.getLocalPart());
    }

    public boolean isSpecified() {
        return true;
    }

    public boolean isStartElement() {
        return false;
    }

    public boolean isEndElement() {
        return false;
    }

    public boolean isEntityReference() {
        return false;
    }

    public boolean isProcessingInstruction() {
        return false;
    }

    public boolean isCharacters() {
        return false;
    }

    public boolean isAttribute() {
        return true;
    }

    public boolean isNamespace() {
        return false;
    }

    public boolean isStartDocument() {
        return false;
    }

    public boolean isEndDocument() {
        return false;
    }

    public boolean isEndEntity() {
        return false;
    }

    public boolean isStartEntity() {
        return false;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public Location getLocation() {
        return this;
    }

    public StartElement asStartElement() {
        throw new ClassCastException("cannnot cast AttributeBase to StartElement");
    }

    public EndElement asEndElement() {
        throw new ClassCastException("cannnot cast AttributeBase to EndElement");
    }

    public Characters asCharacters() {
        throw new ClassCastException("cannnot cast AttributeBase to Characters");
    }

    public void recycle() {
    }

    public boolean isDefault() {
        return true;
    }

    public String getSourceName() {
        return null;
    }

    public QName getSchemaType() {
        return null;
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            String prefix = this.name.getPrefix();
            if (prefix != null && prefix.length() > 0) {
                writer.write(prefix);
                writer.write(58);
            }
            writer.write(this.name.getLocalPart());
            writer.write("=\"");
            String data = this.value;
            int len = data.length();
            if (len > 0) {
                char c;
                int i;
                block10: for (i = 0; i < len; ++i) {
                    c = data.charAt(i);
                    switch (c) {
                        case '\"': 
                        case '&': 
                        case '<': {
                            break block10;
                        }
                        default: {
                            if (c < ' ') break block10;
                            continue block10;
                        }
                    }
                }
                if (i == len) {
                    writer.write(data);
                } else {
                    if (i > 0) {
                        writer.write(data, 0, i);
                    }
                    while (i < len) {
                        c = data.charAt(i);
                        switch (c) {
                            case '&': {
                                writer.write("&amp;");
                                break;
                            }
                            case '<': {
                                writer.write("&lt;");
                                break;
                            }
                            case '\"': {
                                writer.write("&quot;");
                                break;
                            }
                            default: {
                                if (c < ' ') {
                                    AttributeBase.writeEncodedChar(writer, c);
                                    break;
                                }
                                writer.write(c);
                            }
                        }
                        ++i;
                    }
                }
            }
            writer.write(34);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public static void writeEncodedChar(Writer writer, char c) throws IOException {
        writer.write("&#");
        writer.write(Integer.toString(c));
        writer.write(59);
    }
}

