/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.sqlite;

import android.database.Cursor;
import com.lidroid.xutils.DbUtils;
import com.lidroid.xutils.db.sqlite.FinderLazyLoader;
import com.lidroid.xutils.db.sqlite.ForeignLazyLoader;
import com.lidroid.xutils.db.table.Column;
import com.lidroid.xutils.db.table.DbModel;
import com.lidroid.xutils.db.table.Finder;
import com.lidroid.xutils.db.table.Foreign;
import com.lidroid.xutils.db.table.Id;
import com.lidroid.xutils.db.table.Table;
import com.lidroid.xutils.util.LogUtils;
import com.lidroid.xutils.util.core.DoubleKeyValueMap;

public class CursorUtils {
    public static <T> T getEntity(DbUtils db, Cursor cursor, Class<T> entityType, long findCacheSequence) {
        if (db == null || cursor == null) {
            return null;
        }
        EntityTempCache.setSeq(findCacheSequence);
        try {
            Table table = Table.get(db, entityType);
            Id id = table.getId();
            String idColumnName = id.getColumnName();
            int idIndex = cursor.getColumnIndex(idColumnName);
            String idStr = cursor.getString(idIndex);
            T entity = EntityTempCache.get(entityType, idStr);
            if (entity != null) {
                return entity;
            }
            entity = entityType.newInstance();
            id.setValue2Entity(entity, cursor, idIndex);
            EntityTempCache.put(entity, idStr);
            int columnCount = cursor.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                String columnName = cursor.getColumnName(i);
                Column column = table.columnMap.get(columnName);
                if (column != null) {
                    if (column instanceof Foreign) {
                        Foreign foreign = (Foreign)column;
                        foreign.db = db;
                        foreign.setValue2Entity(entity, cursor, i);
                    } else {
                        column.setValue2Entity(entity, cursor, i);
                    }
                }
                ++i;
            }
            for (Column column : table.columnMap.values()) {
                if (!(column instanceof Finder)) continue;
                Finder finder = (Finder)column;
                finder.db = db;
                finder.setValue2Entity(entity, null, 0);
            }
            return entity;
        }
        catch (Throwable e) {
            LogUtils.e(e.getMessage(), e);
            return null;
        }
    }

    public static DbModel getDbModel(Cursor cursor) {
        DbModel result = null;
        if (cursor != null) {
            result = new DbModel();
            int columnCount = cursor.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                result.add(cursor.getColumnName(i), cursor.getString(i));
                ++i;
            }
        }
        return result;
    }

    private static class EntityTempCache {
        private static final DoubleKeyValueMap<Class<?>, String, Object> cache = new DoubleKeyValueMap();
        private static long seq = 0L;

        private EntityTempCache() {
        }

        public static void put(Object entity, String idStr) {
            if (entity != null && idStr != null) {
                cache.put(entity.getClass(), idStr, entity);
            }
        }

        public static <T> T get(Class<T> entityType, String idStr) {
            return (T)cache.get(entityType, idStr);
        }

        public static void setSeq(long seq) {
            if (EntityTempCache.seq != seq) {
                cache.clear();
                EntityTempCache.seq = seq;
            }
        }
    }

    public static class FindCacheSequence {
        private static long seq = 0L;
        private static final String FOREIGN_LAZY_LOADER_CLASS_NAME = ForeignLazyLoader.class.getName();
        private static final String FINDER_LAZY_LOADER_CLASS_NAME = FinderLazyLoader.class.getName();

        public static long getSeq() {
            String findMethodCaller = Thread.currentThread().getStackTrace()[4].getClassName();
            if (!findMethodCaller.equals(FOREIGN_LAZY_LOADER_CLASS_NAME) && !findMethodCaller.equals(FINDER_LAZY_LOADER_CLASS_NAME)) {
                ++seq;
            }
            return seq;
        }
    }
}

