/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream;

import aavax.xml.namespace.NamespaceContext;
import aavax.xml.namespace.QName;
import aavax.xml.stream.Location;
import aavax.xml.stream.XMLStreamException;
import aavax.xml.stream.XMLStreamReader;
import aavax.xml.stream.events.EntityDeclaration;
import aavax.xml.stream.events.NotationDeclaration;
import com.bea.xml.stream.AttributeBase;
import com.bea.xml.stream.ConfigurationContextBase;
import com.bea.xml.stream.NamespaceBase;
import com.bea.xml.stream.ReadOnlyNamespaceContextBase;
import com.bea.xml.stream.SubReader;
import com.bea.xml.stream.events.DTDEvent;
import com.bea.xml.stream.reader.XmlReader;
import com.bea.xml.stream.util.ElementTypeNames;
import com.bea.xml.stream.util.EmptyIterator;
import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttlist;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDNotation;
import com.wutka.dtd.DTDParser;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MXParser
implements XMLStreamReader,
Location {
    protected static final char CHAR_UTF8_BOM = '\ufeff';
    protected static final int MAX_UNICODE_CHAR = 0x10FFFF;
    protected static final String FEATURE_XML_ROUNDTRIP = "http://xmlpull.org/v1/doc/features.html#xml-roundtrip";
    protected static final String FEATURE_NAMES_INTERNED = "http://xmlpull.org/v1/doc/features.html#names-interned";
    public static final String FEATURE_PROCESS_DOCDECL = "http://xmlpull.org/v1/doc/features.html#process-docdecl";
    public static final String FEATURE_STAX_NOTATIONS = "aavax.xml.stream.notations";
    public static final String FEATURE_STAX_ENTITIES = "aavax.xml.stream.entities";
    static final String EOF_MSG = "Unexpected end of stream";
    private boolean reportCdataEvent = false;
    public static final String[] TYPES;
    private static final int TEXT = 16384;
    private static final int DOCDECL = 32768;
    public static final String NO_NAMESPACE;
    protected boolean allStringsInterned;
    private static final boolean TRACE_SIZING = false;
    public static final String FEATURE_PROCESS_NAMESPACES = "http://xmlpull.org/v1/doc/features.html#process-namespaces";
    protected boolean processNamespaces = true;
    protected boolean roundtripSupported = true;
    protected int lineNumber;
    protected int columnNumber;
    protected boolean seenRoot;
    protected boolean reachedEnd;
    protected int eventType;
    protected boolean emptyElementTag;
    protected int depth;
    protected char[][] elRawName;
    protected int[] elRawNameEnd;
    protected String[] elName;
    protected String[] elPrefix;
    protected String[] elUri;
    protected int[] elNamespaceCount;
    protected String xmlVersion = null;
    protected boolean standalone = false;
    protected boolean standaloneSet = false;
    protected String charEncodingScheme;
    protected String piTarget;
    protected String piData;
    protected DTD mDtdIntSubset;
    protected HashMap defaultAttributes;
    protected static final int LOOKUP_MAX = 1024;
    protected static final char LOOKUP_MAX_CHAR = '\u0400';
    protected static boolean[] lookupNameStartChar;
    protected static boolean[] lookupNameChar;
    protected int attributeCount;
    protected String[] attributeName;
    protected int[] attributeNameHash;
    protected String[] attributePrefix;
    protected String[] attributeUri;
    protected String[] attributeValue;
    private static final String[] NO_STRINGS;
    private static final int[] NO_INTS;
    private static final char[] NO_CHARS;
    protected int namespaceEnd;
    protected String[] namespacePrefix = NO_STRINGS;
    protected int[] namespacePrefixHash;
    protected String[] namespaceUri = NO_STRINGS;
    protected int localNamespaceEnd;
    protected String[] localNamespacePrefix;
    protected int[] localNamespacePrefixHash;
    protected String[] localNamespaceUri;
    protected int entityEnd;
    protected String[] entityName;
    protected char[][] entityNameBuf;
    protected int[] entityNameHash;
    protected char[][] entityReplacementBuf;
    protected String[] entityReplacement;
    protected static final int READ_CHUNK_SIZE = 8192;
    protected Reader reader;
    protected String inputEncoding;
    protected int bufLoadFactor = 95;
    protected char[] buf = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 256];
    protected int bufSoftLimit = this.bufLoadFactor * this.buf.length / 100;
    protected int bufAbsoluteStart;
    protected int bufStart;
    protected int bufEnd;
    protected int pos;
    protected int posStart;
    protected int posEnd;
    protected char[] pc = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 64];
    protected int pcStart;
    protected int pcEnd;
    protected boolean usePC;
    protected boolean seenStartTag;
    protected boolean seenEndTag;
    protected boolean pastEndTag;
    protected boolean seenAmpersand;
    protected boolean seenMarkup;
    protected boolean seenDocdecl;
    protected boolean tokenize;
    protected String text;
    protected String entityRefName;
    protected char[] entityValue = null;
    protected char[] charRefOneCharBuf = new char[1];
    protected char[] charRefTwoCharBuf = null;
    protected static final char[] VERSION;
    protected static final char[] ENCODING;
    protected static final char[] STANDALONE;
    protected static final char[] YES;
    protected static final char[] NO;
    private ConfigurationContextBase configurationContext;
    static /* synthetic */ Class class$com$wutka$dtd$DTDEntity;
    static /* synthetic */ Class class$com$wutka$dtd$DTDAttlist;
    static /* synthetic */ Class class$com$wutka$dtd$DTDNotation;

    protected void resetStringCache() {
    }

    protected String newString(char[] cbuf, int off, int len) {
        return new String(cbuf, off, len);
    }

    protected String newStringIntern(char[] cbuf, int off, int len) {
        return new String(cbuf, off, len).intern();
    }

    protected void ensureElementsCapacity() {
        int elStackSize;
        int n = elStackSize = this.elName != null ? this.elName.length : 0;
        if (this.depth + 1 >= elStackSize) {
            int newSize = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
            boolean needsCopying = elStackSize > 0;
            String[] arr = null;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.elName, 0, arr, 0, elStackSize);
            }
            this.elName = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.elPrefix, 0, arr, 0, elStackSize);
            }
            this.elPrefix = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.elUri, 0, arr, 0, elStackSize);
            }
            this.elUri = arr;
            int[] iarr = new int[newSize];
            if (needsCopying) {
                System.arraycopy(this.elNamespaceCount, 0, iarr, 0, elStackSize);
            } else {
                iarr[0] = 0;
            }
            this.elNamespaceCount = iarr;
            iarr = new int[newSize];
            if (needsCopying) {
                System.arraycopy(this.elRawNameEnd, 0, iarr, 0, elStackSize);
            }
            this.elRawNameEnd = iarr;
            char[][] carr = new char[newSize][];
            if (needsCopying) {
                System.arraycopy(this.elRawName, 0, carr, 0, elStackSize);
            }
            this.elRawName = carr;
        }
    }

    private static final void setName(char ch) {
        MXParser.lookupNameChar[ch] = true;
    }

    private static final void setNameStart(char ch) {
        MXParser.lookupNameStartChar[ch] = true;
        MXParser.setName(ch);
    }

    protected boolean isNameStartChar(char ch) {
        return ch < '\u0400' && lookupNameStartChar[ch] || ch >= '\u0400' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    protected boolean isNameChar(char ch) {
        return ch < '\u0400' && lookupNameChar[ch] || ch >= '\u0400' && ch <= '\u2027' || ch >= '\u202a' && ch <= '\u218f' || ch >= '\u2800' && ch <= '\uffef';
    }

    protected boolean isS(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    protected void checkCharValidity(int ch, boolean surrogatesOk) throws XMLStreamException {
        if (ch < 32) {
            if (!this.isS((char)ch)) {
                throw new XMLStreamException("Illegal white space character (code 0x" + Integer.toHexString(ch) + ")");
            }
        } else if (ch >= 55296) {
            if (ch <= 57343) {
                if (!surrogatesOk) {
                    throw new XMLStreamException("Illegal character (code 0x" + Integer.toHexString(ch) + "): surrogate characters are not valid XML characters", this.getLocation());
                }
            } else if (ch > 0x10FFFF) {
                throw new XMLStreamException("Illegal character (code 0x" + Integer.toHexString(ch) + "), past max. Unicode character 0x" + Integer.toHexString(0x10FFFF), this.getLocation());
            }
        }
    }

    protected void ensureAttributesCapacity(int size) {
        int attrPosSize;
        int n = attrPosSize = this.attributeName != null ? this.attributeName.length : 0;
        if (size >= attrPosSize) {
            int newSize = size > 7 ? 2 * size : 8;
            boolean needsCopying = attrPosSize > 0;
            String[] arr = null;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributeName, 0, arr, 0, attrPosSize);
            }
            this.attributeName = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributePrefix, 0, arr, 0, attrPosSize);
            }
            this.attributePrefix = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributeUri, 0, arr, 0, attrPosSize);
            }
            this.attributeUri = arr;
            arr = new String[newSize];
            if (needsCopying) {
                System.arraycopy(this.attributeValue, 0, arr, 0, attrPosSize);
            }
            this.attributeValue = arr;
            if (!this.allStringsInterned) {
                int[] iarr = new int[newSize];
                if (needsCopying) {
                    System.arraycopy(this.attributeNameHash, 0, iarr, 0, attrPosSize);
                }
                this.attributeNameHash = iarr;
            }
            arr = null;
        }
    }

    protected void ensureNamespacesCapacity(int size) {
        int namespaceSize;
        int n = namespaceSize = this.namespacePrefix != null ? this.namespacePrefix.length : 0;
        if (size >= namespaceSize) {
            int newSize = size > 7 ? 2 * size : 8;
            String[] newNamespacePrefix = new String[newSize];
            String[] newNamespaceUri = new String[newSize];
            if (this.namespacePrefix != null) {
                System.arraycopy(this.namespacePrefix, 0, newNamespacePrefix, 0, this.namespaceEnd);
                System.arraycopy(this.namespaceUri, 0, newNamespaceUri, 0, this.namespaceEnd);
            }
            this.namespacePrefix = newNamespacePrefix;
            this.namespaceUri = newNamespaceUri;
            if (!this.allStringsInterned) {
                int[] newNamespacePrefixHash = new int[newSize];
                if (this.namespacePrefixHash != null) {
                    System.arraycopy(this.namespacePrefixHash, 0, newNamespacePrefixHash, 0, this.namespaceEnd);
                }
                this.namespacePrefixHash = newNamespacePrefixHash;
            }
        }
    }

    protected void ensureLocalNamespacesCapacity(int size) {
        int localNamespaceSize;
        int n = localNamespaceSize = this.localNamespacePrefix != null ? this.localNamespacePrefix.length : 0;
        if (size >= localNamespaceSize) {
            int newSize = size > 7 ? 2 * size : 8;
            String[] newLocalNamespacePrefix = new String[newSize];
            String[] newLocalNamespaceUri = new String[newSize];
            if (this.localNamespacePrefix != null) {
                System.arraycopy(this.localNamespacePrefix, 0, newLocalNamespacePrefix, 0, this.localNamespaceEnd);
                System.arraycopy(this.localNamespaceUri, 0, newLocalNamespaceUri, 0, this.localNamespaceEnd);
            }
            this.localNamespacePrefix = newLocalNamespacePrefix;
            this.localNamespaceUri = newLocalNamespaceUri;
            if (!this.allStringsInterned) {
                int[] newLocalNamespacePrefixHash = new int[newSize];
                if (this.localNamespacePrefixHash != null) {
                    System.arraycopy(this.localNamespacePrefixHash, 0, newLocalNamespacePrefixHash, 0, this.localNamespaceEnd);
                }
                this.localNamespacePrefixHash = newLocalNamespacePrefixHash;
            }
        }
    }

    public int getLocalNamespaceCount() {
        int startNs = this.elNamespaceCount[this.depth - 1];
        return this.namespaceEnd - startNs;
    }

    private String getLocalNamespaceURI(int pos) {
        return this.namespaceUri[pos];
    }

    private String getLocalNamespacePrefix(int pos) {
        return this.namespacePrefix[pos];
    }

    protected static final int fastHash(char[] ch, int off, int len) {
        if (len == 0) {
            return 0;
        }
        int hash = ch[off];
        hash = (hash << 7) + ch[off + len - 1];
        if (len > 16) {
            hash = (hash << 7) + ch[off + len / 4];
        }
        if (len > 8) {
            hash = (hash << 7) + ch[off + len / 2];
        }
        return hash;
    }

    protected void ensureEntityCapacity() {
        int entitySize;
        int n = entitySize = this.entityReplacementBuf != null ? this.entityReplacementBuf.length : 0;
        if (this.entityEnd >= entitySize) {
            int newSize = this.entityEnd > 7 ? 2 * this.entityEnd : 8;
            String[] newEntityName = new String[newSize];
            char[][] newEntityNameBuf = new char[newSize][];
            String[] newEntityReplacement = new String[newSize];
            char[][] newEntityReplacementBuf = new char[newSize][];
            if (this.entityName != null) {
                System.arraycopy(this.entityName, 0, newEntityName, 0, this.entityEnd);
                System.arraycopy(this.entityNameBuf, 0, newEntityNameBuf, 0, this.entityEnd);
                System.arraycopy(this.entityReplacement, 0, newEntityReplacement, 0, this.entityEnd);
                System.arraycopy(this.entityReplacementBuf, 0, newEntityReplacementBuf, 0, this.entityEnd);
            }
            this.entityName = newEntityName;
            this.entityNameBuf = newEntityNameBuf;
            this.entityReplacement = newEntityReplacement;
            this.entityReplacementBuf = newEntityReplacementBuf;
            if (!this.allStringsInterned) {
                int[] newEntityNameHash = new int[newSize];
                if (this.entityNameHash != null) {
                    System.arraycopy(this.entityNameHash, 0, newEntityNameHash, 0, this.entityEnd);
                }
                this.entityNameHash = newEntityNameHash;
            }
        }
    }

    private void reset() {
        this.lineNumber = 1;
        this.columnNumber = 0;
        this.seenRoot = false;
        this.reachedEnd = false;
        this.eventType = 7;
        this.emptyElementTag = false;
        this.depth = 0;
        this.attributeCount = 0;
        this.namespaceEnd = 0;
        this.localNamespaceEnd = 0;
        this.entityEnd = 0;
        this.reader = null;
        this.inputEncoding = null;
        this.bufAbsoluteStart = 0;
        this.bufStart = 0;
        this.bufEnd = 0;
        this.posEnd = 0;
        this.posStart = 0;
        this.pos = 0;
        this.pcStart = 0;
        this.pcEnd = 0;
        this.usePC = false;
        this.seenStartTag = false;
        this.seenEndTag = false;
        this.pastEndTag = false;
        this.seenAmpersand = false;
        this.seenMarkup = false;
        this.seenDocdecl = false;
        this.resetStringCache();
    }

    public void setFeature(String name, boolean state) throws XMLStreamException {
        if (name == null) {
            throw new IllegalArgumentException("feature name should not be nulll");
        }
        if (FEATURE_PROCESS_NAMESPACES.equals(name)) {
            if (this.eventType != 7) {
                throw new XMLStreamException("namespace processing feature can only be changed before parsing", this.getLocation());
            }
            this.processNamespaces = state;
        } else if (FEATURE_NAMES_INTERNED.equals(name)) {
            if (state) {
                throw new XMLStreamException("interning names in this implementation is not supported");
            }
        } else if (FEATURE_PROCESS_DOCDECL.equals(name)) {
            if (state) {
                throw new XMLStreamException("processing DOCDECL is not supported");
            }
        } else if (FEATURE_XML_ROUNDTRIP.equals(name)) {
            if (!state) {
                throw new XMLStreamException("roundtrip feature can not be switched off");
            }
        } else {
            throw new XMLStreamException("unknown feature " + name);
        }
    }

    public boolean getFeature(String name) {
        if (name == null) {
            throw new IllegalArgumentException("feature name should not be null");
        }
        if (FEATURE_PROCESS_NAMESPACES.equals(name)) {
            return this.processNamespaces;
        }
        if (FEATURE_NAMES_INTERNED.equals(name)) {
            return false;
        }
        if (FEATURE_PROCESS_DOCDECL.equals(name)) {
            return false;
        }
        return FEATURE_XML_ROUNDTRIP.equals(name);
    }

    public void setProperty(String name, Object value) throws XMLStreamException {
        throw new XMLStreamException("unsupported property: '" + name + "'");
    }

    public boolean checkForXMLDecl() throws XMLStreamException {
        try {
            BufferedReader breader = new BufferedReader(this.reader, 7);
            this.reader = breader;
            breader.mark(7);
            int ch = breader.read();
            if (ch == 65279) {
                breader.mark(7);
                ch = breader.read();
            }
            if (ch == 60 && breader.read() == 63 && breader.read() == 120 && breader.read() == 109 && breader.read() == 108) {
                breader.reset();
                return true;
            }
            breader.reset();
            return false;
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void setInput(Reader in) throws XMLStreamException {
        this.reset();
        this.reader = in;
        if (this.checkForXMLDecl()) {
            this.next();
        }
    }

    public void setInput(InputStream in) throws XMLStreamException {
        try {
            Reader r = XmlReader.createReader(in);
            String enc = null;
            if (r instanceof XmlReader.BaseReader) {
                enc = ((XmlReader.BaseReader)r).getEncoding();
            }
            this.setInput(r);
            if (enc != null) {
                this.inputEncoding = enc;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws XMLStreamException {
        Reader reader;
        if (inputStream == null) {
            throw new IllegalArgumentException("input stream can not be null");
        }
        try {
            reader = inputEncoding != null ? XmlReader.createReader(inputStream, inputEncoding) : XmlReader.createReader(inputStream);
        }
        catch (IOException ioe) {
            String encMsg = inputEncoding == null ? "(for encoding '" + inputEncoding + "')" : "";
            throw new XMLStreamException("could not create reader " + encMsg + ": " + ioe, this.getLocation(), ioe);
        }
        this.setInput(reader);
        if (inputEncoding != null) {
            this.inputEncoding = inputEncoding;
        }
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws XMLStreamException {
        this.ensureEntityCapacity();
        char[] ch = entityName.toCharArray();
        this.entityName[this.entityEnd] = this.newString(ch, 0, entityName.length());
        this.entityNameBuf[this.entityEnd] = ch;
        this.entityReplacement[this.entityEnd] = replacementText;
        ch = replacementText == null ? NO_CHARS : replacementText.toCharArray();
        this.entityReplacementBuf[this.entityEnd] = ch;
        if (!this.allStringsInterned) {
            this.entityNameHash[this.entityEnd] = MXParser.fastHash(this.entityNameBuf[this.entityEnd], 0, this.entityNameBuf[this.entityEnd].length);
        }
        ++this.entityEnd;
    }

    public int getNamespaceCount() {
        if (!MXParser.isElementEvent(this.eventType)) {
            this.throwIllegalState(new int[]{1, 2});
        }
        return this.getNamespaceCount(this.depth);
    }

    public int getNamespaceCount(int depth) {
        if (!this.processNamespaces || depth == 0) {
            return 0;
        }
        if (depth < 0) {
            throw new IllegalArgumentException("namespace count may be 0.." + this.depth + " not " + depth);
        }
        return this.elNamespaceCount[depth] - this.elNamespaceCount[depth - 1];
    }

    public String getNamespacePrefix(int pos) {
        if (!MXParser.isElementEvent(this.eventType)) {
            this.throwIllegalState(new int[]{1, 2});
        }
        int currentDepth = this.depth;
        int end = this.getNamespaceCount(currentDepth);
        int newpos = pos + this.elNamespaceCount[currentDepth - 1];
        if (pos < end) {
            return this.namespacePrefix[newpos];
        }
        throw new ArrayIndexOutOfBoundsException("position " + pos + " exceeded number of available namespaces " + end);
    }

    public String getNamespaceURI(int pos) {
        if (!MXParser.isElementEvent(this.eventType)) {
            this.throwIllegalState(new int[]{1, 2});
        }
        int currentDepth = this.depth;
        int end = this.getNamespaceCount(currentDepth);
        int newpos = pos + this.elNamespaceCount[currentDepth - 1];
        if (pos < end) {
            return this.namespaceUri[newpos];
        }
        throw new ArrayIndexOutOfBoundsException("position " + pos + " exceedded number of available namespaces " + end);
    }

    public String getNamespaceURI(String prefix) {
        if (!MXParser.isElementEvent(this.eventType)) {
            this.throwIllegalState(new int[]{1, 2});
        }
        if (prefix != null && prefix.length() > 0) {
            for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                if (!prefix.equals(this.namespacePrefix[i])) continue;
                return this.namespaceUri[i];
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if ("xmlns".equals(prefix)) {
                return "http://www.w3.org/2000/xmlns/";
            }
        } else {
            for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                if (this.namespacePrefix[i] != null) continue;
                return this.namespaceUri[i];
            }
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    private static int findFragment(int bufMinPos, char[] b, int start, int end) {
        char c;
        if (start < bufMinPos) {
            start = bufMinPos;
            if (start > end) {
                start = end;
            }
            return start;
        }
        if (end - start > 65) {
            start = end - 10;
        }
        int i = start + 1;
        while (--i > bufMinPos && end - i <= 65 && ((c = b[i]) != '<' || start - i <= 10)) {
        }
        return i;
    }

    public String getPositionDescription() {
        String fragment = null;
        if (this.posStart <= this.pos) {
            int start = MXParser.findFragment(0, this.buf, this.posStart, this.pos);
            if (start < this.pos) {
                fragment = new String(this.buf, start, this.pos - start);
            }
            if (this.bufAbsoluteStart > 0 || start > 0) {
                fragment = "..." + fragment;
            }
        }
        return " " + (fragment != null ? " seen " + this.printable(fragment) + "..." : "") + " @" + this.getLineNumber() + ":" + this.getColumnNumber();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getLocationURI() {
        return null;
    }

    public boolean isWhiteSpace() {
        if (this.eventType == 4 || this.eventType == 12) {
            if (this.usePC) {
                for (int i = this.pcStart; i < this.pcEnd; ++i) {
                    if (this.isS(this.pc[i])) continue;
                    return false;
                }
                return true;
            }
            for (int i = this.posStart; i < this.posEnd; ++i) {
                if (this.isS(this.buf[i])) continue;
                return false;
            }
            return true;
        }
        return this.eventType == 6;
    }

    public String getNamespaceURI() {
        if (this.eventType == 1 || this.eventType == 2) {
            return this.processNamespaces ? this.elUri[this.depth] : NO_NAMESPACE;
        }
        return this.throwIllegalState(new int[]{1, 2});
    }

    public String getLocalName() {
        if (this.eventType == 1) {
            return this.elName[this.depth];
        }
        if (this.eventType == 2) {
            return this.elName[this.depth];
        }
        if (this.eventType == 9) {
            if (this.entityRefName == null) {
                this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            }
            return this.entityRefName;
        }
        return this.throwIllegalState(new int[]{1, 2, 9});
    }

    public String getPrefix() {
        if (this.eventType == 1 || this.eventType == 2) {
            return this.elPrefix[this.depth];
        }
        return this.throwIllegalState(new int[]{1, 2});
    }

    public boolean isEmptyElementTag() throws XMLStreamException {
        if (this.eventType != 1) {
            throw new XMLStreamException("parser must be on XMLStreamConstants.START_ELEMENT to check for empty element", this.getLocation());
        }
        return this.emptyElementTag;
    }

    public int getAttributeCount() {
        if (this.eventType != 1) {
            this.throwIllegalState(1);
        }
        return this.attributeCount;
    }

    public String getAttributeNamespace(int index) {
        if (this.eventType != 1) {
            this.throwIllegalState(1);
        }
        if (!this.processNamespaces) {
            return NO_NAMESPACE;
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributeUri[index];
    }

    public String getAttributeLocalName(int index) {
        if (this.eventType != 1) {
            this.throwIllegalState(1);
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributeName[index];
    }

    public String getAttributePrefix(int index) {
        if (this.eventType != 1) {
            this.throwIllegalState(1);
        }
        if (!this.processNamespaces) {
            return null;
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributePrefix[index];
    }

    public String getAttributeType(int index) {
        if (this.eventType != 1) {
            this.throwIllegalState(1);
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return "CDATA";
    }

    public boolean isAttributeSpecified(int index) {
        if (this.eventType != 1) {
            this.throwIllegalState(1);
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return true;
    }

    public String getAttributeValue(int index) {
        if (this.eventType != 1) {
            this.throwIllegalState(1);
        }
        if (index < 0 || index >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + index);
        }
        return this.attributeValue[index];
    }

    public String getAttributeValue(String namespace, String name) {
        if (this.eventType != 1) {
            this.throwIllegalState(1);
        }
        if (name == null) {
            throw new IllegalArgumentException("attribute name can not be null");
        }
        if (namespace != null) {
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!name.equals(this.attributeName[i]) || !namespace.equals(this.attributeUri[i])) continue;
                return this.attributeValue[i];
            }
        } else {
            for (int i = 0; i < this.attributeCount; ++i) {
                if (!name.equals(this.attributeName[i])) continue;
                return this.attributeValue[i];
            }
        }
        return null;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void require(int type, String namespace, String name) throws XMLStreamException {
        boolean ok;
        int currType = this.getEventType();
        boolean bl = ok = type == currType;
        if (ok && name != null) {
            if (currType == 1 || currType == 2 || currType == 9) {
                ok = name.equals(this.getLocalName());
            } else {
                throw new XMLStreamException("Using non-null local name argument for require(); " + ElementTypeNames.getEventTypeString(currType) + " event does not have local name", this.getLocation());
            }
        }
        if (ok && namespace != null && (currType == 1 || currType == 1)) {
            String currNsUri = this.getNamespaceURI();
            ok = namespace.length() == 0 ? currNsUri == null : namespace.equals(currNsUri);
        }
        if (!ok) {
            throw new XMLStreamException("expected event " + ElementTypeNames.getEventTypeString(type) + (name != null ? " with name '" + name + "'" : "") + (namespace != null && name != null ? " and" : "") + (namespace != null ? " with namespace '" + namespace + "'" : "") + " but got" + (type != this.getEventType() ? " " + ElementTypeNames.getEventTypeString(this.getEventType()) : "") + (name != null && this.getLocalName() != null && !name.equals(this.getName()) ? " name '" + this.getLocalName() + "'" : "") + (namespace != null && name != null && this.getLocalName() != null && !name.equals(this.getName()) && this.getNamespaceURI() != null && !namespace.equals(this.getNamespaceURI()) ? " and" : "") + (namespace != null && this.getNamespaceURI() != null && !namespace.equals(this.getNamespaceURI()) ? " namespace '" + this.getNamespaceURI() + "'" : "") + " (position:" + this.getPositionDescription() + ")", this.getLocation());
        }
    }

    public String nextText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 2) {
                throw new XMLStreamException("TEXT must be immediately followed by END_ELEMENT and not " + ElementTypeNames.getEventTypeString(this.getEventType()), this.getLocation());
            }
            return result;
        }
        if (eventType == 2) {
            return "";
        }
        throw new XMLStreamException("parser must be on START_ELEMENT or TEXT to read text", this.getLocation());
    }

    public int nextTag() throws XMLStreamException {
        this.next();
        while (this.eventType == 6 || this.eventType == 5 || this.eventType == 3 || this.eventType == 4 && this.isWhiteSpace() || this.eventType == 12 && this.isWhiteSpace()) {
            this.next();
        }
        if (this.eventType != 1 && this.eventType != 2) {
            throw new XMLStreamException("expected XMLStreamConstants.START_ELEMENT or XMLStreamConstants.END_ELEMENT not " + ElementTypeNames.getEventTypeString(this.getEventType()), this.getLocation());
        }
        return this.eventType;
    }

    public String getElementText() throws XMLStreamException {
        StringBuffer buf = new StringBuffer();
        if (this.getEventType() != 1) {
            throw new XMLStreamException("Precondition for readText is getEventType() == START_ELEMENT");
        }
        do {
            if (this.next() == 8) {
                throw new XMLStreamException("Unexpected end of Document");
            }
            if (this.isStartElement()) {
                throw new XMLStreamException("Unexpected Element start");
            }
            if (!this.isCharacters() && this.getEventType() != 9) continue;
            buf.append(this.getText());
        } while (!this.isEndElement());
        return buf.toString();
    }

    public int next() throws XMLStreamException {
        this.tokenize = true;
        this.pcStart = 0;
        this.pcEnd = 0;
        this.usePC = false;
        return this.nextImpl();
    }

    public int nextToken() throws XMLStreamException {
        this.tokenize = true;
        return this.nextImpl();
    }

    public int nextElement() throws XMLStreamException {
        return this.nextTag();
    }

    public boolean hasNext() throws XMLStreamException {
        return this.eventType != 8;
    }

    public void skip() throws XMLStreamException {
        this.nextToken();
    }

    public void close() throws XMLStreamException {
    }

    public boolean isStartElement() {
        return this.eventType == 1;
    }

    public boolean isEndElement() {
        return this.eventType == 2;
    }

    public boolean isCharacters() {
        return this.eventType == 4;
    }

    public boolean isEOF() {
        return this.eventType == 8;
    }

    public boolean moveToStartElement() throws XMLStreamException {
        if (this.isStartElement()) {
            return true;
        }
        while (this.hasNext()) {
            if (this.isStartElement()) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public boolean moveToStartElement(String localName) throws XMLStreamException {
        if (localName == null) {
            return false;
        }
        while (this.moveToStartElement()) {
            if (localName.equals(this.getLocalName())) {
                return true;
            }
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        return false;
    }

    public boolean moveToStartElement(String localName, String namespaceUri) throws XMLStreamException {
        if (localName == null || namespaceUri == null) {
            return false;
        }
        while (this.moveToStartElement(localName)) {
            if (namespaceUri.equals(this.getNamespaceURI())) {
                return true;
            }
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        return false;
    }

    public boolean moveToEndElement() throws XMLStreamException {
        if (this.isEndElement()) {
            return true;
        }
        while (this.hasNext()) {
            if (this.isEndElement()) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public boolean moveToEndElement(String localName) throws XMLStreamException {
        if (localName == null) {
            return false;
        }
        while (this.moveToEndElement()) {
            if (localName.equals(this.getLocalName())) {
                return true;
            }
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        return false;
    }

    public boolean moveToEndElement(String localName, String namespaceUri) throws XMLStreamException {
        if (localName == null || namespaceUri == null) {
            return false;
        }
        while (this.moveToEndElement(localName)) {
            if (namespaceUri.equals(this.getNamespaceURI())) {
                return true;
            }
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        return false;
    }

    public boolean hasAttributes() {
        return this.getAttributeCount() > 0;
    }

    public boolean hasNamespaces() {
        return this.getNamespaceCount() > 0;
    }

    public Iterator getAttributes() {
        if (!this.hasAttributes()) {
            return EmptyIterator.emptyIterator;
        }
        int attributeCount = this.getAttributeCount();
        ArrayList<AttributeBase> atts = new ArrayList<AttributeBase>();
        for (int i = 0; i < attributeCount; ++i) {
            atts.add(new AttributeBase(this.getAttributePrefix(i), this.getAttributeNamespace(i), this.getAttributeLocalName(i), this.getAttributeValue(i), this.getAttributeType(i)));
        }
        return atts.iterator();
    }

    public Iterator internalGetNamespaces(int depth, int namespaceCount) {
        ArrayList<NamespaceBase> ns = new ArrayList<NamespaceBase>();
        int startNs = this.elNamespaceCount[depth - 1];
        for (int i = 0; i < namespaceCount; ++i) {
            String prefix = this.getLocalNamespacePrefix(i + startNs);
            if (prefix == null) {
                ns.add(new NamespaceBase(this.getLocalNamespaceURI(i + startNs)));
                continue;
            }
            ns.add(new NamespaceBase(prefix, this.getLocalNamespaceURI(i + startNs)));
        }
        return ns.iterator();
    }

    public Iterator getNamespaces() {
        if (!this.hasNamespaces()) {
            return EmptyIterator.emptyIterator;
        }
        int namespaceCount = this.getLocalNamespaceCount();
        return this.internalGetNamespaces(this.depth, namespaceCount);
    }

    public Iterator getOutOfScopeNamespaces() {
        int startNs = this.elNamespaceCount[this.depth - 1];
        int endNs = this.elNamespaceCount[this.depth];
        int namespaceCount = endNs - startNs;
        return this.internalGetNamespaces(this.depth, namespaceCount);
    }

    public XMLStreamReader subReader() throws XMLStreamException {
        return new SubReader(this);
    }

    public void recycle() throws XMLStreamException {
        this.reset();
    }

    public Reader getTextStream() {
        throw new UnsupportedOperationException();
    }

    private final void checkTextEvent() {
        if (!this.hasText()) {
            throw new IllegalStateException("Current state (" + MXParser.eventTypeDesc(this.eventType) + ") does not have textual content");
        }
    }

    private final void checkTextEventXxx() {
        if (this.eventType != 4 && this.eventType != 12 && this.eventType != 5 && this.eventType != 6) {
            throw new IllegalStateException("getTextXxx methods cannot be called for " + MXParser.eventTypeDesc(this.eventType));
        }
    }

    public String getText() {
        this.checkTextEvent();
        if (this.eventType == 9) {
            if (this.text == null && this.entityValue != null) {
                this.text = new String(this.entityValue);
            }
            return this.text;
        }
        this.text = this.usePC ? new String(this.pc, this.pcStart, this.pcEnd - this.pcStart) : new String(this.buf, this.posStart, this.posEnd - this.posStart);
        return this.text;
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        this.checkTextEventXxx();
        int intLen = this.getTextLength();
        if (sourceStart < 0 || sourceStart > intLen) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int avail = intLen - sourceStart;
        if (avail < length) {
            length = avail;
        }
        if (length > 0) {
            char[] intBuf = this.getTextCharacters();
            int intStart = this.getTextStart();
            System.arraycopy(intBuf, intStart + sourceStart, target, targetStart, length);
        }
        return length;
    }

    public char[] getTextCharacters() {
        this.checkTextEventXxx();
        if (this.eventType == 4) {
            if (this.usePC) {
                return this.pc;
            }
            return this.buf;
        }
        return this.buf;
    }

    public int getTextStart() {
        this.checkTextEventXxx();
        if (this.usePC) {
            return this.pcStart;
        }
        return this.posStart;
    }

    public int getTextLength() {
        this.checkTextEventXxx();
        if (this.usePC) {
            return this.pcEnd - this.pcStart;
        }
        return this.posEnd - this.posStart;
    }

    public boolean hasText() {
        return this.eventType == 4 || this.eventType == 11 || this.eventType == 12 || this.eventType == 5 || this.eventType == 6 || this.eventType == 9;
    }

    public String getValue() {
        return this.getText();
    }

    public String getEncoding() {
        return this.getInputEncoding();
    }

    public int getCharacterOffset() {
        return this.posEnd;
    }

    private static final String checkNull(String s) {
        if (s != null) {
            return s;
        }
        return "";
    }

    private static String eventTypeDesc(int type) {
        return type < 0 || type >= TYPES.length ? "[UNKNOWN]" : TYPES[type];
    }

    private static boolean isElementEvent(int type) {
        return type == 1 || type == 2;
    }

    public QName getAttributeName(int index) {
        if (this.eventType != 1) {
            this.throwIllegalState(1);
        }
        return new QName(MXParser.checkNull(this.getAttributeNamespace(index)), this.getAttributeLocalName(index), MXParser.checkNull(this.getAttributePrefix(index)));
    }

    public QName getName() {
        if (!MXParser.isElementEvent(this.eventType)) {
            throw new IllegalStateException("Current state not START_ELEMENT or END_ELEMENT");
        }
        return new QName(MXParser.checkNull(this.getNamespaceURI()), this.getLocalName(), MXParser.checkNull(this.getPrefix()));
    }

    public boolean hasName() {
        return MXParser.isElementEvent(this.eventType);
    }

    public String getVersion() {
        return this.xmlVersion;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public boolean standaloneSet() {
        return this.standaloneSet;
    }

    public String getCharacterEncodingScheme() {
        return this.charEncodingScheme;
    }

    /*
     * Unable to fully structure code
     */
    protected int nextImpl() throws XMLStreamException {
        try {
            block60: {
                this.text = null;
                this.bufStart = this.posEnd;
                if (this.pastEndTag) {
                    this.pastEndTag = false;
                    --this.depth;
                    this.namespaceEnd = this.elNamespaceCount[this.depth];
                }
                if (this.emptyElementTag) {
                    this.emptyElementTag = false;
                    this.pastEndTag = true;
                    this.eventType = 2;
                    return 2;
                }
                if (this.depth <= 0) break block60;
                if (this.seenStartTag) {
                    this.seenStartTag = false;
                    this.eventType = this.parseStartTag();
                    return this.eventType;
                }
                if (this.seenEndTag) {
                    this.seenEndTag = false;
                    this.eventType = this.parseEndTag();
                    return this.eventType;
                }
                if (this.seenMarkup) {
                    this.seenMarkup = false;
                    ch = '<';
                } else if (this.seenAmpersand) {
                    this.seenAmpersand = false;
                    ch = '&';
                } else {
                    ch = this.more();
                }
                this.posStart = this.pos - 1;
                hadCharData = false;
                needsMerging = false;
                while (true) {
                    if (ch != 60) ** GOTO lbl110
                    if (hadCharData && this.tokenize) {
                        this.seenMarkup = true;
                        this.eventType = 4;
                        return 4;
                    }
                    ch = this.more();
                    if (ch == '/') {
                        if (!this.tokenize && hadCharData) {
                            this.seenEndTag = true;
                            this.eventType = 4;
                            return 4;
                        }
                        this.eventType = this.parseEndTag();
                        return this.eventType;
                    }
                    if (ch != 33) ** GOTO lbl93
                    ch = this.more();
                    if (ch == '-') {
                        this.parseComment();
                        if (this.tokenize) {
                            this.eventType = 5;
                            return 5;
                        }
                        if (!this.usePC && hadCharData) {
                            needsMerging = true;
                        }
                    } else if (ch == '[') {
                        oldStart = this.posStart;
                        oldEnd = this.posEnd;
                        this.parseCDATA();
                        cdStart = this.posStart;
                        cdEnd = this.posEnd;
                        this.posStart = oldStart;
                        this.posEnd = oldEnd;
                        cdLen = cdEnd - cdStart;
                        if (cdLen > 0) {
                            if (hadCharData) {
                                if (!this.usePC) {
                                    if (this.posEnd > this.posStart) {
                                        this.joinPC();
                                    } else {
                                        this.usePC = true;
                                        this.pcEnd = 0;
                                        this.pcStart = 0;
                                    }
                                }
                                if (this.pcEnd + cdLen >= this.pc.length) {
                                    this.ensurePC(this.pcEnd + cdLen);
                                }
                                System.arraycopy(this.buf, cdStart, this.pc, this.pcEnd, cdLen);
                                this.pcEnd += cdLen;
                            } else {
                                needsMerging = true;
                                this.posStart = cdStart;
                                this.posEnd = cdEnd;
                            }
                            hadCharData = true;
                        } else if (!this.usePC && hadCharData) {
                            needsMerging = true;
                        }
                        if (this.reportCdataEvent) {
                            this.eventType = 12;
                            return 12;
                        }
                    } else {
                        throw new XMLStreamException("unexpected character in markup " + this.printable(ch), this.getLocation());
lbl93:
                        // 1 sources

                        if (ch == '?') {
                            this.parsePI();
                            if (this.tokenize) {
                                this.eventType = 3;
                                return 3;
                            }
                            if (!this.usePC && hadCharData) {
                                needsMerging = true;
                            }
                        } else {
                            if (this.isNameStartChar(ch)) {
                                if (!this.tokenize && hadCharData) {
                                    this.seenStartTag = true;
                                    this.eventType = 4;
                                    return 4;
                                }
                                this.eventType = this.parseStartTag();
                                return this.eventType;
                            }
                            throw new XMLStreamException("unexpected character in markup " + this.printable(ch), this.getLocation());
lbl110:
                            // 1 sources

                            if (ch == '&') {
                                if (this.tokenize && hadCharData) {
                                    this.seenAmpersand = true;
                                    this.eventType = 4;
                                    return 4;
                                }
                                oldStart = this.posStart;
                                oldEnd = this.posEnd;
                                replace = this.getConfigurationContext().isReplacingEntities();
                                resolvedEntity = this.parseEntityRef(replace);
                                if (!replace) {
                                    this.eventType = 9;
                                    return 9;
                                }
                                this.eventType = 4;
                                if (resolvedEntity == null) {
                                    if (this.entityRefName == null) {
                                        this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                                    }
                                    throw new XMLStreamException("could not resolve entity named '" + this.printable(this.entityRefName) + "'", this.getLocation());
                                }
                                this.posStart = oldStart;
                                this.posEnd = oldEnd;
                                if (!this.usePC) {
                                    if (hadCharData) {
                                        this.joinPC();
                                        needsMerging = false;
                                    } else {
                                        this.usePC = true;
                                        this.pcEnd = 0;
                                        this.pcStart = 0;
                                    }
                                }
                                for (i = 0; i < resolvedEntity.length; ++i) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = resolvedEntity[i];
                                }
                                hadCharData = true;
                            } else {
                                if (needsMerging) {
                                    this.joinPC();
                                    needsMerging = false;
                                }
                                hadCharData = true;
                                normalizedCR = false;
                                do {
                                    if (ch == '\r') {
                                        normalizedCR = true;
                                        this.posEnd = this.pos - 1;
                                        if (!this.usePC) {
                                            if (this.posEnd > this.posStart) {
                                                this.joinPC();
                                            } else {
                                                this.usePC = true;
                                                this.pcEnd = 0;
                                                this.pcStart = 0;
                                            }
                                        }
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC(this.pcEnd);
                                        }
                                        this.pc[this.pcEnd++] = 10;
                                        continue;
                                    }
                                    if (ch == '\n') {
                                        if (!normalizedCR && this.usePC) {
                                            if (this.pcEnd >= this.pc.length) {
                                                this.ensurePC(this.pcEnd);
                                            }
                                            this.pc[this.pcEnd++] = 10;
                                        }
                                        normalizedCR = false;
                                        continue;
                                    }
                                    if (this.usePC) {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC(this.pcEnd);
                                        }
                                        this.pc[this.pcEnd++] = ch;
                                    }
                                    normalizedCR = false;
                                } while ((ch = this.more()) != '<' && ch != 38);
                                this.posEnd = this.pos - 1;
                                continue;
                            }
                        }
                    }
                    ch = this.more();
                }
            }
            if (this.seenRoot) {
                return this.parseEpilog();
            }
            return this.parseProlog();
        }
        catch (EOFException eofe) {
            throw new XMLStreamException("Unexpected end of stream", this.getLocation(), eofe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int parseProlog() throws XMLStreamException {
        try {
            char ch = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
            if (this.eventType == 7) {
                if (ch == '\ufffe') {
                    throw new XMLStreamException("first character in input was UNICODE noncharacter (0xFFFE)- input requires int swapping", this.getLocation());
                }
                if (ch == '\ufeff') {
                    ch = this.more();
                }
            }
            this.seenMarkup = false;
            boolean gotS = false;
            this.posStart = this.pos - 1;
            while (true) {
                block20: {
                    block21: {
                        block22: {
                            if (ch != '<') break block21;
                            if (gotS && this.tokenize) {
                                this.posEnd = this.pos - 1;
                                this.seenMarkup = true;
                                this.eventType = 6;
                                return 6;
                            }
                            ch = this.more();
                            if (ch != '?') break block22;
                            boolean isXMLDecl = this.parsePI();
                            if (this.tokenize) {
                                if (isXMLDecl) {
                                    this.eventType = 7;
                                    return 7;
                                }
                                this.eventType = 3;
                                return 3;
                            }
                            break block20;
                        }
                        if (ch == '!') {
                            ch = this.more();
                            if (ch == 'D') {
                                if (this.seenDocdecl) {
                                    throw new XMLStreamException("only one docdecl allowed in XML document", this.getLocation());
                                }
                                this.seenDocdecl = true;
                                this.parseDocdecl();
                                if (this.tokenize) {
                                    this.eventType = 11;
                                    return 11;
                                }
                                break block20;
                            } else {
                                if (ch != '-') {
                                    throw new XMLStreamException("unexpected markup <!" + this.printable(ch), this.getLocation());
                                }
                                this.parseComment();
                                if (this.tokenize) {
                                    this.eventType = 5;
                                    return 5;
                                }
                            }
                            break block20;
                        } else {
                            if (ch == '/') {
                                throw new XMLStreamException("expected start tag name and not " + this.printable(ch), this.getLocation());
                            }
                            if (this.isNameStartChar(ch)) {
                                this.seenRoot = true;
                                return this.parseStartTag();
                            }
                            throw new XMLStreamException("expected start tag name and not " + this.printable(ch), this.getLocation());
                        }
                    }
                    if (!this.isS(ch)) {
                        throw new XMLStreamException("only whitespace content allowed before start tag and not " + this.printable(ch), this.getLocation());
                    }
                    gotS = true;
                }
                ch = this.more();
            }
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int parseEpilog() throws XMLStreamException {
        if (this.eventType == 8) {
            throw new XMLStreamException("already reached end document", this.getLocation());
        }
        if (this.reachedEnd) {
            this.eventType = 8;
            return 8;
        }
        boolean gotS = false;
        try {
            char ch = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
            this.seenMarkup = false;
            this.posStart = this.pos - 1;
            while (true) {
                block18: {
                    block19: {
                        block20: {
                            if (ch != '<') break block19;
                            if (gotS && this.tokenize) {
                                this.posEnd = this.pos - 1;
                                this.seenMarkup = true;
                                this.eventType = 6;
                                return 6;
                            }
                            ch = this.more();
                            if (ch != '?') break block20;
                            this.parsePI();
                            if (this.tokenize) {
                                this.eventType = 3;
                                return 3;
                            }
                            break block18;
                        }
                        if (ch == '!') {
                            ch = this.more();
                            if (ch == 'D') {
                                this.parseDocdecl();
                                if (this.tokenize) {
                                    this.eventType = 11;
                                    return 11;
                                }
                                break block18;
                            } else {
                                if (ch != '-') {
                                    throw new XMLStreamException("unexpected markup <!" + this.printable(ch), this.getLocation());
                                }
                                this.parseComment();
                                if (this.tokenize) {
                                    this.eventType = 5;
                                    return 5;
                                }
                            }
                            break block18;
                        } else {
                            if (ch == '/') {
                                throw new XMLStreamException("end tag not allowed in epilog but got " + this.printable(ch), this.getLocation());
                            }
                            if (this.isNameStartChar(ch)) {
                                throw new XMLStreamException("start tag not allowed in epilog but got " + this.printable(ch), this.getLocation());
                            }
                            throw new XMLStreamException("in epilog expected ignorable content and not " + this.printable(ch), this.getLocation());
                        }
                    }
                    if (!this.isS(ch)) {
                        throw new XMLStreamException("in epilog non whitespace content is not allowed but got " + this.printable(ch), this.getLocation());
                    }
                    gotS = true;
                }
                ch = this.more();
            }
        }
        catch (EOFException ex) {
            this.reachedEnd = true;
            if (this.tokenize && gotS) {
                this.posEnd = this.pos;
                this.eventType = 6;
                return 6;
            }
            this.eventType = 8;
            return 8;
        }
    }

    public int parseEndTag() throws XMLStreamException {
        this.eventType = 2;
        try {
            char ch = this.more();
            if (!this.isNameStartChar(ch)) {
                throw new XMLStreamException("expected name start and not " + this.printable(ch), this.getLocation());
            }
            this.posStart = this.pos - 3;
            int nameStart = this.pos - 1 + this.bufAbsoluteStart;
            while (this.isNameChar(ch = this.more())) {
            }
            int last = this.pos - 1;
            int off = nameStart - this.bufAbsoluteStart;
            int len = last - off;
            char[] cbuf = this.elRawName[this.depth];
            if (this.elRawNameEnd[this.depth] != len) {
                String startname = new String(cbuf, 0, this.elRawNameEnd[this.depth]);
                String endname = new String(this.buf, off, len);
                throw new XMLStreamException("end tag name '" + endname + "' must match start tag name '" + startname + "'", this.getLocation());
            }
            for (int i = 0; i < len; ++i) {
                if (this.buf[off++] == cbuf[i]) continue;
                String startname = new String(cbuf, 0, len);
                String endname = new String(this.buf, off - i - 1, len);
                throw new XMLStreamException("end tag name '" + endname + "' must be the same as start tag '" + startname + "'", this.getLocation());
            }
            while (this.isS(ch)) {
                ch = this.more();
            }
            if (ch != '>') {
                throw new XMLStreamException("expected > to finsh end tag not " + this.printable(ch), this.getLocation());
            }
            this.posEnd = this.pos;
            this.pastEndTag = true;
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
        return 2;
    }

    public int parseStartTag() throws XMLStreamException {
        this.eventType = 1;
        try {
            String prefix;
            String name;
            block33: {
                ++this.depth;
                this.posStart = this.pos - 2;
                this.emptyElementTag = false;
                this.attributeCount = 0;
                this.localNamespaceEnd = 0;
                int nameStart = this.pos - 1 + this.bufAbsoluteStart;
                int colonPos = -1;
                char ch = this.buf[this.pos - 1];
                if (ch == ':' && this.processNamespaces) {
                    throw new XMLStreamException("when namespaces processing enabled colon can not be at element name start", this.getLocation());
                }
                while (this.isNameChar(ch = this.more())) {
                    if (ch != ':' || !this.processNamespaces) continue;
                    if (colonPos != -1) {
                        throw new XMLStreamException("only one colon is allowed in name of element when namespaces are enabled", this.getLocation());
                    }
                    colonPos = this.pos - 1 + this.bufAbsoluteStart;
                }
                this.ensureElementsCapacity();
                int elLen = this.pos - 1 - (nameStart - this.bufAbsoluteStart);
                if (this.elRawName[this.depth] == null || this.elRawName[this.depth].length < elLen) {
                    this.elRawName[this.depth] = new char[2 * elLen];
                }
                System.arraycopy(this.buf, nameStart - this.bufAbsoluteStart, this.elRawName[this.depth], 0, elLen);
                this.elRawNameEnd[this.depth] = elLen;
                name = null;
                prefix = null;
                if (this.processNamespaces) {
                    if (colonPos != -1) {
                        prefix = this.elPrefix[this.depth] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, colonPos - nameStart);
                        name = this.elName[this.depth] = this.newString(this.buf, colonPos + 1 - this.bufAbsoluteStart, this.pos - 2 - (colonPos - this.bufAbsoluteStart));
                    } else {
                        this.elPrefix[this.depth] = null;
                        prefix = null;
                        name = this.elName[this.depth] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, elLen);
                    }
                } else {
                    name = this.elName[this.depth] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, elLen);
                }
                while (true) {
                    boolean gotS;
                    if (gotS = this.isS(ch)) {
                        while (this.isS(ch = this.more())) {
                        }
                    }
                    if (ch == '>') break block33;
                    if (ch == '/') {
                        this.emptyElementTag = true;
                        ch = this.more();
                        if (ch != '>') {
                            throw new XMLStreamException("expected > to end empty tag not " + this.printable(ch), this.getLocation());
                        }
                        break block33;
                    }
                    if (!this.isNameStartChar(ch)) break;
                    if (!gotS && ch != '>') {
                        throw new XMLStreamException("expected a white space between attributes", this.getLocation());
                    }
                    ch = this.parseAttribute();
                    ch = this.more();
                }
                throw new XMLStreamException("start tag unexpected character " + this.printable(ch), this.getLocation());
            }
            if (this.processNamespaces) {
                int i;
                String uri = this.getNamespaceURI(prefix);
                if (uri == null) {
                    if (prefix == null) {
                        uri = NO_NAMESPACE;
                    } else {
                        throw new XMLStreamException("could not determine namespace bound to element prefix " + prefix, this.getLocation());
                    }
                }
                this.elUri[this.depth] = uri;
                for (i = 0; i < this.attributeCount; ++i) {
                    String attrPrefix = this.attributePrefix[i];
                    if (attrPrefix != null) {
                        String attrUri = this.getNamespaceURI(attrPrefix);
                        if (attrUri == null) {
                            throw new XMLStreamException("could not determine namespace bound to attribute prefix " + attrPrefix, this.getLocation());
                        }
                        this.attributeUri[i] = attrUri;
                        continue;
                    }
                    this.attributeUri[i] = NO_NAMESPACE;
                }
                for (i = 1; i < this.attributeCount; ++i) {
                    for (int j = 0; j < i; ++j) {
                        if (this.attributeUri[j] != this.attributeUri[i] || (!this.allStringsInterned || !this.attributeName[j].equals(this.attributeName[i])) && (this.allStringsInterned || this.attributeNameHash[j] != this.attributeNameHash[i] || !this.attributeName[j].equals(this.attributeName[i]))) continue;
                        String attr1 = this.attributeName[j];
                        if (this.attributeUri[j] != null) {
                            attr1 = this.attributeUri[j] + ":" + attr1;
                        }
                        String attr2 = this.attributeName[i];
                        if (this.attributeUri[i] != null) {
                            attr2 = this.attributeUri[i] + ":" + attr2;
                        }
                        throw new XMLStreamException("duplicated attributes " + attr1 + " and " + attr2, this.getLocation());
                    }
                }
            } else {
                for (int i = 1; i < this.attributeCount; ++i) {
                    for (int j = 0; j < i; ++j) {
                        if ((!this.allStringsInterned || !this.attributeName[j].equals(this.attributeName[i])) && (this.allStringsInterned || this.attributeNameHash[j] != this.attributeNameHash[i] || !this.attributeName[j].equals(this.attributeName[i]))) continue;
                        String attr1 = this.attributeName[j];
                        String attr2 = this.attributeName[i];
                        throw new XMLStreamException("duplicated attributes " + attr1 + " and " + attr2, this.getLocation());
                    }
                }
            }
            this.elNamespaceCount[this.depth] = this.namespaceEnd;
            this.posEnd = this.pos;
            if (this.defaultAttributes != null) {
                if (prefix != null) {
                    this.addDefaultAttributes(prefix + ":" + name);
                } else {
                    this.addDefaultAttributes(name);
                }
            }
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
        return 1;
    }

    protected void addDefaultAttributes(String elementName) throws XMLStreamException {
        if (this.defaultAttributes == null) {
            return;
        }
        DTDAttlist attList = (DTDAttlist)this.defaultAttributes.get(elementName);
        if (elementName == null || attList == null) {
            return;
        }
        DTDAttribute[] atts = attList.getAttribute();
        for (int i = 0; i < atts.length; ++i) {
            DTDAttribute att = atts[i];
            if (att.getDefaultValue() == null) continue;
            boolean found = false;
            int count = this.attributeCount;
            for (int j = 0; j < count; ++j) {
                if (!this.attributeName[j].equals(att.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++this.attributeCount;
            this.ensureAttributesCapacity(this.attributeCount);
            this.attributePrefix[this.attributeCount - 1] = null;
            this.attributeUri[this.attributeCount - 1] = NO_NAMESPACE;
            this.attributeName[this.attributeCount - 1] = att.getName();
            this.attributeValue[this.attributeCount - 1] = att.getDefaultValue();
        }
    }

    protected char parseAttribute() throws XMLStreamException {
        try {
            int prevPosStart = this.posStart + this.bufAbsoluteStart;
            int nameStart = this.pos - 1 + this.bufAbsoluteStart;
            int colonPos = -1;
            char ch = this.buf[this.pos - 1];
            if (ch == ':' && this.processNamespaces) {
                throw new XMLStreamException("when namespaces processing enabled colon can not be at attribute name start", this.getLocation());
            }
            boolean startsWithXmlns = this.processNamespaces && ch == 'x';
            int xmlnsPos = 0;
            ch = this.more();
            while (this.isNameChar(ch)) {
                if (this.processNamespaces) {
                    if (startsWithXmlns && xmlnsPos < 5) {
                        if (++xmlnsPos == 1) {
                            if (ch != 'm') {
                                startsWithXmlns = false;
                            }
                        } else if (xmlnsPos == 2) {
                            if (ch != 'l') {
                                startsWithXmlns = false;
                            }
                        } else if (xmlnsPos == 3) {
                            if (ch != 'n') {
                                startsWithXmlns = false;
                            }
                        } else if (xmlnsPos == 4) {
                            if (ch != 's') {
                                startsWithXmlns = false;
                            }
                        } else if (xmlnsPos == 5 && ch != ':') {
                            throw new XMLStreamException("after xmlns in attribute name must be colonwhen namespaces are enabled", this.getLocation());
                        }
                    }
                    if (ch == ':') {
                        if (colonPos != -1) {
                            throw new XMLStreamException("only one colon is allowed in attribute name when namespaces are enabled", this.getLocation());
                        }
                        colonPos = this.pos - 1 + this.bufAbsoluteStart;
                    }
                }
                ch = this.more();
            }
            this.ensureAttributesCapacity(this.attributeCount);
            String name = null;
            String prefix = null;
            if (this.processNamespaces) {
                if (xmlnsPos < 4) {
                    startsWithXmlns = false;
                }
                if (startsWithXmlns) {
                    if (colonPos != -1 && (name = this.newString(this.buf, colonPos - this.bufAbsoluteStart + 1, this.pos - 2 - (colonPos - this.bufAbsoluteStart))).equals("xmlns")) {
                        throw new XMLStreamException("trying to bind reserved NS prefix 'xmlns'", this.getLocation());
                    }
                } else {
                    if (colonPos != -1) {
                        prefix = this.attributePrefix[this.attributeCount] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, colonPos - nameStart);
                        name = this.attributeName[this.attributeCount] = this.newString(this.buf, colonPos - this.bufAbsoluteStart + 1, this.pos - 2 - (colonPos - this.bufAbsoluteStart));
                    } else {
                        this.attributePrefix[this.attributeCount] = null;
                        prefix = null;
                        name = this.attributeName[this.attributeCount] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, this.pos - 1 - (nameStart - this.bufAbsoluteStart));
                    }
                    if (!this.allStringsInterned) {
                        this.attributeNameHash[this.attributeCount] = name.hashCode();
                    }
                }
            } else {
                name = this.attributeName[this.attributeCount] = this.newString(this.buf, nameStart - this.bufAbsoluteStart, this.pos - 1 - (nameStart - this.bufAbsoluteStart));
                if (!this.allStringsInterned) {
                    this.attributeNameHash[this.attributeCount] = name.hashCode();
                }
            }
            while (this.isS(ch)) {
                ch = this.more();
            }
            if (ch != '=') {
                throw new XMLStreamException("expected = after attribute name", this.getLocation());
            }
            ch = this.more();
            while (this.isS(ch)) {
                ch = this.more();
            }
            char delimit = ch;
            if (delimit != '\"' && delimit != '\'') {
                throw new XMLStreamException("attribute value must start with quotation or apostrophe not " + this.printable(delimit), this.getLocation());
            }
            boolean normalizedCR = false;
            this.usePC = false;
            this.pcStart = this.pcEnd;
            this.posStart = this.pos;
            while ((ch = this.more()) != delimit) {
                if (ch == '<') {
                    throw new XMLStreamException("markup not allowed inside attribute value - illegal < ", this.getLocation());
                }
                if (ch == '&') {
                    char[] resolvedEntity;
                    this.posEnd = this.pos - 1;
                    if (!this.usePC) {
                        boolean hadCharData;
                        boolean bl = hadCharData = this.posEnd > this.posStart;
                        if (hadCharData) {
                            this.joinPC();
                        } else {
                            this.usePC = true;
                            this.pcEnd = 0;
                            this.pcStart = 0;
                        }
                    }
                    if ((resolvedEntity = this.parseEntityRef(this.getConfigurationContext().isReplacingEntities())) == null) {
                        if (this.entityRefName == null) {
                            this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                        }
                        throw new XMLStreamException("could not resolve entity named '" + this.printable(this.entityRefName) + "'", this.getLocation());
                    }
                    for (int i = 0; i < resolvedEntity.length; ++i) {
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = resolvedEntity[i];
                    }
                } else if (ch == '\t' || ch == '\n' || ch == '\r') {
                    if (!this.usePC) {
                        this.posEnd = this.pos - 1;
                        if (this.posEnd > this.posStart) {
                            this.joinPC();
                        } else {
                            this.usePC = true;
                            this.pcStart = 0;
                            this.pcEnd = 0;
                        }
                    }
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    if (ch != '\n' || !normalizedCR) {
                        this.pc[this.pcEnd++] = 32;
                    }
                } else if (this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = ch;
                }
                normalizedCR = ch == '\r';
            }
            if (this.processNamespaces && startsWithXmlns) {
                String ns = null;
                ns = !this.usePC ? this.newStringIntern(this.buf, this.posStart, this.pos - 1 - this.posStart) : this.newStringIntern(this.pc, this.pcStart, this.pcEnd - this.pcStart);
                this.ensureNamespacesCapacity(this.namespaceEnd);
                int prefixHash = -1;
                if (ns.equals("http://www.w3.org/XML/1998/namespace")) {
                    if (!"xml".equals(name)) {
                        throw new XMLStreamException("trying to bind reserved NS URI  'http://www.w3.org/XML/1998/namespace' to prefix other than 'xml'");
                    }
                } else if (ns.equals("http://www.w3.org/2000/xmlns/")) {
                    throw new XMLStreamException("trying to bind reserved NS URI  'http://www.w3.org/2000/xmlns/'");
                }
                if (colonPos != -1) {
                    if (ns.length() == 0) {
                        throw new XMLStreamException("non-default namespace can not be declared to be empty string (in xml 1.0)", this.getLocation());
                    }
                    if (name.equals("xml") && !ns.equals("http://www.w3.org/XML/1998/namespace")) {
                        throw new XMLStreamException("trying to bind reserved NS prefix 'xml' to URI other than its standard value (http://www.w3.org/XML/1998/namespace)", this.getLocation());
                    }
                    this.namespacePrefix[this.namespaceEnd] = name;
                    if (!this.allStringsInterned) {
                        prefixHash = this.namespacePrefixHash[this.namespaceEnd] = name.hashCode();
                    }
                } else {
                    this.namespacePrefix[this.namespaceEnd] = null;
                    if (ns.length() == 0) {
                        ns = NO_NAMESPACE;
                    }
                    if (!this.allStringsInterned) {
                        this.namespacePrefixHash[this.namespaceEnd] = -1;
                        prefixHash = -1;
                    }
                }
                this.namespaceUri[this.namespaceEnd] = ns;
                int startNs = this.elNamespaceCount[this.depth - 1];
                for (int i = this.namespaceEnd - 1; i >= startNs; --i) {
                    if ((!this.allStringsInterned && name != null || this.namespacePrefix[i] != name) && (this.allStringsInterned || name == null || this.namespacePrefixHash[i] != prefixHash || !name.equals(this.namespacePrefix[i]))) continue;
                    String s = name == null ? "default" : "'" + name + "'";
                    throw new XMLStreamException("duplicated namespace declaration for " + s + " prefix", this.getLocation());
                }
                ++this.namespaceEnd;
            } else {
                this.attributeValue[this.attributeCount] = !this.usePC ? new String(this.buf, this.posStart, this.pos - 1 - this.posStart) : new String(this.pc, this.pcStart, this.pcEnd - this.pcStart);
                ++this.attributeCount;
            }
            this.posStart = prevPosStart - this.bufAbsoluteStart;
            return ch;
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
    }

    protected char[] parseEntityRef(boolean replace) throws XMLStreamException {
        try {
            this.entityRefName = null;
            this.posStart = this.pos;
            char ch = this.more();
            if (ch == '#') {
                int charRef = 0;
                ch = this.more();
                if (ch == 'x') {
                    while ((ch = this.more()) != ';') {
                        charRef <<= 4;
                        if (ch >= '0' && ch <= '9') {
                            charRef += ch - 48;
                        } else if (ch >= 'a' && ch <= 'f') {
                            charRef += ch - 87;
                        } else if (ch >= 'A' && ch <= 'F') {
                            charRef += ch - 55;
                        } else {
                            throw new XMLStreamException("character reference (with hex value) may not contain " + this.printable(ch), this.getLocation());
                        }
                        if (charRef <= 0x10FFFF) continue;
                        break;
                    }
                } else {
                    do {
                        if (ch < '0' || ch > '9') {
                            if (ch != ';') {
                                throw new XMLStreamException("character reference (with decimal value) may not contain " + this.printable(ch), this.getLocation());
                            }
                            break;
                        }
                        charRef = charRef * 10 + (ch - 48);
                        ch = this.more();
                    } while (charRef <= 0x10FFFF);
                }
                this.posEnd = this.pos - 1;
                this.checkCharValidity(charRef, false);
                if (charRef > 65535) {
                    if (this.charRefTwoCharBuf == null) {
                        this.charRefTwoCharBuf = new char[2];
                    }
                    this.charRefTwoCharBuf[0] = (char)(((charRef -= 65536) >> 10) + 55296);
                    this.charRefTwoCharBuf[1] = (char)((charRef & 0x3FF) + 56320);
                    this.entityValue = this.charRefTwoCharBuf;
                    return this.charRefTwoCharBuf;
                }
                this.charRefOneCharBuf[0] = (char)charRef;
                this.entityValue = this.charRefOneCharBuf;
                return this.charRefOneCharBuf;
            }
            while ((ch = this.more()) != ';') {
            }
            this.posEnd = this.pos - 1;
            int len = this.posEnd - this.posStart;
            if (len == 2) {
                if (this.buf[this.posStart] == 'l' && this.buf[this.posStart + 1] == 't') {
                    if (!replace) {
                        this.text = "<";
                    }
                    this.charRefOneCharBuf[0] = 60;
                    this.entityValue = this.charRefOneCharBuf;
                    return this.charRefOneCharBuf;
                }
                if (this.buf[this.posStart] == 'g' && this.buf[this.posStart + 1] == 't') {
                    if (!replace) {
                        this.text = ">";
                    }
                    this.charRefOneCharBuf[0] = 62;
                    this.entityValue = this.charRefOneCharBuf;
                    return this.charRefOneCharBuf;
                }
            } else if (len == 3) {
                if (this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'm' && this.buf[this.posStart + 2] == 'p') {
                    if (!replace) {
                        this.text = "&";
                    }
                    this.charRefOneCharBuf[0] = 38;
                    this.entityValue = this.charRefOneCharBuf;
                    return this.charRefOneCharBuf;
                }
            } else if (len == 4) {
                if (this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'p' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 's') {
                    if (!replace) {
                        this.text = "'";
                    }
                    this.charRefOneCharBuf[0] = 39;
                    this.entityValue = this.charRefOneCharBuf;
                    return this.charRefOneCharBuf;
                }
                if (this.buf[this.posStart] == 'q' && this.buf[this.posStart + 1] == 'u' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 't') {
                    if (!replace) {
                        this.text = "\"";
                    }
                    this.charRefOneCharBuf[0] = 34;
                    this.entityValue = this.charRefOneCharBuf;
                    return this.charRefOneCharBuf;
                }
            }
            this.entityValue = this.lookupEntityReplacement(len);
            return this.entityValue;
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
    }

    protected char[] lookupEntityReplacement(int entitNameLen) throws XMLStreamException {
        if (!this.allStringsInterned) {
            int hash = MXParser.fastHash(this.buf, this.posStart, this.posEnd - this.posStart);
            block0: for (int i = this.entityEnd - 1; i >= 0; --i) {
                if (hash != this.entityNameHash[i] || entitNameLen != this.entityNameBuf[i].length) continue;
                char[] entityBuf = this.entityNameBuf[i];
                for (int j = 0; j < entitNameLen; ++j) {
                    if (this.buf[this.posStart + j] != entityBuf[j]) continue block0;
                }
                if (this.tokenize) {
                    this.text = this.entityReplacement[i];
                }
                this.entityRefName = this.entityName[i];
                return this.entityReplacementBuf[i];
            }
        } else {
            this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            for (int i = this.entityEnd - 1; i >= 0; --i) {
                if (this.entityRefName != this.entityName[i]) continue;
                if (this.tokenize) {
                    this.text = this.entityReplacement[i];
                }
                return this.entityReplacementBuf[i];
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseComment() throws XMLStreamException {
        try {
            char ch = this.more();
            if (ch != '-') {
                throw new XMLStreamException("expected <!-- for COMMENT start", this.getLocation());
            }
            this.posStart = this.pos;
            int curLine = this.lineNumber;
            int curColumn = this.columnNumber;
            try {
                int expDash = -2;
                int skipLfAt = -2;
                int at = -1;
                boolean anySkipped = false;
                while (true) {
                    block14: {
                        ch = this.more();
                        ++at;
                        if (ch == '-') {
                            if (expDash < at) {
                                expDash = at + 1;
                                break block14;
                            } else {
                                ch = this.more();
                                if (ch == '>') break;
                                throw new XMLStreamException("in COMMENT after two dashes (--) next character must be '>' not " + this.printable(ch), this.getLocation());
                            }
                        }
                        if (ch == '\r') {
                            this.columnNumber = 1;
                            skipLfAt = at + 1;
                            if (!anySkipped) {
                                this.buf[this.pos - 1] = 10;
                                continue;
                            }
                            ch = '\n';
                        } else if (ch == '\n' && skipLfAt == at) {
                            if (anySkipped) continue;
                            anySkipped = true;
                            this.posEnd = this.pos - 1;
                            continue;
                        }
                    }
                    if (!anySkipped) continue;
                    this.buf[this.posEnd] = ch;
                    ++this.posEnd;
                }
                if (anySkipped) {
                    --this.posEnd;
                    return;
                }
                this.posEnd = this.pos - 3;
                return;
            }
            catch (EOFException ex) {
                throw new XMLStreamException("COMMENT started on line " + curLine + " and column " + curColumn + " was not closed", this.getLocation(), ex);
            }
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
    }

    public String getPITarget() {
        if (this.eventType != 3) {
            this.throwIllegalState(3);
        }
        return this.piTarget;
    }

    public String getPIData() {
        if (this.eventType != 3) {
            this.throwIllegalState(3);
        }
        return this.piData;
    }

    public NamespaceContext getNamespaceContext() {
        return new ReadOnlyNamespaceContextBase(this.namespacePrefix, this.namespaceUri, this.namespaceEnd);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parsePI() throws XMLStreamException {
        curLine = this.lineNumber;
        curColumn = this.columnNumber;
        try {
            block14: {
                block13: {
                    this.piTarget = null;
                    this.piData = null;
                    this.posStart = this.pos;
                    while ((ch = this.more()) != 63) {
                        if (this.isNameChar((char)ch)) continue;
                        if (this.isS((char)ch)) break;
                        throw new XMLStreamException("unexpected character " + this.printable((char)ch) + " after processing instruction name; expected a white space or '?>'", this.getLocation());
                    }
                    if ((len = this.pos - this.posStart - 1) == 0) {
                        throw new XMLStreamException("processing instruction must have PITarget name", this.getLocation());
                    }
                    this.piTarget = new String(this.buf, this.posStart, len);
                    if (ch != 63) {
                        ch = this.skipS((char)ch);
                    }
                    if (!(isXMLDecl = this.piTarget.equalsIgnoreCase("xml"))) break block13;
                    if (this.posStart + this.bufAbsoluteStart > 2) {
                        throw new XMLStreamException("processing instruction can not have PITarget with reserved name 'xml'", this.getLocation());
                    }
                    if (!"xml".equals(this.piTarget)) {
                        throw new XMLStreamException("XMLDecl must have xml name in lowercase", this.getLocation());
                    }
                    this.posStart = this.pos - 1;
                    this.parseXmlDecl((char)ch);
                    isXMLDecl = true;
                    this.posEnd = this.pos - 2;
                    break block14;
                }
                this.posStart = this.pos - 1;
                expLT = -2;
                skipLfAt = -2;
                at = -1;
                anySkipped = false;
                while (true) {
                    block19: {
                        block17: {
                            block18: {
                                block16: {
                                    block15: {
                                        ++at;
                                        if (ch != 63) break block15;
                                        expLT = at + 1;
                                        ** GOTO lbl-1000
                                    }
                                    if (ch != 62) break block16;
                                    if (at == expLT) {
                                        break;
                                    }
                                    ** GOTO lbl-1000
                                }
                                if (ch != 13) break block17;
                                this.columnNumber = 1;
                                skipLfAt = at + 1;
                                if (anySkipped) break block18;
                                this.buf[this.pos - 1] = 10;
                                break block19;
                            }
                            ch = 10;
                            ** GOTO lbl-1000
                        }
                        if (ch == 10 && skipLfAt == at) {
                            if (!anySkipped) {
                                anySkipped = true;
                                this.posEnd = this.pos - 1;
                            }
                        } else if (anySkipped) {
                            this.buf[this.posEnd] = ch;
                            ++this.posEnd;
                        }
                    }
                    ch = this.more();
                }
                this.posEnd = anySkipped ? --this.posEnd : this.pos - 2;
            }
            this.piData = new String(this.buf, this.posStart, this.posEnd - this.posStart);
            return isXMLDecl;
        }
        catch (EOFException ex) {
            throw new XMLStreamException("processing instruction started on line " + curLine + " and column " + curColumn + " was not closed", this.getLocation(), ex);
        }
    }

    protected char requireInput(char ch, char[] input) throws XMLStreamException {
        for (int i = 0; i < input.length; ++i) {
            if (ch != input[i]) {
                throw new XMLStreamException("expected " + this.printable(input[i]) + " in " + new String(input) + " and not " + this.printable(ch), this.getLocation());
            }
            try {
                ch = this.more();
                continue;
            }
            catch (EOFException eofe) {
                throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
            }
        }
        return ch;
    }

    protected char requireNextS() throws XMLStreamException {
        char ch;
        try {
            ch = this.more();
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
        if (!this.isS(ch)) {
            throw new XMLStreamException("white space is required and not " + this.printable(ch), this.getLocation());
        }
        return this.skipS(ch);
    }

    protected char skipS(char ch) throws XMLStreamException {
        try {
            while (this.isS(ch)) {
                ch = this.more();
            }
            return ch;
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
    }

    protected void parseXmlDecl(char ch) throws XMLStreamException {
        try {
            ch = this.skipS(ch);
            ch = this.requireInput(ch, VERSION);
            ch = this.skipS(ch);
            if (ch != '=') {
                throw new XMLStreamException("expected equals sign (=) after version and not " + this.printable(ch), this.getLocation());
            }
            ch = this.more();
            if ((ch = this.skipS(ch)) != '\'' && ch != '\"') {
                throw new XMLStreamException("expected apostrophe (') or quotation mark (\") after version and not " + this.printable(ch), this.getLocation());
            }
            char quotChar = ch;
            int versionStart = this.pos;
            ch = this.more();
            while (ch != quotChar) {
                if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == ':' || ch == '-')) {
                    throw new XMLStreamException("<?xml version value expected to be in ([a-zA-Z0-9_.:] | '-') not " + this.printable(ch), this.getLocation());
                }
                ch = this.more();
            }
            int versionEnd = this.pos - 1;
            this.parseXmlDeclWithVersion(versionStart, versionEnd);
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
    }

    protected void parseXmlDeclWithVersion(int versionStart, int versionEnd) throws XMLStreamException {
        try {
            if (versionEnd - versionStart != 3 || this.buf[versionStart] != '1' || this.buf[versionStart + 1] != '.' || this.buf[versionStart + 2] != '0') {
                throw new XMLStreamException("only 1.0 is supported as <?xml version not '" + this.printable(new String(this.buf, versionStart, versionEnd)) + "'", this.getLocation());
            }
            this.xmlVersion = new String(this.buf, versionStart, versionEnd - versionStart);
            char ch = this.more();
            if ((ch = this.skipS(ch)) != '?') {
                char quotChar;
                if ((ch = this.skipS(ch)) == ENCODING[0]) {
                    ch = this.requireInput(ch, ENCODING);
                    if ((ch = this.skipS(ch)) != '=') {
                        throw new XMLStreamException("expected equals sign (=) after encoding and not " + this.printable(ch), this.getLocation());
                    }
                    ch = this.more();
                    if ((ch = this.skipS(ch)) != '\'' && ch != '\"') {
                        throw new XMLStreamException("expected apostrophe (') or quotation mark (\") after encoding and not " + this.printable(ch), this.getLocation());
                    }
                    quotChar = ch;
                    int encodingStart = this.pos;
                    ch = this.more();
                    if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                        throw new XMLStreamException("<?xml encoding name expected to start with [A-Za-z] not " + this.printable(ch), this.getLocation());
                    }
                    ch = this.more();
                    while (ch != quotChar) {
                        if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '_' || ch == '-')) {
                            throw new XMLStreamException("<?xml encoding value expected to be in ([A-Za-z0-9._] | '-') not " + this.printable(ch), this.getLocation());
                        }
                        ch = this.more();
                    }
                    int encodingEnd = this.pos - 1;
                    this.charEncodingScheme = this.newString(this.buf, encodingStart, encodingEnd - encodingStart);
                    ch = this.more();
                    ch = this.skipS(ch);
                }
                if (ch != '?') {
                    ch = this.skipS(ch);
                    ch = this.requireInput(ch, STANDALONE);
                    if ((ch = this.skipS(ch)) != '=') {
                        throw new XMLStreamException("expected equals sign (=) after standalone and not " + this.printable(ch), this.getLocation());
                    }
                    ch = this.more();
                    if ((ch = this.skipS(ch)) != '\'' && ch != '\"') {
                        throw new XMLStreamException("expected apostrophe (') or quotation mark (\") after encoding and not " + this.printable(ch), this.getLocation());
                    }
                    quotChar = ch;
                    int standaloneStart = this.pos;
                    ch = this.more();
                    if (ch == 'y') {
                        ch = this.requireInput(ch, YES);
                        this.standalone = true;
                    } else if (ch == 'n') {
                        ch = this.requireInput(ch, NO);
                        this.standalone = false;
                    } else {
                        throw new XMLStreamException("expected 'yes' or 'no' after standalone and not " + this.printable(ch), this.getLocation());
                    }
                    this.standaloneSet = true;
                    if (ch != quotChar) {
                        throw new XMLStreamException("expected " + quotChar + " after standalone value not " + this.printable(ch), this.getLocation());
                    }
                    ch = this.more();
                }
            }
            if ((ch = this.skipS(ch)) != '?') {
                throw new XMLStreamException("expected ?> as last part of <?xml not " + this.printable(ch), this.getLocation());
            }
            ch = this.more();
            if (ch != '>') {
                throw new XMLStreamException("expected ?> as last part of <?xml not " + this.printable(ch), this.getLocation());
            }
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseDocdecl() throws XMLStreamException {
        this.posStart = this.pos - 3;
        try {
            if (this.more() != 'O') throw new XMLStreamException("expected <!DOCTYPE", this.getLocation());
            if (this.more() != 'C') throw new XMLStreamException("expected <!DOCTYPE", this.getLocation());
            if (this.more() != 'T') throw new XMLStreamException("expected <!DOCTYPE", this.getLocation());
            if (this.more() != 'Y') throw new XMLStreamException("expected <!DOCTYPE", this.getLocation());
            if (this.more() != 'P') throw new XMLStreamException("expected <!DOCTYPE", this.getLocation());
            if (this.more() != 'E') {
                throw new XMLStreamException("expected <!DOCTYPE", this.getLocation());
            }
            char ch = this.requireNextS();
            if (!this.isNameStartChar(ch)) {
                this.throwNotNameStart(ch);
            }
            int nameStart = this.pos - 1 + this.bufAbsoluteStart;
            while (this.isNameChar(ch = this.more())) {
            }
            if ((ch = this.skipS(ch)) == 'S' || ch == 'P') {
                char quotChar;
                if (ch == 'S') {
                    if (this.more() != 'Y') throw new XMLStreamException("expected keyword SYSTEM", this.getLocation());
                    if (this.more() != 'S') throw new XMLStreamException("expected keyword SYSTEM", this.getLocation());
                    if (this.more() != 'T') throw new XMLStreamException("expected keyword SYSTEM", this.getLocation());
                    if (this.more() != 'E') throw new XMLStreamException("expected keyword SYSTEM", this.getLocation());
                    if (this.more() != 'M') {
                        throw new XMLStreamException("expected keyword SYSTEM", this.getLocation());
                    }
                } else {
                    if (this.more() != 'U') throw new XMLStreamException("expected keyword PUBLIC", this.getLocation());
                    if (this.more() != 'B') throw new XMLStreamException("expected keyword PUBLIC", this.getLocation());
                    if (this.more() != 'L') throw new XMLStreamException("expected keyword PUBLIC", this.getLocation());
                    if (this.more() != 'I') throw new XMLStreamException("expected keyword PUBLIC", this.getLocation());
                    if (this.more() != 'C') {
                        throw new XMLStreamException("expected keyword PUBLIC", this.getLocation());
                    }
                    quotChar = this.requireNextS();
                    if (quotChar != '\"' && quotChar != '\'') {
                        throw new XMLStreamException("Public identifier has to be enclosed in quotes, not " + this.printable(ch), this.getLocation());
                    }
                    while ((ch = this.more()) != quotChar) {
                    }
                }
                if ((quotChar = this.requireNextS()) != '\"' && quotChar != '\'') {
                    throw new XMLStreamException("System identifier has to be enclosed in quotes, not " + this.printable(ch), this.getLocation());
                }
                while ((ch = this.more()) != quotChar) {
                }
                ch = this.skipS(this.more());
            }
            if (ch != '[') {
                this.posStart = this.posEnd = this.pos;
                if ((ch = this.skipS(ch)) == '>') return;
                throw new XMLStreamException("Expected closing '>' after internal DTD subset, not '" + this.printable(ch) + "'", this.getLocation());
            }
            this.posStart = this.pos;
            int bracketLevel = 1;
            block11: while (true) {
                ch = this.more();
                switch (ch) {
                    case '[': {
                        ++bracketLevel;
                        break;
                    }
                    case ']': {
                        --bracketLevel;
                        break;
                    }
                    case '>': {
                        if (bracketLevel > 0) break;
                        break block11;
                    }
                    case '\"': 
                    case '\'': {
                        while (this.more() != ch) {
                        }
                        break block1;
                    }
                }
            }
            this.posEnd = this.pos - 2;
            this.processDTD();
            return;
        }
        catch (EOFException eofe) {
            throw new XMLStreamException(EOF_MSG, this.getLocation(), eofe);
        }
    }

    protected void processDTD() throws XMLStreamException {
        try {
            String internalDTD = new String(this.buf, this.posStart, this.posEnd - this.posStart);
            DTDParser dtdParser = new DTDParser(new StringReader(internalDTD));
            this.mDtdIntSubset = dtdParser.parse();
            Vector v = this.mDtdIntSubset.getItemsByType(class$com$wutka$dtd$DTDEntity == null ? (class$com$wutka$dtd$DTDEntity = MXParser.class$("com.wutka.dtd.DTDEntity")) : class$com$wutka$dtd$DTDEntity);
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                DTDEntity entity = (DTDEntity)e.nextElement();
                if (entity.isParsed()) continue;
                this.defineEntityReplacementText(entity.getName(), entity.getValue());
            }
            v = this.mDtdIntSubset.getItemsByType(class$com$wutka$dtd$DTDAttlist == null ? (class$com$wutka$dtd$DTDAttlist = MXParser.class$("com.wutka.dtd.DTDAttlist")) : class$com$wutka$dtd$DTDAttlist);
            e = v.elements();
            while (e.hasMoreElements()) {
                DTDAttlist list = (DTDAttlist)e.nextElement();
                DTDAttribute[] atts = list.getAttribute();
                for (int i = 0; i < atts.length; ++i) {
                    DTDAttribute att = atts[i];
                    if (att.getDefaultValue() == null) continue;
                    if (this.defaultAttributes == null) {
                        this.defaultAttributes = new HashMap();
                    }
                    this.defaultAttributes.put(list.getName(), list);
                }
            }
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    protected void parseCDATA() throws XMLStreamException {
        try {
            if (this.more() != 'C' || this.more() != 'D' || this.more() != 'A' || this.more() != 'T' || this.more() != 'A' || this.more() != '[') {
                throw new XMLStreamException("expected <[CDATA[ for CDATA start", this.getLocation());
            }
        }
        catch (EOFException eofe) {
            throw new XMLStreamException("Unexpected EOF in directive", this.getLocation(), eofe);
        }
        this.posStart = this.pos;
        int curLine = this.lineNumber;
        int curColumn = this.columnNumber;
        try {
            int bracketCount = 0;
            int skipLfAt = -2;
            int at = -1;
            boolean anySkipped = false;
            while (true) {
                ++at;
                int ch = this.more();
                if (ch == 93) {
                    ++bracketCount;
                } else if (ch == 62) {
                    if (bracketCount >= 2) break;
                    bracketCount = 0;
                } else {
                    bracketCount = 0;
                    if (ch == 13) {
                        this.columnNumber = 1;
                        skipLfAt = at + 1;
                        if (!anySkipped) {
                            this.buf[this.pos - 1] = 10;
                            continue;
                        }
                        ch = 10;
                    } else if (ch == 10 && skipLfAt == at) {
                        anySkipped = true;
                        this.posEnd = this.pos - 1;
                        continue;
                    }
                }
                if (!anySkipped) continue;
                this.buf[this.posEnd] = ch;
                ++this.posEnd;
            }
            this.posEnd = anySkipped ? (this.posEnd -= 2) : this.pos - 3;
        }
        catch (EOFException ex) {
            throw new XMLStreamException("CDATA section on line " + curLine + " and column " + curColumn + " was not closed", this.getLocation(), ex);
        }
    }

    protected void fillBuf() throws XMLStreamException, EOFException {
        int ret;
        int room;
        if (this.reader == null) {
            throw new XMLStreamException("reader must be set before parsing is started");
        }
        if (this.bufEnd > this.bufSoftLimit) {
            boolean compact = this.bufStart > this.bufSoftLimit;
            boolean expand = false;
            if (!compact) {
                if (this.bufStart < this.buf.length / 2) {
                    expand = true;
                } else {
                    compact = true;
                }
            }
            if (compact) {
                System.arraycopy(this.buf, this.bufStart, this.buf, 0, this.bufEnd - this.bufStart);
            } else if (expand) {
                int newSize = 2 * this.buf.length;
                char[] newBuf = new char[newSize];
                System.arraycopy(this.buf, this.bufStart, newBuf, 0, this.bufEnd - this.bufStart);
                this.buf = newBuf;
                if (this.bufLoadFactor > 0) {
                    this.bufSoftLimit = this.bufLoadFactor * this.buf.length / 100;
                }
            } else {
                throw new XMLStreamException("internal error in fillBuffer()");
            }
            this.bufEnd -= this.bufStart;
            this.pos -= this.bufStart;
            this.posStart -= this.bufStart;
            this.posEnd -= this.bufStart;
            this.bufAbsoluteStart += this.bufStart;
            this.bufStart = 0;
        }
        int len = (room = this.buf.length - this.bufEnd) > 8192 ? 8192 : room;
        try {
            ret = this.reader.read(this.buf, this.bufEnd, len);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (ret > 0) {
            this.bufEnd += ret;
            return;
        }
        if (ret == -1) {
            throw new EOFException("no more data available");
        }
        throw new XMLStreamException("error reading input, returned " + ret);
    }

    protected char more() throws XMLStreamException, EOFException {
        char ch;
        if (this.pos >= this.bufEnd) {
            this.fillBuf();
        }
        if ((ch = this.buf[this.pos++]) == '\n') {
            ++this.lineNumber;
            this.columnNumber = 1;
        } else {
            ++this.columnNumber;
        }
        return ch;
    }

    protected String printable(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch == '\'') {
            return "\\'";
        }
        if (ch > '\u007f' || ch < ' ') {
            return "\\u" + Integer.toHexString(ch);
        }
        return "" + ch;
    }

    protected String printable(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            buf.append(this.printable(s.charAt(i)));
        }
        s = buf.toString();
        return s;
    }

    protected void ensurePC(int end) {
        int newSize = end > 8192 ? 2 * end : 16384;
        char[] newPC = new char[newSize];
        System.arraycopy(this.pc, 0, newPC, 0, this.pcEnd);
        this.pc = newPC;
    }

    protected void joinPC() {
        int len = this.posEnd - this.posStart;
        int newEnd = this.pcEnd + len + 1;
        if (newEnd >= this.pc.length) {
            this.ensurePC(newEnd);
        }
        System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, len);
        this.pcEnd += len;
        this.usePC = true;
    }

    public Location getLocation() {
        return this;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public void setConfigurationContext(ConfigurationContextBase c) {
        this.configurationContext = c;
        boolean isCoalescing = Boolean.TRUE.equals(c.getProperty("aavax.xml.stream.isCoalescing"));
        this.reportCdataEvent = Boolean.TRUE.equals(c.getProperty("http://java.sun.com/xml/stream/properties/report-cdata-event"));
    }

    public ConfigurationContextBase getConfigurationContext() {
        return this.configurationContext;
    }

    public Object getProperty(String name) {
        if (name.equals(FEATURE_STAX_ENTITIES)) {
            if (this.mDtdIntSubset != null) {
                Vector v = this.mDtdIntSubset.getItemsByType(class$com$wutka$dtd$DTDEntity == null ? (class$com$wutka$dtd$DTDEntity = MXParser.class$("com.wutka.dtd.DTDEntity")) : class$com$wutka$dtd$DTDEntity);
                Enumeration e = v.elements();
                ArrayList<EntityDeclaration> result = new ArrayList<EntityDeclaration>(v.size());
                while (e.hasMoreElements()) {
                    DTDEntity ent = (DTDEntity)e.nextElement();
                    EntityDeclaration nd = DTDEvent.createEntityDeclaration(ent);
                    if (nd == null) continue;
                    result.add(nd);
                }
                return result;
            }
            return null;
        }
        if (name.equals(FEATURE_STAX_NOTATIONS)) {
            if (this.mDtdIntSubset != null) {
                Vector v = this.mDtdIntSubset.getItemsByType(class$com$wutka$dtd$DTDNotation == null ? (class$com$wutka$dtd$DTDNotation = MXParser.class$("com.wutka.dtd.DTDNotation")) : class$com$wutka$dtd$DTDNotation);
                Enumeration e = v.elements();
                ArrayList<NotationDeclaration> result = new ArrayList<NotationDeclaration>(v.size());
                while (e.hasMoreElements()) {
                    DTDNotation n = (DTDNotation)e.nextElement();
                    NotationDeclaration ed = DTDEvent.createNotationDeclaration(n);
                    if (ed == null) continue;
                    result.add(ed);
                }
                return result;
            }
            return null;
        }
        return this.configurationContext.getProperty(name);
    }

    private String throwIllegalState(int expState) throws IllegalStateException {
        throw new IllegalStateException("Current state (" + MXParser.eventTypeDesc(this.eventType) + ") not " + MXParser.eventTypeDesc(expState));
    }

    private String throwIllegalState(int[] expStates) throws IllegalStateException {
        StringBuffer sb = new StringBuffer();
        sb.append(MXParser.eventTypeDesc(expStates[0]));
        int last = expStates.length - 1;
        for (int i = 0; i < last; ++i) {
            sb.append(", ");
            sb.append(MXParser.eventTypeDesc(expStates[i]));
        }
        sb.append(" or ");
        sb.append(MXParser.eventTypeDesc(expStates[last]));
        throw new IllegalStateException("Current state (" + MXParser.eventTypeDesc(this.eventType) + ") not " + sb.toString());
    }

    private void throwNotNameStart(char ch) throws XMLStreamException {
        throw new XMLStreamException("expected name start character and not " + this.printable(ch), this.getLocation());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        char ch;
        TYPES = new String[]{"[UNKNOWN]", "START_ELEMENT", "END_ELEMENT", "PROCESSING_INSTRUCTION", "CHARACTERS", "COMMENT", "SPACE", "START_DOCUMENT", "END_DOCUMENT", "ENTITY_REFERENCE", "ATTRIBUTE", "DTD", "CDATA", "NAMESPACE", "NOTATION_DECLARATION", "ENTITY_DECLARATION"};
        NO_NAMESPACE = null;
        lookupNameStartChar = new boolean[1024];
        lookupNameChar = new boolean[1024];
        MXParser.setNameStart(':');
        for (ch = 'A'; ch <= 'Z'; ch = (char)((char)(ch + 1))) {
            MXParser.setNameStart(ch);
        }
        MXParser.setNameStart('_');
        for (ch = 'a'; ch <= 'z'; ch = (char)((char)(ch + 1))) {
            MXParser.setNameStart(ch);
        }
        for (ch = '\u00c0'; ch <= '\u02ff'; ch = (char)((char)(ch + 1))) {
            MXParser.setNameStart(ch);
        }
        for (ch = '\u0370'; ch <= '\u037d'; ch = (char)((char)(ch + 1))) {
            MXParser.setNameStart(ch);
        }
        for (ch = '\u037f'; ch < '\u0400'; ch = (char)((char)(ch + '\u0001'))) {
            MXParser.setNameStart(ch);
        }
        MXParser.setName('-');
        MXParser.setName('.');
        for (ch = '0'; ch <= '9'; ch = (char)((char)(ch + 1))) {
            MXParser.setName(ch);
        }
        MXParser.setName('\u00b7');
        for (ch = '\u0300'; ch <= '\u036f'; ch = (char)(ch + '\u0001')) {
            MXParser.setName(ch);
        }
        NO_STRINGS = new String[0];
        NO_INTS = new int[0];
        NO_CHARS = new char[0];
        VERSION = new char[]{'v', 'e', 'r', 's', 'i', 'o', 'n'};
        ENCODING = new char[]{'e', 'n', 'c', 'o', 'd', 'i', 'n', 'g'};
        STANDALONE = new char[]{'s', 't', 'a', 'n', 'd', 'a', 'l', 'o', 'n', 'e'};
        YES = new char[]{'y', 'e', 's'};
        NO = new char[]{'n', 'o'};
    }
}

