/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.lidroid.xutils.db.sqlite.CursorUtils;
import com.lidroid.xutils.db.sqlite.DbModelSelector;
import com.lidroid.xutils.db.sqlite.Selector;
import com.lidroid.xutils.db.sqlite.SqlInfo;
import com.lidroid.xutils.db.sqlite.SqlInfoBuilder;
import com.lidroid.xutils.db.sqlite.WhereBuilder;
import com.lidroid.xutils.db.table.DbModel;
import com.lidroid.xutils.db.table.Id;
import com.lidroid.xutils.db.table.KeyValue;
import com.lidroid.xutils.db.table.Table;
import com.lidroid.xutils.db.table.TableUtils;
import com.lidroid.xutils.exception.DbException;
import com.lidroid.xutils.util.IOUtils;
import com.lidroid.xutils.util.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DbUtils {
    private static HashMap<String, DbUtils> daoMap = new HashMap();
    private SQLiteDatabase database;
    private DaoConfig daoConfig;
    private boolean debug = false;
    private boolean allowTransaction = false;
    private Lock writeLock = new ReentrantLock();
    private volatile boolean writeLocked = false;
    private final FindTempCache findTempCache = new FindTempCache();

    private DbUtils(DaoConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("daoConfig may not be null");
        }
        if (config.getContext() == null) {
            throw new IllegalArgumentException("context mey not be null");
        }
        this.database = this.createDatabase(config);
        this.daoConfig = config;
    }

    private static synchronized DbUtils getInstance(DaoConfig daoConfig) {
        DbUtils dao = daoMap.get(daoConfig.getDbName());
        if (dao == null) {
            dao = new DbUtils(daoConfig);
            daoMap.put(daoConfig.getDbName(), dao);
        } else {
            dao.daoConfig = daoConfig;
        }
        SQLiteDatabase database = dao.database;
        int oldVersion = database.getVersion();
        int newVersion = daoConfig.getDbVersion();
        if (oldVersion != newVersion) {
            if (oldVersion != 0) {
                DbUpgradeListener upgradeListener = daoConfig.getDbUpgradeListener();
                if (upgradeListener != null) {
                    upgradeListener.onUpgrade(dao, oldVersion, newVersion);
                } else {
                    try {
                        dao.dropDb();
                    }
                    catch (DbException e) {
                        LogUtils.e(e.getMessage(), e);
                    }
                }
            }
            database.setVersion(newVersion);
        }
        return dao;
    }

    public static DbUtils create(Context context) {
        DaoConfig config = new DaoConfig(context);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(Context context, String dbName) {
        DaoConfig config = new DaoConfig(context);
        config.setDbName(dbName);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(Context context, String dbDir, String dbName) {
        DaoConfig config = new DaoConfig(context);
        config.setDbDir(dbDir);
        config.setDbName(dbName);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(Context context, String dbName, int dbVersion, DbUpgradeListener dbUpgradeListener) {
        DaoConfig config = new DaoConfig(context);
        config.setDbName(dbName);
        config.setDbVersion(dbVersion);
        config.setDbUpgradeListener(dbUpgradeListener);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(Context context, String dbDir, String dbName, int dbVersion, DbUpgradeListener dbUpgradeListener) {
        DaoConfig config = new DaoConfig(context);
        config.setDbDir(dbDir);
        config.setDbName(dbName);
        config.setDbVersion(dbVersion);
        config.setDbUpgradeListener(dbUpgradeListener);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(DaoConfig daoConfig) {
        return DbUtils.getInstance(daoConfig);
    }

    public DbUtils configDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public DbUtils configAllowTransaction(boolean allowTransaction) {
        this.allowTransaction = allowTransaction;
        return this;
    }

    public SQLiteDatabase getDatabase() {
        return this.database;
    }

    public DaoConfig getDaoConfig() {
        return this.daoConfig;
    }

    public void saveOrUpdate(Object entity) throws DbException {
        try {
            this.beginTransaction();
            this.createTableIfNotExist(entity.getClass());
            this.saveOrUpdateWithoutTransaction(entity);
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void saveOrUpdateAll(List<?> entities) throws DbException {
        if (entities == null || entities.size() == 0) {
            return;
        }
        try {
            this.beginTransaction();
            this.createTableIfNotExist(entities.get(0).getClass());
            for (Object entity : entities) {
                this.saveOrUpdateWithoutTransaction(entity);
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void replace(Object entity) throws DbException {
        try {
            this.beginTransaction();
            this.createTableIfNotExist(entity.getClass());
            this.execNonQuery(SqlInfoBuilder.buildReplaceSqlInfo(this, entity));
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void replaceAll(List<?> entities) throws DbException {
        if (entities == null || entities.size() == 0) {
            return;
        }
        try {
            this.beginTransaction();
            this.createTableIfNotExist(entities.get(0).getClass());
            for (Object entity : entities) {
                this.execNonQuery(SqlInfoBuilder.buildReplaceSqlInfo(this, entity));
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void save(Object entity) throws DbException {
        try {
            this.beginTransaction();
            this.createTableIfNotExist(entity.getClass());
            this.execNonQuery(SqlInfoBuilder.buildInsertSqlInfo(this, entity));
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void saveAll(List<?> entities) throws DbException {
        if (entities == null || entities.size() == 0) {
            return;
        }
        try {
            this.beginTransaction();
            this.createTableIfNotExist(entities.get(0).getClass());
            for (Object entity : entities) {
                this.execNonQuery(SqlInfoBuilder.buildInsertSqlInfo(this, entity));
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public boolean saveBindingId(Object entity) throws DbException {
        boolean result = false;
        try {
            this.beginTransaction();
            this.createTableIfNotExist(entity.getClass());
            result = this.saveBindingIdWithoutTransaction(entity);
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
        return result;
    }

    public void saveBindingIdAll(List<?> entities) throws DbException {
        if (entities == null || entities.size() == 0) {
            return;
        }
        try {
            this.beginTransaction();
            this.createTableIfNotExist(entities.get(0).getClass());
            for (Object entity : entities) {
                if (this.saveBindingIdWithoutTransaction(entity)) continue;
                throw new DbException("saveBindingId error, transaction will not commit!");
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteById(Class<?> entityType, Object idValue) throws DbException {
        if (!this.tableIsExist(entityType)) {
            return;
        }
        try {
            this.beginTransaction();
            this.execNonQuery(SqlInfoBuilder.buildDeleteSqlInfo(entityType, idValue));
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void delete(Object entity) throws DbException {
        if (!this.tableIsExist(entity.getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            this.execNonQuery(SqlInfoBuilder.buildDeleteSqlInfo(entity));
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void delete(Class<?> entityType, WhereBuilder whereBuilder) throws DbException {
        if (!this.tableIsExist(entityType)) {
            return;
        }
        try {
            this.beginTransaction();
            this.execNonQuery(SqlInfoBuilder.buildDeleteSqlInfo(entityType, whereBuilder));
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteAll(List<?> entities) throws DbException {
        if (entities == null || entities.size() == 0 || !this.tableIsExist(entities.get(0).getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            for (Object entity : entities) {
                this.execNonQuery(SqlInfoBuilder.buildDeleteSqlInfo(entity));
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteAll(Class<?> entityType) throws DbException {
        this.delete(entityType, null);
    }

    public void update(Object entity, String ... updateColumnNames) throws DbException {
        if (!this.tableIsExist(entity.getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            this.execNonQuery(SqlInfoBuilder.buildUpdateSqlInfo(this, entity, updateColumnNames));
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void update(Object entity, WhereBuilder whereBuilder, String ... updateColumnNames) throws DbException {
        if (!this.tableIsExist(entity.getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            this.execNonQuery(SqlInfoBuilder.buildUpdateSqlInfo(this, entity, whereBuilder, updateColumnNames));
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void updateAll(List<?> entities, String ... updateColumnNames) throws DbException {
        if (entities == null || entities.size() == 0 || !this.tableIsExist(entities.get(0).getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            for (Object entity : entities) {
                this.execNonQuery(SqlInfoBuilder.buildUpdateSqlInfo(this, entity, updateColumnNames));
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void updateAll(List<?> entities, WhereBuilder whereBuilder, String ... updateColumnNames) throws DbException {
        if (entities == null || entities.size() == 0 || !this.tableIsExist(entities.get(0).getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            for (Object entity : entities) {
                this.execNonQuery(SqlInfoBuilder.buildUpdateSqlInfo(this, entity, whereBuilder, updateColumnNames));
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public <T> T findById(Class<T> entityType, Object idValue) throws DbException {
        if (!this.tableIsExist(entityType)) {
            return null;
        }
        Id id = TableUtils.getId(entityType);
        Selector selector = Selector.from(entityType).where(id.getColumnName(), "=", idValue);
        String sql = selector.limit(1).toString();
        long seq = CursorUtils.FindCacheSequence.getSeq();
        this.findTempCache.setSeq(seq);
        Object obj = this.findTempCache.get(sql);
        if (obj != null) {
            return (T)obj;
        }
        Cursor cursor = this.execQuery(sql);
        if (cursor != null) {
            try {
                if (cursor.moveToNext()) {
                    T entity = CursorUtils.getEntity(this, cursor, entityType, seq);
                    this.findTempCache.put(sql, entity);
                    T t = entity;
                    return t;
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtils.closeQuietly(cursor);
            }
        }
        return null;
    }

    public <T> T findFirst(Selector selector) throws DbException {
        if (!this.tableIsExist(selector.getEntityType())) {
            return null;
        }
        String sql = selector.limit(1).toString();
        long seq = CursorUtils.FindCacheSequence.getSeq();
        this.findTempCache.setSeq(seq);
        Object obj = this.findTempCache.get(sql);
        if (obj != null) {
            return (T)obj;
        }
        Cursor cursor = this.execQuery(sql);
        if (cursor != null) {
            try {
                if (cursor.moveToNext()) {
                    Object entity = CursorUtils.getEntity(this, cursor, selector.getEntityType(), seq);
                    this.findTempCache.put(sql, entity);
                    Object obj2 = entity;
                    return (T)obj2;
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtils.closeQuietly(cursor);
            }
        }
        return null;
    }

    public <T> T findFirst(Class<T> entityType) throws DbException {
        return this.findFirst(Selector.from(entityType));
    }

    public <T> T findFirst(Class<T> entityType, WhereBuilder whereBuilder) throws DbException {
        return this.findFirst(Selector.from(entityType).where(whereBuilder));
    }

    public <T> T findFirst(Object entity) throws DbException {
        if (!this.tableIsExist(entity.getClass())) {
            return null;
        }
        Selector selector = Selector.from(entity.getClass());
        List<KeyValue> entityKvList = SqlInfoBuilder.entity2KeyValueList(this, entity);
        if (entityKvList != null) {
            WhereBuilder wb = WhereBuilder.b();
            for (KeyValue keyValue : entityKvList) {
                Object value = keyValue.getValue();
                if (value == null) continue;
                wb.and(keyValue.getKey(), "=", value);
            }
            selector.where(wb);
        }
        return this.findFirst(selector);
    }

    public <T> List<T> findAll(Selector selector) throws DbException {
        if (!this.tableIsExist(selector.getEntityType())) {
            return null;
        }
        String sql = selector.toString();
        long seq = CursorUtils.FindCacheSequence.getSeq();
        this.findTempCache.setSeq(seq);
        Object obj = this.findTempCache.get(sql);
        if (obj != null) {
            return (List)obj;
        }
        ArrayList result = new ArrayList();
        Cursor cursor = this.execQuery(sql);
        if (cursor != null) {
            try {
                try {
                    while (cursor.moveToNext()) {
                        Object entity = CursorUtils.getEntity(this, cursor, selector.getEntityType(), seq);
                        result.add(entity);
                    }
                    this.findTempCache.put(sql, result);
                }
                catch (Throwable e) {
                    throw new DbException(e);
                }
            }
            finally {
                IOUtils.closeQuietly(cursor);
            }
        }
        return result;
    }

    public <T> List<T> findAll(Class<T> entityType) throws DbException {
        return this.findAll(Selector.from(entityType));
    }

    public <T> List<T> findAll(Class<T> entityType, WhereBuilder whereBuilder) throws DbException {
        return this.findAll(Selector.from(entityType).where(whereBuilder));
    }

    public <T> List<T> findAll(Object entity) throws DbException {
        if (!this.tableIsExist(entity.getClass())) {
            return null;
        }
        Selector selector = Selector.from(entity.getClass());
        List<KeyValue> entityKvList = SqlInfoBuilder.entity2KeyValueList(this, entity);
        if (entityKvList != null) {
            WhereBuilder wb = WhereBuilder.b();
            for (KeyValue keyValue : entityKvList) {
                Object value = keyValue.getValue();
                if (value == null) continue;
                wb.and(keyValue.getKey(), "=", value);
            }
            selector.where(wb);
        }
        return this.findAll(selector);
    }

    public DbModel findDbModelFirst(SqlInfo sqlInfo) throws DbException {
        Cursor cursor = this.execQuery(sqlInfo);
        if (cursor != null) {
            try {
                if (cursor.moveToNext()) {
                    DbModel dbModel = CursorUtils.getDbModel(cursor);
                    return dbModel;
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtils.closeQuietly(cursor);
            }
        }
        return null;
    }

    public DbModel findDbModelFirst(DbModelSelector selector) throws DbException {
        if (!this.tableIsExist(selector.getEntityType())) {
            return null;
        }
        Cursor cursor = this.execQuery(selector.limit(1).toString());
        if (cursor != null) {
            try {
                if (cursor.moveToNext()) {
                    DbModel dbModel = CursorUtils.getDbModel(cursor);
                    return dbModel;
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtils.closeQuietly(cursor);
            }
        }
        return null;
    }

    public List<DbModel> findDbModelAll(SqlInfo sqlInfo) throws DbException {
        ArrayList<DbModel> dbModelList = new ArrayList<DbModel>();
        Cursor cursor = this.execQuery(sqlInfo);
        if (cursor != null) {
            try {
                try {
                    while (cursor.moveToNext()) {
                        dbModelList.add(CursorUtils.getDbModel(cursor));
                    }
                }
                catch (Throwable e) {
                    throw new DbException(e);
                }
            }
            finally {
                IOUtils.closeQuietly(cursor);
            }
        }
        return dbModelList;
    }

    public List<DbModel> findDbModelAll(DbModelSelector selector) throws DbException {
        if (!this.tableIsExist(selector.getEntityType())) {
            return null;
        }
        ArrayList<DbModel> dbModelList = new ArrayList<DbModel>();
        Cursor cursor = this.execQuery(selector.toString());
        if (cursor != null) {
            try {
                try {
                    while (cursor.moveToNext()) {
                        dbModelList.add(CursorUtils.getDbModel(cursor));
                    }
                }
                catch (Throwable e) {
                    throw new DbException(e);
                }
            }
            finally {
                IOUtils.closeQuietly(cursor);
            }
        }
        return dbModelList;
    }

    public long count(Selector selector) throws DbException {
        Class<?> entityType = selector.getEntityType();
        if (!this.tableIsExist(entityType)) {
            return 0L;
        }
        DbModelSelector dmSelector = selector.select("count(" + TableUtils.getId(entityType).getColumnName() + ") as count");
        return this.findDbModelFirst(dmSelector).getLong("count");
    }

    public long count(Class<?> entityType) throws DbException {
        return this.count(Selector.from(entityType));
    }

    public long count(Class<?> entityType, WhereBuilder whereBuilder) throws DbException {
        return this.count(Selector.from(entityType).where(whereBuilder));
    }

    public long count(Object entity) throws DbException {
        if (!this.tableIsExist(entity.getClass())) {
            return 0L;
        }
        Selector selector = Selector.from(entity.getClass());
        List<KeyValue> entityKvList = SqlInfoBuilder.entity2KeyValueList(this, entity);
        if (entityKvList != null) {
            WhereBuilder wb = WhereBuilder.b();
            for (KeyValue keyValue : entityKvList) {
                Object value = keyValue.getValue();
                if (value == null) continue;
                wb.and(keyValue.getKey(), "=", value);
            }
            selector.where(wb);
        }
        return this.count(selector);
    }

    private SQLiteDatabase createDatabase(DaoConfig config) {
        SQLiteDatabase result = null;
        String dbDir = config.getDbDir();
        if (!TextUtils.isEmpty((CharSequence)dbDir)) {
            File dir = new File(dbDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File dbFile = new File(dbDir, config.getDbName());
            result = SQLiteDatabase.openOrCreateDatabase((File)dbFile, null);
        } else {
            result = config.getContext().openOrCreateDatabase(config.getDbName(), 0, null);
        }
        return result;
    }

    private void saveOrUpdateWithoutTransaction(Object entity) throws DbException {
        Id id = TableUtils.getId(entity.getClass());
        if (id.isAutoIncrement()) {
            if (id.getColumnValue(entity) != null) {
                this.execNonQuery(SqlInfoBuilder.buildUpdateSqlInfo(this, entity, new String[0]));
            } else {
                this.saveBindingIdWithoutTransaction(entity);
            }
        } else {
            this.execNonQuery(SqlInfoBuilder.buildReplaceSqlInfo(this, entity));
        }
    }

    private boolean saveBindingIdWithoutTransaction(Object entity) throws DbException {
        Class<?> entityType = entity.getClass();
        String tableName = TableUtils.getTableName(entityType);
        Id idColumn = TableUtils.getId(entityType);
        if (idColumn.isAutoIncrement()) {
            this.execNonQuery(SqlInfoBuilder.buildInsertSqlInfo(this, entity));
            long id = this.getLastAutoIncrementId(tableName);
            if (id == -1L) {
                return false;
            }
            idColumn.setAutoIncrementId(entity, id);
            return true;
        }
        this.execNonQuery(SqlInfoBuilder.buildInsertSqlInfo(this, entity));
        return true;
    }

    private long getLastAutoIncrementId(String tableName) throws DbException {
        long id = -1L;
        Cursor cursor = this.execQuery("SELECT seq FROM sqlite_sequence WHERE name='" + tableName + "'");
        if (cursor != null) {
            try {
                try {
                    if (cursor.moveToNext()) {
                        id = cursor.getLong(0);
                    }
                }
                catch (Throwable e) {
                    throw new DbException(e);
                }
            }
            finally {
                IOUtils.closeQuietly(cursor);
            }
        }
        return id;
    }

    public void createTableIfNotExist(Class<?> entityType) throws DbException {
        if (!this.tableIsExist(entityType)) {
            SqlInfo sqlInfo = SqlInfoBuilder.buildCreateTableSqlInfo(entityType);
            this.execNonQuery(sqlInfo);
            String execAfterTableCreated = TableUtils.getExecAfterTableCreated(entityType);
            if (!TextUtils.isEmpty((CharSequence)execAfterTableCreated)) {
                this.execNonQuery(execAfterTableCreated);
            }
        }
    }

    public boolean tableIsExist(Class<?> entityType) throws DbException {
        Table table = Table.get(this, entityType);
        if (table.isCheckedDatabase()) {
            return true;
        }
        Cursor cursor = this.execQuery("SELECT COUNT(*) AS c FROM sqlite_master WHERE type='table' AND name='" + table.getTableName() + "'");
        if (cursor != null) {
            try {
                int count;
                if (cursor.moveToNext() && (count = cursor.getInt(0)) > 0) {
                    table.setCheckedDatabase(true);
                    return true;
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
            finally {
                IOUtils.closeQuietly(cursor);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dropDb() throws DbException {
        Cursor cursor = this.execQuery("SELECT name FROM sqlite_master WHERE type='table' AND name<>'sqlite_sequence'");
        if (cursor == null) return;
        try {
            try {
                while (true) {
                    if (!cursor.moveToNext()) {
                        return;
                    }
                    try {
                        String tableName = cursor.getString(0);
                        this.execNonQuery("DROP TABLE " + tableName);
                        Table.remove(this, tableName);
                    }
                    catch (Throwable e) {
                        LogUtils.e(e.getMessage(), e);
                    }
                }
            }
            catch (Throwable e) {
                throw new DbException(e);
            }
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
    }

    public void dropTable(Class<?> entityType) throws DbException {
        if (!this.tableIsExist(entityType)) {
            return;
        }
        String tableName = TableUtils.getTableName(entityType);
        this.execNonQuery("DROP TABLE " + tableName);
        Table.remove(this, entityType);
    }

    private void debugSql(String sql) {
        if (this.debug) {
            LogUtils.d(sql);
        }
    }

    private void beginTransaction() {
        if (this.allowTransaction) {
            this.database.beginTransaction();
        } else {
            this.writeLock.lock();
            this.writeLocked = true;
        }
    }

    private void setTransactionSuccessful() {
        if (this.allowTransaction) {
            this.database.setTransactionSuccessful();
        }
    }

    private void endTransaction() {
        if (this.allowTransaction) {
            this.database.endTransaction();
        }
        if (this.writeLocked) {
            this.writeLock.unlock();
            this.writeLocked = false;
        }
    }

    public void execNonQuery(SqlInfo sqlInfo) throws DbException {
        this.debugSql(sqlInfo.getSql());
        try {
            if (sqlInfo.getBindArgs() != null) {
                this.database.execSQL(sqlInfo.getSql(), sqlInfo.getBindArgsAsArray());
            } else {
                this.database.execSQL(sqlInfo.getSql());
            }
        }
        catch (Throwable e) {
            throw new DbException(e);
        }
    }

    public void execNonQuery(String sql) throws DbException {
        this.debugSql(sql);
        try {
            this.database.execSQL(sql);
        }
        catch (Throwable e) {
            throw new DbException(e);
        }
    }

    public Cursor execQuery(SqlInfo sqlInfo) throws DbException {
        this.debugSql(sqlInfo.getSql());
        try {
            return this.database.rawQuery(sqlInfo.getSql(), sqlInfo.getBindArgsAsStrArray());
        }
        catch (Throwable e) {
            throw new DbException(e);
        }
    }

    public Cursor execQuery(String sql) throws DbException {
        this.debugSql(sql);
        try {
            return this.database.rawQuery(sql, null);
        }
        catch (Throwable e) {
            throw new DbException(e);
        }
    }

    public static class DaoConfig {
        private Context context;
        private String dbName = "xUtils.db";
        private int dbVersion = 1;
        private DbUpgradeListener dbUpgradeListener;
        private String dbDir;

        public DaoConfig(Context context) {
            this.context = context;
        }

        public Context getContext() {
            return this.context;
        }

        public String getDbName() {
            return this.dbName;
        }

        public void setDbName(String dbName) {
            if (!TextUtils.isEmpty((CharSequence)dbName)) {
                this.dbName = dbName;
            }
        }

        public int getDbVersion() {
            return this.dbVersion;
        }

        public void setDbVersion(int dbVersion) {
            this.dbVersion = dbVersion;
        }

        public DbUpgradeListener getDbUpgradeListener() {
            return this.dbUpgradeListener;
        }

        public void setDbUpgradeListener(DbUpgradeListener dbUpgradeListener) {
            this.dbUpgradeListener = dbUpgradeListener;
        }

        public String getDbDir() {
            return this.dbDir;
        }

        public void setDbDir(String dbDir) {
            this.dbDir = dbDir;
        }
    }

    public static interface DbUpgradeListener {
        public void onUpgrade(DbUtils var1, int var2, int var3);
    }

    private class FindTempCache {
        private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();
        private long seq = 0L;

        private FindTempCache() {
        }

        public void put(String sql, Object result) {
            if (sql != null && result != null) {
                this.cache.put(sql, result);
            }
        }

        public Object get(String sql) {
            return this.cache.get(sql);
        }

        public void setSeq(long seq) {
            if (this.seq != seq) {
                this.cache.clear();
                this.seq = seq;
            }
        }
    }
}

