﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Bluetooth;
using Com.Rscja.Deviceapi;
using static Android.Views.View;
using Android.Views;
using Android.Content;
using Android.Util;
using Com.Rscja.Deviceapi.Interfaces;
using Java.Lang;
using System;
using System.Threading;
using Com.Rscja.Deviceapi.Entity;

namespace demo_uhf_ble
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : Activity, IOnClickListener
    {

        private static string TAG = "MainActivity";
        private const int REQUEST_ENABLE_BT = 2;
        private const int REQUEST_SELECT_DEVICE = 1;
        public BluetoothDevice mDevice = null;
        private Button btn_connect, btn_disconnect;
        private Button btStop, btStart;
        private TextView tvAddress, tvData;
        public BluetoothAdapter mBtAdapter = null;
        public RFIDWithUHFBLE uhf = RFIDWithUHFBLE.Instance;
        private bool isInventorying = false;
        private UIHand hand = null;
        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            SetContentView(Resource.Layout.activity_main);
            //--------ui------------
            tvAddress = FindViewById<TextView>(Resource.Id.tvAddress);
            tvData = FindViewById<TextView>(Resource.Id.tvData);
            btn_connect = FindViewById<Button>(Resource.Id.btn_connect);
            btn_disconnect = FindViewById<Button>(Resource.Id.btn_disconnect);
            btStop = FindViewById<Button>(Resource.Id.btStop);
            btStart = FindViewById<Button>(Resource.Id.btStart);
            btStop.SetOnClickListener(this);
            btStart.SetOnClickListener(this);
            btn_connect.SetOnClickListener(this);
            btn_disconnect.SetOnClickListener(this);
            hand = new UIHand(this);
            //--------------------
            uhf.Init(this);
            uhf.SetKeyEventCallback(new KeyEventCallback(this));
            mBtAdapter = BluetoothAdapter.DefaultAdapter;
        }
        protected override void OnDestroy()
        {
            disconnect();
            uhf.Free();
            base.OnDestroy();
        }
        public void OnClick(View v)
        {
            switch (v.Id)
            {
                case Resource.Id.btn_connect:
                    showBluetoothDevice();
                    break;
                case Resource.Id.btn_disconnect:
                    disconnect();
                    break;
                case Resource.Id.btStop:
                    stopInventory();
                    break;
                case Resource.Id.btStart:
                    startInventory();
                    break;
            }
        }

        private void enableButton(ConnectionStatus connectionStatus)
        {
            if (connectionStatus == ConnectionStatus.Connected)
            {
                btn_connect.Enabled = false;
                btStop.Enabled = true;
                btStart.Enabled = true;
                btn_disconnect.Enabled = true;
            }
            else if (connectionStatus == ConnectionStatus.Disconnected)
            {
                btn_connect.Enabled = true;
                btn_disconnect.Enabled = false;
                btStart.Enabled = false;
                btStop.Enabled = false;
            }
            else if (connectionStatus == ConnectionStatus.Connecting)
            {
                btn_connect.Enabled = false;
                btn_disconnect.Enabled = false;
                btStart.Enabled = false;
                btStop.Enabled = false;
            }
        }




        #region  Search \ connect  

                private void showBluetoothDevice()
                {
                    if (mBtAdapter == null)
                    {
                        Toast.MakeText(this, "Bluetooth is not available", ToastLength.Short).Show();
                        return;
                    }
          
                    if (!mBtAdapter.IsEnabled)
                    {
                        Log.Info(TAG, "onClick - BT not enabled yet");
                        Intent enableIntent = new Intent(BluetoothAdapter.ActionRequestEnable);
                        StartActivityForResult(enableIntent, REQUEST_ENABLE_BT);
                    }
                    else
                    {
                        StartActivityForResult(typeof(DeviceListActivity), REQUEST_SELECT_DEVICE);
                    }
                }
                protected override void OnActivityResult(int requestCode, Android.App.Result resultCode, Intent data)
                {
                    base.OnActivityResult(requestCode, resultCode, data);
                    switch (requestCode)
                    {
                        case REQUEST_SELECT_DEVICE:
                            if (resultCode == Result.Ok && data != null)
                            {
                                string deviceAddress = data.GetStringExtra(BluetoothDevice.ExtraDevice);
                                mDevice = BluetoothAdapter.DefaultAdapter.GetRemoteDevice(deviceAddress);
                                tvAddress.Text = mDevice.Name + "(" + deviceAddress + ")\r\n connecting";
                                connect(deviceAddress);
                            }
                            break;
                    }
                }
                /*
                 * 连接蓝牙
                 */
                public void connect(string deviceAddress)
                {
                    enableButton(ConnectionStatus.Connecting);
                    uhf.Connect(deviceAddress, new ConnectionStatusCallback(this));
                }
                /*
                 * 断开蓝牙
                 */
                public void disconnect()
                {
                    stopInventory();
                    uhf.Disconnect();
                }

                class ConnectionStatusCallback : Java.Lang.Object, IConnectionStatusCallback
                {
                    MainActivity mainActivity = null;
                    public ConnectionStatusCallback(MainActivity mainActivity)
                    {
                        this.mainActivity = mainActivity;
                    }
                    public void GetStatus(ConnectionStatus connectionStatus, Java.Lang.Object device1)
                    {
                        BluetoothDevice device = (BluetoothDevice)device1;
                        if (connectionStatus == ConnectionStatus.Connected)
                        {
                            mainActivity.RunOnUiThread(() => mainActivity.tvAddress.Text = device.Name + "(" + device.Address + ")\r\n connected");
                        }
                        else if (connectionStatus == ConnectionStatus.Disconnected)
                        {
                            if (device != null)
                            {
                                mainActivity.RunOnUiThread(() => mainActivity.tvAddress.Text = device.Name + "(" + device.Address + ")\r\n disconnected");
                            }
                            else
                            {

                                mainActivity.RunOnUiThread(() => mainActivity.tvAddress.Text = "disconnected");
                            }
                            mainActivity.stopInventory();
                        }

                        mainActivity.RunOnUiThread(() => mainActivity.enableButton(connectionStatus));

                    }

                }
#endregion


        #region  Inventory
         /*
         * 开始盘点
         */
            public void startInventory()
            {
                if (uhf.StartInventoryTag())
                {
                    btStart.Enabled = false;
                    btStop.Enabled = true;
                    isInventorying = true;
                    read();
                }
                else
                {
                    Toast.MakeText(this, "fail", ToastLength.Short).Show();
                }
            }
             /*
             * 停止盘点
             */
             public void stopInventory()
             {
                if (isInventorying)
                {
                    isInventorying = false;
                    uhf.StopInventory();
                }
                btStop.Enabled = false;  
                btStart.Enabled = true;
             }

             public void read()
             {
                System.Threading.Thread th = new System.Threading.Thread(new ThreadStart(delegate
                {
                    while (isInventorying)
                    {
                        System.Collections.Generic.IList<UHFTAGInfo> list = uhf.ReadTagFromBufferList();
                        if (list != null && list.Count > 0)
                        {
                            foreach (UHFTAGInfo info in list)
                            {
                                Message msg = hand.ObtainMessage();
                                msg.Obj = info;
                                hand.SendMessage(msg);
                            }
                        }
                        else
                        {
                            System.Threading.Thread.Sleep(2);
                        }
                    }
                }));
                th.IsBackground = true;
                th.Start();
            }
             public class UIHand : Handler
            {
                MainActivity mainActivity;
                public UIHand(MainActivity main)
                {
                    this.mainActivity = main;
                }
                public override void HandleMessage(Message msg)
                {
                    UHFTAGInfo info = (UHFTAGInfo)msg.Obj;
                    mainActivity.tvData.Append(info.EPC);
                    mainActivity.tvData.Append("\r\n");
                }
            }

    
        class KeyEventCallback : Java.Lang.Object,IKeyEventCallback
        {
            MainActivity mainActivity = null;
            public KeyEventCallback(MainActivity mainActivity)
            {
                this.mainActivity = mainActivity;
            }
            public void OnKeyDown(int keyCOde)
            {
                if (mainActivity.btStart.Enabled)
                {
                    mainActivity.startInventory();
                }
                else
                {
                    mainActivity.stopInventory();
                }
            }

            public void OnKeyUp(int p0)
            {
                
            }
        }

        #endregion

    }
 
  

}