﻿using System;
using System.Collections.Generic;
using System.Drawing;
using Android;
using Android.App;
using Android.Bluetooth;
using Android.Content;
using Android.Content.Res;
using Android.Graphics.Drawables;
using Android.OS;
using Android.Provider;
using Android.Runtime;
using Android.Util;
using Android.Views;
using Android.Widget;
using Com.Rscja.Deviceapi;
using Com.Rscja.Deviceapi.Interfaces;
using Java.Lang;
using Java.Util;
using static Android.Media.Audiofx.BassBoost;
using static Android.Views.View;
using static Android.Widget.AdapterView;

namespace demo_uhf_ble
{
    [Activity(Label = "DeviceListActivity")]
    public class DeviceListActivity : Activity,IOnClickListener
    {

        private const int MSG_TIMEOUT = 0;
        private TextView mEmptyList;
        public const string TAG = "DeviceListActivity";
        private TextView tvTitle;
        private List<MyDevice> deviceList;
        private DeviceAdapter deviceAdapter;
        private IDictionary<string, int> devRssiValues;
        private const long SCAN_PERIOD = 10000; //10 seconds
        Button btn_cancel = null;
        ImageView close = null;
        private bool mScanning;
        UIHand mHandler = null;


        public class UIHand : Handler
        {
            DeviceListActivity deviceListActivity = null;
            public UIHand(DeviceListActivity main)
            {
                this.deviceListActivity = main;  
            }
            public override void HandleMessage(Message msg)
            {
                if (msg.What == MSG_TIMEOUT)
                {
                    deviceListActivity.stopBLEDevice();
                }
            }
        }

        protected override void OnCreate(Bundle savedInstanceState)
        {
            RequestWindowFeature(WindowFeatures.NoTitle);
            base.OnCreate(savedInstanceState);
            SetContentView(Resource.Layout.activity_devicelist);
    

            mHandler = new UIHand(this);
            // 设置窗体背景透明
            Window.SetBackgroundDrawable(new ColorDrawable(Android.Graphics.Color.Transparent));
            string FEATURE_BLUETOOTH_LE = "android.hardware.bluetooth_le";
            if (!PackageManager.HasSystemFeature(FEATURE_BLUETOOTH_LE))
            {
                Toast.MakeText(this, "Bluetooth Low Energy not supported!", ToastLength.Short).Show();
                Finish();
            }
            initUI();
            if (!checkLocationEnable())
            {
                Finish();
            }
            startBLEDevice();
        }

        protected override void OnStop()
        {
            stopBLEDevice();
            mHandler.RemoveMessages(MSG_TIMEOUT);
            base.OnStop();
        }


        protected override void OnDestroy()
        {
            stopBLEDevice();
            base.OnDestroy();
        }
        private void initUI()
        {
            btn_cancel = FindViewById<Button>(Resource.Id.btn_cancel);
            close = FindViewById<ImageView>(Resource.Id.close);
            tvTitle = FindViewById<TextView>(Resource.Id.title_devices);
            mEmptyList = FindViewById<TextView>(Resource.Id.empty);

            devRssiValues = new JavaDictionary<string, int>();
            deviceList = new List<MyDevice>();
            deviceAdapter = new DeviceAdapter(this, deviceList);
            tvTitle.Text = "Select a device";
            mEmptyList.Text = "Scanning...";
            ListView newDevicesListView = FindViewById<ListView>(Resource.Id.new_devices);
            newDevicesListView.Adapter = deviceAdapter;

            //  newDevicesListView.SetOnItemClickListener();
            //  newDevicesListView.SetOnContextClickListener(new OnItemClickListener());

            newDevicesListView.ItemClick += new EventHandler<AdapterView.ItemClickEventArgs>(ListView_ItemClick);
            void ListView_ItemClick(object sender, AdapterView.ItemClickEventArgs e)
            {
                MyDevice device =  deviceList[e.Position];
                stopBLEDevice();

                string address = device.getAddress();
                if (!string.IsNullOrEmpty(address))
                {
                    Bundle b = new Bundle();
                    b.PutString(BluetoothDevice.ExtraDevice, device.getAddress());

                    Intent result = new Intent();
                    result.PutExtras(b);
                    SetResult(Result.Ok, result);
                    Finish();
                }
                else
                {
                    Toast.MakeText(this, "Invalid Bluetooth address", ToastLength.Short).Show();
                }
                
            }


            close.SetOnClickListener(this);
            btn_cancel.SetOnClickListener(this);
        }
        public void OnClick(View v)
        {
            switch (v.Id)
            {
                case Resource.Id.close:
                    Finish();
                    break;
                case Resource.Id.btn_cancel:
                    if (mScanning == false)
                    {
                        startBLEDevice();
                    }
                    else
                    {
                        Finish();
                    }
                    break;
            }
        }
         
        private void startBLEDevice()
        {
            mScanning = true;
            btn_cancel.Text = "Cancel";
            mHandler.SendEmptyMessageDelayed(MSG_TIMEOUT, SCAN_PERIOD);
            RFIDWithUHFBLE.Instance.StartScanBTDevices(new ScanBTCallback(this));
        }
        public void stopBLEDevice()
        {
            mScanning = false;
            mHandler.RemoveMessages(MSG_TIMEOUT);
            RFIDWithUHFBLE.Instance.StopScanBTDevices();
            btn_cancel.Text = "Scan";
        }
        class ScanBTCallback : Java.Lang.Object, IScanBTCallback
        {
            DeviceListActivity deviceListActivity;
            public ScanBTCallback(DeviceListActivity deviceListActivity) {
                this.deviceListActivity = deviceListActivity;
            }
            public void GetDevices(BluetoothDevice bluetoothDevice, int rssi, byte[] bytes)
            {
                Log.Debug(TAG, "success");
                MyDevice myDevice = new MyDevice(bluetoothDevice.Address, bluetoothDevice.Name);
                deviceListActivity.addDevice(myDevice, rssi);
            }
        }
         
        private void addDevice(MyDevice device, int rssi)
        {
            bool deviceFound = false;
            foreach (MyDevice listDev in deviceList)
            {
                if (listDev.getAddress() == device.getAddress())
                {
                    deviceFound = true;
                    break;
                }
            }
            if (devRssiValues.ContainsKey(device.getAddress()))
            {
                devRssiValues.Remove(device.getAddress());
            }
            devRssiValues.Add(device.getAddress(), rssi);

            if (!deviceFound)
            {
                deviceList.Add(device);
                mEmptyList.Visibility = ViewStates.Gone;
            }

            if (!deviceFound) {
                deviceAdapter.NotifyDataSetChanged();
            }
        }
  
        class MyDevice: Java.Lang.Object
        {
            private string address;
            private string name;
            private int bondState;
            public MyDevice(string address, string name)
            {
                this.address = address;
                this.name = name;
            }

            public string getAddress()
            {
                return address;
            }

            public void setAddress(string address)
            {
                this.address = address;
            }

            public string getName()
            {
                return name;
            }

            public void setName(string name)
            {
                this.name = name;
            }

            public int getBondState()
            {
                return bondState;
            }

            public void setBondState(int bondState)
            {
                this.bondState = bondState;
            }
        }

        class DeviceAdapter : BaseAdapter
        {
            DeviceListActivity context;
            List<MyDevice> devices;
            LayoutInflater inflater;

            public DeviceAdapter(DeviceListActivity context, List<MyDevice> devices)
            {
                this.context = context;
                inflater = LayoutInflater.From(context);
                this.devices = devices;
            }

            public override int Count => devices.Count;

            public override Java.Lang.Object GetItem(int position)
            {
                return devices[position];
            }

            public override long GetItemId(int position)
            {
                return position; 
            }

            public override View GetView(int position, View convertView, ViewGroup parent)
            {
                ViewGroup vg;
                if (convertView != null)
                {
                    vg = (ViewGroup)convertView;
                }
                else
                {
                    vg = (ViewGroup)inflater.Inflate(Resource.Layout.device_element, null);
                }
                
                  MyDevice device = devices[position];
                  TextView tvadd = vg.FindViewById<TextView>(Resource.Id.address);
                  TextView tvname = vg.FindViewById<TextView>(Resource.Id.name);
                  TextView tvpaired = vg.FindViewById<TextView>(Resource.Id.paired);
                  TextView tvrssi = vg.FindViewById<TextView>(Resource.Id.rssi);

                 
                int rssival = context.devRssiValues[device.getAddress()];  
                if (rssival != 0)
                {
                    tvrssi.Text = "Rssi = " + rssival;
                    tvrssi.SetTextColor(ColorStateList.ValueOf(Android.Graphics.Color.Black));
                    tvrssi.Visibility = ViewStates.Visible;
                }

                tvname.Text = device.getName();
                tvname.SetTextColor(ColorStateList.ValueOf(Android.Graphics.Color.Black));
                tvadd.Text = device.getAddress();
                tvadd.SetTextColor(ColorStateList.ValueOf(Android.Graphics.Color.Black));
                const int BOND_BONDED = 12;
                if (device.getBondState() == BOND_BONDED)
                {
                    Log.Info(TAG, "device::" + device.getName());
                    tvpaired.Text = "No Matching";
                    tvpaired.SetTextColor(ColorStateList.ValueOf(Android.Graphics.Color.Red));
                    tvpaired.Visibility = ViewStates.Visible;
                }
                else
                {
                    tvpaired.Visibility = ViewStates.Gone;
                }

                return vg;
            }

         

        }


        //------------------搜索蓝牙设备需要定位权限---获取定位权限--------------------------------
        private const int ACCESS_FINE_LOCATION_PERMISSION_REQUEST = 100;
        private const int REQUEST_ACTION_LOCATION_SETTINGS = 3;

        private bool checkLocationEnable()
        {

            bool result = true;
            if (Build.VERSION.SdkInt >= BuildVersionCodes.M)
            {
                if (CheckSelfPermission(Manifest.Permission.AccessFineLocation) != 0)
                {
                    RequestPermissions(new string[] { Manifest.Permission.AccessFineLocation }, ACCESS_FINE_LOCATION_PERMISSION_REQUEST);
                    result = false;
                }
            }
            if (!isLocationEnabled())
            {
                alert(this, "Get location permission", "Do you enter the settings interface to open the location permission?");

            }
            return result;
        }

        private bool isLocationEnabled()
        {
            if (Build.VERSION.SdkInt >= BuildVersionCodes.Kitkat)
            {
                int locationMode = Android.Provider.Settings.Secure.GetInt(ContentResolver, Android.Provider.Settings.Secure.LocationMode);
                return locationMode != 0;
            }
            else
            {
                string locationProviders = Android.Provider.Settings.Secure.GetString(ContentResolver, Android.Provider.Settings.Secure.LocationProvidersAllowed);
                return !string.IsNullOrEmpty(locationProviders);
            }
        }

        class DialogInterfaceOnClickListenerPost : Java.Lang.Object, IDialogInterfaceOnClickListener
        {
            DeviceListActivity deviceListActivity;
            public DialogInterfaceOnClickListenerPost(DeviceListActivity deviceListActivity) {
                this.deviceListActivity = deviceListActivity;
            }
            public void OnClick(IDialogInterface dialog, int which)
            {
                Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                deviceListActivity.StartActivityForResult(intent, REQUEST_ACTION_LOCATION_SETTINGS);
                dialog.Dismiss();
            }
        }
        class DialogInterfaceOnClickListenerNegative : Java.Lang.Object, IDialogInterfaceOnClickListener
        {
            public void OnClick(IDialogInterface dialog, int which)
            {
                dialog.Dismiss();
            }
        }

        public void alert(Activity act, string title, string message)
        {
            AlertDialog.Builder builder = new AlertDialog.Builder(act);
            builder.SetTitle(title);
            builder.SetMessage(message);
            builder.SetNegativeButton("Close", new DialogInterfaceOnClickListenerNegative());
            builder.SetPositiveButton("OK", new DialogInterfaceOnClickListenerPost(this));
            builder.Create().Show();
        }
    }
}