/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http;

import com.lidroid.xutils.HttpUtils;
import com.lidroid.xutils.exception.HttpException;
import com.lidroid.xutils.http.HttpCache;
import com.lidroid.xutils.http.ResponseStream;
import com.lidroid.xutils.http.callback.DefaultHttpRedirectHandler;
import com.lidroid.xutils.http.callback.HttpRedirectHandler;
import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;

public class SyncHttpHandler {
    private final AbstractHttpClient client;
    private final HttpContext context;
    private HttpRedirectHandler httpRedirectHandler;
    private String requestUrl;
    private String requestMethod;
    private String charset;
    private int retriedTimes = 0;
    private long expiry = HttpCache.getDefaultExpiryTime();

    public void setHttpRedirectHandler(HttpRedirectHandler httpRedirectHandler) {
        this.httpRedirectHandler = httpRedirectHandler;
    }

    public SyncHttpHandler(AbstractHttpClient client, HttpContext context, String charset) {
        this.client = client;
        this.context = context;
        this.charset = charset;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    public ResponseStream sendRequest(HttpRequestBase request) throws HttpException {
        IOException exception;
        boolean retry;
        HttpRequestRetryHandler retryHandler = this.client.getHttpRequestRetryHandler();
        do {
            retry = true;
            exception = null;
            try {
                String result;
                this.requestUrl = request.getURI().toString();
                this.requestMethod = request.getMethod();
                if (HttpUtils.sHttpCache.isEnabled(this.requestMethod) && (result = HttpUtils.sHttpCache.get(this.requestUrl)) != null) {
                    return new ResponseStream(result);
                }
                HttpResponse response = this.client.execute((HttpUriRequest)request, this.context);
                return this.handleResponse(response);
            }
            catch (UnknownHostException e) {
                exception = e;
                retry = retryHandler.retryRequest(exception, ++this.retriedTimes, this.context);
            }
            catch (IOException e) {
                exception = e;
                retry = retryHandler.retryRequest(exception, ++this.retriedTimes, this.context);
            }
            catch (NullPointerException e) {
                exception = new IOException(e.getMessage());
                exception.initCause(e);
                retry = retryHandler.retryRequest(exception, ++this.retriedTimes, this.context);
            }
            catch (HttpException e) {
                throw e;
            }
            catch (Throwable e) {
                exception = new IOException(e.getMessage());
                exception.initCause(e);
                retry = retryHandler.retryRequest(exception, ++this.retriedTimes, this.context);
            }
        } while (retry);
        throw new HttpException(exception);
    }

    private ResponseStream handleResponse(HttpResponse response) throws HttpException, IOException {
        if (response == null) {
            throw new HttpException("response is null");
        }
        StatusLine status = response.getStatusLine();
        int statusCode = status.getStatusCode();
        if (statusCode < 300) {
            ResponseStream responseStream = new ResponseStream(response, this.charset, this.requestUrl, this.expiry);
            responseStream.setRequestMethod(this.requestMethod);
            return responseStream;
        }
        if (statusCode == 301 || statusCode == 302) {
            HttpRequestBase request;
            if (this.httpRedirectHandler == null) {
                this.httpRedirectHandler = new DefaultHttpRedirectHandler();
            }
            if ((request = this.httpRedirectHandler.getDirectRequest(response)) != null) {
                return this.sendRequest(request);
            }
        } else {
            if (statusCode == 416) {
                throw new HttpException(statusCode, "maybe the file has downloaded completely");
            }
            throw new HttpException(statusCode, status.getReasonPhrase());
        }
        return null;
    }
}

