/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http.client.entity;

import com.lidroid.xutils.http.callback.RequestCallBackHandler;
import com.lidroid.xutils.http.client.entity.UploadEntity;
import com.lidroid.xutils.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.http.entity.FileEntity;

public class FileUploadEntity
extends FileEntity
implements UploadEntity {
    private long fileSize;
    private long uploadedSize = 0L;
    private RequestCallBackHandler callBackHandler = null;

    public FileUploadEntity(File file, String contentType) {
        super(file, contentType);
        this.fileSize = file.length();
    }

    public void writeTo(OutputStream outStream) throws IOException {
        if (outStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream inStream = null;
        try {
            int len;
            inStream = new FileInputStream(this.file);
            byte[] tmp = new byte[4096];
            while ((len = ((InputStream)inStream).read(tmp)) != -1) {
                outStream.write(tmp, 0, len);
                this.uploadedSize += (long)len;
                if (this.callBackHandler == null || this.callBackHandler.updateProgress(this.fileSize, this.uploadedSize, false)) continue;
                throw new InterruptedIOException("stop");
            }
            outStream.flush();
            if (this.callBackHandler != null) {
                this.callBackHandler.updateProgress(this.fileSize, this.uploadedSize, true);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inStream);
            throw throwable;
        }
        IOUtils.closeQuietly(inStream);
    }

    @Override
    public void setCallBackHandler(RequestCallBackHandler callBackHandler) {
        this.callBackHandler = callBackHandler;
    }
}

