/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.sqlite;

import com.lidroid.xutils.db.sqlite.Selector;
import com.lidroid.xutils.db.table.ColumnUtils;
import com.lidroid.xutils.db.table.Foreign;
import com.lidroid.xutils.db.table.TableUtils;
import com.lidroid.xutils.exception.DbException;
import java.util.List;

public class ForeignLazyLoader<T> {
    private final Foreign foreignColumn;
    private Object columnValue;

    public ForeignLazyLoader(Class<?> entityType, String columnName, Object value) {
        this.foreignColumn = (Foreign)TableUtils.getColumnOrId(entityType, columnName);
        this.columnValue = ColumnUtils.convert2DbColumnValueIfNeeded(value);
    }

    public ForeignLazyLoader(Foreign foreignColumn, Object value) {
        this.foreignColumn = foreignColumn;
        this.columnValue = ColumnUtils.convert2DbColumnValueIfNeeded(value);
    }

    public List<T> getAllFromDb() throws DbException {
        List entities = null;
        if (this.foreignColumn != null && this.foreignColumn.db != null) {
            entities = this.foreignColumn.db.findAll(Selector.from(this.foreignColumn.getForeignEntityType()).where(this.foreignColumn.getForeignColumnName(), "=", this.columnValue));
        }
        return entities;
    }

    public T getFirstFromDb() throws DbException {
        T entity = null;
        if (this.foreignColumn != null && this.foreignColumn.db != null) {
            entity = this.foreignColumn.db.findFirst(Selector.from(this.foreignColumn.getForeignEntityType()).where(this.foreignColumn.getForeignColumnName(), "=", this.columnValue));
        }
        return entity;
    }

    public void setColumnValue(Object value) {
        this.columnValue = ColumnUtils.convert2DbColumnValueIfNeeded(value);
    }

    public Object getColumnValue() {
        return this.columnValue;
    }
}

