/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http;

import android.text.TextUtils;
import com.lidroid.xutils.http.client.HttpRequest;
import com.lidroid.xutils.util.core.LruMemoryCache;
import java.util.concurrent.ConcurrentHashMap;

public class HttpCache {
    private final LruMemoryCache<String, String> mMemoryCache;
    private static final int DEFAULT_CACHE_SIZE = 102400;
    private static final long DEFAULT_EXPIRY_TIME = 60000L;
    private int cacheSize = 102400;
    private static long defaultExpiryTime = 60000L;
    private static final ConcurrentHashMap<String, Boolean> httpMethod_enabled_map = new ConcurrentHashMap(10);

    static {
        httpMethod_enabled_map.put(HttpRequest.HttpMethod.GET.toString(), true);
    }

    public HttpCache() {
        this(102400, 60000L);
    }

    public HttpCache(int strLength, long defaultExpiryTime) {
        this.cacheSize = strLength;
        HttpCache.defaultExpiryTime = defaultExpiryTime;
        this.mMemoryCache = new LruMemoryCache<String, String>(this.cacheSize){

            @Override
            protected int sizeOf(String key, String value) {
                if (value == null) {
                    return 0;
                }
                return value.length();
            }
        };
    }

    public void setCacheSize(int strLength) {
        this.mMemoryCache.setMaxSize(strLength);
    }

    public static void setDefaultExpiryTime(long defaultExpiryTime) {
        HttpCache.defaultExpiryTime = defaultExpiryTime;
    }

    public static long getDefaultExpiryTime() {
        return defaultExpiryTime;
    }

    public void put(String url, String result) {
        this.put(url, result, defaultExpiryTime);
    }

    public void put(String url, String result, long expiry) {
        if (url == null || result == null || expiry < 1L) {
            return;
        }
        this.mMemoryCache.put(url, result, System.currentTimeMillis() + expiry);
    }

    public String get(String url) {
        return url != null ? this.mMemoryCache.get(url) : null;
    }

    public void clear() {
        this.mMemoryCache.evictAll();
    }

    public boolean isEnabled(HttpRequest.HttpMethod method) {
        if (method == null) {
            return false;
        }
        Boolean enabled = httpMethod_enabled_map.get(method.toString());
        return enabled == null ? false : enabled;
    }

    public boolean isEnabled(String method) {
        if (TextUtils.isEmpty((CharSequence)method)) {
            return false;
        }
        Boolean enabled = httpMethod_enabled_map.get(method.toUpperCase());
        return enabled == null ? false : enabled;
    }

    public void setEnabled(HttpRequest.HttpMethod method, boolean enabled) {
        httpMethod_enabled_map.put(method.toString(), enabled);
    }
}

