/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.bitmap;

import android.widget.AbsListView;
import com.lidroid.xutils.BitmapUtils;

public class PauseOnScrollListener
implements AbsListView.OnScrollListener {
    private BitmapUtils bitmapUtils;
    private final boolean pauseOnScroll;
    private final boolean pauseOnFling;
    private final AbsListView.OnScrollListener externalListener;

    public PauseOnScrollListener(BitmapUtils bitmapUtils, boolean pauseOnScroll, boolean pauseOnFling) {
        this(bitmapUtils, pauseOnScroll, pauseOnFling, null);
    }

    public PauseOnScrollListener(BitmapUtils bitmapUtils, boolean pauseOnScroll, boolean pauseOnFling, AbsListView.OnScrollListener customListener) {
        this.bitmapUtils = bitmapUtils;
        this.pauseOnScroll = pauseOnScroll;
        this.pauseOnFling = pauseOnFling;
        this.externalListener = customListener;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        switch (scrollState) {
            case 0: {
                this.bitmapUtils.resumeTasks();
                break;
            }
            case 1: {
                if (!this.pauseOnScroll) break;
                this.bitmapUtils.pauseTasks();
                break;
            }
            case 2: {
                if (!this.pauseOnFling) break;
                this.bitmapUtils.pauseTasks();
            }
        }
        if (this.externalListener != null) {
            this.externalListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.externalListener != null) {
            this.externalListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }
}

