/*
 * Created by JFormDesigner on Fri Oct 21 19:25:55 CST 2022
 */

package com.uhf.form;

import java.awt.event.*;
import java.util.*;

import com.rscja.deviceapi.entity.ReaderIPEntity;
import com.rscja.deviceapi.entity.WifiConfig;
import com.uhf.UHFMainForm;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.awt.*;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.*;

import static com.uhf.utils.StringUtils.isIPAddress;

/**
 * @author Brainrain
 */
public class WifiAndInterForm extends JPanel {

    private final Map<String, Integer> IS_STATIC_IP_MAP = new HashMap<String, Integer>() {
        {
            put("Dynamic", 0);
            put("Static", 1);
        }
    };
    private final String[] tableColumnName = {"INDEX", "SSID", "BSSID", "Status", "Security Type"};
    private final DefaultTableModel tableModel = new DefaultTableModel(tableColumnName, 0);
    private ListSelectionListener selectionListener;

    public WifiAndInterForm() {
        initComponents();
        initUI();
    }

    private void initUI() {
        table.setModel(tableModel);
        DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();//单元格渲染器
        tcr.setHorizontalAlignment(JLabel.CENTER);//居中显示
        table.setDefaultRenderer(Object.class, tcr);
        table.getColumnModel().getColumn(0).setPreferredWidth(100);
        table.getColumnModel().getColumn(1).setPreferredWidth(200);
        table.getColumnModel().getColumn(2).setPreferredWidth(200);
        table.getColumnModel().getColumn(3).setPreferredWidth(100);
        table.getColumnModel().getColumn(4).setPreferredWidth(300);
        selectionListener = new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent event) {
                tfWifiSSID.setText((String) tableModel.getValueAt(table.getSelectedRow(), 1));
                String securityType = ((String) tableModel.getValueAt(table.getSelectedRow(), 4));
                // System.out.println(securityType);
                if (securityType.contains("WEP")) {
                    cbWifiSecurityType.setSelectedIndex(0);
                } else if (securityType.contains("WPA")) {
                    cbWifiSecurityType.setSelectedIndex(1);
                } else if (securityType.contains("NOPASS")) {
                    cbWifiSecurityType.setSelectedIndex(2);
                } else {
                    cbWifiSecurityType.setSelectedIndex(3);
                }
            }
        };
        table.getSelectionModel().addListSelectionListener(selectionListener);
    }

    /**
     * 验证几个IP的合法性
     */
    private boolean verifyIPConfig(String ip, String gateWay, String subNetMask, String dns1, String dns2) {
        if (!isIPAddress(ip)) {
            JOptionPane.showMessageDialog(this, "The IP address is invalid!", "", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        if (!isIPAddress(gateWay)) {
            JOptionPane.showMessageDialog(this, "The Gateway is invalid!", "", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        if (!isIPAddress(subNetMask)) {
            JOptionPane.showMessageDialog(this, "The Subnet Mask is invalid!", "", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        if (!isIPAddress(dns1)) {
            JOptionPane.showMessageDialog(this, "The DNS1 is invalid!", "", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        if (!dns2.equals("") && !isIPAddress(dns2)) {
            JOptionPane.showMessageDialog(this, "The DNS2 is invalid!", "", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        return true;
    }

    /**
     * IP地址加 1, 调用前需保证IP地址合法
     *
     * @param ip
     * @return
     */
    private String IPIncrease(String ip) {
        String[] ips;
        ips = ip.split("\\.");
        String res = "";
        try {
            // ip地址：ip0.ip1.ip2.ip3
            int ip0 = Integer.parseInt(ips[0]), ip1 = Integer.parseInt(ips[1]), ip2 = Integer.parseInt(ips[2]), ip3 = Integer.parseInt(ips[3]) + 1;
            if (ip3 >= 256) {
                ip3 = 0;
                if (++ip2 >= 256) {
                    ip2 = 0;
                    if (++ip1 >= 256) {
                        ip1 = 0;
                        if (++ip0 >= 256) {
                            ip0 = 0;
                        }
                    }
                }
            }
            res = "" + ip0 + "." + ip1 + "." + ip2 + "." + ip3;
        } catch (Exception e) {
            return "";
        }
        return res;
    }


    private void btnEthernetSetActionPerformed(ActionEvent e) {
        if (!verifyIPConfig(tfEthernetIP.getText(), tfEthernetGateway.getText(), tfEthernetSubnetMask.getText(), tfEthernetDNS1.getText(), tfEthernetDNS2.getText())) {
            return;
        }

        ReaderIPEntity ipConfig = new ReaderIPEntity();
        ipConfig.setIp(tfEthernetIP.getText());
        ipConfig.setGateway(tfEthernetGateway.getText());
        ipConfig.setSubnetMask(tfEthernetSubnetMask.getText());
        ipConfig.setDns1(tfEthernetDNS1.getText());
        ipConfig.setDns2(tfEthernetDNS2.getText());

        boolean result = UHFMainForm.ur4.setEthernetConfigInfo(ipConfig);
        if (result) {
            JOptionPane.showMessageDialog(this, "Set Success!", "", JOptionPane.INFORMATION_MESSAGE);
            if (cboxEthernetIpSelfIncrease.isSelected()) {
                tfEthernetIP.setText(IPIncrease(tfEthernetIP.getText()));
            }
        } else {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
        }
    }

    private void btnEthernetGetActionPerformed(ActionEvent e) {
        String ethIpConfig = UHFMainForm.ur4.getEthernetIpConfig();
        // System.out.println(ethIpConfig);
        if (ethIpConfig != null && !ethIpConfig.isEmpty()) {
            try {
                JSONObject jsonObject = JSONObject.fromObject(ethIpConfig);
                tfEthernetIP.setText((String) jsonObject.get("ip"));
                tfEthernetGateway.setText((String) jsonObject.get("gateway"));
                tfEthernetSubnetMask.setText((String) jsonObject.get("subnetMask"));
                tfEthernetDNS1.setText((String) jsonObject.get("dns1"));
                tfEthernetDNS2.setText((String) jsonObject.get("dsn2"));
            } catch (Exception e1) {
                // e1.printStackTrace();
                System.out.println("ex:" + e1.toString());
            }
        } else {
            JOptionPane.showMessageDialog(this, "fail", "", JOptionPane.ERROR_MESSAGE);
        }

    }

    private void btnPortSetActionPerformed(ActionEvent e) {
        int port;
        try {
            port = Integer.parseInt(tfPort.getText());
        } catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "The Port is invalid!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        boolean result = UHFMainForm.ur4.setTcpServicePort(port);
        if (result) {
            JOptionPane.showMessageDialog(this, "Set Success!", "", JOptionPane.INFORMATION_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
        }
    }

    private void btnWifiSetActionPerformed(ActionEvent e) {
        if (tfWifiSSID.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "The SSID is invalid!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (tfWifiPassword.isEnabled() && tfWifiPassword.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "The Password is invalid!!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }

        WifiConfig wifiConfig = new WifiConfig();
        wifiConfig.setSsid(tfWifiSSID.getText());
        if (tfWifiPassword.isEnabled()) {
            wifiConfig.setPassword(tfWifiPassword.getText());
        }
        wifiConfig.setSecurityType(cbWifiSecurityType.getSelectedIndex());
        wifiConfig.setProxy(cbWifiProxy.getSelectedIndex());
        if (cboxStaticIP.isSelected()) {    //如果选择静态IP
            ReaderIPEntity staticIPConfig = new ReaderIPEntity();
            if (!verifyIPConfig(tfWifiIP.getText(), tfWifiGateway.getText(), tfWifiSubnetMask.getText(), tfWifiDNS1.getText(), tfWifiDNS2.getText())) {
                return;
            }
            staticIPConfig.setIp(tfWifiIP.getText());
            staticIPConfig.setGateway(tfWifiGateway.getText());
            staticIPConfig.setSubnetMask(tfWifiSubnetMask.getText());
            staticIPConfig.setDns1(tfWifiDNS1.getText());
            staticIPConfig.setDns2(tfWifiDNS2.getText());
            wifiConfig.setStaticIp(true);
            wifiConfig.setStaticIpConfig(staticIPConfig);
        }

        boolean result = UHFMainForm.ur4.setWifiConfigInfo(wifiConfig);
        if (result) {
            JOptionPane.showMessageDialog(this, "Set Success!", "", JOptionPane.INFORMATION_MESSAGE);
            if (cboxWifiIpSelfIncrease.isSelected() && cboxStaticIP.isSelected()) {
                tfWifiIP.setText(IPIncrease(tfWifiIP.getText()));
            }
        } else {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
        }
    }

    private void btnWifiGetActionPerformed(ActionEvent e) {
        String wifiIpConfig = UHFMainForm.ur4.getWifiIpConfig();
        System.out.println("WifiIpConfig：" + wifiIpConfig);
        if (wifiIpConfig != null && !wifiIpConfig.isEmpty()) {
            try {
                JSONObject jsonObject = JSONObject.fromObject(wifiIpConfig);
//                tfWifiPassword.setText((String) jsonObject.get("pass"));
                tfWifiSSID.setText((String) jsonObject.get("ssid"));
                tfWifiIP.setText((String) jsonObject.get("ip"));
                tfWifiGateway.setText((String) jsonObject.get("gateway"));
                tfWifiSubnetMask.setText((String) jsonObject.get("subnetMask"));
                tfWifiDNS1.setText((String) jsonObject.get("dns1"));
                tfWifiDNS2.setText((String) jsonObject.get("dns2"));
            } catch (Exception e1) {
                // e1.printStackTrace();
                System.out.println("ex:" + e1.toString());
            }
        } else {
            JOptionPane.showMessageDialog(this, "fail", "", JOptionPane.ERROR_MESSAGE);
        }
    }

    private void btnOpenWifiActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.openWifi();
        if (result) {
            JOptionPane.showMessageDialog(this, "Success!", "", JOptionPane.INFORMATION_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(this, "Failed!", "", JOptionPane.ERROR_MESSAGE);
        }
    }

    private void btnCloseWifiActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.closeWifi();
        if (result) {
            JOptionPane.showMessageDialog(this, "Success!", "", JOptionPane.INFORMATION_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(this, "Failed!", "", JOptionPane.ERROR_MESSAGE);
        }
    }

    private void btnGetWifiInfoActionPerformed(ActionEvent e) {
        btnClearActionPerformed(null);  // 清除数据和点击事件

        String wifiInfo = UHFMainForm.ur4.GetWifiInfo();
        // System.out.println("GetWifiInfo: " + wifiInfo);
        if (wifiInfo != null && !wifiInfo.isEmpty()) {
            try {
                JSONArray jsonArray = JSONArray.fromObject(wifiInfo);
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonObject = JSONObject.fromObject(jsonArray.get(i));
                    String[] column = new String[5];
                    column[0] = String.valueOf(i + 1);
                    column[1] = (String) jsonObject.get("ssid");
                    column[2] = (String) jsonObject.get("bssid");
                    column[3] = (String) jsonObject.get("state");
                    column[4] = (String) jsonObject.get("securityType");
                    tableModel.addRow(column);
                }
                table.getSelectionModel().addListSelectionListener(selectionListener);
            } catch (Exception e1) {
//                System.out.println(e1.toString());
                JOptionPane.showMessageDialog(this, "Failed", "", JOptionPane.ERROR_MESSAGE);
                e1.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Failed", "", JOptionPane.ERROR_MESSAGE);
        }
    }

    private void btnClearActionPerformed(ActionEvent e) {
        table.getSelectionModel().removeListSelectionListener(selectionListener);
        table.clearSelection();
        for (int i = tableModel.getRowCount() - 1; i >= 0; i--) {
            synchronized (tableModel) {
                tableModel.removeRow(i);
            }
        }
    }

    private void cbWifiSecurityTypeItemStateChanged(ItemEvent e) {
        if (e.getItem().equals("WEP")) {
            labWifiPassword.setEnabled(false);
            tfWifiPassword.setText("");
            tfWifiPassword.setEnabled(false);
        } else {
            labWifiPassword.setEnabled(true);
            tfWifiPassword.setEnabled(true);
        }
    }

    private void cboxStaticIPItemStateChanged(ItemEvent e) {
        if (cboxStaticIP.isSelected()) {
            labWifiIP.setEnabled(true);
            labWifiGateway.setEnabled(true);
            labWifiSubnetMask.setEnabled(true);
            labWifiDNS1.setEnabled(true);
            labWifiDNS2.setEnabled(true);
            tfWifiIP.setEnabled(true);
            tfWifiGateway.setEnabled(true);
            tfWifiSubnetMask.setEnabled(true);
            tfWifiDNS1.setEnabled(true);
            tfWifiDNS2.setEnabled(true);
        } else {
            labWifiIP.setEnabled(false);
            labWifiGateway.setEnabled(false);
            labWifiSubnetMask.setEnabled(false);
            labWifiDNS1.setEnabled(false);
            labWifiDNS2.setEnabled(false);
            tfWifiIP.setEnabled(false);
            tfWifiGateway.setEnabled(false);
            tfWifiSubnetMask.setEnabled(false);
            tfWifiDNS1.setEnabled(false);
            tfWifiDNS2.setEnabled(false);
        }
    }

    private void initComponents() {
        // JFormDesigner - Component initialization - DO NOT MODIFY  //GEN-BEGIN:initComponents
        panel1 = new JPanel();
        label1 = new JLabel();
        label2 = new JLabel();
        label3 = new JLabel();
        label4 = new JLabel();
        label5 = new JLabel();
        tfEthernetIP = new JTextField();
        tfEthernetGateway = new JTextField();
        tfEthernetSubnetMask = new JTextField();
        tfEthernetDNS1 = new JTextField();
        tfEthernetDNS2 = new JTextField();
        btnEthernetSet = new JButton();
        btnEthernetGet = new JButton();
        cboxEthernetIpSelfIncrease = new JCheckBox();
        panel2 = new JPanel();
        label6 = new JLabel();
        tfPort = new JTextField();
        btnPortSet = new JButton();
        panel3 = new JPanel();
        label7 = new JLabel();
        labWifiPassword = new JLabel();
        lWifiSafeMode = new JLabel();
        label10 = new JLabel();
        tfWifiSSID = new JTextField();
        tfWifiPassword = new JTextField();
        cbWifiSecurityType = new JComboBox<>();
        cbWifiProxy = new JComboBox<>();
        cboxStaticIP = new JCheckBox();
        labWifiIP = new JLabel();
        tfWifiIP = new JTextField();
        labWifiGateway = new JLabel();
        labWifiSubnetMask = new JLabel();
        labWifiDNS1 = new JLabel();
        labWifiDNS2 = new JLabel();
        tfWifiDNS2 = new JTextField();
        tfWifiDNS1 = new JTextField();
        tfWifiSubnetMask = new JTextField();
        tfWifiGateway = new JTextField();
        btnWifiSet = new JButton();
        btnWifiGet = new JButton();
        cboxWifiIpSelfIncrease = new JCheckBox();
        scrollPane1 = new JScrollPane();
        table = new JTable();
        btnOpenWifi = new JButton();
        btnCloseWifi = new JButton();
        btnClear = new JButton();
        btnGetWifiInfo = new JButton();

        //======== this ========
        setLayout(null);

        //======== panel1 ========
        {
            panel1.setBorder(new TitledBorder("Ethernet"));
            panel1.setToolTipText("333");
            panel1.setLayout(null);

            //---- label1 ----
            label1.setText("IP\uff1a");
            panel1.add(label1);
            label1.setBounds(new Rectangle(new Point(20, 30), label1.getPreferredSize()));

            //---- label2 ----
            label2.setText("Gateway\uff1a");
            panel1.add(label2);
            label2.setBounds(new Rectangle(new Point(20, 60), label2.getPreferredSize()));

            //---- label3 ----
            label3.setText("SubnetMask\uff1a");
            panel1.add(label3);
            label3.setBounds(new Rectangle(new Point(20, 90), label3.getPreferredSize()));

            //---- label4 ----
            label4.setText("DNS1\uff1a");
            panel1.add(label4);
            label4.setBounds(new Rectangle(new Point(20, 120), label4.getPreferredSize()));

            //---- label5 ----
            label5.setText("DNS2\uff1a");
            panel1.add(label5);
            label5.setBounds(new Rectangle(new Point(20, 150), label5.getPreferredSize()));

            //---- tfEthernetIP ----
            tfEthernetIP.setText("192.168.1.100");
            panel1.add(tfEthernetIP);
            tfEthernetIP.setBounds(100, 25, 175, tfEthernetIP.getPreferredSize().height);

            //---- tfEthernetGateway ----
            tfEthernetGateway.setText("192.168.1.1");
            panel1.add(tfEthernetGateway);
            tfEthernetGateway.setBounds(100, 55, 175, tfEthernetGateway.getPreferredSize().height);

            //---- tfEthernetSubnetMask ----
            tfEthernetSubnetMask.setText("255.255.255.0");
            panel1.add(tfEthernetSubnetMask);
            tfEthernetSubnetMask.setBounds(100, 85, 175, tfEthernetSubnetMask.getPreferredSize().height);

            //---- tfEthernetDNS1 ----
            tfEthernetDNS1.setText("192.168.99.1");
            panel1.add(tfEthernetDNS1);
            tfEthernetDNS1.setBounds(100, 115, 175, tfEthernetDNS1.getPreferredSize().height);
            panel1.add(tfEthernetDNS2);
            tfEthernetDNS2.setBounds(100, 145, 175, tfEthernetDNS2.getPreferredSize().height);

            //---- btnEthernetSet ----
            btnEthernetSet.setText("Set");
            btnEthernetSet.addActionListener(e -> btnEthernetSetActionPerformed(e));
            panel1.add(btnEthernetSet);
            btnEthernetSet.setBounds(130, 185, 65, btnEthernetSet.getPreferredSize().height);

            //---- btnEthernetGet ----
            btnEthernetGet.setText("Get");
            btnEthernetGet.addActionListener(e -> btnEthernetGetActionPerformed(e));
            panel1.add(btnEthernetGet);
            btnEthernetGet.setBounds(210, 185, 65, btnEthernetGet.getPreferredSize().height);

            //---- cboxEthernetIpSelfIncrease ----
            cboxEthernetIpSelfIncrease.setText("IP self-increase");
            panel1.add(cboxEthernetIpSelfIncrease);
            cboxEthernetIpSelfIncrease.setBounds(new Rectangle(new Point(15, 190), cboxEthernetIpSelfIncrease.getPreferredSize()));

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel1.getComponentCount(); i++) {
                    Rectangle bounds = panel1.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel1.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel1.setMinimumSize(preferredSize);
                panel1.setPreferredSize(preferredSize);
            }
        }
        add(panel1);
        panel1.setBounds(10, 15, 285, 225);

        //======== panel2 ========
        {
            panel2.setBorder(new TitledBorder("Port"));
            panel2.setLayout(null);

            //---- label6 ----
            label6.setText("port\uff1a");
            panel2.add(label6);
            label6.setBounds(new Rectangle(new Point(20, 30), label6.getPreferredSize()));

            //---- tfPort ----
            tfPort.setText("9160");
            panel2.add(tfPort);
            tfPort.setBounds(80, 25, 155, tfPort.getPreferredSize().height);

            //---- btnPortSet ----
            btnPortSet.setText("Set");
            btnPortSet.addActionListener(e -> btnPortSetActionPerformed(e));
            panel2.add(btnPortSet);
            btnPortSet.setBounds(270, 25, 100, btnPortSet.getPreferredSize().height);

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel2.getComponentCount(); i++) {
                    Rectangle bounds = panel2.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel2.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel2.setMinimumSize(preferredSize);
                panel2.setPreferredSize(preferredSize);
            }
        }
        add(panel2);
        panel2.setBounds(10, 250, 900, 65);

        //======== panel3 ========
        {
            panel3.setBorder(new TitledBorder("WiFi"));
            panel3.setLayout(null);

            //---- label7 ----
            label7.setText("SSID\uff1a");
            panel3.add(label7);
            label7.setBounds(new Rectangle(new Point(20, 30), label7.getPreferredSize()));

            //---- labWifiPassword ----
            labWifiPassword.setText("Password:");
            panel3.add(labWifiPassword);
            labWifiPassword.setBounds(new Rectangle(new Point(20, 60), labWifiPassword.getPreferredSize()));

            //---- lWifiSafeMode ----
            lWifiSafeMode.setText("Safe Mode:");
            panel3.add(lWifiSafeMode);
            lWifiSafeMode.setBounds(new Rectangle(new Point(20, 90), lWifiSafeMode.getPreferredSize()));

            //---- label10 ----
            label10.setText("Proxy:");
            panel3.add(label10);
            label10.setBounds(new Rectangle(new Point(20, 120), label10.getPreferredSize()));
            panel3.add(tfWifiSSID);
            tfWifiSSID.setBounds(90, 25, 155, tfWifiSSID.getPreferredSize().height);
            panel3.add(tfWifiPassword);
            tfWifiPassword.setBounds(90, 55, 155, tfWifiPassword.getPreferredSize().height);

            //---- cbWifiSecurityType ----
            cbWifiSecurityType.setModel(new DefaultComboBoxModel<>(new String[] {
                "WEP",
                "WPA",
                "NOPASS",
                "INVALID"
            }));
            cbWifiSecurityType.setSelectedIndex(1);
            cbWifiSecurityType.addItemListener(e -> cbWifiSecurityTypeItemStateChanged(e));
            panel3.add(cbWifiSecurityType);
            cbWifiSecurityType.setBounds(90, 85, 155, cbWifiSecurityType.getPreferredSize().height);

            //---- cbWifiProxy ----
            cbWifiProxy.setModel(new DefaultComboBoxModel<>(new String[] {
                "NO",
                "Manual",
                "Auto"
            }));
            panel3.add(cbWifiProxy);
            cbWifiProxy.setBounds(90, 115, 155, cbWifiProxy.getPreferredSize().height);

            //---- cboxStaticIP ----
            cboxStaticIP.setText("Static IP");
            cboxStaticIP.setSelected(true);
            cboxStaticIP.addItemListener(e -> cboxStaticIPItemStateChanged(e));
            panel3.add(cboxStaticIP);
            cboxStaticIP.setBounds(new Rectangle(new Point(140, 150), cboxStaticIP.getPreferredSize()));

            //---- labWifiIP ----
            labWifiIP.setText("IP\uff1a");
            panel3.add(labWifiIP);
            labWifiIP.setBounds(new Rectangle(new Point(290, 30), labWifiIP.getPreferredSize()));

            //---- tfWifiIP ----
            tfWifiIP.setText("192.168.1.100");
            panel3.add(tfWifiIP);
            tfWifiIP.setBounds(370, 25, 155, tfWifiIP.getPreferredSize().height);

            //---- labWifiGateway ----
            labWifiGateway.setText("Gateway\uff1a");
            panel3.add(labWifiGateway);
            labWifiGateway.setBounds(new Rectangle(new Point(290, 60), labWifiGateway.getPreferredSize()));

            //---- labWifiSubnetMask ----
            labWifiSubnetMask.setText("SubnetMask\uff1a");
            panel3.add(labWifiSubnetMask);
            labWifiSubnetMask.setBounds(new Rectangle(new Point(290, 90), labWifiSubnetMask.getPreferredSize()));

            //---- labWifiDNS1 ----
            labWifiDNS1.setText("DNS1\uff1a");
            panel3.add(labWifiDNS1);
            labWifiDNS1.setBounds(new Rectangle(new Point(290, 120), labWifiDNS1.getPreferredSize()));

            //---- labWifiDNS2 ----
            labWifiDNS2.setText("DNS2\uff1a");
            panel3.add(labWifiDNS2);
            labWifiDNS2.setBounds(new Rectangle(new Point(290, 150), labWifiDNS2.getPreferredSize()));
            panel3.add(tfWifiDNS2);
            tfWifiDNS2.setBounds(370, 145, 155, tfWifiDNS2.getPreferredSize().height);

            //---- tfWifiDNS1 ----
            tfWifiDNS1.setText("192.168.99.1");
            panel3.add(tfWifiDNS1);
            tfWifiDNS1.setBounds(370, 115, 155, tfWifiDNS1.getPreferredSize().height);

            //---- tfWifiSubnetMask ----
            tfWifiSubnetMask.setText("255.255.255.0");
            panel3.add(tfWifiSubnetMask);
            tfWifiSubnetMask.setBounds(370, 85, 155, tfWifiSubnetMask.getPreferredSize().height);

            //---- tfWifiGateway ----
            tfWifiGateway.setText("192.168.1.1");
            panel3.add(tfWifiGateway);
            tfWifiGateway.setBounds(370, 55, 155, tfWifiGateway.getPreferredSize().height);

            //---- btnWifiSet ----
            btnWifiSet.setText("Set");
            btnWifiSet.addActionListener(e -> btnWifiSetActionPerformed(e));
            panel3.add(btnWifiSet);
            btnWifiSet.setBounds(20, 185, 95, btnWifiSet.getPreferredSize().height);

            //---- btnWifiGet ----
            btnWifiGet.setText("Get");
            btnWifiGet.addActionListener(e -> btnWifiGetActionPerformed(e));
            panel3.add(btnWifiGet);
            btnWifiGet.setBounds(140, 185, 95, btnWifiGet.getPreferredSize().height);

            //---- cboxWifiIpSelfIncrease ----
            cboxWifiIpSelfIncrease.setText("IP self-increase");
            panel3.add(cboxWifiIpSelfIncrease);
            cboxWifiIpSelfIncrease.setBounds(new Rectangle(new Point(20, 150), cboxWifiIpSelfIncrease.getPreferredSize()));

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel3.getComponentCount(); i++) {
                    Rectangle bounds = panel3.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel3.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel3.setMinimumSize(preferredSize);
                panel3.setPreferredSize(preferredSize);
            }
        }
        add(panel3);
        panel3.setBounds(305, 15, 605, 225);

        //======== scrollPane1 ========
        {

            //---- table ----
            table.setModel(new DefaultTableModel(
                new Object[][] {
                },
                new String[] {
                    "INDEX", "SSID", "BSSID", "Status", "Security Type"
                }
            ));
            {
                TableColumnModel cm = table.getColumnModel();
                cm.getColumn(0).setMaxWidth(100);
                cm.getColumn(4).setMinWidth(200);
            }
            scrollPane1.setViewportView(table);
        }
        add(scrollPane1);
        scrollPane1.setBounds(10, 330, 900, 290);

        //---- btnOpenWifi ----
        btnOpenWifi.setText("OPEN WiFi");
        btnOpenWifi.setFont(btnOpenWifi.getFont().deriveFont(btnOpenWifi.getFont().getSize() + 2f));
        btnOpenWifi.addActionListener(e -> btnOpenWifiActionPerformed(e));
        add(btnOpenWifi);
        btnOpenWifi.setBounds(930, 330, 150, btnOpenWifi.getPreferredSize().height);

        //---- btnCloseWifi ----
        btnCloseWifi.setText("CLOSE WiFi");
        btnCloseWifi.setFont(btnCloseWifi.getFont().deriveFont(btnCloseWifi.getFont().getSize() + 2f));
        btnCloseWifi.addActionListener(e -> btnCloseWifiActionPerformed(e));
        add(btnCloseWifi);
        btnCloseWifi.setBounds(930, 375, 150, btnCloseWifi.getPreferredSize().height);

        //---- btnClear ----
        btnClear.setText("CLEAR");
        btnClear.setFont(btnClear.getFont().deriveFont(btnClear.getFont().getSize() + 2f));
        btnClear.addActionListener(e -> btnClearActionPerformed(e));
        add(btnClear);
        btnClear.setBounds(930, 465, 150, btnClear.getPreferredSize().height);

        //---- btnGetWifiInfo ----
        btnGetWifiInfo.setText("GET WiFi LIST");
        btnGetWifiInfo.setFont(btnGetWifiInfo.getFont().deriveFont(btnGetWifiInfo.getFont().getSize() + 2f));
        btnGetWifiInfo.addActionListener(e -> btnGetWifiInfoActionPerformed(e));
        add(btnGetWifiInfo);
        btnGetWifiInfo.setBounds(930, 420, 150, btnGetWifiInfo.getPreferredSize().height);

        setPreferredSize(new Dimension(1090, 630));
        // JFormDesigner - End of component initialization  //GEN-END:initComponents
    }

    // JFormDesigner - Variables declaration - DO NOT MODIFY  //GEN-BEGIN:variables
    private JPanel panel1;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JTextField tfEthernetIP;
    private JTextField tfEthernetGateway;
    private JTextField tfEthernetSubnetMask;
    private JTextField tfEthernetDNS1;
    private JTextField tfEthernetDNS2;
    private JButton btnEthernetSet;
    private JButton btnEthernetGet;
    private JCheckBox cboxEthernetIpSelfIncrease;
    private JPanel panel2;
    private JLabel label6;
    private JTextField tfPort;
    private JButton btnPortSet;
    private JPanel panel3;
    private JLabel label7;
    private JLabel labWifiPassword;
    private JLabel lWifiSafeMode;
    private JLabel label10;
    private JTextField tfWifiSSID;
    private JTextField tfWifiPassword;
    private JComboBox<String> cbWifiSecurityType;
    private JComboBox<String> cbWifiProxy;
    private JCheckBox cboxStaticIP;
    private JLabel labWifiIP;
    private JTextField tfWifiIP;
    private JLabel labWifiGateway;
    private JLabel labWifiSubnetMask;
    private JLabel labWifiDNS1;
    private JLabel labWifiDNS2;
    private JTextField tfWifiDNS2;
    private JTextField tfWifiDNS1;
    private JTextField tfWifiSubnetMask;
    private JTextField tfWifiGateway;
    private JButton btnWifiSet;
    private JButton btnWifiGet;
    private JCheckBox cboxWifiIpSelfIncrease;
    private JScrollPane scrollPane1;
    private JTable table;
    private JButton btnOpenWifi;
    private JButton btnCloseWifi;
    private JButton btnClear;
    private JButton btnGetWifiInfo;
    // JFormDesigner - End of variables declaration  //GEN-END:variables
}
