/*
 * Created by JFormDesigner on Sat Oct 22 11:32:43 CST 2022
 */

package com.uhf.form;

import com.rscja.deviceapi.entity.ReaderIPEntity;
import com.uhf.UHFMainForm;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * @author Brainrain
 */
public class IPv6Form extends JPanel {
    public IPv6Form() {
        initComponents();
    }

    private void btnGetCurIpConfigActionPerformed(ActionEvent e) {
        ReaderIPEntity config = UHFMainForm.ur4.getReaderCurrentIp();
        if (config == null) {
            JOptionPane.showMessageDialog(this, "Get failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }

        System.out.println("config: " + config);

        tfIP.setText(config.getIp());
        tfIPv6_1.setText(config.getIpv6Ip1());
        tfIPv6_2.setText(config.getIpv6Ip2());
        tfIPv6_3.setText(config.getIpv6Ip3());
        tfIPv6Dns1.setText(config.getIpv6Dns1());
        tfIpv6Dns2.setText(config.getIpv6Dns2());
        tfIPv4.setText(config.getIp());
        tfIPv4Dns1.setText(config.getDns1());
        tfIPv4Dns2.setText(config.getDns2());
        tfGateway.setText(config.getGateway());
        tfSubnetMask.setText(config.getSubnetMask());
        int networkType = config.getNetworkType();
        if (networkType == 1) {
            tfNetworkType.setText("Ethernet");
        }else if(networkType == 2){
            tfNetworkType.setText("WiFi");
        }
        tfSSID.setText(config.getSsid());
    }


    private void initComponents() {
        // JFormDesigner - Component initialization - DO NOT MODIFY  //GEN-BEGIN:initComponents
        label1 = new JLabel();
        label2 = new JLabel();
        label3 = new JLabel();
        label4 = new JLabel();
        label5 = new JLabel();
        label6 = new JLabel();
        label7 = new JLabel();
        label8 = new JLabel();
        label9 = new JLabel();
        label10 = new JLabel();
        label11 = new JLabel();
        tfIP = new JTextField();
        tfIPv6_1 = new JTextField();
        tfIPv6Dns1 = new JTextField();
        tfIpv6Dns2 = new JTextField();
        tfGateway = new JTextField();
        tfIPv4Dns2 = new JTextField();
        tfIPv4Dns1 = new JTextField();
        tfIPv4 = new JTextField();
        tfSSID = new JTextField();
        tfNetworkType = new JTextField();
        tfSubnetMask = new JTextField();
        btnGetCurIpConfig = new JButton();
        tfIPv6_2 = new JTextField();
        tfIPv6_3 = new JTextField();

        //======== this ========
        setLayout(null);

        //---- label1 ----
        label1.setText("Cur IP Address\uff1a");
        add(label1);
        label1.setBounds(new Rectangle(new Point(15, 20), label1.getPreferredSize()));

        //---- label2 ----
        label2.setText("IPv6 Address\uff1a");
        add(label2);
        label2.setBounds(new Rectangle(new Point(20, 70), label2.getPreferredSize()));

        //---- label3 ----
        label3.setText("IPv6 DNS1\uff1a");
        add(label3);
        label3.setBounds(new Rectangle(new Point(20, 120), label3.getPreferredSize()));

        //---- label4 ----
        label4.setText("IPv6 DNS2\uff1a");
        add(label4);
        label4.setBounds(new Rectangle(new Point(20, 150), label4.getPreferredSize()));

        //---- label5 ----
        label5.setText("IPv4 Address\uff1a");
        add(label5);
        label5.setBounds(new Rectangle(new Point(20, 180), label5.getPreferredSize()));

        //---- label6 ----
        label6.setText("IPv4 DNS1\uff1a");
        add(label6);
        label6.setBounds(new Rectangle(new Point(20, 210), label6.getPreferredSize()));

        //---- label7 ----
        label7.setText("IPv4 DNS2\uff1a");
        add(label7);
        label7.setBounds(new Rectangle(new Point(20, 240), label7.getPreferredSize()));

        //---- label8 ----
        label8.setText("Gateway\uff1a");
        add(label8);
        label8.setBounds(new Rectangle(new Point(20, 270), label8.getPreferredSize()));

        //---- label9 ----
        label9.setText("Subnet Mask: ");
        add(label9);
        label9.setBounds(new Rectangle(new Point(20, 300), label9.getPreferredSize()));

        //---- label10 ----
        label10.setText("Network Type:");
        add(label10);
        label10.setBounds(new Rectangle(new Point(20, 330), label10.getPreferredSize()));

        //---- label11 ----
        label11.setText("SSID\uff1a");
        add(label11);
        label11.setBounds(new Rectangle(new Point(20, 360), label11.getPreferredSize()));
        add(tfIP);
        tfIP.setBounds(120, 15, 220, tfIP.getPreferredSize().height);
        add(tfIPv6_1);
        tfIPv6_1.setBounds(120, 45, 220, tfIPv6_1.getPreferredSize().height);
        add(tfIPv6Dns1);
        tfIPv6Dns1.setBounds(120, 115, 220, tfIPv6Dns1.getPreferredSize().height);
        add(tfIpv6Dns2);
        tfIpv6Dns2.setBounds(120, 145, 220, tfIpv6Dns2.getPreferredSize().height);
        add(tfGateway);
        tfGateway.setBounds(120, 265, 220, tfGateway.getPreferredSize().height);
        add(tfIPv4Dns2);
        tfIPv4Dns2.setBounds(120, 235, 220, tfIPv4Dns2.getPreferredSize().height);
        add(tfIPv4Dns1);
        tfIPv4Dns1.setBounds(120, 205, 220, tfIPv4Dns1.getPreferredSize().height);
        add(tfIPv4);
        tfIPv4.setBounds(120, 175, 220, tfIPv4.getPreferredSize().height);
        add(tfSSID);
        tfSSID.setBounds(120, 355, 220, tfSSID.getPreferredSize().height);
        add(tfNetworkType);
        tfNetworkType.setBounds(120, 325, 220, tfNetworkType.getPreferredSize().height);
        add(tfSubnetMask);
        tfSubnetMask.setBounds(120, 295, 220, tfSubnetMask.getPreferredSize().height);

        //---- btnGetCurIpConfig ----
        btnGetCurIpConfig.setText("IP Address");
        btnGetCurIpConfig.setFont(btnGetCurIpConfig.getFont().deriveFont(btnGetCurIpConfig.getFont().getSize() + 2f));
        btnGetCurIpConfig.addActionListener(e -> btnGetCurIpConfigActionPerformed(e));
        add(btnGetCurIpConfig);
        btnGetCurIpConfig.setBounds(115, 400, 150, 40);
        add(tfIPv6_2);
        tfIPv6_2.setBounds(120, 65, 220, tfIPv6_2.getPreferredSize().height);
        add(tfIPv6_3);
        tfIPv6_3.setBounds(120, 85, 220, tfIPv6_3.getPreferredSize().height);

        {
            // compute preferred size
            Dimension preferredSize = new Dimension();
            for(int i = 0; i < getComponentCount(); i++) {
                Rectangle bounds = getComponent(i).getBounds();
                preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
            }
            Insets insets = getInsets();
            preferredSize.width += insets.right;
            preferredSize.height += insets.bottom;
            setMinimumSize(preferredSize);
            setPreferredSize(preferredSize);
        }
        // JFormDesigner - End of component initialization  //GEN-END:initComponents
    }

    // JFormDesigner - Variables declaration - DO NOT MODIFY  //GEN-BEGIN:variables
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JLabel label6;
    private JLabel label7;
    private JLabel label8;
    private JLabel label9;
    private JLabel label10;
    private JLabel label11;
    private JTextField tfIP;
    private JTextField tfIPv6_1;
    private JTextField tfIPv6Dns1;
    private JTextField tfIpv6Dns2;
    private JTextField tfGateway;
    private JTextField tfIPv4Dns2;
    private JTextField tfIPv4Dns1;
    private JTextField tfIPv4;
    private JTextField tfSSID;
    private JTextField tfNetworkType;
    private JTextField tfSubnetMask;
    private JButton btnGetCurIpConfig;
    private JTextField tfIPv6_2;
    private JTextField tfIPv6_3;
    // JFormDesigner - End of variables declaration  //GEN-END:variables
}
