/*
 * Created by JFormDesigner on Fri Oct 21 17:06:41 CST 2022
 */

package com.uhf.form;

import com.rscja.deviceapi.entity.GPIStateEntity;
import com.rscja.deviceapi.entity.GPOEntity;
import com.rscja.deviceapi.interfaces.IGPIStateCallback;
import com.uhf.UHFMainForm;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.List;
import javax.swing.*;

/**
 * @author Brainrain
 */
public class GPIOForm extends JPanel {
    private IGPIStateCallback iGPIStateCallback = new IGPIStateCallback() {
        @Override


        public void callback(List<GPIStateEntity> list) {

            String sb = textArea.getText();
            for (int i = 0; i < list.size(); i++) {
                sb += list.get(i).getGPIName() + " = " + list.get(i).getGPIState() + "， ";
            }
            sb += "\n";
            textArea.setText(sb);


        }
    };


    public GPIOForm() {
        initComponents();
    }


    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag && UHFMainForm.ur4 != null) {
            UHFMainForm.ur4.setGPIStateCallback(iGPIStateCallback);
        }
    }


    private void btnSetActionPerformed(ActionEvent e) {
        List<GPOEntity> list = new LinkedList<>();
        if(cbGPIO1.getSelectedIndex() == 1){
            list.add(new GPOEntity(GPOEntity.GPO1,1));
        }else{
            list.add(new GPOEntity(GPOEntity.GPO1,0));
        }
        if(cbGPIO2.getSelectedIndex() == 1){
            list.add(new GPOEntity(GPOEntity.GPO2,1));
        }else{
            list.add(new GPOEntity(GPOEntity.GPO2,0));
        }
        if(cbGPIO3.getSelectedIndex() == 1){
            list.add(new GPOEntity(GPOEntity.GPO3,1));
        }else{
            list.add(new GPOEntity(GPOEntity.GPO3,0));
        }
        if(cbGPIO4.getSelectedIndex() == 1){
            list.add(new GPOEntity(GPOEntity.GPO4,1));
        }else {
            list.add(new GPOEntity(GPOEntity.GPO4,0));
        }
        if(cbGPIO5.getSelectedIndex() == 1){
            list.add(new GPOEntity(GPOEntity.WiegandData0,1));
        }else {
            list.add(new GPOEntity(GPOEntity.WiegandData0,0));
        }
        if(cbGPIO6.getSelectedIndex() == 1){
            list.add(new GPOEntity(GPOEntity.WiegandData1,1));
        }else {
            list.add(new GPOEntity(GPOEntity.WiegandData1,0));
        }
        UHFMainForm.ur4.outputOnAndOff(list);

//        UHFMainForm.ur4.output1OnAndOff(mapBoolean.get((String) cbGPIO1.getSelectedItem()));
//        UHFMainForm.ur4.output2OnAndOff(mapBoolean.get((String) cbGPIO2.getSelectedItem()));
//        UHFMainForm.ur4.output3OnAndOff(mapBoolean.get((String) cbGPIO3.getSelectedItem()));
//        UHFMainForm.ur4.output4OnAndOff(mapBoolean.get((String) cbGPIO4.getSelectedItem()));


    }

    /**
     * GPIO灯全开
     * **/
    private void btnGpioOnActionPerformed(ActionEvent e) {

        List<GPOEntity> list = new LinkedList<>();
        list.add(new GPOEntity(GPOEntity.GPO1, 1));
        list.add(new GPOEntity(GPOEntity.GPO2, 1));
        list.add(new GPOEntity(GPOEntity.GPO3, 1));
        list.add(new GPOEntity(GPOEntity.GPO4, 1));
        list.add(new GPOEntity(GPOEntity.WiegandData0, 1));
        list.add(new GPOEntity(GPOEntity.WiegandData1, 1));
        UHFMainForm.ur4.outputOnAndOff(list);
        cbGPIO1.setSelectedIndex(1);
        cbGPIO2.setSelectedIndex(1);
        cbGPIO3.setSelectedIndex(1);
        cbGPIO4.setSelectedIndex(1);
        cbGPIO5.setSelectedIndex(1);
        cbGPIO6.setSelectedIndex(1);

    }
    /**
     * GPIO灯全关
     * **/
    private void btnGpioOffActionPerformed(ActionEvent e) {
        List<GPOEntity> list = new LinkedList<>();
        list.add(new GPOEntity(GPOEntity.GPO1, 0));
        list.add(new GPOEntity(GPOEntity.GPO2, 0));
        list.add(new GPOEntity(GPOEntity.GPO3, 0));
        list.add(new GPOEntity(GPOEntity.GPO4, 0));
        list.add(new GPOEntity(GPOEntity.WiegandData0, 0));
        list.add(new GPOEntity(GPOEntity.WiegandData1, 0));
        UHFMainForm.ur4.outputOnAndOff(list);
        cbGPIO1.setSelectedIndex(0);
        cbGPIO2.setSelectedIndex(0);
        cbGPIO3.setSelectedIndex(0);
        cbGPIO4.setSelectedIndex(0);
        cbGPIO5.setSelectedIndex(0);
        cbGPIO6.setSelectedIndex(0);
    }

    private void btnClearActionPerformed(ActionEvent e) {
        textArea.setText("");
    }

    private void initComponents() {
        // JFormDesigner - Component initialization - DO NOT MODIFY  //GEN-BEGIN:initComponents
        label1 = new JLabel();
        cbGPIO1 = new JComboBox<>();
        label2 = new JLabel();
        cbGPIO2 = new JComboBox<>();
        label3 = new JLabel();
        label4 = new JLabel();
        label5 = new JLabel();
        label6 = new JLabel();
        cbGPIO3 = new JComboBox<>();
        cbGPIO4 = new JComboBox<>();
        cbGPIO5 = new JComboBox<>();
        cbGPIO6 = new JComboBox<>();
        btnSet = new JButton();
        btnClear = new JButton();
        btnGpioOn = new JButton();
        btnGpioOff = new JButton();
        scrollPane1 = new JScrollPane();
        textArea = new JTextArea();

        //======== this ========
        setLayout(null);

        //---- label1 ----
        label1.setText("GPIO1");
        add(label1);
        label1.setBounds(new Rectangle(new Point(25, 25), label1.getPreferredSize()));

        //---- cbGPIO1 ----
        cbGPIO1.setModel(new DefaultComboBoxModel<>(new String[] {
            "OFF",
            "ON"
        }));
        add(cbGPIO1);
        cbGPIO1.setBounds(63, 20, 70, cbGPIO1.getPreferredSize().height);

        //---- label2 ----
        label2.setText("GPIO2");
        add(label2);
        label2.setBounds(new Rectangle(new Point(160, 25), label2.getPreferredSize()));

        //---- cbGPIO2 ----
        cbGPIO2.setModel(new DefaultComboBoxModel<>(new String[] {
            "OFF",
            "ON"
        }));
        add(cbGPIO2);
        cbGPIO2.setBounds(198, 20, 70, cbGPIO2.getPreferredSize().height);

        //---- label3 ----
        label3.setText("GPIO3");
        add(label3);
        label3.setBounds(new Rectangle(new Point(300, 25), label3.getPreferredSize()));

        //---- label4 ----
        label4.setText("GPIO4");
        add(label4);
        label4.setBounds(new Rectangle(new Point(440, 25), label4.getPreferredSize()));

        //---- label5 ----
        label5.setText("GPIO5");
        add(label5);
        label5.setBounds(new Rectangle(new Point(585, 25), label5.getPreferredSize()));

        //---- label6 ----
        label6.setText("GPIO6");
        add(label6);
        label6.setBounds(new Rectangle(new Point(720, 25), label6.getPreferredSize()));

        //---- cbGPIO3 ----
        cbGPIO3.setModel(new DefaultComboBoxModel<>(new String[] {
            "OFF",
            "ON"
        }));
        add(cbGPIO3);
        cbGPIO3.setBounds(340, 20, 70, cbGPIO3.getPreferredSize().height);

        //---- cbGPIO4 ----
        cbGPIO4.setModel(new DefaultComboBoxModel<>(new String[] {
            "OFF",
            "ON"
        }));
        add(cbGPIO4);
        cbGPIO4.setBounds(480, 20, 70, cbGPIO4.getPreferredSize().height);

        //---- cbGPIO5 ----
        cbGPIO5.setModel(new DefaultComboBoxModel<>(new String[] {
            "OFF",
            "ON"
        }));
        add(cbGPIO5);
        cbGPIO5.setBounds(624, 20, 70, cbGPIO5.getPreferredSize().height);

        //---- cbGPIO6 ----
        cbGPIO6.setModel(new DefaultComboBoxModel<>(new String[] {
            "OFF",
            "ON"
        }));
        add(cbGPIO6);
        cbGPIO6.setBounds(760, 20, 70, cbGPIO6.getPreferredSize().height);

        //---- btnSet ----
        btnSet.setText("SET");
        btnSet.addActionListener(e -> btnSetActionPerformed(e));
        add(btnSet);
        btnSet.setBounds(174, 400, 95, btnSet.getPreferredSize().height);

        //---- btnClear ----
        btnClear.setText("CLEAR");
        btnClear.addActionListener(e -> btnClearActionPerformed(e));
        add(btnClear);
        btnClear.setBounds(312, 400, 95, btnClear.getPreferredSize().height);

        //---- btnGpioOn ----
        btnGpioOn.setText("GPIO ON");
        btnGpioOn.addActionListener(e -> btnGpioOnActionPerformed(e));
        add(btnGpioOn);
        btnGpioOn.setBounds(448, 400, 95, btnGpioOn.getPreferredSize().height);

        //---- btnGpioOff ----
        btnGpioOff.setText("GPIO OFF");
        btnGpioOff.addActionListener(e -> btnGpioOffActionPerformed(e));
        add(btnGpioOff);
        btnGpioOff.setBounds(586, 400, 95, btnGpioOff.getPreferredSize().height);

        //======== scrollPane1 ========
        {

            //---- textArea ----
            textArea.setEditable(false);
            textArea.setFont(textArea.getFont().deriveFont(textArea.getFont().getSize() + 3f));
            scrollPane1.setViewportView(textArea);
        }
        add(scrollPane1);
        scrollPane1.setBounds(30, 65, 800, 315);

        setPreferredSize(new Dimension(860, 445));
        // JFormDesigner - End of component initialization  //GEN-END:initComponents
    }

    // JFormDesigner - Variables declaration - DO NOT MODIFY  //GEN-BEGIN:variables
    private JLabel label1;
    private JComboBox<String> cbGPIO1;
    private JLabel label2;
    private JComboBox<String> cbGPIO2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JLabel label6;
    private JComboBox<String> cbGPIO3;
    private JComboBox<String> cbGPIO4;
    private JComboBox<String> cbGPIO5;
    private JComboBox<String> cbGPIO6;
    private JButton btnSet;
    private JButton btnClear;
    private JButton btnGpioOn;
    private JButton btnGpioOff;
    private JScrollPane scrollPane1;
    private JTextArea textArea;
    // JFormDesigner - End of variables declaration  //GEN-END:variables
}
