/*
 * Created by JFormDesigner on Mon Oct 17 17:18:30 CST 2022
 */

package com.uhf.form;

import com.rscja.deviceapi.entity.*;
import com.rscja.deviceapi.interfaces.IUHF;
import com.uhf.UHFMainForm;
import com.uhf.utils.StringUtils;
import jdk.nashorn.internal.scripts.JO;

import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.List;
import javax.swing.*;
import javax.swing.border.*;

/**
 * @author zp
 */
public class ConfigForm extends JPanel {
    public ConfigForm() {
        initComponents();
        initUI();
    }

    public void onConnected() {
        // if(this.isVisible())
        {
            ReaderInfo readerInfo = UHFMainForm.ur4.getReaderInfo();
            if (readerInfo != null) {
                if (readerInfo.getAntennaNumber() == 4) {
                    cmbAnt5Power.setVisible(false);
                    cmbAnt6Power.setVisible(false);
                    cmbAnt7Power.setVisible(false);
                    cmbAnt8Power.setVisible(false);
                    label8.setVisible(false);
                    label9.setVisible(false);
                    label10.setVisible(false);
                    label11.setVisible(false);
                    btnSetPoer5.setVisible(false);
                    btnSetPoer6.setVisible(false);
                    btnSetPoer7.setVisible(false);
                    btnSetPoer8.setVisible(false);

                    cbANT5.setVisible(false);
                    cbANT6.setVisible(false);
                    cbANT7.setVisible(false);
                    cbANT8.setVisible(false);
                } else {
                    cmbAnt5Power.setVisible(true);
                    cmbAnt6Power.setVisible(true);
                    cmbAnt7Power.setVisible(true);
                    cmbAnt8Power.setVisible(true);
                    label8.setVisible(true);
                    label9.setVisible(true);
                    label10.setVisible(true);
                    label11.setVisible(true);
                    btnSetPoer5.setVisible(true);
                    btnSetPoer6.setVisible(true);
                    btnSetPoer7.setVisible(true);
                    btnSetPoer8.setVisible(true);

                    cbANT5.setVisible(true);
                    cbANT6.setVisible(true);
                    cbANT7.setVisible(true);
                    cbANT8.setVisible(true);
                }
            }
        }
    }

    /**
     * 获取天线功率
     *
     * @param e
     */
    private void btnGetPowerActionPerformed(ActionEvent e) {
        List<AntennaPowerEntity> list = UHFMainForm.ur4.getPowerAll();
        if (list == null) {
            JOptionPane.showMessageDialog(this, "Get Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        for (AntennaPowerEntity entity : list) {
            if (entity.getAntennaNameEnum() == AntennaNameEnum.ANT1) {
                int ant1Power = entity.getPower();
                cmbAnt1Power.setSelectedIndex(ant1Power - 1);
                System.out.println("ant1Power=" + ant1Power);
            } else if (entity.getAntennaNameEnum() == AntennaNameEnum.ANT2) {
                int ant2Power = entity.getPower();
                cmbAnt2Power.setSelectedIndex(ant2Power - 1);
                System.out.println("ant2Power=" + ant2Power);
            } else if (entity.getAntennaNameEnum() == AntennaNameEnum.ANT3) {
                int ant3Power = entity.getPower();
                cmbAnt3Power.setSelectedIndex(ant3Power - 1);
                System.out.println("ant3Power=" + ant3Power);
            } else if (entity.getAntennaNameEnum() == AntennaNameEnum.ANT4) {
                int ant4Power = entity.getPower();
                cmbAnt4Power.setSelectedIndex(ant4Power - 1);
                System.out.println("ant4Power=" + ant4Power);
            } else if (entity.getAntennaNameEnum() == AntennaNameEnum.ANT5) {
                int ant5Power = entity.getPower();
                cmbAnt5Power.setSelectedIndex(ant5Power - 1);
                System.out.println("ant5Power=" + ant5Power);
            } else if (entity.getAntennaNameEnum() == AntennaNameEnum.ANT6) {
                int ant6Power = entity.getPower();
                cmbAnt6Power.setSelectedIndex(ant6Power - 1);
                System.out.println("ant6Power=" + ant6Power);
            } else if (entity.getAntennaNameEnum() == AntennaNameEnum.ANT7) {
                int ant7Power = entity.getPower();
                cmbAnt7Power.setSelectedIndex(ant7Power - 1);
                System.out.println("ant7Power=" + ant7Power);
            } else if (entity.getAntennaNameEnum() == AntennaNameEnum.ANT8) {
                int ant8Power = entity.getPower();
                cmbAnt8Power.setSelectedIndex(ant8Power - 1);
                System.out.println("ant8Power=" + ant8Power);
            }
        }
    }

    /**
     * 设置天线功率
     *
     * @param e
     */

    private void btnSetPoer1ActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.setPower(AntennaNameEnum.ANT1, cmbAnt1Power.getSelectedIndex() + 1);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set ANT1 Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }else {
            JOptionPane.showMessageDialog(this, "设置天线成功!", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    private void btnSetPoer2ActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.setPower(AntennaNameEnum.ANT2, cmbAnt2Power.getSelectedIndex() + 1);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set ANT2 Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }else {
            JOptionPane.showMessageDialog(this, "设置天线成功!", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    private void btnSetPoer3ActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.setPower(AntennaNameEnum.ANT3, cmbAnt3Power.getSelectedIndex() + 1);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set ANT3 Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }else {
            JOptionPane.showMessageDialog(this, "设置天线成功!", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    private void btnSetPoer4ActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.setPower(AntennaNameEnum.ANT4, cmbAnt4Power.getSelectedIndex() + 1);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set ANT4 Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }else {
            JOptionPane.showMessageDialog(this, "设置天线成功!", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    private void btnSetPoer5ActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.setPower(AntennaNameEnum.ANT5, cmbAnt5Power.getSelectedIndex() + 1);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set ANT5 Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }else {
            JOptionPane.showMessageDialog(this, "设置天线成功!", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    private void btnSetPoer6ActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.setPower(AntennaNameEnum.ANT6, cmbAnt6Power.getSelectedIndex() + 1);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set ANT6 Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }else {
            JOptionPane.showMessageDialog(this, "设置天线成功!", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    private void btnSetPoer7ActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.setPower(AntennaNameEnum.ANT7, cmbAnt7Power.getSelectedIndex() + 1);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set ANT7 Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }else {
            JOptionPane.showMessageDialog(this, "设置天线成功!", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    private void btnSetPoer8ActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.setPower(AntennaNameEnum.ANT8, cmbAnt8Power.getSelectedIndex() + 1);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set ANT8 Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }else {
            JOptionPane.showMessageDialog(this, "设置天线成功!", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    /**
     * 获取天线
     *
     * @param e
     */
    private void btnGetANTActionPerformed(ActionEvent e) {
        List<AntennaState> list = UHFMainForm.ur4.getAntenna();
        if (list == null) {
            JOptionPane.showMessageDialog(this, "Get Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        cbANT1.setSelected(false);
        cbANT2.setSelected(false);
        cbANT3.setSelected(false);
        cbANT4.setSelected(false);
        cbANT5.setSelected(false);
        cbANT6.setSelected(false);
        cbANT7.setSelected(false);
        cbANT8.setSelected(false);
        for (AntennaState ant : list) {
            System.out.println(ant.getAntennaName() + "  " + ant.isEnable());
            if (ant.getAntennaName() == AntennaNameEnum.ANT1 && ant.isEnable()) {
                cbANT1.setSelected(true);
            } else if (ant.getAntennaName() == AntennaNameEnum.ANT2 && ant.isEnable()) {
                cbANT2.setSelected(true);
            } else if (ant.getAntennaName() == AntennaNameEnum.ANT3 && ant.isEnable()) {
                cbANT3.setSelected(true);
            } else if (ant.getAntennaName() == AntennaNameEnum.ANT4 && ant.isEnable()) {
                cbANT4.setSelected(true);
            } else if (ant.getAntennaName() == AntennaNameEnum.ANT5 && ant.isEnable()) {
                cbANT5.setSelected(true);
            } else if (ant.getAntennaName() == AntennaNameEnum.ANT6 && ant.isEnable()) {
                cbANT6.setSelected(true);
            } else if (ant.getAntennaName() == AntennaNameEnum.ANT7 && ant.isEnable()) {
                cbANT7.setSelected(true);
            } else if (ant.getAntennaName() == AntennaNameEnum.ANT8 && ant.isEnable()) {
                cbANT8.setSelected(true);
            }
        }
    }

    /**
     * 设置天线
     *
     * @param e
     */
    private void btnSetANTActionPerformed(ActionEvent e) {
        List<AntennaState> list = new ArrayList<>();
        list.add(new AntennaState(AntennaNameEnum.ANT1, cbANT1.isSelected()));
        list.add(new AntennaState(AntennaNameEnum.ANT2, cbANT2.isSelected()));
        list.add(new AntennaState(AntennaNameEnum.ANT3, cbANT3.isSelected()));
        list.add(new AntennaState(AntennaNameEnum.ANT4, cbANT4.isSelected()));
        list.add(new AntennaState(AntennaNameEnum.ANT5, cbANT5.isSelected()));
        list.add(new AntennaState(AntennaNameEnum.ANT6, cbANT6.isSelected()));
        list.add(new AntennaState(AntennaNameEnum.ANT7, cbANT7.isSelected()));
        list.add(new AntennaState(AntennaNameEnum.ANT8, cbANT8.isSelected()));
        boolean result = UHFMainForm.ur4.setAntenna(list);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        JOptionPane.showMessageDialog(this, "Set Success!", "", JOptionPane.INFORMATION_MESSAGE);
    }

    /**
     * 获取频段
     *
     * @param e
     */
    private void btnGetFrequencyBandActionPerformed(ActionEvent e) {
        int region = UHFMainForm.ur4.getFrequencyMode();
        switch (region) {
            case 0x01:
                cbFrequencyBand.setSelectedIndex(0);
                break;
            case 0x02:
                cbFrequencyBand.setSelectedIndex(1);
                break;
            case 0x04:
                cbFrequencyBand.setSelectedIndex(2);
                break;
            case 0x08:
                cbFrequencyBand.setSelectedIndex(3);
                break;
            case 0x16:
                cbFrequencyBand.setSelectedIndex(4);
                break;
            case 0x32:
                cbFrequencyBand.setSelectedIndex(5);
                break;
            case 0x34:
                cbFrequencyBand.setSelectedIndex(6);
                break;
            case 0x33:
                cbFrequencyBand.setSelectedIndex(7);
                break;
            case 0x36:
                cbFrequencyBand.setSelectedIndex(8);
                break;
            case 0x37:
                cbFrequencyBand.setSelectedIndex(9);
                break;
            default:
                JOptionPane.showMessageDialog(this, "Get Failed!", "", JOptionPane.ERROR_MESSAGE);
                break;

        }
    }

    /**
     * 设置频段
     *
     * @param e
     */
    private void btnSetFrequencyBandActionPerformed(ActionEvent e) {

        int region = -1;
        switch (cbFrequencyBand.getSelectedIndex()) {
            case 0:
                region = 0x01;
                break;
            case 1:
                region = 0x02;
                break;
            case 2:
                region = 0x04;
                break;
            case 3:
                region = 0x08;
                break;
            case 4:
                region = 0x16;
                break;
            case 5:
                region = 0x32;
                break;
            case 6:
                region = 0x34;
                break;
            case 7:
                region = 0x33;
                break;
            case 8:
                region = 0x36;
                break;
            case 9:
                region = 0x37;
                break;

        }
        if (region == -1) {
            JOptionPane.showMessageDialog(this, "Get Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        boolean result = UHFMainForm.ur4.setFrequencyMode((byte) region);
        if (result) {
            JOptionPane.showMessageDialog(this, "Set Success!", "", JOptionPane.INFORMATION_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
        }
    }

    /**
     * 设置协议
     *
     * @param e
     */
    private void btnSetProtocolActionPerformed(ActionEvent e) {
        int p = cmbProtocol.getSelectedIndex();
        if (p <= 0) {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        boolean result = UHFMainForm.ur4.setProtocol(p);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        JOptionPane.showMessageDialog(this, "Set Success!", "", JOptionPane.INFORMATION_MESSAGE);
    }

    /**
     * 获取协议
     *
     * @param e
     */
    private void btnGetProtocolActionPerformed(ActionEvent e) {
        int result = UHFMainForm.ur4.getProtocol();
        if (result == -1) {
            JOptionPane.showMessageDialog(this, "Get Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        cmbProtocol.setSelectedIndex(result);
        JOptionPane.showMessageDialog(this, "Get Success!", "", JOptionPane.INFORMATION_MESSAGE);
    }

    /**
     * 获取链路
     *
     * @param e
     */
    private void btnGetLinkActionPerformed(ActionEvent e) {
        int result = UHFMainForm.ur4.getRFLink();
        if (result == -1) {
            JOptionPane.showMessageDialog(this, "Get Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        cmbRFLink.setSelectedIndex(result);
        JOptionPane.showMessageDialog(this, "Get Success!", "", JOptionPane.INFORMATION_MESSAGE);
    }

    /**
     * 设置链路
     *
     * @param e
     */
    private void btnSetLinkActionPerformed(ActionEvent e) {
        int l = cmbRFLink.getSelectedIndex();
        if (l < 0) {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        boolean result = UHFMainForm.ur4.setRFLink(l);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        JOptionPane.showMessageDialog(this, "Set Success!", "", JOptionPane.INFORMATION_MESSAGE);
    }

    /**
     * 获取盘点模式
     *
     * @param e
     */
    private void btnGetEPCAndTIDUserModeActionPerformed(ActionEvent e) {
        InventoryModeEntity result = UHFMainForm.ur4.getEPCAndTIDUserMode();
        if (result == null) {
            JOptionPane.showMessageDialog(this, "Get Failed", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        int User_prt = result.getUserOffset();
        int User_len = result.getUserLength();
        cmbEPCAndTIDUserMode.setSelectedIndex(result.getMode());
        if (result.getMode() == 2) {
            tf_user_prt.setText(String.valueOf(User_prt));
            tf_user_len.setText(String.valueOf(User_len));
        } else {
            tf_user_prt.setText("");
            tf_user_len.setText("");
        }
        JOptionPane.showMessageDialog(this, "Get Success", "", JOptionPane.INFORMATION_MESSAGE);
    }

    /**
     * 设置盘点模式
     *
     * @param e
     */
    private void btnSetEPCAndTIDUserModeActionPerformed(ActionEvent e) {
        if (cmbEPCAndTIDUserMode.getSelectedIndex() == 0) {
            boolean result1 = UHFMainForm.ur4.setEPCMode();
            if (!result1) {
                JOptionPane.showMessageDialog(this, "Set Failed!", "", JOptionPane.ERROR_MESSAGE);
                return;
            } else {
                JOptionPane.showMessageDialog(this, "Set Success!", "", JOptionPane.INFORMATION_MESSAGE);
            }
        } else if (cmbEPCAndTIDUserMode.getSelectedIndex() == 1) {
            boolean result2 = UHFMainForm.ur4.setEPCAndTIDMode();
            if (!result2) {
                JOptionPane.showMessageDialog(this, "Set Failed", "", JOptionPane.ERROR_MESSAGE);
            } else {
                JOptionPane.showMessageDialog(this, "Set Success", "", JOptionPane.INFORMATION_MESSAGE);
            }
        } else if (cmbEPCAndTIDUserMode.getSelectedIndex() == 2) {
            String User_Prt = tf_user_prt.getText();
            String User_Len = tf_user_len.getText();


            if (StringUtils.isEmpty(User_Prt)) {
                JOptionPane.showMessageDialog(this, "Ptr cannot be empty", "", JOptionPane.WARNING_MESSAGE);
                return;
            }
            if (StringUtils.isEmpty(User_Len)) {
                JOptionPane.showMessageDialog(this, "Len cannot be empty", "", JOptionPane.WARNING_MESSAGE);
                return;
            }
            boolean result3 = UHFMainForm.ur4.setEPCAndTIDUserMode(Integer.parseInt(User_Prt), Integer.parseInt(User_Len));
            if (!result3) {
                JOptionPane.showMessageDialog(this, "Set Failed", "", JOptionPane.ERROR_MESSAGE);
            } else {
                JOptionPane.showMessageDialog(this, "Set Success", "", JOptionPane.INFORMATION_MESSAGE);
            }
        }
    }

    /**
     * 获取蜂鸣器
     *
     * @param e
     */
    private void btnGetBeepActionPerformed(ActionEvent e) {
        char[] result = UHFMainForm.ur4.getBeep();
        System.out.println(String.valueOf(result));
        if (result == null || result[0] != 0) {
            rbtn_Beep_On.setSelected(false);
            rbtn_Beep_Off.setSelected(true);
            JOptionPane.showMessageDialog(this, "Get Failed", "", JOptionPane.ERROR_MESSAGE);
        } else {
            if (result[1] == 1) {
                rbtn_Beep_On.setSelected(true);
                rbtn_Beep_Off.setSelected(false);
            } else {
                rbtn_Beep_On.setSelected(false);
                rbtn_Beep_Off.setSelected(true);
            }

            JOptionPane.showMessageDialog(this, "Get Success", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    /**
     * 设置蜂鸣器
     *
     * @param e
     */
    private void btnSetBeepActionPerformed(ActionEvent e) {
        int mode = -1;
        if (rbtn_Beep_On.isSelected()) {
            mode = 1;
        } else if (rbtn_Beep_Off.isSelected()) {
            mode = 0;
        }
        boolean result = UHFMainForm.ur4.setBeep(mode);
        if (result) {
            JOptionPane.showMessageDialog(this, "Set Success", "", JOptionPane.INFORMATION_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(this, "Set Failed", "", JOptionPane.ERROR_MESSAGE);
        }
    }

    /**
     * 蜂鸣器 开
     *
     * @param e
     */
    private void rbtn_Beep_OnActionPerformed(ActionEvent e) {
        rbtn_Beep_On.setSelected(true);
        rbtn_Beep_Off.setSelected(false);
    }

    /**
     * 蜂鸣器 关
     *
     * @param e
     */
    private void rbtn_Beep_OffActionPerformed(ActionEvent e) {
        rbtn_Beep_On.setSelected(false);
        rbtn_Beep_Off.setSelected(true);
    }

    /**
     * 获取Gen2
     *
     * @param e
     */
    private void btnGetGen2ActionPerformed(ActionEvent e) {
        Gen2Entity getGen2 = UHFMainForm.ur4.getGen2();
        if (getGen2 == null) {
            JOptionPane.showMessageDialog(this, "Get Failed", "", JOptionPane.ERROR_MESSAGE);
            return;
        }
        int session = getGen2.getQuerySession();
        int target = getGen2.getQueryTarget();
        // System.out.println("session: " + session + "  target:" + target);
        cmb_Gen2_session.setSelectedIndex(session);
        cmb_Gen2_target.setSelectedIndex(target);
        JOptionPane.showMessageDialog(this, "Get Success", "", JOptionPane.INFORMATION_MESSAGE);
    }

    /**
     * 设置Gen2
     *
     * @param e
     */
    private void btnSetGen2ActionPerformed(ActionEvent e) {
        Gen2Entity entity = UHFMainForm.ur4.getGen2();
        int session = cmb_Gen2_session.getSelectedIndex();
        int target = cmb_Gen2_target.getSelectedIndex();
        entity.setQuerySession(session);
        entity.setQueryTarget(target);

        boolean result = UHFMainForm.ur4.setGen2(entity);
        if (!result) {
            JOptionPane.showMessageDialog(this, "Set Failed", "", JOptionPane.ERROR_MESSAGE);
            return;
        } else {
            JOptionPane.showMessageDialog(this, "Set Success", "", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    /**
     * 重启设备
     *
     * @param e
     */
    private void btnRebootDeviceActionPerformed(ActionEvent e) {
        boolean result = UHFMainForm.ur4.rebootDevice();
        if (result) {
            JOptionPane.showMessageDialog(this, "Restart Success", "", JOptionPane.INFORMATION_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(this, "Restart Failed", "", JOptionPane.ERROR_MESSAGE);
        }
    }





    private void initComponents() {
        // JFormDesigner - Component initialization - DO NOT MODIFY  //GEN-BEGIN:initComponents
        panel1 = new JPanel();
        label1 = new JLabel();
        cmbAnt1Power = new JComboBox();
        cmbAnt2Power = new JComboBox();
        label2 = new JLabel();
        cmbAnt3Power = new JComboBox();
        label3 = new JLabel();
        cmbAnt4Power = new JComboBox();
        label4 = new JLabel();
        btnGetPower = new JButton();
        label8 = new JLabel();
        label9 = new JLabel();
        cmbAnt5Power = new JComboBox();
        cmbAnt7Power = new JComboBox();
        cmbAnt6Power = new JComboBox();
        cmbAnt8Power = new JComboBox();
        label10 = new JLabel();
        label11 = new JLabel();
        btnSetPoer1 = new JButton();
        btnSetPoer2 = new JButton();
        btnSetPoer3 = new JButton();
        btnSetPoer4 = new JButton();
        btnSetPoer5 = new JButton();
        btnSetPoer6 = new JButton();
        btnSetPoer7 = new JButton();
        btnSetPoer8 = new JButton();
        panel2 = new JPanel();
        cbANT1 = new JCheckBox();
        cbANT2 = new JCheckBox();
        cbANT3 = new JCheckBox();
        cbANT4 = new JCheckBox();
        btnSetANT = new JButton();
        btnGetANT = new JButton();
        cbANT5 = new JCheckBox();
        cbANT6 = new JCheckBox();
        cbANT7 = new JCheckBox();
        cbANT8 = new JCheckBox();
        panel3 = new JPanel();
        label5 = new JLabel();
        cbFrequencyBand = new JComboBox();
        btnGetFrequencyBand = new JButton();
        btnSetFrequencyBand = new JButton();
        panel5 = new JPanel();
        label6 = new JLabel();
        cmbProtocol = new JComboBox();
        btnSetProtocol = new JButton();
        btnGetProtocol = new JButton();
        panel17 = new JPanel();
        label22 = new JLabel();
        cmbEPCAndTIDUserMode = new JComboBox();
        btnGetEPCAndTIDUserMode = new JButton();
        btnSetEPCAndTIDUserMode = new JButton();
        label23 = new JLabel();
        tf_user_prt = new JTextField();
        label24 = new JLabel();
        tf_user_len = new JTextField();
        panel18 = new JPanel();
        label25 = new JLabel();
        cmb_Gen2_session = new JComboBox();
        label26 = new JLabel();
        cmb_Gen2_target = new JComboBox();
        btnSetGen2 = new JButton();
        btnGetGen2 = new JButton();
        panel19 = new JPanel();
        label27 = new JLabel();
        rbtn_Beep_On = new JRadioButton();
        rbtn_Beep_Off = new JRadioButton();
        btnGetBeep = new JButton();
        btnSetBeep = new JButton();
        panel23 = new JPanel();
        cmbRFLink = new JComboBox();
        label7 = new JLabel();
        btnSetRFLink = new JButton();
        btnGetRFLink = new JButton();
        btnRebootDevice = new JButton();

        //======== this ========
        setLayout(null);

        //======== panel1 ========
        {
            panel1.setPreferredSize(new Dimension(42, 42));
            panel1.setBorder(new TitledBorder("Power"));
            panel1.setLayout(null);

            //---- label1 ----
            label1.setText("ANT1:");
            panel1.add(label1);
            label1.setBounds(15, 25, 40, label1.getPreferredSize().height);
            panel1.add(cmbAnt1Power);
            cmbAnt1Power.setBounds(55, 20, 80, 30);
            panel1.add(cmbAnt2Power);
            cmbAnt2Power.setBounds(310, 20, 80, 30);

            //---- label2 ----
            label2.setText("ANT2:");
            panel1.add(label2);
            label2.setBounds(265, 25, 40, 17);
            panel1.add(cmbAnt3Power);
            cmbAnt3Power.setBounds(55, 55, 80, 30);

            //---- label3 ----
            label3.setText("ANT3:");
            panel1.add(label3);
            label3.setBounds(15, 60, 40, 17);
            panel1.add(cmbAnt4Power);
            cmbAnt4Power.setBounds(310, 55, 80, 30);

            //---- label4 ----
            label4.setText("ANT4:");
            panel1.add(label4);
            label4.setBounds(265, 60, 40, 17);

            //---- btnGetPower ----
            btnGetPower.setText("GET POWER");
            btnGetPower.addActionListener(e -> btnGetPowerActionPerformed(e));
            panel1.add(btnGetPower);
            btnGetPower.setBounds(new Rectangle(new Point(210, 165), btnGetPower.getPreferredSize()));

            //---- label8 ----
            label8.setText("ANT7:");
            panel1.add(label8);
            label8.setBounds(15, 130, 40, 17);

            //---- label9 ----
            label9.setText("ANT5:");
            panel1.add(label9);
            label9.setBounds(15, 95, 40, 15);
            panel1.add(cmbAnt5Power);
            cmbAnt5Power.setBounds(55, 90, 80, 30);
            panel1.add(cmbAnt7Power);
            cmbAnt7Power.setBounds(55, 125, 80, 30);
            panel1.add(cmbAnt6Power);
            cmbAnt6Power.setBounds(310, 90, 80, 30);
            panel1.add(cmbAnt8Power);
            cmbAnt8Power.setBounds(310, 125, 80, 30);

            //---- label10 ----
            label10.setText("ANT8:");
            panel1.add(label10);
            label10.setBounds(265, 130, 40, 17);

            //---- label11 ----
            label11.setText("ANT6:");
            panel1.add(label11);
            label11.setBounds(265, 95, 40, 17);

            //---- btnSetPoer1 ----
            btnSetPoer1.setText("SET POWER 1");
            btnSetPoer1.addActionListener(e -> btnSetPoer1ActionPerformed(e));
            panel1.add(btnSetPoer1);
            btnSetPoer1.setBounds(new Rectangle(new Point(135, 20), btnSetPoer1.getPreferredSize()));

            //---- btnSetPoer2 ----
            btnSetPoer2.setText("SET POWER 2");
            btnSetPoer2.addActionListener(e -> btnSetPoer2ActionPerformed(e));
            panel1.add(btnSetPoer2);
            btnSetPoer2.setBounds(new Rectangle(new Point(390, 20), btnSetPoer2.getPreferredSize()));

            //---- btnSetPoer3 ----
            btnSetPoer3.setText("SET POWER 3");
            btnSetPoer3.addActionListener(e -> btnSetPoer3ActionPerformed(e));
            panel1.add(btnSetPoer3);
            btnSetPoer3.setBounds(new Rectangle(new Point(135, 55), btnSetPoer3.getPreferredSize()));

            //---- btnSetPoer4 ----
            btnSetPoer4.setText("SET POWER 4");
            btnSetPoer4.addActionListener(e -> btnSetPoer4ActionPerformed(e));
            panel1.add(btnSetPoer4);
            btnSetPoer4.setBounds(new Rectangle(new Point(390, 55), btnSetPoer4.getPreferredSize()));

            //---- btnSetPoer5 ----
            btnSetPoer5.setText("SET POWER 5");
            btnSetPoer5.addActionListener(e -> btnSetPoer5ActionPerformed(e));
            panel1.add(btnSetPoer5);
            btnSetPoer5.setBounds(new Rectangle(new Point(135, 90), btnSetPoer5.getPreferredSize()));

            //---- btnSetPoer6 ----
            btnSetPoer6.setText("SET POWER 6");
            btnSetPoer6.addActionListener(e -> btnSetPoer6ActionPerformed(e));
            panel1.add(btnSetPoer6);
            btnSetPoer6.setBounds(new Rectangle(new Point(390, 90), btnSetPoer6.getPreferredSize()));

            //---- btnSetPoer7 ----
            btnSetPoer7.setText("SET POWER 7");
            btnSetPoer7.addActionListener(e -> btnSetPoer7ActionPerformed(e));
            panel1.add(btnSetPoer7);
            btnSetPoer7.setBounds(new Rectangle(new Point(135, 125), btnSetPoer7.getPreferredSize()));

            //---- btnSetPoer8 ----
            btnSetPoer8.setText("SET POWER 8");
            btnSetPoer8.addActionListener(e -> btnSetPoer8ActionPerformed(e));
            panel1.add(btnSetPoer8);
            btnSetPoer8.setBounds(new Rectangle(new Point(390, 125), btnSetPoer8.getPreferredSize()));

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel1.getComponentCount(); i++) {
                    Rectangle bounds = panel1.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel1.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel1.setMinimumSize(preferredSize);
                panel1.setPreferredSize(preferredSize);
            }
        }
        add(panel1);
        panel1.setBounds(25, 10, 525, 210);

        //======== panel2 ========
        {
            panel2.setPreferredSize(new Dimension(42, 42));
            panel2.setBorder(new TitledBorder("Antenna"));
            panel2.setLayout(null);

            //---- cbANT1 ----
            cbANT1.setText("ANT1");
            panel2.add(cbANT1);
            cbANT1.setBounds(new Rectangle(new Point(15, 25), cbANT1.getPreferredSize()));

            //---- cbANT2 ----
            cbANT2.setText("ANT2");
            panel2.add(cbANT2);
            cbANT2.setBounds(new Rectangle(new Point(85, 25), cbANT2.getPreferredSize()));

            //---- cbANT3 ----
            cbANT3.setText("ANT3");
            panel2.add(cbANT3);
            cbANT3.setBounds(new Rectangle(new Point(155, 25), cbANT3.getPreferredSize()));

            //---- cbANT4 ----
            cbANT4.setText("ANT4");
            panel2.add(cbANT4);
            cbANT4.setBounds(new Rectangle(new Point(225, 25), cbANT4.getPreferredSize()));

            //---- btnSetANT ----
            btnSetANT.setText("SET ANTENNA");
            btnSetANT.addActionListener(e -> btnSetANTActionPerformed(e));
            panel2.add(btnSetANT);
            btnSetANT.setBounds(new Rectangle(new Point(180, 85), btnSetANT.getPreferredSize()));

            //---- btnGetANT ----
            btnGetANT.setText("GET ANTENNA");
            btnGetANT.addActionListener(e -> btnGetANTActionPerformed(e));
            panel2.add(btnGetANT);
            btnGetANT.setBounds(new Rectangle(new Point(25, 85), btnGetANT.getPreferredSize()));

            //---- cbANT5 ----
            cbANT5.setText("ANT5");
            panel2.add(cbANT5);
            cbANT5.setBounds(new Rectangle(new Point(15, 50), cbANT5.getPreferredSize()));

            //---- cbANT6 ----
            cbANT6.setText("ANT6");
            panel2.add(cbANT6);
            cbANT6.setBounds(new Rectangle(new Point(85, 50), cbANT6.getPreferredSize()));

            //---- cbANT7 ----
            cbANT7.setText("ANT7");
            panel2.add(cbANT7);
            cbANT7.setBounds(new Rectangle(new Point(155, 50), cbANT7.getPreferredSize()));

            //---- cbANT8 ----
            cbANT8.setText("ANT8");
            panel2.add(cbANT8);
            cbANT8.setBounds(new Rectangle(new Point(225, 50), cbANT8.getPreferredSize()));

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel2.getComponentCount(); i++) {
                    Rectangle bounds = panel2.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel2.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel2.setMinimumSize(preferredSize);
                panel2.setPreferredSize(preferredSize);
            }
        }
        add(panel2);
        panel2.setBounds(120, 230, 325, 125);

        //======== panel3 ========
        {
            panel3.setPreferredSize(new Dimension(42, 42));
            panel3.setBorder(new TitledBorder("Frequency Band"));
            panel3.setLayout(null);

            //---- label5 ----
            label5.setText("Frequency Band:");
            panel3.add(label5);
            label5.setBounds(new Rectangle(new Point(15, 35), label5.getPreferredSize()));
            panel3.add(cbFrequencyBand);
            cbFrequencyBand.setBounds(120, 30, 185, cbFrequencyBand.getPreferredSize().height);

            //---- btnGetFrequencyBand ----
            btnGetFrequencyBand.setText("READ FREQUENCY");
            btnGetFrequencyBand.addActionListener(e -> btnGetFrequencyBandActionPerformed(e));
            panel3.add(btnGetFrequencyBand);
            btnGetFrequencyBand.setBounds(new Rectangle(new Point(20, 65), btnGetFrequencyBand.getPreferredSize()));

            //---- btnSetFrequencyBand ----
            btnSetFrequencyBand.setText("SET FREQUENCY");
            btnSetFrequencyBand.addActionListener(e -> btnSetFrequencyBandActionPerformed(e));
            panel3.add(btnSetFrequencyBand);
            btnSetFrequencyBand.setBounds(new Rectangle(new Point(175, 65), btnSetFrequencyBand.getPreferredSize()));

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel3.getComponentCount(); i++) {
                    Rectangle bounds = panel3.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel3.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel3.setMinimumSize(preferredSize);
                panel3.setPreferredSize(preferredSize);
            }
        }
        add(panel3);
        panel3.setBounds(120, 370, 325, 110);

        //======== panel5 ========
        {
            panel5.setPreferredSize(new Dimension(42, 42));
            panel5.setBorder(new TitledBorder("Procotol"));
            panel5.setLayout(null);

            //---- label6 ----
            label6.setText("Protocol:");
            panel5.add(label6);
            label6.setBounds(new Rectangle(new Point(20, 35), label6.getPreferredSize()));
            panel5.add(cmbProtocol);
            cmbProtocol.setBounds(85, 30, 140, cmbProtocol.getPreferredSize().height);

            //---- btnSetProtocol ----
            btnSetProtocol.setText("SET PROTOCOL");
            btnSetProtocol.addActionListener(e -> btnSetProtocolActionPerformed(e));
            panel5.add(btnSetProtocol);
            btnSetProtocol.setBounds(new Rectangle(new Point(175, 65), btnSetProtocol.getPreferredSize()));

            //---- btnGetProtocol ----
            btnGetProtocol.setText("GET PROTOCOL");
            btnGetProtocol.addActionListener(e -> btnGetProtocolActionPerformed(e));
            panel5.add(btnGetProtocol);
            btnGetProtocol.setBounds(new Rectangle(new Point(20, 65), btnGetProtocol.getPreferredSize()));

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel5.getComponentCount(); i++) {
                    Rectangle bounds = panel5.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel5.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel5.setMinimumSize(preferredSize);
                panel5.setPreferredSize(preferredSize);
            }
        }
        add(panel5);
        panel5.setBounds(120, 495, 325, 105);

        //======== panel17 ========
        {
            panel17.setPreferredSize(new Dimension(42, 42));
            panel17.setBorder(new TitledBorder("InventoryMode"));
            panel17.setLayout(null);

            //---- label22 ----
            label22.setText("Mode:");
            panel17.add(label22);
            label22.setBounds(20, 35, 40, 17);
            panel17.add(cmbEPCAndTIDUserMode);
            cmbEPCAndTIDUserMode.setBounds(55, 30, 235, 30);

            //---- btnGetEPCAndTIDUserMode ----
            btnGetEPCAndTIDUserMode.setText("GET MODE");
            btnGetEPCAndTIDUserMode.addActionListener(e -> btnGetEPCAndTIDUserModeActionPerformed(e));
            panel17.add(btnGetEPCAndTIDUserMode);
            btnGetEPCAndTIDUserMode.setBounds(55, 110, btnGetEPCAndTIDUserMode.getPreferredSize().width, 30);

            //---- btnSetEPCAndTIDUserMode ----
            btnSetEPCAndTIDUserMode.setText("SET MODE");
            btnSetEPCAndTIDUserMode.addActionListener(e -> btnSetEPCAndTIDUserModeActionPerformed(e));
            panel17.add(btnSetEPCAndTIDUserMode);
            btnSetEPCAndTIDUserMode.setBounds(175, 110, btnSetEPCAndTIDUserMode.getPreferredSize().width, 30);

            //---- label23 ----
            label23.setText("User Ptr:");
            panel17.add(label23);
            label23.setBounds(new Rectangle(new Point(20, 75), label23.getPreferredSize()));
            panel17.add(tf_user_prt);
            tf_user_prt.setBounds(80, 70, 60, tf_user_prt.getPreferredSize().height);

            //---- label24 ----
            label24.setText("User Len:");
            panel17.add(label24);
            label24.setBounds(new Rectangle(new Point(165, 75), label24.getPreferredSize()));
            panel17.add(tf_user_len);
            tf_user_len.setBounds(230, 70, 60, tf_user_len.getPreferredSize().height);

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel17.getComponentCount(); i++) {
                    Rectangle bounds = panel17.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel17.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel17.setMinimumSize(preferredSize);
                panel17.setPreferredSize(preferredSize);
            }
        }
        add(panel17);
        panel17.setBounds(570, 130, 325, 155);

        //======== panel18 ========
        {
            panel18.setPreferredSize(new Dimension(42, 42));
            panel18.setBorder(new TitledBorder("Gen2"));
            panel18.setLayout(null);

            //---- label25 ----
            label25.setText("Session:");
            panel18.add(label25);
            label25.setBounds(new Rectangle(new Point(20, 30), label25.getPreferredSize()));
            panel18.add(cmb_Gen2_session);
            cmb_Gen2_session.setBounds(70, 25, 85, cmb_Gen2_session.getPreferredSize().height);

            //---- label26 ----
            label26.setText("Target:");
            panel18.add(label26);
            label26.setBounds(new Rectangle(new Point(165, 30), label26.getPreferredSize()));
            panel18.add(cmb_Gen2_target);
            cmb_Gen2_target.setBounds(215, 25, 85, cmb_Gen2_target.getPreferredSize().height);

            //---- btnSetGen2 ----
            btnSetGen2.setText("SET GEN2");
            btnSetGen2.addActionListener(e -> btnSetGen2ActionPerformed(e));
            panel18.add(btnSetGen2);
            btnSetGen2.setBounds(new Rectangle(new Point(175, 70), btnSetGen2.getPreferredSize()));

            //---- btnGetGen2 ----
            btnGetGen2.setText("GET GEN2");
            btnGetGen2.addActionListener(e -> btnGetGen2ActionPerformed(e));
            panel18.add(btnGetGen2);
            btnGetGen2.setBounds(new Rectangle(new Point(55, 70), btnGetGen2.getPreferredSize()));

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel18.getComponentCount(); i++) {
                    Rectangle bounds = panel18.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel18.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel18.setMinimumSize(preferredSize);
                panel18.setPreferredSize(preferredSize);
            }
        }
        add(panel18);
        panel18.setBounds(570, 295, 325, 115);

        //======== panel19 ========
        {
            panel19.setPreferredSize(new Dimension(42, 42));
            panel19.setBorder(new TitledBorder("Buzzer"));
            panel19.setLayout(null);

            //---- label27 ----
            label27.setText("Buzzer:");
            panel19.add(label27);
            label27.setBounds(new Rectangle(new Point(20, 35), label27.getPreferredSize()));

            //---- rbtn_Beep_On ----
            rbtn_Beep_On.setText("ON");
            rbtn_Beep_On.addActionListener(e -> rbtn_Beep_OnActionPerformed(e));
            panel19.add(rbtn_Beep_On);
            rbtn_Beep_On.setBounds(new Rectangle(new Point(80, 35), rbtn_Beep_On.getPreferredSize()));

            //---- rbtn_Beep_Off ----
            rbtn_Beep_Off.setText("OFF");
            rbtn_Beep_Off.addActionListener(e -> rbtn_Beep_OffActionPerformed(e));
            panel19.add(rbtn_Beep_Off);
            rbtn_Beep_Off.setBounds(new Rectangle(new Point(140, 35), rbtn_Beep_Off.getPreferredSize()));

            //---- btnGetBeep ----
            btnGetBeep.setText("GET BUZZER");
            btnGetBeep.addActionListener(e -> btnGetBeepActionPerformed(e));
            panel19.add(btnGetBeep);
            btnGetBeep.setBounds(new Rectangle(new Point(40, 70), btnGetBeep.getPreferredSize()));

            //---- btnSetBeep ----
            btnSetBeep.setText("SET BUZZER");
            btnSetBeep.addActionListener(e -> btnSetBeepActionPerformed(e));
            panel19.add(btnSetBeep);
            btnSetBeep.setBounds(new Rectangle(new Point(175, 70), btnSetBeep.getPreferredSize()));

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel19.getComponentCount(); i++) {
                    Rectangle bounds = panel19.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel19.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel19.setMinimumSize(preferredSize);
                panel19.setPreferredSize(preferredSize);
            }
        }
        add(panel19);
        panel19.setBounds(570, 420, 325, 120);

        //======== panel23 ========
        {
            panel23.setPreferredSize(new Dimension(42, 42));
            panel23.setBorder(new TitledBorder("Link"));
            panel23.setLayout(null);
            panel23.add(cmbRFLink);
            cmbRFLink.setBounds(55, 30, 210, cmbRFLink.getPreferredSize().height);

            //---- label7 ----
            label7.setText("Link:");
            panel23.add(label7);
            label7.setBounds(new Rectangle(new Point(20, 35), label7.getPreferredSize()));

            //---- btnSetRFLink ----
            btnSetRFLink.setText("SET LINK");
            btnSetRFLink.addActionListener(e -> btnSetLinkActionPerformed(e));
            panel23.add(btnSetRFLink);
            btnSetRFLink.setBounds(new Rectangle(new Point(185, 65), btnSetRFLink.getPreferredSize()));

            //---- btnGetRFLink ----
            btnGetRFLink.setText("GET LINK");
            btnGetRFLink.addActionListener(e -> btnGetLinkActionPerformed(e));
            panel23.add(btnGetRFLink);
            btnGetRFLink.setBounds(new Rectangle(new Point(55, 65), btnGetRFLink.getPreferredSize()));

            {
                // compute preferred size
                Dimension preferredSize = new Dimension();
                for(int i = 0; i < panel23.getComponentCount(); i++) {
                    Rectangle bounds = panel23.getComponent(i).getBounds();
                    preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                    preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
                }
                Insets insets = panel23.getInsets();
                preferredSize.width += insets.right;
                preferredSize.height += insets.bottom;
                panel23.setMinimumSize(preferredSize);
                panel23.setPreferredSize(preferredSize);
            }
        }
        add(panel23);
        panel23.setBounds(570, 10, 325, 110);

        //---- btnRebootDevice ----
        btnRebootDevice.setText("RESTART DEVICE");
        btnRebootDevice.addActionListener(e -> btnRebootDeviceActionPerformed(e));
        add(btnRebootDevice);
        btnRebootDevice.setBounds(570, 555, 325, 45);

        {
            // compute preferred size
            Dimension preferredSize = new Dimension();
            for(int i = 0; i < getComponentCount(); i++) {
                Rectangle bounds = getComponent(i).getBounds();
                preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
                preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
            }
            Insets insets = getInsets();
            preferredSize.width += insets.right;
            preferredSize.height += insets.bottom;
            setMinimumSize(preferredSize);
            setPreferredSize(preferredSize);
        }
        // JFormDesigner - End of component initialization  //GEN-END:initComponents
    }

    private void initUI() {
        for (int k = 1; k <= 30; k++) {
            cmbAnt1Power.addItem(k);
            cmbAnt2Power.addItem(k);
            cmbAnt3Power.addItem(k);
            cmbAnt4Power.addItem(k);
            cmbAnt5Power.addItem(k);
            cmbAnt6Power.addItem(k);
            cmbAnt7Power.addItem(k);
            cmbAnt8Power.addItem(k);
        }
        cbFrequencyBand.addItem("China1(840~845MHz)");
        cbFrequencyBand.addItem("China2(920~925MHz)");
        cbFrequencyBand.addItem("Europe(865~868MHz)");
        cbFrequencyBand.addItem("USA(902~928MHz)");
        cbFrequencyBand.addItem("Korea(917~923MHz)");
        cbFrequencyBand.addItem("Japan(952~953MHz)");
        cbFrequencyBand.addItem("Taiwan(920~928Mhz)");
        cbFrequencyBand.addItem("South Africa(915~919MHz)");
        cbFrequencyBand.addItem("Peru(915-928 MHz)");
        cbFrequencyBand.addItem("Russia(860MHz-867.6MHz)");

        cmbProtocol.addItem("ISO18000-6C");
        cmbProtocol.addItem("GB/T 29768");
        cmbProtocol.addItem("GJB 7377.1");
        cmbProtocol.addItem("ISO18000-6B");

        cmbRFLink.addItem("DSB_ASK/FM0/40KH");
        cmbRFLink.addItem("PR_ASK/Miller4/250KHz");
        cmbRFLink.addItem("PR_ASK/Miller4/300KHz");
        cmbRFLink.addItem("DSB_ASK/FM0/400KHz");

        cmbEPCAndTIDUserMode.addItem("EPC");
        cmbEPCAndTIDUserMode.addItem("EPC+TID");
        cmbEPCAndTIDUserMode.addItem("EPC+TID+USER");


        cmb_Gen2_session.addItem("S0");
        cmb_Gen2_session.addItem("S1");
        cmb_Gen2_session.addItem("S2");
        cmb_Gen2_session.addItem("S3");
        cmb_Gen2_target.addItem("A");
        cmb_Gen2_target.addItem("B");

        rbtn_Beep_On.setSelected(true);
        rbtn_Beep_Off.setSelected(false);

    }

    // JFormDesigner - Variables declaration - DO NOT MODIFY  //GEN-BEGIN:variables
    private JPanel panel1;
    private JLabel label1;
    private JComboBox cmbAnt1Power;
    private JComboBox cmbAnt2Power;
    private JLabel label2;
    private JComboBox cmbAnt3Power;
    private JLabel label3;
    private JComboBox cmbAnt4Power;
    private JLabel label4;
    private JButton btnGetPower;
    private JLabel label8;
    private JLabel label9;
    private JComboBox cmbAnt5Power;
    private JComboBox cmbAnt7Power;
    private JComboBox cmbAnt6Power;
    private JComboBox cmbAnt8Power;
    private JLabel label10;
    private JLabel label11;
    private JButton btnSetPoer1;
    private JButton btnSetPoer2;
    private JButton btnSetPoer3;
    private JButton btnSetPoer4;
    private JButton btnSetPoer5;
    private JButton btnSetPoer6;
    private JButton btnSetPoer7;
    private JButton btnSetPoer8;
    private JPanel panel2;
    private JCheckBox cbANT1;
    private JCheckBox cbANT2;
    private JCheckBox cbANT3;
    private JCheckBox cbANT4;
    private JButton btnSetANT;
    private JButton btnGetANT;
    private JCheckBox cbANT5;
    private JCheckBox cbANT6;
    private JCheckBox cbANT7;
    private JCheckBox cbANT8;
    private JPanel panel3;
    private JLabel label5;
    private JComboBox cbFrequencyBand;
    private JButton btnGetFrequencyBand;
    private JButton btnSetFrequencyBand;
    private JPanel panel5;
    private JLabel label6;
    private JComboBox cmbProtocol;
    private JButton btnSetProtocol;
    private JButton btnGetProtocol;
    private JPanel panel17;
    private JLabel label22;
    private JComboBox cmbEPCAndTIDUserMode;
    private JButton btnGetEPCAndTIDUserMode;
    private JButton btnSetEPCAndTIDUserMode;
    private JLabel label23;
    private JTextField tf_user_prt;
    private JLabel label24;
    private JTextField tf_user_len;
    private JPanel panel18;
    private JLabel label25;
    private JComboBox cmb_Gen2_session;
    private JLabel label26;
    private JComboBox cmb_Gen2_target;
    private JButton btnSetGen2;
    private JButton btnGetGen2;
    private JPanel panel19;
    private JLabel label27;
    private JRadioButton rbtn_Beep_On;
    private JRadioButton rbtn_Beep_Off;
    private JButton btnGetBeep;
    private JButton btnSetBeep;
    private JPanel panel23;
    private JComboBox cmbRFLink;
    private JLabel label7;
    private JButton btnSetRFLink;
    private JButton btnGetRFLink;
    private JButton btnRebootDevice;
    // JFormDesigner - End of variables declaration  //GEN-END:variables
}
