/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi.linux.usb;

import com.rscja.deviceapi.ConnectionState;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.RFIDWithUHFBase;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.InventoryModeEntity$Builder;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.ISingleAntenna;
import com.rscja.deviceapi.interfaces.IUHF;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.deviceapi.linux.usb.UsbLinux;
import com.rscja.deviceapi.linux.usb.UsbLinuxDeviceAPI$InventoryThread;
import com.rscja.utility.StringUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class UsbLinuxDeviceAPI
extends RFIDWithUHFBase
implements ISingleAntenna,
IUHF {
    private static final String TAG = StringUtility.TAG + "UHF";
    private static UsbLinux single = null;
    private boolean DEBUG = StringUtility.DEBUG;
    private IUHFInventoryCallback inventoryCallback;
    private int isFilterRepeatBank = 0;
    private UsbLinuxDeviceAPI$InventoryThread inventoryThread = null;
    private char[] uhfdata = new char[512];
    ArrayList<UHFTAGInfo> listUHFINFO = null;
    protected boolean isRuning = false;
    private ConnectionState connectionState = ConnectionState.DISCONNECTED;
    protected List<UHFTAGInfo> uhfinfoList = null;
    char[] tagData = new char[1024];

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    @Override
    public synchronized boolean init(String string) {
        int n = this.getDeviceAPI().UHFUSBConnect();
        if (n >= 0) {
            this.connectionState = ConnectionState.CONNECTED;
            this.setPowerOn(true);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean free() {
        this.stopInventory();
        this.isRuning = false;
        int n = this.getDeviceAPI().UHFUSBClose();
        this.connectionState = ConnectionState.DISCONNECTED;
        this.setPowerOn(false);
        return n >= 0;
    }

    @Override
    public synchronized String getVersion() {
        if (!this.isPowerOn()) {
            return null;
        }
        char[] cArray = this.getDeviceAPI().UHFGetHwType();
        if (cArray != null && cArray[0] == '\u0000') {
            cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
            return new String(cArray);
        }
        System.out.println("getHardwareType() err:" + cArray[0]);
        return null;
    }

    @Override
    public synchronized int getPower() {
        char[] cArray = this.getDeviceAPI().UHFGetPower();
        if (cArray != null && cArray[0] == '\u0000') {
            return cArray[1];
        }
        System.out.println("getPower() err :" + cArray[0]);
        return -1;
    }

    @Override
    public synchronized boolean setPower(int n) {
        n = this.getDeviceAPI().UHFSetPower((char)n);
        if (n == 0) {
            return true;
        }
        System.out.println("setPower() err :" + n);
        return false;
    }

    @Override
    public synchronized int getFrequencyMode() {
        char[] cArray = this.getDeviceAPI().UHFGetFrequency_Ex();
        if (cArray != null && cArray[0] == '\u0000') {
            char c2 = cArray[1];
            int n = -1;
            switch (c2) {
                case '\u0000': {
                    n = 2;
                    break;
                }
                case '\u0001': {
                    n = 1;
                    break;
                }
                case '\u0002': {
                    n = 4;
                    break;
                }
                case '\u0004': {
                    n = 8;
                    break;
                }
                case '\u0005': {
                    n = 22;
                    break;
                }
                case '\u0006': {
                    n = 50;
                    break;
                }
                case '\u0007': {
                    n = 128;
                    break;
                }
                case '\b': {
                    n = 51;
                    break;
                }
                case '\t': {
                    n = 52;
                }
            }
            return n;
        }
        System.out.println("getFrequencyMode() err :" + cArray[0]);
        return -1;
    }

    @Override
    public synchronized boolean setFrequencyMode(byte by) {
        int n = -1;
        switch (by & 0xFF) {
            case 2: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 8: {
                n = 4;
                break;
            }
            case 22: {
                n = 5;
                break;
            }
            case 50: {
                n = 6;
                break;
            }
            case 128: {
                n = 7;
                break;
            }
            case 51: {
                n = 8;
                break;
            }
            case 52: {
                n = 9;
            }
        }
        int n2 = this.getDeviceAPI().UHFSetFrequency_EX((char)n);
        by = (byte)n2;
        if (n2 == 0) {
            return true;
        }
        System.out.println("setFrequencyMode() err :" + by);
        return false;
    }

    @Override
    public boolean startInventoryTag() {
        if (this.isRuning) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (this.uhfinfoList != null) {
            this.uhfinfoList.clear();
        }
        if (this.startInventoryTag(0, 0, 6)) {
            this.isRuning = true;
            this.startInventoryThread();
            return true;
        }
        return false;
    }

    private synchronized boolean startInventoryTag(int n, int n2, int n3) {
        this.listUHFINFO = null;
        n = this.getDeviceAPI().UHFInventory_EX_cnt((char)n, (char)n2, (char)n3);
        if (n == 0) {
            return true;
        }
        System.out.println("startInventory() err :" + n);
        return false;
    }

    public ArrayList<UHFTAGInfo> readTagFromBufferList() {
        int n;
        for (n = 0; n < this.tagData.length; ++n) {
            this.tagData[n] = '\u0000';
        }
        n = this.getDeviceAPI().UHFGetTagsData(this.tagData);
        if (n > 3) {
            byte[] byArray = StringUtility.charsTobytes(this.tagData, n);
            return this.parseReadTagDataEPC_TID_USER(byArray);
        }
        return null;
    }

    @Override
    public synchronized UHFTAGInfo readTagFromBuffer() {
        if (this.listUHFINFO != null && this.listUHFINFO.size() > 0) {
            UHFTAGInfo uHFTAGInfo = this.listUHFINFO.get(0);
            this.listUHFINFO.remove(0);
            return uHFTAGInfo;
        }
        this.listUHFINFO = this.readTagFromBufferList();
        if (this.listUHFINFO != null && this.listUHFINFO.size() > 0) {
            UHFTAGInfo uHFTAGInfo = this.listUHFINFO.get(0);
            this.listUHFINFO.remove(0);
            return uHFTAGInfo;
        }
        return null;
    }

    @Override
    public synchronized boolean stopInventory() {
        int n = this.getDeviceAPI().UHFStopGet();
        this.isRuning = false;
        this.stopInventoryThread();
        if (n == 0) {
            return true;
        }
        System.out.println("stopInventory() err :" + n);
        return false;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> arrayList, int n) {
        if (arrayList == null || arrayList.size() == 0 || n < 0) {
            return null;
        }
        switch (n) {
            case 16: 
            case 32: 
            case 48: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException("lockMode error");
            }
        }
        return super.generateLockCode(arrayList, n);
    }

    @Override
    public synchronized boolean lockMem(String string, String string2) {
        StringUtility.hexString2Chars(string);
        StringUtility.hexString2Chars(string2);
        boolean bl = this.lockMem(string, 1, 0, 0, "", string2);
        if (bl) {
            return true;
        }
        System.out.println("lockMem() err :" + bl);
        return false;
    }

    @Override
    public boolean lockMem(String object, int n, int n2, int n3, String string, String string2) {
        if (StringUtility.isEmpty((CharSequence)object)) {
            return false;
        }
        if (StringUtility.isEmpty(string2)) {
            return false;
        }
        if (n3 > 0) {
            if (StringUtility.isEmpty(string)) {
                return false;
            }
            int n4 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            int n5 = string.replace(" ", "").length() / 2;
            if (n5 < n4) {
                return false;
            }
        } else {
            string = "00";
        }
        char[] cArray = StringUtility.hexString2Chars((String)object);
        char[] cArray2 = StringUtility.hexString2Chars(string);
        object = StringUtility.hexString2Chars(string2);
        return this.getDeviceAPI().UHFLockMemEx(cArray, (char)n, n2, n3, cArray2, (char[])object) == 0;
    }

    @Override
    public synchronized UHFTAGInfo inventorySingleTag() {
        char[] cArray;
        Object object;
        Object object2 = this.getDeviceAPI().UHFInventorySingleEPCTIDUSER();
        if (object2 == null || object2[0] != '\u0000') {
            return null;
        }
        System.out.println("data =" + StringUtility.chars2HexString(object2, ((char[])object2).length));
        UHFTAGInfo uHFTAGInfo = new UHFTAGInfo();
        int n = 3 + object2[2];
        int n2 = n + 1;
        int n3 = n2 + object2[n];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n3 - n2 > 4) {
            object = Arrays.copyOfRange(object2, n2, n3);
            if (((char[])object).length > 12) {
                cArray = Arrays.copyOfRange(object, 12, ((char[])object).length);
                uHFTAGInfo.setUser(StringUtility.chars2HexString(cArray, cArray.length));
            }
            uHFTAGInfo.setTid(StringUtility.chars2HexString(object, 12));
            if (((char[])object2).length >= n3 + 2) {
                n4 = n3;
                n5 = n3 + 2;
                if (((char[])object2).length >= n5 + 2) {
                    n6 = n5;
                    n7 = n5 + 2;
                }
            }
        } else {
            uHFTAGInfo.setTid("");
            if (((char[])object2).length >= 2) {
                n4 = n2;
                n5 = n2 + 2;
                if (((char[])object2).length >= n5 + 2) {
                    n6 = n5;
                    n7 = n5 + 2;
                }
            }
        }
        char[] cArray2 = Arrays.copyOfRange(object2, n6, n7);
        object = "";
        if (n5 > 0) {
            cArray = Arrays.copyOfRange(object2, n4, n5);
            object = StringUtility.chars2HexString(cArray, cArray.length);
        }
        cArray = Arrays.copyOfRange(object2, 3, 5);
        object2 = Arrays.copyOfRange(object2, 5, n);
        if (n7 > 0) {
            String string = "" + ((cArray2[1] & 0xFF) << 8 | cArray2[0] & 0xFF);
            uHFTAGInfo.setAnt(string);
        }
        String string = StringUtility.chars2HexString(cArray, cArray.length);
        object2 = StringUtility.chars2HexString(object2, ((char[])object2).length);
        float f2 = (float)(65535 - Integer.parseInt((String)object, 16)) / 10.0f;
        Object object3 = "N/A";
        if (f2 < 200.0f && f2 > 0.0f) {
            object3 = new DecimalFormat("##0.00");
            object3 = "-" + ((NumberFormat)object3).format(f2);
        }
        uHFTAGInfo.setRssi((String)object3);
        uHFTAGInfo.setPc(string);
        uHFTAGInfo.setEPC((String)object2);
        return uHFTAGInfo;
    }

    @Override
    public String readData(String string, int n, int n2, int n3) {
        if (StringUtility.isEmpty(string) || !StringUtility.isHexNumberRex(string)) {
            return null;
        }
        return this.readData(string, 1, 0, 0, "00", n, n2, n3);
    }

    @Override
    public String readData(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6) {
        char c2;
        if (StringUtility.isEmpty(string) || !StringUtility.isHexNumberRex(string)) {
            return null;
        }
        if (StringUtility.isEmpty(string2) || !StringUtility.isHexNumberRex(string2)) {
            return null;
        }
        if (n3 > 0) {
            if (StringUtility.isEmpty(string2)) {
                return null;
            }
            int n7 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            c2 = string2.replace(" ", "").length() / 2;
            if (c2 < n7) {
                return null;
            }
        } else {
            string2 = "00";
            n3 = 0;
        }
        char[] cArray = StringUtility.hexString2Chars(string);
        c2 = (char)n;
        int n8 = n3;
        char[] cArray2 = StringUtility.hexString2Chars(string2);
        n3 = (char)n4;
        char[] cArray3 = this.getDeviceAPI().UHFReadData_Ex2(cArray, c2, n2, n8, cArray2, (char)n3, n5, n6);
        if (cArray3[0] != '\u0000') {
            System.out.println("readData() err :" + cArray3[0]);
            return null;
        }
        cArray3 = Arrays.copyOfRange(cArray3, 2, cArray3[1] + 2);
        return StringUtility.chars2HexString(cArray3, cArray3.length);
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2) {
        if (StringUtility.isEmpty(string) || StringUtility.isEmpty(string2)) {
            return false;
        }
        String string3 = "00";
        boolean bl = this.writeData(string, 1, 32, 0, string3, n, n2, n3, string2);
        return bl;
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, String string3) {
        char c2;
        if (StringUtility.isEmpty(string) || !StringUtility.isHexNumberRex(string)) {
            return false;
        }
        if (StringUtility.isEmpty(string3) || !StringUtility.isHexNumberRex(string3)) {
            return false;
        }
        if (n3 > 0) {
            if (StringUtility.isEmpty(string2)) {
                return false;
            }
            int n7 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            c2 = string2.replace(" ", "").length() / 2;
            if (c2 < n7) {
                return false;
            }
        } else {
            string2 = "00";
            n3 = 0;
        }
        char[] cArray = StringUtility.hexString2Chars(string);
        c2 = (char)n;
        int n8 = n3;
        char[] cArray2 = StringUtility.hexString2Chars(string2);
        n3 = (char)n4;
        char c3 = (char)n6;
        char[] cArray3 = StringUtility.hexString2Chars(string3);
        n8 = this.getDeviceAPI().UHFWriteData_Ex2(cArray, c2, n2, n8, cArray2, (char)n3, n5, c3, cArray3);
        return n8 == 0;
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String object, int n4, int n5, int n6, String string2) {
        char c2;
        if (StringUtility.isEmpty(string) || !StringUtility.isHexNumberRex(string)) {
            return false;
        }
        if (StringUtility.isEmpty(string2) || !StringUtility.isHexNumberRex(string2)) {
            return false;
        }
        if (n3 > 0) {
            if (StringUtility.isEmpty((CharSequence)object)) {
                return false;
            }
            int n7 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            c2 = ((String)object).replace(" ", "").length() / 2;
            if (c2 < n7) {
                return false;
            }
        } else {
            object = "00";
            n3 = 0;
        }
        char[] cArray = StringUtility.hexString2Chars(string);
        c2 = (char)n;
        int n8 = n3;
        char[] cArray2 = StringUtility.hexString2Chars((String)object);
        n3 = (char)n4;
        object = StringUtility.hexString2Chars(string2);
        n8 = this.getDeviceAPI().UHFBlockWriteData(cArray, c2, n2, n8, cArray2, (char)n3, n5, n6, (char[])object);
        return n8 == 0;
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String string2) {
        return this.blockWriteData(string, 1, 0, 0, "00", n, n2, n3, string2);
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6) {
        char c2;
        if (StringUtility.isEmpty(string) || !StringUtility.isHexNumberRex(string)) {
            return false;
        }
        if (StringUtility.isEmpty(string2) || !StringUtility.isHexNumberRex(string2)) {
            return false;
        }
        if (n3 > 0) {
            if (StringUtility.isEmpty(string2)) {
                return false;
            }
            int n7 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            c2 = string2.replace(" ", "").length() / 2;
            if (c2 < n7) {
                return false;
            }
        } else {
            string2 = "00";
            n3 = 0;
        }
        char[] cArray = StringUtility.hexString2Chars(string);
        c2 = (char)n;
        int n8 = n3;
        char[] cArray2 = StringUtility.hexString2Chars(string2);
        n3 = (char)n4;
        n8 = this.getDeviceAPI().UHFEraseDataEx(cArray, c2, n2, (char)n8, cArray2, (char)n3, n5, n6);
        if (n8 == 0) {
            return true;
        }
        System.out.println("eraseData() err :" + n8);
        return false;
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3) {
        return this.eraseData(string, 48, 0, 0, "00", n, n2, n3);
    }

    @Override
    public boolean setFilter(int n, int n2, int n3, String string) {
        if (n3 < 0 || n2 < 0) {
            return false;
        }
        if (n3 > 0) {
            if (StringUtility.isEmpty(string)) {
                return false;
            }
            int n4 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            int n5 = string.replace(" ", "").length() / 2;
            if (n5 < n4) {
                return false;
            }
        } else {
            string = "00";
        }
        char[] cArray = StringUtility.hexString2Chars(string);
        n = this.getDeviceAPI().UHFSetFilter_Ex('\u0000', (char)n, n2, n3, cArray);
        if (n == 0) {
            return true;
        }
        System.out.println("setFilter() err :" + n);
        return false;
    }

    @Override
    public synchronized boolean killTag(String object) {
        if (StringUtility.isEmpty((CharSequence)object)) {
            return false;
        }
        object = StringUtility.hexString2Chars((String)object);
        char[] cArray = this.getDeviceAPI().UHFKillTagSingle((char[])object);
        object = cArray;
        if (cArray[0] != '\u0000') {
            System.out.println("killTag() err :" + (int)object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean killTag(String string, int n, int n2, int n3, String string2) {
        if (StringUtility.isEmpty(string)) {
            return false;
        }
        if (n3 > 0) {
            if (StringUtility.isEmpty(string2)) {
                return false;
            }
            int n4 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            int n5 = string2.replace(" ", "").length() / 2;
            if (n5 < n4) {
                return false;
            }
        } else {
            string2 = "00";
        }
        char[] cArray = StringUtility.hexString2Chars(string);
        char[] cArray2 = StringUtility.hexString2Chars(string2);
        return this.getDeviceAPI().UHFKillTagEx(cArray, (char)n, n2, (char)n3, cArray2) == 0;
    }

    @Override
    public synchronized boolean setProtocol(int n) {
        n = this.getDeviceAPI().UHFSetProtocolType(n);
        if (n == 0) {
            return true;
        }
        System.out.println("setProtocol() err :" + n);
        return false;
    }

    @Override
    public synchronized int getProtocol() {
        char[] cArray = this.getDeviceAPI().UHFGetProtocolType();
        if (cArray[0] == '\u0000') {
            return cArray[2];
        }
        return -1;
    }

    @Override
    public synchronized boolean setFreHop(float f2) {
        int n = (int)(f2 * 1000.0f);
        n = this.getDeviceAPI().R2000_FreHopSet(n);
        if (n == 0) {
            return true;
        }
        System.out.println("setFreHop() err :" + n);
        return false;
    }

    @Override
    public synchronized boolean setRFLink(int n) {
        n = this.getDeviceAPI().UHFSetRFLink((char)n);
        if (n == 0) {
            return true;
        }
        System.out.println("setRFLink() err :" + n);
        return false;
    }

    @Override
    public synchronized int getRFLink() {
        byte[] byArray = this.getDeviceAPI().UHFGetRFLink();
        if (byArray == null || byArray[0] != 0) {
            System.out.println("getRFLink() err :" + byArray[0]);
            return -1;
        }
        if (byArray.length > 1) {
            return byArray[1];
        }
        return -1;
    }

    @Override
    public synchronized boolean setFastID(boolean bl) {
        int n = this.getDeviceAPI().UHFSetFastID((char)(bl ? 1 : 0));
        if (n == 0) {
            return true;
        }
        System.out.println("setFastID() err :" + n);
        return false;
    }

    @Override
    public synchronized boolean setTagFocus(boolean bl) {
        int n = this.getDeviceAPI().UHFSetTagFocus((char)(bl ? 1 : 0));
        if (n == 0) {
            return true;
        }
        System.out.println("setTagFocus() err :" + n);
        return false;
    }

    @Override
    public synchronized boolean setEPCMode() {
        int n = this.getDeviceAPI().UHFSetEPCUserMode('\u0000', 0, 0, 0);
        if (n == 0) {
            return true;
        }
        System.out.println("setEPCUSERMode() err :" + n);
        return false;
    }

    @Override
    public synchronized boolean setEPCAndTIDMode() {
        int n = this.getDeviceAPI().UHFSetEPCUserMode('\u0001', 0, 0, 0);
        if (n == 0) {
            return true;
        }
        System.out.println("setEPCAndTIDMode() err :" + n);
        return false;
    }

    @Override
    public synchronized boolean setEPCAndTIDUserMode(int n, int n2) {
        n = this.getDeviceAPI().UHFSetEPCUserMode('\u0002', n, n2, 0);
        if (n == 0) {
            return true;
        }
        System.out.println("setEPCAndTIDUserMode() err :" + n);
        return false;
    }

    @Override
    public synchronized int getTemperature() {
        Object object = this.getDeviceAPI().GetTemperature();
        if (object == null || object[0] != '\u0000') {
            return -1;
        }
        String string = StringUtility.chars2HexString(new char[]{object[1], object[2]}, 2);
        object = string;
        return Integer.valueOf(string, 16) / 100;
    }

    @Override
    public boolean uhfBlockPermalock(String object, int n, int n2, int n3, String string, int n4, int n5, int n6, int n7, byte[] byArray) {
        char[] cArray = StringUtility.hexString2Chars((String)object);
        char[] cArray2 = StringUtility.hexString2Chars(string);
        if (this.DEBUG) {
            System.out.println("accessPwd=" + (String)object + " FilterBank=" + n + " FilterStartaddr=" + n2 + " FilterLen=" + n3 + " FilterData=" + string + " ReadLock=" + n4 + " uBank=" + n5 + " uPtr=" + n6 + " uMaskbuf=" + StringUtility.bytes2HexString(byArray));
        }
        char[] cArray3 = this.getDeviceAPI().UHFBlockPermalock_Ex(cArray, (char)n, n2, n3, cArray2, (char)n4, (char)n5, n6, (char)n7, byArray);
        object = cArray3;
        if (cArray3[0] == '\u0000') {
            if (n4 == 0) {
                object = Arrays.copyOfRange((char[])object, 2, 2 + object[1]);
                byArray[0] = (byte)object[0];
                byArray[1] = (byte)object[1];
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setGen2(Gen2Entity gen2Entity) {
        int n = gen2Entity.getSelectTarget();
        int n2 = gen2Entity.getSelectAction();
        int n3 = gen2Entity.getSelectTruncate();
        int n4 = gen2Entity.getQ();
        int n5 = gen2Entity.getStartQ();
        int n6 = gen2Entity.getMinQ();
        int n7 = gen2Entity.getMaxQ();
        int n8 = gen2Entity.getQueryDR();
        int n9 = gen2Entity.getQueryM();
        int n10 = gen2Entity.getQueryTRext();
        int n11 = gen2Entity.getQuerySel();
        int n12 = gen2Entity.getQuerySession();
        int n13 = gen2Entity.getQueryTarget();
        int n14 = gen2Entity.getLinkFrequency();
        n14 = this.getDeviceAPI().SetGen2((char)n, (char)n2, (char)n3, (char)n4, (char)n5, (char)n6, (char)n7, (char)n8, (char)n9, (char)n10, (char)n11, (char)n12, (char)n13, (char)n14);
        return n14 == 0;
    }

    @Override
    public Gen2Entity getGen2() {
        System.out.println("GetGen2()=========");
        char[] cArray = this.getDeviceAPI().GetGen2();
        if (cArray[0] == '\u0000') {
            Object object;
            if (this.DEBUG) {
                object = new StringBuilder();
                ((StringBuilder)object).append("result data[0]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[0]));
                ((StringBuilder)object).append("leng data[1]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[1]));
                ((StringBuilder)object).append("target data[2]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[2]));
                ((StringBuilder)object).append(",action data[3]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[3]));
                ((StringBuilder)object).append(",t data[4]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[4]));
                ((StringBuilder)object).append(",q data[5]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[5]));
                ((StringBuilder)object).append(",startQ data[6]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[6]));
                ((StringBuilder)object).append(",minQ data[7]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[7]));
                ((StringBuilder)object).append(",maxQ data[8]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[8]));
                ((StringBuilder)object).append(",dr data[9]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[9]));
                ((StringBuilder)object).append(",coding data[10]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[10]));
                ((StringBuilder)object).append(", p data[11]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[11]));
                ((StringBuilder)object).append(",Sel data[12]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[12]));
                ((StringBuilder)object).append(",Session data[13]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[13]));
                ((StringBuilder)object).append(",g data[14]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[14]));
                ((StringBuilder)object).append(",linkFrequency data[15]=");
                ((StringBuilder)object).append(String.valueOf((int)cArray[15]));
                System.out.println(((StringBuilder)object).toString());
            }
            object = new Gen2Entity();
            ((Gen2Entity)object).setSelectTarget(cArray[2]);
            ((Gen2Entity)object).setSelectAction(cArray[3]);
            ((Gen2Entity)object).setSelectTruncate(cArray[4]);
            ((Gen2Entity)object).setQ(cArray[5]);
            ((Gen2Entity)object).setStartQ(cArray[6]);
            ((Gen2Entity)object).setMinQ(cArray[7]);
            ((Gen2Entity)object).setMaxQ(cArray[8]);
            ((Gen2Entity)object).setQueryDR(cArray[9]);
            ((Gen2Entity)object).setQueryM(cArray[10]);
            ((Gen2Entity)object).setQueryTRext(cArray[11]);
            ((Gen2Entity)object).setQuerySel(cArray[12]);
            ((Gen2Entity)object).setQuerySession(cArray[13]);
            ((Gen2Entity)object).setQueryTarget(cArray[14]);
            ((Gen2Entity)object).setLinkFrequency(cArray[15]);
            return object;
        }
        System.out.println("error=" + cArray[0]);
        return null;
    }

    @Override
    public synchronized boolean setPwm(int n, int n2) {
        n = this.getDeviceAPI().UHFSetPwm(n, n2);
        if (n == 0) {
            return true;
        }
        System.out.println("setPwm() err :" + n);
        return false;
    }

    @Override
    public synchronized int[] getPwm() {
        int[] nArray = this.getDeviceAPI().UHFGetPwm();
        if (nArray == null || nArray[0] != 0) {
            System.out.println("getPwm() err :" + nArray[0]);
            return null;
        }
        nArray = Arrays.copyOfRange(nArray, 1, 3);
        return nArray;
    }

    public synchronized boolean setQTPara(boolean bl) {
        int n = this.getDeviceAPI().SetQTPara(bl ? (char)'\u0001' : '\u0000');
        if (n == 0) {
            return true;
        }
        System.out.println("setQTPara() err :" + n);
        return false;
    }

    public synchronized int[] getQTPara() {
        char[] cArray = this.getDeviceAPI().GetQTPara();
        int[] nArray = new int[]{0, 0};
        if (cArray != null && cArray[0] == '\u0000') {
            nArray[0] = 1;
            nArray[1] = cArray[1];
            return nArray;
        }
        System.out.println("getQTPara() err :" + cArray[0]);
        return nArray;
    }

    @Override
    public synchronized boolean uhfJump2Boot() {
        return this.getDeviceAPI().UHFJump2Boot() == 0;
    }

    @Override
    public synchronized boolean uhfStartUpdate() {
        return this.getDeviceAPI().UHFStartUpdate() == 0;
    }

    @Override
    public synchronized boolean uhfUpdating(byte[] byArray) {
        byte[] byArray2 = new byte[64];
        if (byArray.length < 64) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray2[i2] = byArray[i2];
            }
        } else {
            for (int i3 = 0; i3 < 64; ++i3) {
                byArray2[i3] = byArray[i3];
            }
        }
        return this.getDeviceAPI().UHFUpdating(byArray2) == 0;
    }

    @Override
    public synchronized boolean uhfStopUpdate() {
        return this.getDeviceAPI().UHFStopUpdate() == 0;
    }

    @Override
    public synchronized int getCW() {
        char[] cArray = this.getDeviceAPI().UHFGetCW();
        if (cArray[0] == '\u0000') {
            return cArray[1];
        }
        return -1;
    }

    @Override
    public boolean setCW(int n) {
        return this.getDeviceAPI().UHFSetCW((char)n) == 0;
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        char[] cArray = this.getDeviceAPI().UHFGetEPCTIDMode();
        if (cArray == null || cArray[0] != '\u0000') {
            return null;
        }
        InventoryModeEntity$Builder inventoryModeEntity$Builder = new InventoryModeEntity$Builder();
        char c2 = cArray[2];
        inventoryModeEntity$Builder.setMode(c2);
        if (c2 == '\u0002') {
            inventoryModeEntity$Builder.setUserOffset(cArray[3]);
            inventoryModeEntity$Builder.setUserOffset(cArray[4]);
        }
        return inventoryModeEntity$Builder.build();
    }

    @Override
    public boolean setBeep(int n) {
        n = this.getDeviceAPI().UHFSetReaderBeep((char)n);
        return n == 0;
    }

    @Override
    public ConnectionState getConnectStatus() {
        return this.connectionState;
    }

    @Override
    public char[] getBeep() {
        return this.getDeviceAPI().UHFGetReaderBeep();
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        this.inventoryCallback = iUHFInventoryCallback;
    }

    private ArrayList<UHFTAGInfo> parseReadTagDataEPC_TID_USER(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<UHFTAGInfo> arrayList = new ArrayList<UHFTAGInfo>();
        if (byArray != null && byArray[0] == 0) {
            int n = 2 + (0xFF & byArray[1]);
            if (byArray.length < n) {
                return null;
            }
            byArray = Arrays.copyOfRange(byArray, 2, n);
            n = byArray[0] & 0xFF;
            int n2 = byArray[1] & 0xFF;
            int n3 = 2;
            int n4 = n2 + 2;
            for (int i2 = 0; i2 < n && byArray.length >= n4; ++i2) {
                Object object = Arrays.copyOfRange(byArray, n3, n4);
                UHFTAGInfo uHFTAGInfo = this.parserUhfTagBuff_EPC_TID_USER((byte[])object);
                object = uHFTAGInfo;
                if (uHFTAGInfo != null) {
                    arrayList.add((UHFTAGInfo)object);
                }
                if (i2 >= n - 1) break;
                n2 = byArray[n4] & 0xFF;
                n3 = n4 + 1;
                n4 = n3 + n2;
            }
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    private UHFTAGInfo parserUhfTagBuff_EPC_TID_USER(byte[] object) {
        if (object == null || ((byte[])object).length == 0) {
            throw new IllegalArgumentException();
        }
        UHFTAGInfo uHFTAGInfo = new UHFTAGInfo();
        int n = ((byte[])object).length;
        byte[] byArray = Arrays.copyOfRange((byte[])object, 0, 2);
        uHFTAGInfo.setPc(StringUtility.bytes2HexString2(byArray, byArray.length));
        int n2 = (byArray[0] & 0xFF) >> 3 << 1;
        byte[] byArray2 = Arrays.copyOfRange((byte[])object, 2, n2 + 2);
        String string = StringUtility.bytes2HexString2(byArray2, byArray2.length);
        uHFTAGInfo.setEPC(string);
        uHFTAGInfo.setEpcBytes(byArray2);
        byArray2 = null;
        if (n >= (n2 += 2) + 12) {
            int n3 = n2 + 12;
            byte[] byArray3 = Arrays.copyOfRange((byte[])object, n2, n3);
            uHFTAGInfo.setTid(StringUtility.bytes2HexString2(byArray3, byArray3.length));
            uHFTAGInfo.setTidBytes(byArray3);
            if (n - 3 > n3) {
                int n4 = n - 2;
                byte[] byArray4 = Arrays.copyOfRange((byte[])object, n3, n4);
                uHFTAGInfo.setUser(StringUtility.bytes2HexString2(byArray4, byArray4.length));
                if (n >= n4 + 2) {
                    n = n4 + 2;
                    byArray2 = Arrays.copyOfRange((byte[])object, n4, n);
                }
            } else if (n >= n3 + 2) {
                int n5 = n3 + 2;
                byArray2 = Arrays.copyOfRange((byte[])object, n3, n5);
            }
        } else if (n >= n2 + 2) {
            int n6 = n2 + 2;
            byArray2 = Arrays.copyOfRange((byte[])object, n2, n6);
        }
        if (byArray2 != null) {
            object = StringUtility.bytes2HexString2(byArray2, byArray2.length);
            float f2 = (float)(65535 - Integer.parseInt((String)object, 16)) / 10.0f;
            String string2 = "N/A";
            if (f2 < 200.0f && f2 > 0.0f) {
                object = new DecimalFormat("##0.00");
                string2 = "-" + ((NumberFormat)object).format(f2);
            }
            uHFTAGInfo.setRssi(string2);
        }
        if (uHFTAGInfo.getEPC() == null || uHFTAGInfo.getEPC().isEmpty()) {
            uHFTAGInfo = null;
        }
        return uHFTAGInfo;
    }

    private void log(String string) {
        Object object = "/home/cw/eclipse-workspace/deviceJar/MakefileUHF/jni/uhf_jni_log2.txt";
        object = new File((String)object);
        try {
            string = this.getDateTime() + string;
            object = new FileOutputStream((File)object, true);
            ((FileOutputStream)object).write(string.getBytes());
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    private String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date()) + "  ";
    }

    public boolean triggerBeep(int n) {
        n = this.getDeviceAPI().UHFSetBeep((byte)1, n);
        return n == 0;
    }

    public boolean setLed(int n) {
        n = this.getDeviceAPI().UHFSetLed((byte)n, 0, 0, 0);
        return n == 0;
    }

    public boolean blinkOfLed(int n, int n2, int n3) {
        n = this.getDeviceAPI().UHFSetLed((byte)2, n, n2, n3);
        return n == 0;
    }

    @Override
    public boolean uhfJump2BootToSTM32() {
        int n = this.getDeviceAPI().UHFJump2BootSTM32();
        System.out.println("UHFJump2BootSTM32 result=" + n);
        return n == 0;
    }

    public void setFilterRepeatData(int n) {
        block3: {
            block4: {
                block2: {
                    if (n <= 0 || n > 2) {
                        throw new IllegalArgumentException("bank invalid!");
                    }
                    this.isFilterRepeatBank = n;
                    if (n != 0) break block2;
                    if (this.uhfinfoList == null) break block3;
                    break block4;
                }
                if (this.uhfinfoList == null) {
                    this.uhfinfoList = new ArrayList<UHFTAGInfo>();
                }
            }
            this.uhfinfoList.clear();
        }
    }

    private void startInventoryThread() {
        if (this.inventoryThread == null) {
            this.inventoryThread = new UsbLinuxDeviceAPI$InventoryThread(this);
            this.inventoryThread.start();
        }
    }

    private void stopInventoryThread() {
        if (this.inventoryThread != null) {
            this.inventoryThread.stopThread();
            this.inventoryThread = null;
        }
    }

    static /* synthetic */ int access$000(UsbLinuxDeviceAPI usbLinuxDeviceAPI) {
        return usbLinuxDeviceAPI.isFilterRepeatBank;
    }

    static /* synthetic */ IUHFInventoryCallback access$100(UsbLinuxDeviceAPI usbLinuxDeviceAPI) {
        return usbLinuxDeviceAPI.inventoryCallback;
    }
}

