/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.entity.AntennaNameEnum;
import com.rscja.deviceapi.entity.AntennaPowerEntity;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.IUHFProtocolParse;
import com.rscja.deviceapi.j;
import com.rscja.utility.LogUtility;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class k
extends j
implements IUHFProtocolParse {
    private final byte[] a = new byte[2048];

    public k() {
        new ArrayList();
    }

    @Override
    public byte[] getBeepSendData(boolean bl) {
        if (bl) {
            String string = "A55A000AE40301EC0D0A";
            return StringUtility.hexString2Bytes("A55A000AE40301EC0D0A");
        }
        String string = "A55A000AE40300ED0D0A";
        return StringUtility.hexString2Bytes("A55A000AE40300ED0D0A");
    }

    @Override
    public byte[] setBeepTimeOfDurationSendData(int n) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = byArray;
        byArray[0] = 3;
        byArray2[1] = 1;
        byArray2[2] = (byte)n;
        return this.b(228, byArray2);
    }

    @Override
    public boolean parseBeepData(byte[] byArray) {
        return (byArray = this.a(229, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public boolean parseSetBeepTimeOfDuration(byte[] byArray) {
        return (byArray = this.a(229, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getScanBarcodeSendData() {
        String string = "A55A0009E402EF0D0A";
        return StringUtility.hexString2Bytes("A55A0009E402EF0D0A");
    }

    @Override
    public byte[] parseBarcodeData(byte[] byArray) {
        if ((byArray = this.a(229, byArray)) != null && byArray.length > 1 && byArray[0] == 2) {
            return Arrays.copyOfRange(byArray, 1, byArray.length);
        }
        return null;
    }

    @Override
    public byte[] getBatterySendData() {
        String string = "A55A0009E401EC0D0A";
        return StringUtility.hexString2Bytes("A55A0009E401EC0D0A");
    }

    @Override
    public int parseBatteryData(byte[] byArray) {
        if ((byArray = this.a(229, byArray)) != null && byArray.length > 1 && byArray[0] == 1) {
            return byArray[1] & 0xFF;
        }
        return -1;
    }

    @Override
    public byte[] getWriteSendData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6, String object3) {
        int n7;
        int n8;
        byte[] byArray = StringUtility.hexString2Bytes((String)object);
        object = byArray;
        if (byArray == null || ((Object)object).length != 4) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        if (n4 < 0 || n5 < 0 || n6 < 0) {
            throw new IllegalArgumentException("bank or ptr or cnt error !");
        }
        if (object3 == null || ((String)object3).length() == 0) {
            throw new IllegalArgumentException("writeData is Empty!");
        }
        if (((String)object3).length() % 4 != 0) {
            throw new IllegalArgumentException("writeData length err!");
        }
        if (((Object)(object3 = (Object)StringUtility.hexString2Bytes((String)object3))).length < (n8 = n6 << 1)) {
            throw new IllegalArgumentException("writeData cnt error!");
        }
        if (n3 == 0) {
            n = 1;
            n2 = 0;
            object2 = new byte[1];
        } else {
            if (n < 0 || n2 < 0 || n3 < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            byte[] byArray2 = StringUtility.hexString2Bytes((String)object2);
            object2 = byArray2;
            if (byArray2 == null || ((Object)object2).length == 0) {
                throw new IllegalArgumentException("filterCnt error !");
            }
            n8 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            if (((Object)object2).length < n8) {
                throw new IllegalArgumentException("filterCnt error 2!");
            }
        }
        n8 = 0;
        byte[] byArray3 = new byte[1024];
        byte[] byArray4 = byArray3;
        ++n8;
        byArray3[0] = (byte)object[0];
        ++n8;
        byArray4[1] = (byte)object[1];
        ++n8;
        byArray4[2] = (byte)object[2];
        ++n8;
        byArray4[3] = (byte)object[3];
        ++n8;
        byArray4[4] = (byte)n;
        ++n8;
        byArray4[5] = (byte)(n2 / 256);
        ++n8;
        byArray4[6] = (byte)(n2 % 256);
        ++n8;
        byArray4[7] = (byte)(n3 / 256);
        ++n8;
        byArray4[8] = (byte)(n3 % 256);
        for (n7 = 0; n7 < n3 / 8; ++n7) {
            byArray4[n8++] = (byte)object2[n7];
        }
        if (n3 % 8 > 0) {
            byArray4[n8++] = (byte)object2[n7];
        }
        byArray4[n8++] = (byte)n4;
        byArray4[n8++] = (byte)(n5 / 256);
        byArray4[n8++] = (byte)(n5 % 256);
        byArray4[n8++] = (byte)(n6 / 256);
        byArray4[n8++] = (byte)(n6 % 256);
        for (n7 = 0; n7 < n6 << 1; ++n7) {
            byArray4[n8++] = (byte)object3[n7];
        }
        byArray4 = Arrays.copyOf(byArray4, n8);
        return this.b(134, byArray4);
    }

    @Override
    public boolean parseWriteData(byte[] byArray) {
        return (byArray = this.a(135, byArray)) != null && byArray.length > 1 && byArray[0] == 1 && byArray[1] == 0;
    }

    @Override
    public byte[] getReadSendData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6) {
        int n7;
        byte[] byArray = StringUtility.hexString2Bytes((String)object);
        object = byArray;
        if (byArray == null || ((Object)object).length != 4) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        if (n4 < 0 || n5 < 0 || n6 < 0) {
            throw new IllegalArgumentException("bank or ptr or cnt error !");
        }
        if (n3 == 0) {
            n = 1;
            n2 = 0;
            object2 = new byte[1];
        } else {
            if (n < 0 || n2 < 0 || n3 < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            byte[] byArray2 = StringUtility.hexString2Bytes((String)object2);
            object2 = byArray2;
            if (byArray2 == null || ((Object)object2).length == 0) {
                throw new IllegalArgumentException("filterData cannot be empty!");
            }
            int n8 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            if (((Object)object2).length < n8) {
                throw new IllegalArgumentException("filterCnt error !");
            }
        }
        byte[] byArray3 = new byte[1024];
        int n9 = 0;
        ++n9;
        byArray3[0] = (byte)object[0];
        ++n9;
        byArray3[1] = (byte)object[1];
        ++n9;
        byArray3[2] = (byte)object[2];
        ++n9;
        byArray3[3] = (byte)object[3];
        ++n9;
        byArray3[4] = (byte)n;
        ++n9;
        byArray3[5] = (byte)(n2 / 256);
        ++n9;
        byArray3[6] = (byte)(n2 % 256);
        ++n9;
        byArray3[7] = (byte)(n3 / 256);
        ++n9;
        byArray3[8] = (byte)(n3 % 256);
        for (n7 = 0; n7 < n3 / 8; ++n7) {
            byArray3[n9++] = (byte)object2[n7];
        }
        if (n3 % 8 > 0) {
            byArray3[n9++] = (byte)object2[n7];
        }
        byArray3[n9++] = (byte)n4;
        byArray3[n9++] = (byte)(n5 / 256);
        byArray3[n9++] = (byte)(n5 % 256);
        byArray3[n9++] = (byte)(n6 / 256);
        byArray3[n9++] = (byte)(n6 % 256);
        byArray3 = Arrays.copyOf(byArray3, n9);
        return this.b(132, byArray3);
    }

    @Override
    public String parseReadData(byte[] byArray) {
        if ((byArray = this.a(133, byArray)) != null && byArray.length > 1 && byArray[0] == 1 && byArray[1] == 0) {
            int n = (byArray[2] << 8) + byArray[3] << 1;
            new StringBuilder("parseReadData! len=").append(n);
            byte[] byArray2 = new byte[n];
            for (int i2 = 0; i2 < n; ++i2) {
                byArray2[i2] = byArray[i2 + 4];
            }
            return StringUtility.bytes2HexString(byArray2, n);
        }
        return null;
    }

    @Override
    public byte[] getLockSendData(String object, int n, int n2, int n3, String object2, String object3) {
        int n4;
        object = StringUtility.hexString2Bytes((String)object);
        object3 = StringUtility.hexString2Bytes((String)object3);
        if (object == null || ((Object)object).length != 4) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        if (object3 == null || ((Object)object3).length != 3) {
            throw new IllegalArgumentException("lockCode error !");
        }
        if (n3 == 0) {
            n = 1;
            n2 = 0;
            object2 = new byte[1];
        } else {
            if (n < 0 || n2 < 0 || n3 < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            byte[] byArray = StringUtility.hexString2Bytes((String)object2);
            object2 = byArray;
            if (byArray == null || ((Object)object2).length == 0) {
                throw new IllegalArgumentException("ufilterData cannot be empty!");
            }
            int n5 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            if (((Object)object2).length < n5) {
                throw new IllegalArgumentException("filterCnt error !");
            }
        }
        byte[] byArray = new byte[1024];
        int n6 = 0;
        ++n6;
        byArray[0] = (byte)object[0];
        ++n6;
        byArray[1] = (byte)object[1];
        ++n6;
        byArray[2] = (byte)object[2];
        ++n6;
        byArray[3] = (byte)object[3];
        ++n6;
        byArray[4] = (byte)n;
        ++n6;
        byArray[5] = (byte)(n2 / 256);
        ++n6;
        byArray[6] = (byte)(n2 % 256);
        ++n6;
        byArray[7] = (byte)(n3 / 256);
        ++n6;
        byArray[8] = (byte)(n3 % 256);
        for (n4 = 0; n4 < n3 / 8; ++n4) {
            byArray[n6++] = (byte)object2[n4];
        }
        if (n3 % 8 > 0) {
            byArray[n6++] = (byte)object2[n4];
        }
        byArray[n6++] = (byte)object3[0];
        byArray[n6++] = (byte)object3[1];
        byArray[n6++] = (byte)object3[2];
        byArray = Arrays.copyOf(byArray, n6);
        return this.b(136, byArray);
    }

    @Override
    public boolean parseLockData(byte[] byArray) {
        return (byArray = this.a(137, byArray)) != null && byArray.length > 1 && byArray[0] == 1 && byArray[1] == 0;
    }

    @Override
    public byte[] getKillSendData(String object, int n, int n2, int n3, String object2) {
        int n4;
        byte[] byArray = StringUtility.hexString2Bytes((String)object);
        object = byArray;
        if (byArray == null || ((Object)object).length != 4) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        if (n3 == 0) {
            n = 1;
            n2 = 0;
            object2 = new byte[1];
        } else {
            if (n < 0 || n2 < 0 || n3 < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            byte[] byArray2 = StringUtility.hexString2Bytes((String)object2);
            object2 = byArray2;
            if (byArray2 == null || ((Object)object2).length == 0) {
                throw new IllegalArgumentException("filterData cannot be empty!");
            }
            int n5 = n3 / 8 + (n3 % 8 == 0 ? 0 : 1);
            if (((Object)object2).length < n5) {
                throw new IllegalArgumentException("filterCnt error !");
            }
        }
        byte[] byArray3 = new byte[1024];
        int n6 = 0;
        ++n6;
        byArray3[0] = (byte)object[0];
        ++n6;
        byArray3[1] = (byte)object[1];
        ++n6;
        byArray3[2] = (byte)object[2];
        ++n6;
        byArray3[3] = (byte)object[3];
        ++n6;
        byArray3[4] = (byte)n;
        ++n6;
        byArray3[5] = (byte)(n2 / 256);
        ++n6;
        byArray3[6] = (byte)(n2 % 256);
        ++n6;
        byArray3[7] = (byte)(n3 / 256);
        ++n6;
        byArray3[8] = (byte)(n3 % 256);
        for (n4 = 0; n4 < n3 / 8; ++n4) {
            byArray3[n6++] = (byte)object2[n4];
        }
        if (n3 % 8 > 0) {
            byArray3[n6++] = (byte)object2[n4];
        }
        byArray3 = Arrays.copyOf(byArray3, n6);
        return this.b(138, byArray3);
    }

    @Override
    public boolean parseKillData(byte[] byArray) {
        return (byArray = this.a(139, byArray)) != null && byArray.length > 1 && byArray[0] == 1 && byArray[1] == 0;
    }

    @Override
    public byte[] getInventorySingleTagSendData() {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray2[1] = 100;
        return this.b(128, byArray2);
    }

    @Override
    public UHFTAGInfo parseInventorySingleTagData(byte[] object) {
        if ((object = this.a(129, (byte[])object)) != null && ((byte[])object).length > 0) {
            k k2 = this;
            boolean bl = true;
            byte[] byArray = object;
            object = k2;
            return super.a(byArray, bl);
        }
        return null;
    }

    @Override
    public UHFTAGInfo parseContinuousInventoryTagData(byte[] object) {
        if ((object = this.a(131, (byte[])object)) != null && ((byte[])object).length > 0) {
            k k2 = this;
            boolean bl = true;
            byte[] byArray = object;
            object = k2;
            return super.a(byArray, bl);
        }
        return null;
    }

    public final UHFTAGInfo c(byte[] object) {
        if (object != null && ((byte[])object).length > 0) {
            k k2 = this;
            boolean bl = true;
            byte[] byArray = object;
            object = k2;
            return super.a(byArray, bl);
        }
        return null;
    }

    public final List<UHFTAGInfo> d(byte[] byArray) {
        if (byArray != null && byArray.length > 2) {
            int n = byArray[0] & 0xFF;
            int n2 = 1;
            ArrayList<byte[]> arrayList = null;
            for (int i2 = 0; i2 < n; ++i2) {
                int n3 = byArray[n2] & 0xFF;
                Object object = Arrays.copyOfRange(byArray, n2 + 1, n2 + 1 + n3);
                k k2 = this;
                boolean bl = false;
                byte[] byArray2 = object;
                object = k2;
                UHFTAGInfo uHFTAGInfo = super.a(byArray2, bl);
                object = uHFTAGInfo;
                if (uHFTAGInfo != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<byte[]>();
                    }
                    arrayList.add((byte[])object);
                }
                n2 = n2 + 1 + n3;
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public byte[] getStartInventoryTagSendData() {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray2[1] = 0;
        return this.b(130, byArray2);
    }

    @Override
    public boolean parseStartInventoryTagData(byte[] object) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
        }
        return true;
    }

    @Override
    public byte[] getStopInventorySendData() {
        String string = "A55A00088C840D0A";
        return StringUtility.hexString2Bytes("A55A00088C840D0A");
    }

    @Override
    public boolean parseStopInventoryData(byte[] byArray) {
        return (byArray = this.a(141, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getReadTagSendData() {
        byte[] byArray = new byte[]{};
        return this.b(224, byArray);
    }

    @Override
    public List<UHFTAGInfo> parseReadTagData_EPC(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (byArray != null && byArray.length > 0) {
            return super.a(byArray);
        }
        return null;
    }

    @Override
    public List<UHFTAGInfo> parseReadTagDataEPC_TID_USER(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (byArray != null && byArray.length > 0) {
            if (byArray.length == 1) {
                LogUtility.isDebug();
            }
            return super.b(byArray);
        }
        return null;
    }

    @Override
    public byte[] setPowerSendData(int n, int n2) {
        byte[] byArray = new byte[]{2, (byte)n, (byte)((n2 *= 100) >> 8), (byte)n2, (byte)(n2 >> 8), (byte)n2};
        return this.b(16, byArray);
    }

    @Override
    public byte[] setPowerSendData(int n) {
        byte[] byArray = new byte[]{2, 1, (byte)((n *= 100) >> 8), (byte)n, (byte)(n >> 8), (byte)n};
        return this.b(16, byArray);
    }

    @Override
    public boolean parseSetPowerData(byte[] byArray) {
        return (byArray = this.a(17, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getPowerSendData() {
        byte[] byArray = new byte[]{};
        return this.b(18, byArray);
    }

    @Override
    public int parseGetPowerData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if ((byArray = this.a(19, byArray)) != null && byArray.length >= 4 && byArray[0] == 0) {
            int n = (((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF)) / 100;
            return n;
        }
        return -1;
    }

    @Override
    public List<AntennaPowerEntity> parseGetPowerAllData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if ((byArray = this.a(19, byArray)) != null && byArray.length >= 4 && byArray[0] == 0) {
            int n;
            int n2;
            int n3 = (byArray.length - 1) / 5;
            ArrayList<AntennaPowerEntity> arrayList = new ArrayList<AntennaPowerEntity>();
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                n = n2 * 5;
                if (byArray.length < ++n + 1) continue;
                byte by = byArray[n];
                if (by == 0) {
                    by = 1;
                }
                n = (((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF)) / 100;
                if (by == 1) {
                    n4 = n;
                } else if (by > 8) continue;
                if (n == 0) {
                    n = n4;
                }
                AntennaPowerEntity antennaPowerEntity = new AntennaPowerEntity();
                antennaPowerEntity.setAntennaNameEnum(AntennaNameEnum.getValue(by));
                antennaPowerEntity.setPower(n);
                arrayList.add(antennaPowerEntity);
            }
            if (arrayList.size() > 0) {
                for (n2 = 1; n2 <= 8; ++n2) {
                    n = 0;
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        if (n2 != ((AntennaPowerEntity)arrayList.get(i2)).getAntennaNameEnum().getValue()) continue;
                        n = 1;
                        break;
                    }
                    if (n != 0) continue;
                    AntennaPowerEntity antennaPowerEntity = new AntennaPowerEntity();
                    antennaPowerEntity.setAntennaNameEnum(AntennaNameEnum.getValue(n2));
                    antennaPowerEntity.setPower(n4);
                    arrayList.add(antennaPowerEntity);
                }
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public byte[] getVersionSendData() {
        byte[] byArray = new byte[]{};
        return this.b(2, byArray);
    }

    @Override
    public String parseVersionData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[100];
        if ((byArray = this.a(3, byArray)) != null && byArray.length >= 3) {
            int n = 0;
            ++n;
            cArray[0] = 86;
            if (this.a[0] > 9) {
                ++n;
                cArray[1] = (char)(this.a[0] / 10 + 48);
                cArray[2] = (char)(48 + this.a[0] % 10);
            } else {
                ++n;
                cArray[1] = (char)(48 + this.a[0] % 10);
            }
            int n2 = ++n;
            ++n;
            cArray[n2] = 46;
            if (this.a[1] > 9) {
                cArray[n++] = (char)(this.a[1] / 10 + 48);
            }
            cArray[n++] = (char)(48 + this.a[1] % 10);
            cArray[n++] = 46;
            if (this.a[2] > 9) {
                cArray[n++] = (char)(this.a[2] / 10 + 48);
            }
            cArray[n++] = (char)(48 + this.a[2] % 10);
            return new String(Arrays.copyOf(cArray, n));
        }
        return null;
    }

    @Override
    public byte[] getTemperatureSendData() {
        byte[] byArray = new byte[]{};
        return this.b(52, byArray);
    }

    @Override
    public int parseTemperatureData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if ((byArray = this.a(53, byArray)) != null && byArray.length > 0 && this.a[0] == 1) {
            byte[] byArray2 = new byte[2];
            byArray = byArray2;
            byArray2[0] = this.a[1];
            byArray[1] = this.a[2];
            String string = StringUtility.bytes2HexString(byArray, 2);
            if ((byArray[0] & 0xFF) >= 240) {
                int n = Integer.valueOf(string, 16);
                return -((65535 - n) / 100);
            }
            return Integer.valueOf(string, 16) / 100;
        }
        return -1;
    }

    @Override
    public byte[] setEPCModeSendData() {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = 1;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = 0;
        return this.b(112, byArray2);
    }

    @Override
    public boolean parseSetEPCModeData(byte[] byArray) {
        return this.parseSetEPCAndTIDUserModeData(byArray);
    }

    @Override
    public byte[] setEPCAndTIDModeSendData() {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = 1;
        byArray2[1] = 1;
        byArray2[2] = 0;
        byArray2[3] = 0;
        return this.b(112, byArray2);
    }

    @Override
    public boolean parseSetEPCAndTIDModeData(byte[] byArray) {
        return this.parseSetEPCAndTIDUserModeData(byArray);
    }

    @Override
    public byte[] setEPCAndTIDUserModeSendData(int n, int n2) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = 1;
        byArray2[1] = 2;
        byArray2[2] = (byte)n;
        byArray2[3] = (byte)n2;
        return this.b(112, byArray2);
    }

    @Override
    public boolean parseSetEPCAndTIDUserModeData(byte[] byArray) {
        return (byArray = this.a(113, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getEPCTIDModeSendData(char c2, char c3) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)c2;
        byArray2[1] = (byte)c3;
        return this.b(114, byArray2);
    }

    @Override
    public byte[] parseGetEPCTIDModeData(byte[] byArray) {
        if ((byArray = this.a(115, byArray)) != null && byArray.length >= 4 && byArray[0] == 1) {
            byte[] byArray2 = new byte[3];
            byte[] byArray3 = byArray2;
            byArray2[0] = byArray[1];
            byArray3[1] = byArray[2];
            byArray3[2] = byArray[3];
            return byArray3;
        }
        return null;
    }

    @Override
    public byte[] setFilterSendData(char c2, int n, int n2, String object) {
        new StringBuilder("setFilterSendData ufBank:").append((int)c2);
        new StringBuilder("setFilterSendData ufPtr:").append(n);
        new StringBuilder("setFilterSendData datalen:").append(n2);
        new StringBuilder("setFilterSendData databuf:").append((String)object);
        if (n2 < 0 || n2 < 0) {
            return null;
        }
        if (n2 > 0) {
            if (StringUtility.isEmpty((CharSequence)object)) {
                return null;
            }
            if (n2 > ((String)object).length() << 2) {
                return null;
            }
            if (((String)object).length() % 2 != 0) {
                object = (String)object + "0";
            }
        } else {
            object = "00";
        }
        object = StringUtility.hexString2Bytes((String)object);
        byte[] byArray = new byte[1024];
        int n3 = 0;
        ++n3;
        byArray[0] = 0;
        ++n3;
        byArray[1] = (byte)c2;
        ++n3;
        byArray[2] = (byte)(n / 256);
        ++n3;
        byArray[3] = (byte)(n % 256);
        ++n3;
        byArray[4] = (byte)(n2 / 256);
        ++n3;
        byArray[5] = (byte)(n2 % 256);
        for (c2 = '\u0000'; c2 < n2 / 8; c2 = (char)(c2 + 1)) {
            byArray[n3++] = (byte)object[c2];
        }
        if (n2 % 8 > 0) {
            byArray[n3++] = (byte)object[c2];
        }
        return this.b(110, Arrays.copyOf(byArray, n3));
    }

    @Override
    public boolean parseSetFilterData(byte[] byArray) {
        return (byArray = this.a(111, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getSTM32VersionSendData() {
        byte[] byArray = new byte[]{};
        return this.b(200, byArray);
    }

    @Override
    public String parseSTM32VersionData(byte[] byArray) {
        if ((byArray = this.a(201, byArray)) != null && byArray.length >= 3) {
            char[] cArray = new char[5];
            char[] cArray2 = cArray;
            cArray[0] = 86;
            cArray2[1] = (char)(byArray[0] + 48);
            cArray2[2] = 46;
            cArray2[3] = (char)(byArray[1] + 48);
            cArray2[4] = (char)(byArray[2] + 48);
            return new String(cArray2);
        }
        return null;
    }

    @Override
    public byte[] setProtocolSendData(int n) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray2[1] = (byte)n;
        return this.b(6, byArray2);
    }

    @Override
    public boolean parseSetProtocolData(byte[] byArray) {
        return (byArray = this.a(7, byArray)) != null && byArray.length > 1 && byArray[0] == 0 && byArray[1] == 1;
    }

    @Override
    public byte[] getProtocolSendData() {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 1;
        return this.b(6, byArray2);
    }

    @Override
    public int parseGetProtocolData(byte[] byArray) {
        if ((byArray = this.a(7, byArray)) != null && byArray.length > 1 && byArray[0] == 1) {
            return byArray[1] & 0xFF;
        }
        return -1;
    }

    @Override
    public byte[] getFrequencyModeSendData() {
        byte[] byArray = new byte[]{};
        return this.b(46, byArray);
    }

    @Override
    public byte parseGetFrequencyModeData(byte[] byArray) {
        if ((byArray = this.a(47, byArray)) != null && byArray.length > 1 && byArray[0] == 1) {
            return byArray[1];
        }
        return -1;
    }

    @Override
    public byte[] setFrequencyModeSendData(int n) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 1;
        byArray2[1] = (byte)n;
        return this.b(44, byArray2);
    }

    @Override
    public boolean parseSetFrequencyModeData(byte[] byArray) {
        return (byArray = this.a(45, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] setGen2SendData(Gen2Entity gen2Entity) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)((gen2Entity.getSelectTarget() & 7) << 5 | (gen2Entity.getSelectAction() & 7) << 2 | (gen2Entity.getSelectTruncate() & 1) << 1 | gen2Entity.getQ() & 1);
        byArray2[1] = (byte)((gen2Entity.getStartQ() & 0xF) << 4 | gen2Entity.getMinQ() & 0xF);
        byArray2[2] = (byte)((gen2Entity.getMaxQ() & 0xF) << 4 | (gen2Entity.getQueryDR() & 1) << 3 | (gen2Entity.getQueryM() & 3) << 1 | gen2Entity.getQueryTRext() & 1);
        byArray2[3] = (byte)((gen2Entity.getQuerySel() & 3) << 6 | (gen2Entity.getQuerySession() & 3) << 4 | (gen2Entity.getQueryTarget() & 1) << 3 | gen2Entity.getLinkFrequency() & 7);
        return this.b(32, byArray2);
    }

    @Override
    public boolean parseSetGen2Data(byte[] byArray) {
        return (byArray = this.a(33, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getGen2SendData() {
        byte[] byArray = new byte[]{};
        return this.b(34, byArray);
    }

    @Override
    public byte[] parseGetGen2Data(byte[] byArray) {
        if ((byArray = this.a(35, byArray)) != null && byArray.length >= 4) {
            byte[] byArray2 = new byte[14];
            byArray = byArray2;
            byArray2[0] = (byte)((this.a[0] & 0xE0) >> 5);
            byArray[1] = (byte)((this.a[0] & 0x1C) >> 2);
            byArray[2] = (byte)((this.a[0] & 2) >> 1);
            byArray[3] = (byte)(this.a[0] & 1);
            byArray[4] = (byte)((this.a[1] & 0xF0) >> 4);
            byArray[5] = (byte)(this.a[1] & 0xF);
            byArray[6] = (byte)((this.a[2] & 0xF0) >> 4);
            byArray[7] = (byte)((this.a[2] & 8) >> 3);
            byArray[8] = (byte)((this.a[2] & 6) >> 1);
            byArray[9] = (byte)(this.a[2] & 1);
            byArray[10] = (byte)((this.a[3] & 0xC0) >> 6);
            byArray[11] = (byte)((this.a[3] & 0x30) >> 4);
            byArray[12] = (byte)((this.a[3] & 8) >> 3);
            byArray[13] = (byte)(this.a[3] & 7);
            return byArray;
        }
        return null;
    }

    @Override
    public byte[] setRFLinkSendData(int n) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray2[1] = 1;
        byArray2[2] = (byte)n;
        return this.b(82, byArray2);
    }

    @Override
    public boolean parseSetRFLinkData(byte[] byArray) {
        return (byArray = this.a(83, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getRFLinkSendData() {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray2[1] = 0;
        return this.b(84, byArray2);
    }

    @Override
    public int parseGetRFLinkData(byte[] byArray) {
        if ((byArray = this.a(85, byArray)) != null && byArray.length >= 3 && byArray[0] == 1) {
            return byArray[2] & 0xFF;
        }
        return -1;
    }

    @Override
    public byte[] setFastIdSendData(int n) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)n;
        byArray2[1] = 0;
        return this.b(92, byArray2);
    }

    @Override
    public boolean parseFastIdData(byte[] byArray) {
        return (byArray = this.a(93, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getFastIDSendData() {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        byArray2[1] = 0;
        return this.b(94, byArray2);
    }

    @Override
    public boolean parseGetFastIdData(byte[] byArray) {
        if ((byArray = this.a(93, byArray)) != null && byArray.length >= 2 && byArray[0] == 1) {
            return byArray[1] == 1;
        }
        return false;
    }

    @Override
    public byte[] openLedSendData() {
        byte[] byArray = new byte[5];
        byte[] byArray2 = byArray;
        byArray[0] = 7;
        byArray2[1] = 1;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 0;
        return this.b(228, byArray2);
    }

    @Override
    public byte[] closeLedSendData() {
        byte[] byArray = new byte[5];
        byte[] byArray2 = byArray;
        byArray[0] = 7;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 0;
        return this.b(228, byArray2);
    }

    @Override
    public byte[] blinkOfLedSendData(int n, int n2, int n3) {
        byte[] byArray = new byte[5];
        byte[] byArray2 = byArray;
        byArray[0] = 7;
        byArray2[1] = 2;
        byArray2[2] = (byte)n;
        byArray2[3] = (byte)n2;
        byArray2[4] = (byte)n3;
        return this.b(228, byArray2);
    }

    @Override
    public boolean parseOpenLedData(byte[] byArray) {
        return (byArray = this.a(229, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public boolean parseCloseLedData(byte[] byArray) {
        return (byArray = this.a(229, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public boolean parseBlinkOfLedData(byte[] byArray) {
        return (byArray = this.a(229, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] blockWriteDataSendData(String object, char c2, int n, int n2, String object2, char c3, int n3, char c4, String object3) {
        int n4;
        int n5;
        byte[] byArray = StringUtility.hexString2Bytes((String)object);
        object = byArray;
        if (byArray == null || ((Object)object).length != 4) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        if (c3 < '\u0000' || n3 < 0 || c4 < '\u0000') {
            throw new IllegalArgumentException("bank or ptr or cnt error !");
        }
        if (((Object)(object3 = (Object)StringUtility.hexString2Bytes((String)object3))).length < (n5 = c4 / 8 + (c4 % 8 == 0 ? 0 : 1))) {
            throw new IllegalArgumentException("writeData cnt error!");
        }
        if (n2 == 0) {
            c2 = '\u0001';
            n = 0;
            object2 = new byte[1];
        } else {
            if (c2 < '\u0000' || n < 0 || n2 < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            byte[] byArray2 = StringUtility.hexString2Bytes((String)object2);
            object2 = byArray2;
            if (byArray2 == null || ((Object)object2).length == 0) {
                throw new IllegalArgumentException("filterCnt error !");
            }
            n5 = n2 / 8 + (n2 % 8 == 0 ? 0 : 1);
            if (((Object)object2).length < n5) {
                throw new IllegalArgumentException("filterCnt error 2!");
            }
        }
        n5 = 0;
        byte[] byArray3 = new byte[1024];
        byte[] byArray4 = byArray3;
        ++n5;
        byArray3[0] = (byte)object[0];
        ++n5;
        byArray4[1] = (byte)object[1];
        ++n5;
        byArray4[2] = (byte)object[2];
        ++n5;
        byArray4[3] = (byte)object[3];
        ++n5;
        byArray4[4] = (byte)c2;
        ++n5;
        byArray4[5] = (byte)(n / 256);
        ++n5;
        byArray4[6] = (byte)(n % 256);
        ++n5;
        byArray4[7] = (byte)(n2 / 256);
        ++n5;
        byArray4[8] = (byte)(n2 % 256);
        for (n4 = 0; n4 < n2 / 8; ++n4) {
            byArray4[n5++] = (byte)object2[n4];
        }
        if (n2 % 8 > 0) {
            byArray4[n5++] = (byte)object2[n4];
        }
        byArray4[n5++] = (byte)c3;
        byArray4[n5++] = (byte)(n3 / 256);
        byArray4[n5++] = (byte)(n3 % 256);
        byArray4[n5++] = (byte)(c4 / 256);
        byArray4[n5++] = (byte)(c4 % 256);
        for (n4 = 0; n4 < c4 << 1; ++n4) {
            byArray4[n5++] = (byte)object3[n4];
        }
        byArray4 = Arrays.copyOf(byArray4, n5);
        return this.b(147, byArray4);
    }

    @Override
    public boolean parseBlockWriteData(byte[] byArray) {
        return (byArray = this.a(148, byArray)) != null && byArray.length > 1 && byArray[0] == 1 && byArray[1] == 0;
    }

    @Override
    public byte[] blockEraseDataSendData(String object, char c2, int n, int n2, String string, char c3, int n3, char c4) {
        byte[] byArray = StringUtility.hexString2Bytes((String)object);
        if (!StringUtility.isHexNumberRex((String)object) || ((String)object).length() % 2 != 0) {
            throw new IllegalArgumentException("accessPwd not hex!");
        }
        if (((String)object).length() != 8) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        char c5 = c2;
        int n4 = n2;
        int n5 = n;
        object = string;
        if (n4 != 0) {
            if (c5 < '\u0000' || n5 < 0 || n4 < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            if (!StringUtility.isHexNumberRex((String)object) || ((String)object).length() % 2 != 0) {
                throw new IllegalArgumentException("filterData not hex!");
            }
            n5 = n4 / 8 + (n4 % 8 == 0 ? 0 : 1);
            if (((String)object).length() / 2 < n5) {
                throw new IllegalArgumentException("filterCnt error 2!");
            }
        }
        if (c3 < '\u0000' || n3 < 0 || c4 < '\u0000') {
            throw new IllegalArgumentException("bank or ptr or cnt error !");
        }
        if (n2 == 0) {
            c2 = '\u0001';
            n = 0;
            object = new byte[1];
        } else {
            int n6;
            object = StringUtility.hexString2Bytes(string);
            if (((Object)object).length < (n6 = n2 / 8 + (n2 % 8 == 0 ? 0 : 1))) {
                throw new IllegalArgumentException("filterCnt error 2!");
            }
        }
        int n7 = 0;
        byte[] byArray2 = new byte[1024];
        byte[] byArray3 = byArray2;
        ++n7;
        byArray2[0] = byArray[0];
        ++n7;
        byArray3[1] = byArray[1];
        ++n7;
        byArray3[2] = byArray[2];
        ++n7;
        byArray3[3] = byArray[3];
        ++n7;
        byArray3[4] = (byte)c2;
        ++n7;
        byArray3[5] = (byte)(n / 256);
        ++n7;
        byArray3[6] = (byte)(n % 256);
        ++n7;
        byArray3[7] = (byte)(n2 / 256);
        ++n7;
        byArray3[8] = (byte)(n2 % 256);
        for (c2 = '\u0000'; c2 < n2 / 8; c2 = (char)(c2 + 1)) {
            byArray3[n7++] = (byte)object[c2];
        }
        if (n2 % 8 > 0) {
            byArray3[n7++] = (byte)object[c2];
        }
        byArray3[n7++] = (byte)c3;
        byArray3[n7++] = (byte)(n3 / 256);
        byArray3[n7++] = (byte)(n3 % 256);
        byArray3[n7++] = (byte)(c4 / 256);
        byArray3[n7++] = (byte)(c4 % 256);
        byArray3 = Arrays.copyOf(byArray3, n7);
        return this.b(149, byArray3);
    }

    @Override
    public boolean parseBlockEraseDataData(byte[] byArray) {
        return (byArray = this.a(150, byArray)) != null && byArray.length > 1 && byArray[0] == 1 && byArray[1] == 0;
    }

    @Override
    public byte[] GBTagLockSendData(String string, char c2, int n, int n2, String string2, char c3, char c4, char c5) {
        return null;
    }

    @Override
    public boolean parseGBTagLockData(byte[] byArray) {
        return false;
    }

    @Override
    public byte[] setCWSendData(char c2) {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)c2;
        return this.b(36, byArray2);
    }

    @Override
    public boolean parseSetCWData(byte[] byArray) {
        return (byArray = this.a(37, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getCWSendData() {
        byte[] byArray = new byte[]{};
        return this.b(38, byArray);
    }

    @Override
    public int parseGetCWData(byte[] byArray) {
        if ((byArray = this.a(39, byArray)) != null && byArray.length > 0 && byArray[0] == 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public byte[] setJumpFrequencySendData(int n) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = 1;
        byArray2[1] = (byte)(n >> 16);
        byArray2[2] = (byte)(n >> 8);
        byArray2[3] = (byte)n;
        return this.b(20, byArray2);
    }

    @Override
    public boolean parseSetJumpFrequencyData(byte[] byArray) {
        return (byArray = this.a(21, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] btDeleteAllTagToFlashSendData() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = -1;
        return this.b(233, byArray2);
    }

    @Override
    public boolean parseBtDeleteAllTagToFlashData(byte[] byArray) {
        return (byArray = this.a(234, byArray)) != null && byArray.length >= 2 && byArray[0] == 0 && byArray[1] == 0;
    }

    @Override
    public byte[] btGetAllTagNumFromFlashSendData() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = 0;
        return this.b(233, byArray2);
    }

    @Override
    public byte[] btGetNewTagNumFromFlashSendData() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = 1;
        return this.b(233, byArray2);
    }

    @Override
    public int parseBtGetAllTagNumFromFlashData(byte[] byArray) {
        byArray = this.a(234, byArray);
        int n = -1;
        if (byArray != null && byArray.length >= 2) {
            n = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        }
        return n;
    }

    @Override
    public int parseBtGetNewTagNumFromFlashData(byte[] byArray) {
        byArray = this.a(234, byArray);
        int n = -1;
        if (byArray != null && byArray.length >= 2) {
            n = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        }
        return n;
    }

    @Override
    public byte[] btGetTagDataFromFlashSendData() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = -1;
        return this.b(235, byArray2);
    }

    @Override
    public byte[] parseBtGetTagDataFromFlashData(byte[] byArray) {
        if ((byArray = this.a(236, byArray)) != null && byArray.length >= 2) {
            return byArray;
        }
        return null;
    }

    @Override
    public byte[] setR6WorkmodeSendData(char c2) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 4;
        byArray2[1] = (byte)c2;
        return this.b(229, byArray2);
    }

    @Override
    public boolean parseSetR6WorkModeData(byte[] byArray) {
        return (byArray = this.a(230, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] uhfJump2BootSendData(char c2) {
        byte[] byArray = new byte[]{c2 == '\u0001' ? (byte)-52 : -18};
        return this.b(192, byArray);
    }

    @Override
    public boolean parseUHFJump2BootData(byte[] byArray) {
        return (byArray = this.a(193, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] uhfStartUpdateSendData() {
        byte[] byArray = new byte[]{};
        return this.b(194, byArray);
    }

    @Override
    public boolean parseUHFStartUpdateData(byte[] byArray) {
        return (byArray = this.a(195, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] uhfUpdatingSendData(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[64];
        for (int i2 = 0; i2 < 64; ++i2) {
            if (byArray.length <= i2) continue;
            byArray2[i2] = byArray[i2];
        }
        return this.b(196, byArray2);
    }

    @Override
    public boolean parseUHFUpdatingData(byte[] byArray) {
        return (byArray = this.a(197, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] UHFStopUpdateSendData() {
        byte[] byArray = new byte[]{};
        return this.b(198, byArray);
    }

    @Override
    public boolean parseUHFStopUpdateData(byte[] byArray) {
        return (byArray = this.a(199, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] setReaderAwaitSleepTimeSendData(char c2) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 5;
        byArray2[1] = (byte)c2;
        return this.b(228, byArray2);
    }

    @Override
    public boolean parseSetReaderAwaitSleepTimeData(byte[] byArray) {
        return (byArray = this.a(229, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getReaderAwaitSleepTimeSendData() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = 6;
        return this.b(228, byArray2);
    }

    @Override
    public int parseGetReaderAwaitSleepTimeData(byte[] byArray) {
        if ((byArray = this.a(229, byArray)) != null && byArray.length >= 2 && byArray[0] == 6) {
            return byArray[1] & 0xFF;
        }
        return -1;
    }

    @Override
    public byte[] setTagfocusSendData(char c2) {
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)c2;
        byArray2[1] = 0;
        return this.b(96, byArray2);
    }

    @Override
    public boolean parseSetTagfocusData(byte[] byArray) {
        return (byArray = this.a(97, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    @Override
    public byte[] getTagfocusSendData() {
        byte[] byArray = new byte[2];
        return this.b(98, byArray);
    }

    @Override
    public int parseGetTagfocusData(byte[] byArray) {
        if ((byArray = this.a(99, byArray)) != null && byArray.length >= 2 && byArray[0] == 0) {
            if (byArray[1] == 1) {
                return 1;
            }
            if (byArray[1] == 0) {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public synchronized byte[] parseTagBuff(byte[] byArray) {
        return this.a(131, byArray);
    }

    @Override
    public byte[] setPowerAllSendData(List<AntennaPowerEntity> object) {
        if (object == null) {
            return null;
        }
        byte[] byArray = new byte[512];
        byte[] byArray2 = byArray;
        byArray[0] = 2;
        int n = 1;
        object = object.iterator();
        while (object.hasNext()) {
            AntennaPowerEntity antennaPowerEntity = (AntennaPowerEntity)object.next();
            int n2 = antennaPowerEntity.getPower() * 100;
            int n3 = antennaPowerEntity.getAntennaNameEnum().getValue();
            byArray2[n++] = (byte)n3;
            byArray2[n++] = (byte)(n2 >> 8);
            byArray2[n++] = (byte)n2;
            byArray2[n++] = (byte)(n2 >> 8);
            byArray2[n++] = (byte)n2;
        }
        object = Arrays.copyOf(byArray2, n);
        return this.b(16, (byte[])object);
    }

    @Override
    public boolean parseSetPowerAllDataData(byte[] byArray) {
        return (byArray = this.a(17, byArray)) != null && byArray.length > 0 && byArray[0] == 1;
    }

    protected final synchronized byte[] a(int n, byte[] byArray) {
        return this.a(n, -1, byArray);
    }

    protected final synchronized byte[] a(int n, int n2, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        LogUtility.isDebug();
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray2 = this.a(n, n2, byArray, stringBuilder);
        if (byArray2 != null) {
            LogUtility.isDebug();
        }
        return byArray2;
    }

    private synchronized byte[] a(int n, int n2, byte[] byArray, StringBuilder stringBuilder) {
        if (byArray == null || byArray.length == 0) {
            stringBuilder.append("\u8f93\u5165inDataBuf=null\n");
            return null;
        }
        Arrays.fill(this.a, (byte)0);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n8 = byArray[i2] & 0xFF;
            switch (n3) {
                case 0: {
                    n3 = n8 == 165 ? 1 : 0;
                    n6 = 0;
                    n5 = 0;
                    n4 = 0;
                    bl = false;
                    break;
                }
                case 1: {
                    if (n8 == 90) {
                        n3 = 2;
                        break;
                    }
                    n3 = 0;
                    break;
                }
                case 2: {
                    n6 ^= n8;
                    n4 = n8 << 8;
                    n3 = 3;
                    break;
                }
                case 3: {
                    n6 ^= n8;
                    if ((n4 += n8) < 8 || n4 > 2048) {
                        n3 = 0;
                        break;
                    }
                    n4 -= 8;
                    n3 = 4;
                    break;
                }
                case 4: {
                    n6 ^= n8;
                    n7 = n8;
                    if (n4 > 0) {
                        n3 = 5;
                        break;
                    }
                    n3 = 6;
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        n3 = 0;
                        break;
                    }
                    if (n5 >= n4) break;
                    n6 ^= n8;
                    this.a[n5++] = (byte)n8;
                    if (n5 < n4) break;
                    n3 = 6;
                    break;
                }
                case 6: {
                    if (n6 == n8) {
                        n3 = 7;
                        break;
                    }
                    n3 = 0;
                    break;
                }
                case 7: {
                    if (n8 == 13) {
                        n3 = 8;
                        break;
                    }
                    n3 = 0;
                    break;
                }
                case 8: {
                    n3 = 0;
                    if (n8 != 10) break;
                    bl = true;
                    break;
                }
                default: {
                    n6 = 0;
                    n5 = 0;
                    n4 = 0;
                    bl = false;
                }
            }
            if (!bl) continue;
            if (n7 == n) {
                if (n2 == -1 || (this.a[0] & 0xFF) == n2) break;
                bl = false;
                continue;
            }
            bl = false;
        }
        if (bl) {
            if (n7 != n) {
                return null;
            }
            return Arrays.copyOf(this.a, n4);
        }
        return null;
    }

    protected final byte[] b(int n, byte[] byArray) {
        int n2;
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length + 8];
        int n3 = 0;
        int n4 = 0;
        ++n3;
        byArray2[0] = -91;
        ++n3;
        byArray2[1] = 90;
        ++n3;
        byArray2[2] = (byte)((8 + byArray.length) / 256);
        ++n3;
        byArray2[3] = (byte)((8 + byArray.length) % 256);
        ++n3;
        byArray2[4] = (byte)n;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray2[n3++] = byArray[n2];
        }
        for (n2 = 2; n2 < n3; ++n2) {
            n4 ^= byArray2[n2];
        }
        byArray2[n3++] = (byte)n4;
        byArray2[n3++] = 13;
        byArray2[n3] = 10;
        if (LogUtility.isDebug()) {
            new StringBuilder().append(Integer.toHexString(n)).append("==>makeSendData\u7684\u6570\u636e:").append(StringUtility.bytes2HexString(byArray2, byArray2.length));
        }
        return byArray2;
    }
}

