/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.ConnectionState;
import com.rscja.deviceapi.RFIDWithUHFBase;
import com.rscja.deviceapi.RFIDWithUHFNetworkR3$1;
import com.rscja.deviceapi.RFIDWithUHFNetworkR3$2;
import com.rscja.deviceapi.RFIDWithUHFNetworkR3$InventoryThread;
import com.rscja.deviceapi.SocketManageR3;
import com.rscja.deviceapi.a.a;
import com.rscja.deviceapi.c;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.ConnectionStateCallback;
import com.rscja.deviceapi.interfaces.IObserver;
import com.rscja.deviceapi.interfaces.ISingleAntenna;
import com.rscja.deviceapi.interfaces.IUHF;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.deviceapi.m;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.List;

public class RFIDWithUHFNetworkR3
extends RFIDWithUHFBase
implements IObserver,
ISingleAntenna,
IUHF {
    private String TAG = "RFIDWithUHFNetworkR3";
    protected SocketManageR3 socketManage = new SocketManageR3();
    protected boolean isRuning = false;
    protected m uhfProtocolParse = new m();
    protected List<UHFTAGInfo> uhfinfoList = null;
    private IUHFInventoryCallback inventoryCallback = null;
    private RFIDWithUHFNetworkR3$InventoryThread inventoryThread = null;
    private int isFilterRepeatBank = 0;
    private ConnectionStateCallback btStatusCallback = null;
    private ConnectionState connectionStatus = ConnectionState.DISCONNECTED;
    List<UHFTAGInfo> tempTagList = null;

    public synchronized boolean init(String string, int n) {
        this.socketManage.setObserver(this);
        boolean bl = this.socketManage.connect(string, n, true);
        System.out.println("init end host=" + string + ", port=" + n + ">>result=" + bl);
        if (bl) {
            this.connectionStatus = ConnectionState.CONNECTED;
            this.setPowerOn(true);
            return true;
        }
        this.connectionStatus = ConnectionState.DISCONNECTED;
        return false;
    }

    @Override
    public boolean init(String string) {
        return false;
    }

    @Override
    public boolean free() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "free \u65ad\u5f00\u8fde\u63a5");
        }
        this.isRuning = false;
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        this.socketManage.close();
        this.setPowerOn(false);
        this.stopInventoryThread();
        this.socketManage.cleanTagCmd();
        this.isFilterRepeatBank = 0;
        return true;
    }

    @Override
    public void setConnectionStateCallback(ConnectionStateCallback connectionStateCallback) {
        this.btStatusCallback = connectionStateCallback;
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setInventoryCallback inventoryCallback=" + iUHFInventoryCallback);
        }
        this.inventoryCallback = iUHFInventoryCallback;
    }

    @Override
    public ConnectionState getConnectStatus() {
        return this.connectionStatus;
    }

    @Override
    public String getVersion() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "getVersion");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getVersionSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseVersionData(object.d);
        System.out.println("getVersion() vesionString:" + (String)object);
        return object;
    }

    @Override
    public int getPower() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "getPower");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getPowerSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetPowerData(object.d);
        System.out.println("getPower() err :" + n);
        return n;
    }

    @Override
    public boolean setPower(int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setPower");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (n > 30) {
            n = 30;
        } else if (n <= 0) {
            n = 1;
        }
        Object object = this.uhfProtocolParse.setPowerSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetPowerData(object.d);
        System.out.println("setPower() err :" + bl);
        return bl;
    }

    @Override
    public int getFrequencyMode() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "getFrequencyMode");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getFrequencyModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        byte by = this.uhfProtocolParse.parseGetFrequencyModeData(object.d);
        System.out.println("getFrequencyMode() err :" + by);
        return by;
    }

    @Override
    public synchronized boolean setFrequencyMode(byte by) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setFrequencyMode");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFrequencyModeSendData(by);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetFrequencyModeData(object.d);
        System.out.println("setFrequencyMode() err :" + bl);
        return bl;
    }

    @Override
    public synchronized boolean startInventoryTag() {
        return this.startInventoryTag(0, 0, 6);
    }

    private synchronized boolean startInventoryTag(int n, int n2, int n3) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "20220323\u5f00\u59cb\u76d8\u70b9 startInventory() begin");
        }
        if (this.isRuning) {
            if (this.socketManage.getLogger() != null) {
                this.socketManage.getLogger().a(this.TAG, "\u4e0d\u80fd\u91cd\u590d\u5f00\u59cb\u76d8\u70b9!");
            }
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (this.uhfinfoList != null) {
            this.uhfinfoList.clear();
        }
        this.socketManage.cleanTagCmd();
        byte[] byArray = this.uhfProtocolParse.getStartInventoryTagSendData();
        boolean bl = this.socketManage.send(byArray);
        if (!bl) {
            if (this.socketManage.getLogger() != null) {
                this.socketManage.getLogger().a(this.TAG, "\u5f00\u59cb\u76d8\u70b9 \u5931\u8d25!");
            }
            return false;
        }
        this.isRuning = true;
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "\u5f00\u59cb\u76d8\u70b9 startInventory() result :  inventoryCallback=" + this.inventoryCallback + "  inventoryThread=" + this.inventoryThread);
        }
        this.startInventoryThread();
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "\u5f00\u59cb\u76d8\u70b9 startInventory() end");
        }
        return true;
    }

    @Override
    public synchronized UHFTAGInfo readTagFromBuffer() {
        if (this.tempTagList == null || this.tempTagList.size() == 0) {
            this.tempTagList = this.readTagFromBufferList();
        }
        if (this.tempTagList != null && this.tempTagList.size() > 0) {
            int n = this.tempTagList.size() - 1;
            UHFTAGInfo uHFTAGInfo = this.tempTagList.get(n);
            this.tempTagList.remove(n);
            return uHFTAGInfo;
        }
        return null;
    }

    private List<UHFTAGInfo> readTagFromBufferList() {
        List<com.rscja.deviceapi.b.c> list = this.socketManage.a(this.uhfProtocolParse.getReadTagSendData(), 50);
        if (list == null) {
            return null;
        }
        ArrayList arrayList = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object = list.get(i2);
            if (((com.rscja.deviceapi.b.c)object).c == null || ((com.rscja.deviceapi.b.c)object).c.length <= 2 || (object = this.uhfProtocolParse.d(((com.rscja.deviceapi.b.c)object).c)) == null || object.size() <= 0) continue;
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            ArrayList arrayList2 = arrayList;
            arrayList2.addAll(arrayList2.size(), object);
        }
        return arrayList;
    }

    @Override
    public synchronized boolean stopInventory() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "\u505c\u6b62\u76d8\u70b9stopInventory() inventoryThread=" + this.inventoryThread);
        }
        byte[] byArray = this.uhfProtocolParse.getStopInventorySendData();
        this.socketManage.send(byArray);
        this.isRuning = false;
        this.stopInventoryThread();
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "\u505c\u6b62\u76d8\u70b9stopInventory() end");
        }
        return true;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> arrayList, int n) {
        if (arrayList == null || arrayList.size() == 0 || n < 0) {
            return null;
        }
        switch (n) {
            case 16: 
            case 32: 
            case 48: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException("lockMode error");
            }
        }
        return super.generateLockCode(arrayList, n);
    }

    @Override
    public boolean lockMem(String object, int n, int n2, int n3, String string, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "lockMem");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getLockSendData((String)object, n, n2, n3, string, string2);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseLockData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("lockMem() err :" + bl);
        return bl;
    }

    @Override
    public synchronized boolean lockMem(String string, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "lockMem");
        }
        StringUtility.hexString2Chars(string);
        StringUtility.hexString2Chars(string2);
        boolean bl = this.lockMem(string, 1, 0, 0, "", string2);
        if (bl) {
            return true;
        }
        System.out.println("lockMem() err :" + bl);
        return false;
    }

    @Override
    public synchronized UHFTAGInfo inventorySingleTag() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "inventorySingleTag");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getInventorySingleTagSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        UHFTAGInfo uHFTAGInfo = this.uhfProtocolParse.a(object.d, true);
        object = uHFTAGInfo;
        return uHFTAGInfo;
    }

    @Override
    public String readData(String string, int n, int n2, int n3) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "readData");
        }
        if (StringUtility.isEmpty(string) || !StringUtility.isHexNumberRex(string)) {
            return null;
        }
        return this.readData(string, 1, 0, 0, "00", n, n2, n3);
    }

    @Override
    public String readData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "readData");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        object = this.uhfProtocolParse.getReadSendData((String)object, n, n2, n3, string, n4, n5, n6);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseReadData(((com.rscja.deviceapi.b.c)object).d);
        return object;
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "writeData");
        }
        if (StringUtility.isEmpty(string) || StringUtility.isEmpty(string2)) {
            return false;
        }
        String string3 = "00";
        boolean bl = this.writeData(string, 1, 32, 0, string3, n, n2, n3, string2);
        return bl;
    }

    @Override
    public boolean writeData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "writeData");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getWriteSendData((String)object, n, n2, n3, string, n4, n5, n6, string2);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseWriteData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String string2) {
        return this.blockWriteData(string, 1, 0, 0, "00", n, n2, n3, string2);
    }

    @Override
    public boolean blockWriteData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "blockWriteData");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.blockWriteDataSendData((String)object, (char)n, n2, n3, string, (char)n4, n5, (char)n6, string2);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBlockWriteData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean eraseData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "eraseData");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.blockEraseDataSendData((String)object, (char)n, n2, n3, string, (char)n4, n5, (char)n6);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBlockEraseDataData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3) {
        return this.eraseData(string, 1, 0, 0, "00", n, n2, n3);
    }

    @Override
    public boolean setFilter(int n, int n2, int n3, String string) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setFilter");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFilterSendData((char)n, n2, n3, string);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetFilterData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean killTag(String string) {
        return this.killTag(string, 0, 0, 0, "00");
    }

    @Override
    public boolean killTag(String object, int n, int n2, int n3, String string) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "killTag");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getKillSendData((String)object, n, n2, n3, string);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseKillData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public synchronized boolean setProtocol(int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setProtocol");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setProtocolSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetProtocolData(object.d);
        return bl;
    }

    @Override
    public synchronized int getProtocol() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "getProtocol");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getProtocolSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetProtocolData(object.d);
        return n;
    }

    @Override
    public synchronized boolean setFreHop(float f2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setFreHop");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        int n = (int)(f2 * 1000.0f);
        Object object = this.uhfProtocolParse.setJumpFrequencySendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetJumpFrequencyData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean setRFLink(int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setRFLink");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setRFLinkSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetRFLinkData(object.d);
        return bl;
    }

    @Override
    public synchronized int getRFLink() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "getRFLink");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getRFLinkSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetRFLinkData(object.d);
        return n;
    }

    @Override
    public synchronized boolean setFastID(boolean bl) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setFastID");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean setTagFocus(boolean bl) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setTagFocus");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean setEPCMode() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setEPCMode");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCModeData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean setEPCAndTIDMode() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setEPCAndTIDMode");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCAndTIDModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCAndTIDModeData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean setEPCAndTIDUserMode(int n, int n2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setEPCAndTIDUserMode");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCAndTIDUserModeSendData(n, n2);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCAndTIDUserModeData(object.d);
        return bl;
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        return null;
    }

    @Override
    public synchronized int getTemperature() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "getTemperature");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getTemperatureSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseTemperatureData(object.d);
        return n;
    }

    @Override
    public boolean uhfBlockPermalock(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, int n7, byte[] byArray) {
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public boolean setGen2(Gen2Entity object) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.setGen2SendData((Gen2Entity)object);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetGen2Data(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public Gen2Entity getGen2() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "getGen2");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getGen2SendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseGetGen2Data(object.d);
        if (object == null) {
            return null;
        }
        Gen2Entity gen2Entity = new Gen2Entity();
        gen2Entity.setSelectTarget(object[0]);
        gen2Entity.setSelectAction(object[1]);
        gen2Entity.setSelectTruncate(object[2]);
        gen2Entity.setQ(object[3]);
        gen2Entity.setStartQ(object[4]);
        gen2Entity.setMinQ(object[5]);
        gen2Entity.setMaxQ(object[6]);
        gen2Entity.setQueryDR(object[7]);
        gen2Entity.setQueryM(object[8]);
        gen2Entity.setQueryTRext(object[9]);
        gen2Entity.setQuerySel(object[10]);
        gen2Entity.setQuerySession(object[11]);
        gen2Entity.setQueryTarget(object[12]);
        gen2Entity.setLinkFrequency(object[13]);
        return gen2Entity;
    }

    @Override
    public synchronized boolean setPwm(int n, int n2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "setPwm");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public synchronized int[] getPwm() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "getPwm");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        return null;
    }

    @Override
    public boolean setCW(int n) {
        Object object = this.uhfProtocolParse.setCWSendData((char)n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetCWData(object.d);
    }

    @Override
    public synchronized int getCW() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getCWSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        return this.uhfProtocolParse.parseGetCWData(object.d);
    }

    @Override
    public boolean uhfJump2Boot() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "uhfJump2Boot");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        this.socketManage.setAutoCheckConnectStatus(false);
        Object object = this.uhfProtocolParse.uhfJump2BootSendData('\u0001');
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.socketManage.setAutoCheckConnectStatus(true);
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFJump2BootData(object.d);
        if (!bl) {
            this.socketManage.setAutoCheckConnectStatus(true);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    @Override
    public boolean uhfJump2BootToSTM32() {
        return false;
    }

    @Override
    public boolean uhfStartUpdate() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "uhfStartUpdate");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.uhfStartUpdateSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.socketManage.setAutoCheckConnectStatus(true);
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFStartUpdateData(object.d);
        if (!bl) {
            this.socketManage.setAutoCheckConnectStatus(true);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    @Override
    public synchronized boolean uhfUpdating(byte[] object) {
        int n;
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "uhfUpdating");
        }
        byte[] byArray = new byte[64];
        if (((byte[])object).length < 64) {
            for (n = 0; n < ((byte[])object).length; ++n) {
                byArray[n] = object[n];
            }
        } else {
            for (n = 0; n < 64; ++n) {
                byArray[n] = object[n];
            }
        }
        if (!this.isPowerOn()) {
            return false;
        }
        byte[] byArray2 = this.uhfProtocolParse.uhfUpdatingSendData(byArray);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive(byArray2, -1, 5000);
        object = c2;
        if (c2 == null) {
            this.socketManage.setAutoCheckConnectStatus(true);
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFUpdatingData(object.d);
        if (!bl) {
            this.socketManage.setAutoCheckConnectStatus(true);
        }
        return bl;
    }

    @Override
    public synchronized boolean uhfStopUpdate() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "uhfStopUpdate");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.UHFStopUpdateSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.socketManage.setAutoCheckConnectStatus(true);
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFStopUpdateData(object.d);
        this.socketManage.setAutoCheckConnectStatus(true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    @Override
    public char[] getBeep() {
        if (!this.isPowerOn()) {
            return null;
        }
        return null;
    }

    @Override
    public boolean setBeep(int n) {
        Object object = this.uhfProtocolParse.getBeepSendData(n == 1);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBeepData(object.d);
        return bl;
    }

    public void setFilterRepeatData(int n) {
        block3: {
            block4: {
                block2: {
                    if (n < 0 || n > 3) {
                        throw new IllegalArgumentException("bank invalid!");
                    }
                    this.isFilterRepeatBank = n;
                    if (n != 0) break block2;
                    if (this.uhfinfoList == null) break block3;
                    break block4;
                }
                if (this.uhfinfoList == null) {
                    this.uhfinfoList = new ArrayList<UHFTAGInfo>();
                }
            }
            this.uhfinfoList.clear();
        }
    }

    private void startInventoryThread() {
        if (this.inventoryThread == null) {
            if (this.socketManage.getLogger() != null) {
                this.socketManage.getLogger().a(this.TAG, "\u5f00\u542f\u76d8\u70b9\u7ebf\u7a0b");
            }
            this.inventoryThread = new RFIDWithUHFNetworkR3$InventoryThread(this);
            this.inventoryThread.start();
        }
    }

    private void stopInventoryThread() {
        if (this.inventoryThread != null) {
            this.inventoryThread.stopThread();
            this.inventoryThread = null;
        }
    }

    @Override
    public void update(a a2, Object object) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(this.TAG, "RFIDWithUHFNetworkMT update status=" + object.toString());
        }
        if (Integer.parseInt(object.toString()) == c.STATUS_CONNECT) {
            this.setPowerOn(true);
            this.connectionStatus = ConnectionState.CONNECTED;
            if (this.btStatusCallback != null) {
                new RFIDWithUHFNetworkR3$1(this).start();
                return;
            }
        } else {
            this.setPowerOn(false);
            this.connectionStatus = ConnectionState.DISCONNECTED;
            if (this.btStatusCallback != null) {
                new RFIDWithUHFNetworkR3$2(this).start();
            }
        }
    }

    static /* synthetic */ String access$000(RFIDWithUHFNetworkR3 rFIDWithUHFNetworkR3) {
        return rFIDWithUHFNetworkR3.TAG;
    }

    static /* synthetic */ int access$100(RFIDWithUHFNetworkR3 rFIDWithUHFNetworkR3) {
        return rFIDWithUHFNetworkR3.isFilterRepeatBank;
    }

    static /* synthetic */ IUHFInventoryCallback access$200(RFIDWithUHFNetworkR3 rFIDWithUHFNetworkR3) {
        return rFIDWithUHFNetworkR3.inventoryCallback;
    }

    static /* synthetic */ ConnectionStateCallback access$300(RFIDWithUHFNetworkR3 rFIDWithUHFNetworkR3) {
        return rFIDWithUHFNetworkR3.btStatusCallback;
    }
}

