/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XMLException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DOMConverter {
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    private DOMConverter() {
    }

    public static Document convert(org.w3c.dom.Document document) {
        return DOMConverter.convert(document, new NodeFactory());
    }

    public static Document convert(org.w3c.dom.Document document, NodeFactory nodeFactory) {
        org.w3c.dom.Element element = document.getDocumentElement();
        Element element2 = nodeFactory.makeRootElement(element.getTagName(), element.getNamespaceURI());
        Document document2 = nodeFactory.startMakingDocument();
        document2.setRootElement(element2);
        Nodes nodes = DOMConverter.convert(element, nodeFactory);
        boolean bl = true;
        int n = 0;
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            Node node = nodes.get(i2);
            if (bl) {
                if (node instanceof Element) {
                    document2.setRootElement((Element)node);
                    bl = false;
                    continue;
                }
                document2.insertChild(node, n++);
                continue;
            }
            document2.appendChild(node);
        }
        org.w3c.dom.Node node = document.getFirstChild();
        int n2 = 0;
        while (node.getNodeType() != 1) {
            Nodes nodes2 = DOMConverter.convert(node, nodeFactory);
            for (int i3 = 0; i3 < nodes2.size(); ++i3) {
                document2.insertChild(nodes2.get(i3), n2++);
            }
            node = node.getNextSibling();
        }
        for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
            Nodes nodes3 = DOMConverter.convert(node, nodeFactory);
            for (int i4 = 0; i4 < nodes3.size(); ++i4) {
                document2.appendChild(nodes3.get(i4));
            }
        }
        return document2;
    }

    public static Nodes convert(DocumentFragment documentFragment) {
        return DOMConverter.convert(documentFragment, new NodeFactory());
    }

    public static Nodes convert(DocumentFragment documentFragment, NodeFactory nodeFactory) {
        Nodes nodes = new Nodes();
        NodeList nodeList = documentFragment.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Nodes nodes2 = DOMConverter.convert(nodeList.item(i2), nodeFactory);
            DOMConverter.appendNodes(nodes, nodes2);
        }
        return nodes;
    }

    private static void appendNodes(Nodes nodes, Nodes nodes2) {
        for (int i2 = 0; i2 < nodes2.size(); ++i2) {
            nodes.append(nodes2.get(i2));
        }
    }

    private static Nodes convert(org.w3c.dom.Node node, NodeFactory nodeFactory) {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                return DOMConverter.convert((org.w3c.dom.Element)node, nodeFactory);
            }
            case 8: {
                return DOMConverter.convert((org.w3c.dom.Comment)node, nodeFactory);
            }
            case 10: {
                return DOMConverter.convert((DocumentType)node, nodeFactory);
            }
            case 3: {
                return DOMConverter.convert((org.w3c.dom.Text)node, nodeFactory);
            }
            case 4: {
                return DOMConverter.convert((org.w3c.dom.Text)node, nodeFactory);
            }
            case 7: {
                return DOMConverter.convert((org.w3c.dom.ProcessingInstruction)node, nodeFactory);
            }
        }
        throw new XMLException("Unexpected DOM node type: " + s);
    }

    public static Comment convert(org.w3c.dom.Comment comment) {
        return new Comment(comment.getNodeValue());
    }

    private static Nodes convert(org.w3c.dom.Comment comment, NodeFactory nodeFactory) {
        return nodeFactory.makeComment(comment.getNodeValue());
    }

    public static Text convert(org.w3c.dom.Text text) {
        return new Text(text.getNodeValue());
    }

    private static Nodes convert(org.w3c.dom.Text text, NodeFactory nodeFactory) {
        return nodeFactory.makeText(text.getNodeValue());
    }

    public static Attribute convert(Attr attr) {
        String string = attr.getName();
        String string2 = attr.getNamespaceURI();
        if (string2 == null) {
            string2 = "";
        }
        return new Attribute(string, string2, attr.getNodeValue());
    }

    public static ProcessingInstruction convert(org.w3c.dom.ProcessingInstruction processingInstruction) {
        return new ProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getNodeValue());
    }

    private static Nodes convert(org.w3c.dom.ProcessingInstruction processingInstruction, NodeFactory nodeFactory) {
        return nodeFactory.makeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getNodeValue());
    }

    public static DocType convert(DocumentType documentType) {
        DocType docType = new DocType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        docType.setInternalDTDSubset(documentType.getInternalSubset());
        return docType;
    }

    private static Nodes convert(DocumentType documentType, NodeFactory nodeFactory) {
        Nodes nodes = nodeFactory.makeDocType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            Node node = nodes.get(i2);
            if (!(node instanceof DocType)) continue;
            ((DocType)node).setInternalDTDSubset(documentType.getInternalSubset());
            break;
        }
        return nodes;
    }

    public static Element convert(org.w3c.dom.Element element) {
        return (Element)DOMConverter.convert(element, new NodeFactory()).get(0);
    }

    /*
     * Unable to fully structure code
     */
    private static Nodes convert(org.w3c.dom.Element var0, NodeFactory var1_1) {
        var2_2 = var0;
        var3_3 = DOMConverter.makeElement(var0, var1_1);
        if (var3_3 == null) {
            var4_4 = new Nodes();
            var5_6 = var0.getChildNodes();
            for (var6_8 = 0; var6_8 < var5_6.getLength(); ++var6_8) {
                var7_10 = DOMConverter.convert(var5_6.item(var6_8), var1_1);
                for (var8_12 = 0; var8_12 < var7_10.size(); ++var8_12) {
                    var4_4.append(var7_10.get(var8_12));
                }
            }
            return var4_4;
        }
        var4_5 = var3_3;
        var5_7 = false;
        block2: while (true) {
            if (var2_2.hasChildNodes() && !var5_7) {
                var2_2 = var2_2.getFirstChild();
                var5_7 = false;
            } else {
                if (var2_2 == var0) break;
                if (var2_2.getNextSibling() != null) {
                    var2_2 = var2_2.getNextSibling();
                    var5_7 = false;
                } else {
                    var2_2 = var2_2.getParentNode();
                    var5_7 = true;
                    if (var4_5.getParent() == null) continue;
                    var4_5 = var4_5.getParent();
                    continue;
                }
            }
            var6_9 = var2_2.getNodeType();
            if (var6_9 == 1) {
                var7_11 = DOMConverter.makeElement((org.w3c.dom.Element)var2_2, var1_1);
                if (var7_11 == null) continue;
                var4_5.appendChild((Node)var7_11);
                if (!var2_2.hasChildNodes()) continue;
                var4_5 = var7_11;
                continue;
            }
            var7_11 = DOMConverter.convert(var2_2, var1_1);
            var8_13 = 0;
            while (true) {
                if (var8_13 < var7_11.size()) ** break;
                continue block2;
                var4_5.appendChild(var7_11.get(var8_13));
                ++var8_13;
            }
            break;
        }
        return var1_1.finishMakingElement(var3_3);
    }

    private static Element makeElement(org.w3c.dom.Element element, NodeFactory nodeFactory) {
        String string = element.getNamespaceURI();
        String string2 = element.getTagName();
        Element element2 = element.getParentNode() == null || element.getParentNode().getNodeType() == 9 ? nodeFactory.makeRootElement(string2, string) : nodeFactory.startMakingElement(string2, string);
        if (element2 == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Object object;
            Attr attr = (Attr)namedNodeMap.item(i2);
            String string3 = attr.getName();
            String string4 = attr.getNamespaceURI();
            String string5 = attr.getValue();
            if (string4 == null) {
                string4 = "";
            }
            if (string4.equals(XMLNS_NAMESPACE)) {
                String string6;
                if (string3.equals("xmlns") || string5.equals(string6 = element2.getNamespaceURI((String)(object = string3.substring(string3.indexOf(58) + 1))))) continue;
                element2.addNamespaceDeclaration((String)object, string5);
                continue;
            }
            object = nodeFactory.makeAttribute(string3, string4, string5, Attribute.Type.UNDECLARED);
            for (int i3 = 0; i3 < ((Nodes)object).size(); ++i3) {
                Node node = ((Nodes)object).get(i3);
                if (node instanceof Attribute) {
                    element2.addAttribute((Attribute)node);
                    continue;
                }
                element2.appendChild(node);
            }
        }
        return element2;
    }

    public static org.w3c.dom.Document convert(Document document, DOMImplementation dOMImplementation) {
        Element element = document.getRootElement();
        String string = element.getQualifiedName();
        String string2 = element.getNamespaceURI();
        DocType docType = document.getDocType();
        DocumentType documentType = null;
        if (docType != null) {
            documentType = dOMImplementation.createDocumentType(string, docType.getPublicID(), docType.getSystemID());
        }
        org.w3c.dom.Document document2 = dOMImplementation.createDocument(string2, string, documentType);
        org.w3c.dom.Element element2 = document2.getDocumentElement();
        boolean bl = true;
        for (int i2 = 0; i2 < document.getChildCount(); ++i2) {
            Node node = document.getChild(i2);
            if (node instanceof DocType) continue;
            if (node instanceof Element) {
                DOMConverter.convert((Element)node, document2);
                bl = false;
                continue;
            }
            org.w3c.dom.Node node2 = DOMConverter.convert(node, document2);
            if (bl) {
                document2.insertBefore(node2, element2);
                continue;
            }
            document2.appendChild(node2);
        }
        return document2;
    }

    private static org.w3c.dom.Node convert(Node node, org.w3c.dom.Document document) {
        if (node instanceof Text) {
            return DOMConverter.convert((Text)node, document);
        }
        if (node instanceof Comment) {
            return DOMConverter.convert((Comment)node, document);
        }
        if (node instanceof ProcessingInstruction) {
            return DOMConverter.convert((ProcessingInstruction)node, document);
        }
        throw new XMLException("Unexpected node type: " + node.getClass().getName());
    }

    private static org.w3c.dom.Comment convert(Comment comment, org.w3c.dom.Document document) {
        return document.createComment(comment.getValue());
    }

    private static org.w3c.dom.Text convert(Text text, org.w3c.dom.Document document) {
        return document.createTextNode(text.getValue());
    }

    private static org.w3c.dom.ProcessingInstruction convert(ProcessingInstruction processingInstruction, org.w3c.dom.Document document) {
        return document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getValue());
    }

    private static org.w3c.dom.Element convert(Element element, org.w3c.dom.Document document) {
        org.w3c.dom.Element element2 = DOMConverter.makeElement(element, document);
        org.w3c.dom.Node node = element2;
        Node node2 = element;
        int n = 0;
        int[] nArray = new int[10];
        int n2 = 0;
        nArray[0] = 0;
        boolean bl = false;
        while (true) {
            org.w3c.dom.Node node3;
            Object object;
            if (!bl && node2.getChildCount() > 0) {
                node2 = node2.getChild(0);
                n = 0;
                nArray = DOMConverter.grow(nArray, ++n2);
                nArray[n2] = 0;
            } else {
                bl = false;
                object = node2.getParent();
                node3 = node.getParentNode();
                if (node3.getNodeType() == 1 && node2 instanceof Element) {
                    node = node3;
                }
                if (((ParentNode)object).getChildCount() - 1 == n) {
                    ParentNode parentNode;
                    node2 = object;
                    --n2;
                    if (node2 == element || (parentNode = node2.getParent()) == null) break;
                    n = nArray[n2];
                    bl = true;
                    continue;
                }
                nArray[n2] = ++n;
                node2 = ((ParentNode)object).getChild(n);
            }
            if (node2 instanceof Element) {
                object = node2;
                node3 = DOMConverter.makeElement((Element)object, document);
                node.appendChild(node3);
                node = node3;
                continue;
            }
            object = DOMConverter.convert(node2, document);
            node.appendChild((org.w3c.dom.Node)object);
        }
        return element2;
    }

    private static int[] grow(int[] nArray, int n) {
        if (n < nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private static org.w3c.dom.Element makeElement(Element element, org.w3c.dom.Document document) {
        Object object;
        String string;
        int n;
        String string2 = element.getNamespaceURI();
        org.w3c.dom.Element element2 = element.getParent() instanceof Document ? document.getDocumentElement() : (string2.equals("") ? document.createElement(element.getQualifiedName()) : document.createElementNS(string2, element.getQualifiedName()));
        int n2 = element.getAttributeCount();
        for (n = 0; n < n2; ++n) {
            Attribute attribute = element.getAttribute(n);
            string = attribute.getNamespaceURI();
            if (string.equals("")) {
                object = document.createAttribute(attribute.getLocalName());
                element2.setAttributeNode((Attr)object);
            } else {
                object = document.createAttributeNS(string, attribute.getQualifiedName());
                element2.setAttributeNodeNS((Attr)object);
            }
            object.setValue(attribute.getValue());
        }
        n = element.getNamespaceDeclarationCount();
        for (int i2 = 0; i2 < n; ++i2) {
            Object object2;
            string = element.getNamespacePrefix(i2);
            object = element.getNamespaceURI(string);
            ParentNode parentNode = element.getParent();
            if (!(parentNode instanceof Element) ? ((String)object).equals("") : ((String)object).equals(((Element)(object2 = (Element)parentNode)).getNamespaceURI(string))) continue;
            if ("".equals(string)) {
                object2 = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns");
                element2.setAttributeNodeNS((Attr)object2);
                object2.setValue((String)object);
                continue;
            }
            object2 = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns:" + string);
            element2.setAttributeNodeNS((Attr)object2);
            object2.setValue((String)object);
        }
        return element2;
    }
}

