/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.canonical;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Namespace;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XPathContext;
import nu.xom.canonical.CanonicalizationException;
import org.xml.sax.helpers.NamespaceSupport;

public class Canonicalizer {
    private boolean withComments;
    private boolean exclusive = false;
    private CanonicalXMLSerializer serializer;
    private List inclusiveNamespacePrefixes = new ArrayList();
    private static Comparator comparator = new AttributeComparator();
    public static final String CANONICAL_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String CANONICAL_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCLUSIVE_XML_CANONICALIZATION = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";

    public Canonicalizer(OutputStream outputStream) {
        this(outputStream, true, false);
    }

    public Canonicalizer(OutputStream outputStream, boolean bl) {
        this(outputStream, bl, false);
    }

    private Canonicalizer(OutputStream outputStream, boolean bl, boolean bl2) {
        this.serializer = new CanonicalXMLSerializer(outputStream);
        this.serializer.setLineSeparator("\n");
        this.withComments = bl;
        this.exclusive = bl2;
    }

    public Canonicalizer(OutputStream outputStream, String string) {
        if (string == null) {
            throw new NullPointerException("Null algorithm");
        }
        this.serializer = new CanonicalXMLSerializer(outputStream);
        this.serializer.setLineSeparator("\n");
        if (string.equals(CANONICAL_XML)) {
            this.withComments = false;
            this.exclusive = false;
        } else if (string.equals(CANONICAL_XML_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = false;
        } else if (string.equals(EXCLUSIVE_XML_CANONICALIZATION)) {
            this.withComments = false;
            this.exclusive = true;
        } else if (string.equals(EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = true;
        } else {
            throw new CanonicalizationException("Unsupported canonicalization algorithm: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Node node) throws IOException {
        if (node instanceof Element) {
            Object object;
            Document document = node.getDocument();
            Element element = null;
            if (document == null) {
                element = new Element("pseudo");
                new Document(element);
                object = (ParentNode)node;
                while (((Node)object).getParent() != null) {
                    object = ((Node)object).getParent();
                }
                element.appendChild((Node)object);
            }
            try {
                object = node.query(".//. | .//@* | .//namespace::*");
                if (this.exclusive) {
                    String string;
                    Node node2;
                    int n;
                    HashSet<String> hashSet = new HashSet<String>(((Nodes)object).size());
                    for (n = 0; n < ((Nodes)object).size(); ++n) {
                        node2 = ((Nodes)object).get(n);
                        if (node2 instanceof Element) {
                            string = ((Element)node2).getNamespacePrefix();
                            hashSet.add(string);
                            continue;
                        }
                        if (!(node2 instanceof Attribute) || "".equals(string = ((Attribute)node2).getNamespacePrefix())) continue;
                        hashSet.add(string);
                    }
                    for (n = 0; n < ((Nodes)object).size(); ++n) {
                        node2 = ((Nodes)object).get(n);
                        if (!(node2 instanceof Namespace) || hashSet.contains(string = ((Namespace)node2).getPrefix())) continue;
                        ((Nodes)object).remove(n);
                        --n;
                    }
                }
                this.write((Nodes)object);
            }
            finally {
                if (element != null) {
                    element.removeChild(0);
                }
            }
        } else {
            this.serializer.nodes = null;
            this.serializer.write(node);
        }
        this.serializer.flush();
    }

    public final void write(Nodes nodes) throws IOException {
        if (nodes.size() > 0) {
            Document document = nodes.get(0).getDocument();
            if (document == null) {
                throw new CanonicalizationException("Canonicalization is not defined for detached nodes");
            }
            Nodes nodes2 = this.sort(nodes);
            this.serializer.nodes = nodes2;
            this.serializer.write(document);
            this.serializer.flush();
        }
    }

    public final void setInclusiveNamespacePrefixList(String string) throws IOException {
        this.inclusiveNamespacePrefixes.clear();
        if (this.exclusive && string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.inclusiveNamespacePrefixes.add(stringTokenizer.nextToken());
            }
        }
    }

    private Nodes sort(Nodes nodes) {
        Document document = nodes.get(0).getDocument();
        if (nodes.size() > 1) {
            Node node;
            Nodes nodes2 = new Nodes();
            ArrayList<Node> arrayList = new ArrayList<Node>(nodes.size());
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            for (int i2 = 0; i2 < nodes.size(); ++i2) {
                node = nodes.get(i2);
                arrayList.add(node);
                if (!(node instanceof Namespace)) continue;
                arrayList2.add(node);
            }
            Canonicalizer.sort(arrayList, arrayList2, nodes2, document);
            if (!arrayList.isEmpty()) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    node = (Node)iterator.next();
                    if (document == node.getDocument()) continue;
                    throw new CanonicalizationException("Cannot canonicalize subsets that contain nodes from more than one document");
                }
            }
            return nodes2;
        }
        return new Nodes(nodes.get(0));
    }

    private static void sort(List list, List list2, Nodes nodes, ParentNode parentNode) {
        if (list.isEmpty()) {
            return;
        }
        if (list.contains(parentNode)) {
            nodes.append(parentNode);
            list.remove(parentNode);
        }
        int n = parentNode.getChildCount();
        for (int i2 = 0; i2 < n; ++i2) {
            Node node = parentNode.getChild(i2);
            if (node instanceof Element) {
                Object object;
                Element element = (Element)node;
                if (list.contains(element)) {
                    nodes.append(element);
                    list.remove(element);
                }
                if (!list2.isEmpty()) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Namespace namespace;
                        object = iterator.next();
                        if (!(object instanceof Namespace) || element != (namespace = (Namespace)object).getParent()) continue;
                        nodes.append(namespace);
                        iterator.remove();
                    }
                }
                for (int i3 = 0; i3 < element.getAttributeCount(); ++i3) {
                    object = element.getAttribute(i3);
                    if (!list.contains(object)) continue;
                    nodes.append((Node)object);
                    list.remove(object);
                    if (!list.isEmpty()) continue;
                    return;
                }
                Canonicalizer.sort(list, list2, nodes, element);
                continue;
            }
            if (!list.contains(node)) continue;
            nodes.append(node);
            list.remove(node);
            if (!list.isEmpty()) continue;
            return;
        }
    }

    private class CanonicalXMLSerializer
    extends Serializer {
        private Nodes nodes;
        private NamespaceSupport inScope;
        private final XPathContext xmlcontext = new XPathContext("xml", "http://www.w3.org/XML/1998/namespace");

        CanonicalXMLSerializer(OutputStream outputStream) {
            super(outputStream);
            this.setLineSeparator("\n");
        }

        public final void write(Document document) throws IOException {
            Node node;
            this.inScope = new NamespaceSupport();
            int n = 0;
            do {
                node = document.getChild(n);
                if (this.nodes == null || node instanceof Element || this.nodes.contains(node)) {
                    this.writeChild(node);
                    if (node instanceof ProcessingInstruction) {
                        this.breakLine();
                    } else if (node instanceof Comment && Canonicalizer.this.withComments) {
                        this.breakLine();
                    }
                }
                ++n;
            } while (!(node instanceof Element));
            for (int i2 = n; i2 < document.getChildCount(); ++i2) {
                Node node2 = document.getChild(i2);
                if (this.nodes != null && !(node2 instanceof Element) && !this.nodes.contains(node2)) continue;
                if (node2 instanceof ProcessingInstruction) {
                    this.breakLine();
                } else if (node2 instanceof Comment && Canonicalizer.this.withComments) {
                    this.breakLine();
                }
                this.writeChild(node2);
            }
            this.flush();
        }

        protected final void write(Element element) throws IOException {
            if (element.getChildCount() == 0) {
                this.writeStartTag(element, false);
                this.writeEndTag(element);
            } else {
                Node node = element;
                boolean bl = false;
                int n = -1;
                int[] nArray = new int[10];
                int n2 = 0;
                nArray[0] = -1;
                while (true) {
                    if (!bl && ((Node)node).getChildCount() > 0) {
                        this.writeStartTag((Element)node, false);
                        node = ((Node)node).getChild(0);
                        n = 0;
                        nArray = this.grow(nArray, ++n2);
                        nArray[n2] = 0;
                        continue;
                    }
                    if (bl) {
                        this.writeEndTag((Element)node);
                        if (node == element) {
                            break;
                        }
                    } else {
                        this.writeChild(node);
                    }
                    bl = false;
                    ParentNode parentNode = node.getParent();
                    if (parentNode.getChildCount() - 1 == n) {
                        node = parentNode;
                        --n2;
                        if (node != element) {
                            n = nArray[n2];
                        }
                        bl = true;
                        continue;
                    }
                    nArray[n2] = ++n;
                    node = parentNode.getChild(n);
                }
            }
        }

        private int[] grow(int[] nArray, int n) {
            if (n < nArray.length) {
                return nArray;
            }
            int[] nArray2 = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }

        protected void writeStartTag(Element element, boolean bl) throws IOException {
            String string;
            Object object;
            Attribute[] attributeArray;
            boolean bl2;
            boolean bl3 = bl2 = this.nodes == null || this.nodes.contains(element);
            if (bl2) {
                this.inScope.pushContext();
                this.writeRaw("<");
                this.writeRaw(element.getQualifiedName());
            }
            TreeMap<Object, String> treeMap = new TreeMap<Object, String>();
            if (this.nodes == null) {
                attributeArray = element.getParent();
                Element element2 = null;
                if (attributeArray instanceof Element) {
                    element2 = (Element)attributeArray;
                }
                for (int i2 = 0; i2 < element.getNamespaceDeclarationCount(); ++i2) {
                    object = element.getNamespacePrefix(i2);
                    string = element.getNamespaceURI((String)object);
                    if (string.equals(this.inScope.getURI((String)object))) continue;
                    if (Canonicalizer.this.exclusive) {
                        if (!this.needToDeclareNamespace(element, (String)object, string)) continue;
                        treeMap.put(object, string);
                        continue;
                    }
                    if (string.equals("")) {
                        if (element2 == null || "".equals(element2.getNamespaceURI(""))) continue;
                        treeMap.put(object, string);
                        continue;
                    }
                    treeMap.put(object, string);
                }
                this.writeNamespaceDeclarations(treeMap);
            } else {
                Object object2;
                int n = this.indexOf(element);
                if (n != -1 && "".equals(element.getNamespaceURI())) {
                    ParentNode parentNode = element.getParent();
                    while (parentNode instanceof Element && !this.nodes.contains(parentNode)) {
                        parentNode = parentNode.getParent();
                    }
                    if (parentNode instanceof Element && !"".equals(object2 = ((Element)parentNode).getNamespaceURI(""))) {
                        treeMap.put("", "");
                    }
                }
                for (int i3 = n + 1; i3 < this.nodes.size() && (object2 = this.nodes.get(i3)) instanceof Namespace; ++i3) {
                    object = (Namespace)object2;
                    string = ((Namespace)object).getPrefix();
                    String string2 = ((Namespace)object).getValue();
                    if (string2.equals(this.inScope.getURI(string))) continue;
                    if (Canonicalizer.this.exclusive) {
                        if (!this.needToDeclareNamespace(element, string, string2)) continue;
                        treeMap.put(string, string2);
                        continue;
                    }
                    treeMap.put(string, string2);
                }
                this.writeNamespaceDeclarations(treeMap);
            }
            attributeArray = this.sortAttributes(element);
            for (int i4 = 0; i4 < attributeArray.length; ++i4) {
                if (this.nodes != null && !this.nodes.contains(attributeArray[i4]) && (!attributeArray[i4].getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") || attributeArray[i4].getParent() == element)) continue;
                this.write(attributeArray[i4]);
            }
            if (bl2) {
                this.writeRaw(">");
            }
        }

        private void writeNamespaceDeclarations(SortedMap sortedMap) throws IOException {
            Iterator iterator = sortedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                this.writeRaw(" ");
                this.writeNamespaceDeclaration(string, string2);
                this.inScope.declarePrefix(string, string2);
            }
        }

        private boolean needToDeclareNamespace(Element element, String string, String string2) {
            boolean bl = this.visiblyUtilized(element, string, string2);
            if (bl || Canonicalizer.this.inclusiveNamespacePrefixes.contains(string)) {
                return this.noOutputAncestorUsesPrefix(element, string, string2);
            }
            return false;
        }

        private boolean visiblyUtilized(Element element, String string, String string2) {
            boolean bl = false;
            String string3 = element.getNamespacePrefix();
            String string4 = element.getNamespaceURI();
            if (string.equals(string3) && string4.equals(string2)) {
                bl = true;
            } else {
                for (int i2 = 0; i2 < element.getAttributeCount(); ++i2) {
                    Attribute attribute = element.getAttribute(i2);
                    if (this.nodes != null && !this.nodes.contains(attribute) || !string.equals(string3 = attribute.getNamespacePrefix())) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        private boolean noOutputAncestorUsesPrefix(Element element, String string, String string2) {
            ParentNode parentNode = element.getParent();
            if (parentNode instanceof Document && "".equals(string2)) {
                return false;
            }
            while (parentNode != null && !(parentNode instanceof Document)) {
                if (this.nodes == null || this.nodes.contains(parentNode)) {
                    Element element2 = (Element)parentNode;
                    String string3 = element2.getNamespacePrefix();
                    if (string3.equals(string)) {
                        String string4 = element2.getNamespaceURI(string);
                        return !string4.equals(string2);
                    }
                    for (int i2 = 0; i2 < element2.getAttributeCount(); ++i2) {
                        Attribute attribute = element2.getAttribute(i2);
                        String string5 = attribute.getNamespacePrefix();
                        if (!string5.equals(string)) continue;
                        String string6 = element2.getNamespaceURI(string);
                        return !string6.equals(string2);
                    }
                }
                parentNode = parentNode.getParent();
            }
            return true;
        }

        private int indexOf(Element element) {
            for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
                if (this.nodes.get(i2) != element) continue;
                return i2;
            }
            return -1;
        }

        protected void write(Attribute attribute) throws IOException {
            this.writeRaw(" ");
            this.writeRaw(attribute.getQualifiedName());
            this.writeRaw("=\"");
            this.writeRaw(this.prepareAttributeValue(attribute));
            this.writeRaw("\"");
        }

        protected void writeEndTag(Element element) throws IOException {
            if (this.nodes == null || this.nodes.contains(element)) {
                this.writeRaw("</");
                this.writeRaw(element.getQualifiedName());
                this.writeRaw(">");
                this.inScope.popContext();
            }
        }

        private Attribute[] sortAttributes(Element element) {
            Object object;
            TreeMap<String, Attribute> treeMap = new TreeMap<String, Attribute>();
            if (!Canonicalizer.this.exclusive && this.nodes != null && this.nodes.contains(element) && !this.nodes.contains(element.getParent())) {
                Nodes nodes = element.query("ancestor::*/@xml:*", this.xmlcontext);
                if (nodes.size() != 0) {
                    for (int i2 = nodes.size() - 1; i2 >= 0; --i2) {
                        Attribute attribute = (Attribute)nodes.get(i2);
                        String string = attribute.getLocalName();
                        if (element.getAttribute(string, "http://www.w3.org/XML/1998/namespace") != null || treeMap.containsKey(string)) continue;
                        Element element2 = (Element)attribute.getParent();
                        if (!this.nodes.contains(element2)) {
                            treeMap.put(string, attribute);
                            continue;
                        }
                        treeMap.put(string, null);
                    }
                }
                object = treeMap.values().iterator();
                while (object.hasNext()) {
                    if (object.next() != null) continue;
                    object.remove();
                }
            }
            int n = element.getAttributeCount();
            object = new Attribute[n + treeMap.size()];
            for (int i3 = 0; i3 < n; ++i3) {
                object[i3] = element.getAttribute(i3);
            }
            Iterator iterator = treeMap.values().iterator();
            for (int i4 = n; i4 < ((Attribute[])object).length; ++i4) {
                object[i4] = (Attribute)iterator.next();
            }
            Arrays.sort(object, comparator);
            return object;
        }

        private String prepareAttributeValue(Attribute attribute) {
            String string = attribute.getValue();
            StringBuffer stringBuffer = new StringBuffer(string.length());
            if (attribute.getType().equals(Attribute.Type.CDATA) || attribute.getType().equals(Attribute.Type.UNDECLARED)) {
                char[] cArray = string.toCharArray();
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    char c2 = cArray[i2];
                    if (c2 == '\t') {
                        stringBuffer.append("&#x9;");
                        continue;
                    }
                    if (c2 == '\n') {
                        stringBuffer.append("&#xA;");
                        continue;
                    }
                    if (c2 == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (c2 == '\"') {
                        stringBuffer.append("&quot;");
                        continue;
                    }
                    if (c2 == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (c2 == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    stringBuffer.append(c2);
                }
            } else {
                char[] cArray = string.toCharArray();
                boolean bl = false;
                for (int i3 = 0; i3 < cArray.length; ++i3) {
                    if (cArray[i3] == ' ') {
                        if (i3 == cArray.length - 1 || cArray[i3 + 1] == ' ' || !bl) continue;
                        stringBuffer.append(cArray[i3]);
                        continue;
                    }
                    bl = true;
                    if (cArray[i3] == '\t') {
                        stringBuffer.append("&#x9;");
                        continue;
                    }
                    if (cArray[i3] == '\n') {
                        stringBuffer.append("&#xA;");
                        continue;
                    }
                    if (cArray[i3] == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (cArray[i3] == '\"') {
                        stringBuffer.append("&quot;");
                        continue;
                    }
                    if (cArray[i3] == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (cArray[i3] == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    stringBuffer.append(cArray[i3]);
                }
            }
            return stringBuffer.toString();
        }

        protected final void write(Text text) throws IOException {
            if (this.nodes == null || this.nodes.contains(text)) {
                String string = text.getValue();
                StringBuffer stringBuffer = new StringBuffer(string.length());
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c2 = string.charAt(i2);
                    if (c2 == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (c2 == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (c2 == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    if (c2 == '>') {
                        stringBuffer.append("&gt;");
                        continue;
                    }
                    stringBuffer.append(c2);
                }
                this.writeRaw(stringBuffer.toString());
            }
        }

        protected final void write(Comment comment) throws IOException {
            if (Canonicalizer.this.withComments && (this.nodes == null || this.nodes.contains(comment))) {
                super.write(comment);
            }
        }

        protected final void write(ProcessingInstruction processingInstruction) throws IOException {
            if (this.nodes == null || this.nodes.contains(processingInstruction)) {
                super.write(processingInstruction);
            }
        }

        protected final void write(DocType docType) {
        }

        public void write(Node node) throws IOException {
            if (node instanceof Document) {
                this.write((Document)node);
            } else if (node instanceof Attribute) {
                this.write((Attribute)node);
            } else if (node instanceof Namespace) {
                this.write((Namespace)node);
            } else {
                this.writeChild(node);
            }
        }

        private void write(Namespace namespace) throws IOException {
            String string = namespace.getPrefix();
            String string2 = namespace.getValue();
            this.writeRaw(" xmlns");
            if (!"".equals(string)) {
                this.writeRaw(":");
                this.writeRaw(string);
            }
            this.writeRaw("=\"");
            this.writeAttributeValue(string2);
            this.writeRaw("\"");
        }
    }

    private static class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object object, Object object2) {
            String string;
            Attribute attribute = (Attribute)object;
            Attribute attribute2 = (Attribute)object2;
            String string2 = attribute.getNamespaceURI();
            if (string2.equals(string = attribute2.getNamespaceURI())) {
                return attribute.getLocalName().compareTo(attribute2.getLocalName());
            }
            if (string2.equals("")) {
                return -1;
            }
            if (string.equals("")) {
                return 1;
            }
            return string2.compareTo(string);
        }
    }
}

