/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.form;

import com.uhf.UHFMainForm;
import com.uhf.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class LockKillForm
extends JPanel {
    private JPanel panel3;
    private JLabel label1;
    private JScrollPane scrollPane2;
    private JTextArea txtFilterData;
    private JLabel label2;
    private JTextField txtFilterStart;
    private JLabel label3;
    private JTextField txtFilterLen;
    private JPanel panel4;
    private JPanel panel5;
    private JRadioButton rbFilterEpc;
    private JRadioButton rbFliterTid;
    private JRadioButton rbFilterUser;
    private JPanel panel6;
    private JPanel panel7;
    private JLabel label4;
    private JTextField txtAccessPwd;
    private JLabel label5;
    private JPanel panel10;
    private JRadioButton rbOpen;
    private JRadioButton rbLock;
    private JRadioButton rbPOpen;
    private JRadioButton rbPLock;
    private JButton btnLock;
    private JPanel panel11;
    private JRadioButton rbKillPwd;
    private JRadioButton rbAccessPwd;
    private JRadioButton rbEpc;
    private JRadioButton rbTid;
    private JRadioButton rbUser;
    private JLabel label8;
    private JLabel lblLockCode;
    private JPanel panel8;
    private JPanel panel9;
    private JLabel label6;
    private JTextField txtKillPwd;
    private JLabel label7;
    private JButton btnKill;

    public LockKillForm() {
        this.initComponents();
    }

    private void btnLockActionPerformed(ActionEvent e2) {
        String start = this.txtFilterStart.getText();
        String len = this.txtFilterLen.getText();
        String data = this.txtFilterData.getText();
        String temp = this.lblLockCode.getText().trim();
        if (temp.isEmpty()) {
            JOptionPane.showMessageDialog(this, "The LockCode cannot be empty!", "", 0);
            return;
        }
        if (!StringUtils.isEmpty(len) && Integer.parseInt(len) > 0) {
            if (StringUtils.isEmpty(start)) {
                JOptionPane.showMessageDialog(this, "The Ptr cannot be empty!", "", 0);
                return;
            }
            if (StringUtils.isEmpty(data)) {
                JOptionPane.showMessageDialog(this, "The Data cannot be empty!", "", 0);
                return;
            }
            if (data.length() * 4 < Integer.parseInt(len)) {
                JOptionPane.showMessageDialog(this, "Data and Len do not match!", "", 0);
                return;
            }
            String accessPwd = this.txtAccessPwd.getText();
            if (StringUtils.isEmpty(accessPwd) || accessPwd.length() != 8) {
                JOptionPane.showMessageDialog(this, "The Access Pwd must be 4 bytes of hexadecimal data!", "", 0);
                return;
            }
            int bank = -1;
            if (this.rbFilterEpc.isSelected()) {
                bank = 1;
            } else if (this.rbFliterTid.isSelected()) {
                bank = 2;
            } else if (this.rbFilterUser.isSelected()) {
                bank = 3;
            }
            boolean result = UHFMainForm.ur4.lockMem(accessPwd, bank, Integer.parseInt(start), Integer.parseInt(len), data, this.lblLockCode.getText());
            if (result) {
                JOptionPane.showMessageDialog(this, "Lock Success!", "", 0);
            } else {
                JOptionPane.showMessageDialog(this, "Lock failed!", "", 0);
            }
            return;
        }
        String accessPwd = this.txtAccessPwd.getText();
        if (StringUtils.isEmpty(accessPwd) || accessPwd.length() != 8) {
            JOptionPane.showMessageDialog(this, "The access password must be 4 bytes of hexadecimal data!", "", 0);
            return;
        }
        boolean result = UHFMainForm.ur4.lockMem(accessPwd, this.lblLockCode.getText());
        if (result) {
            JOptionPane.showMessageDialog(this, "Lock Success!", "", 0);
        } else {
            JOptionPane.showMessageDialog(this, "Lock failed!", "", 0);
        }
    }

    private void generateLockCode() {
        int lockMode = 0;
        if (this.rbLock.isSelected()) {
            lockMode = 16;
        } else if (this.rbPLock.isSelected()) {
            lockMode = 48;
        } else if (this.rbOpen.isSelected()) {
            lockMode = 32;
        } else if (this.rbPOpen.isSelected()) {
            lockMode = 64;
        } else {
            this.lblLockCode.setText("");
            return;
        }
        ArrayList<Integer> lockBank = new ArrayList<Integer>();
        if (this.rbAccessPwd.isSelected()) {
            lockBank.add(32);
        }
        if (this.rbKillPwd.isSelected()) {
            lockBank.add(16);
        }
        if (this.rbEpc.isSelected()) {
            lockBank.add(48);
        }
        if (this.rbTid.isSelected()) {
            lockBank.add(64);
        }
        if (this.rbUser.isSelected()) {
            lockBank.add(80);
        }
        if (lockBank.size() == 0) {
            this.lblLockCode.setText("");
            return;
        }
        String hexLockCode = UHFMainForm.ur4.generateLockCode(lockBank, lockMode);
        this.lblLockCode.setText(hexLockCode);
    }

    private void rbOpenActionPerformed(ActionEvent e2) {
        this.rbOpen.setSelected(true);
        this.rbLock.setSelected(false);
        this.rbPOpen.setSelected(false);
        this.rbPLock.setSelected(false);
        this.generateLockCode();
    }

    private void rbLockActionPerformed(ActionEvent e2) {
        this.rbOpen.setSelected(false);
        this.rbLock.setSelected(true);
        this.rbPOpen.setSelected(false);
        this.rbPLock.setSelected(false);
        this.generateLockCode();
    }

    private void rbPOpenActionPerformed(ActionEvent e2) {
        this.rbOpen.setSelected(false);
        this.rbLock.setSelected(false);
        this.rbPOpen.setSelected(true);
        this.rbPLock.setSelected(false);
        this.generateLockCode();
    }

    private void rbPLockActionPerformed(ActionEvent e2) {
        this.rbOpen.setSelected(false);
        this.rbLock.setSelected(false);
        this.rbPOpen.setSelected(false);
        this.rbPLock.setSelected(true);
        this.generateLockCode();
    }

    private void rbKillPwdActionPerformed(ActionEvent e2) {
        this.rbKillPwd.setSelected(this.rbKillPwd.isSelected());
        this.generateLockCode();
    }

    private void rbAccessPwdActionPerformed(ActionEvent e2) {
        this.rbAccessPwd.setSelected(this.rbAccessPwd.isSelected());
        this.generateLockCode();
    }

    private void rbEpcActionPerformed(ActionEvent e2) {
        this.rbEpc.setSelected(this.rbEpc.isSelected());
        this.generateLockCode();
    }

    private void rbTidActionPerformed(ActionEvent e2) {
        this.rbTid.setSelected(this.rbTid.isSelected());
        this.generateLockCode();
    }

    private void rbUserActionPerformed(ActionEvent e2) {
        this.rbUser.setSelected(this.rbUser.isSelected());
        this.generateLockCode();
    }

    private void btnKillActionPerformed(ActionEvent e2) {
        boolean result = false;
        String filterStart = this.txtFilterStart.getText();
        String filterLen = this.txtFilterLen.getText();
        String filterData = this.txtFilterData.getText();
        String killPwd = this.txtKillPwd.getText();
        if (StringUtils.isEmpty(killPwd) || killPwd.length() != 8) {
            JOptionPane.showMessageDialog(this, "The Destroy Password must be 4 bytes of hexadecimal data!", "", 0);
            return;
        }
        if (!StringUtils.isEmpty(filterLen) && Integer.parseInt(filterLen) > 0) {
            if (StringUtils.isEmpty(filterStart)) {
                JOptionPane.showMessageDialog(this, "The Ptr cannot be empty!", "", 0);
                return;
            }
            if (StringUtils.isEmpty(filterData)) {
                JOptionPane.showMessageDialog(this, "The Data cannot be empty!", "", 0);
                return;
            }
            if (filterData.length() * 4 < Integer.parseInt(filterLen)) {
                JOptionPane.showMessageDialog(this, "Data and Len do not match!", "", 0);
                return;
            }
            int bank = -1;
            if (this.rbFilterEpc.isSelected()) {
                bank = 1;
            } else if (this.rbFliterTid.isSelected()) {
                bank = 2;
            } else if (this.rbFilterUser.isSelected()) {
                bank = 3;
            }
            result = UHFMainForm.ur4.killTag(killPwd, bank, Integer.parseInt(filterStart), Integer.parseInt(filterLen), filterData);
        } else {
            result = UHFMainForm.ur4.killTag(killPwd);
        }
        if (result) {
            JOptionPane.showMessageDialog(this, "Destroy success!", "", 0);
        } else {
            JOptionPane.showMessageDialog(this, "Destroy failed!", "", 0);
        }
    }

    private void initComponents() {
        Rectangle bounds;
        this.panel3 = new JPanel();
        this.label1 = new JLabel();
        this.scrollPane2 = new JScrollPane();
        this.txtFilterData = new JTextArea();
        this.label2 = new JLabel();
        this.txtFilterStart = new JTextField();
        this.label3 = new JLabel();
        this.txtFilterLen = new JTextField();
        this.panel4 = new JPanel();
        this.panel5 = new JPanel();
        this.rbFilterEpc = new JRadioButton();
        this.rbFliterTid = new JRadioButton();
        this.rbFilterUser = new JRadioButton();
        this.panel6 = new JPanel();
        this.panel7 = new JPanel();
        this.label4 = new JLabel();
        this.txtAccessPwd = new JTextField();
        this.label5 = new JLabel();
        this.panel10 = new JPanel();
        this.rbOpen = new JRadioButton();
        this.rbLock = new JRadioButton();
        this.rbPOpen = new JRadioButton();
        this.rbPLock = new JRadioButton();
        this.btnLock = new JButton();
        this.panel11 = new JPanel();
        this.rbKillPwd = new JRadioButton();
        this.rbAccessPwd = new JRadioButton();
        this.rbEpc = new JRadioButton();
        this.rbTid = new JRadioButton();
        this.rbUser = new JRadioButton();
        this.label8 = new JLabel();
        this.lblLockCode = new JLabel();
        this.panel8 = new JPanel();
        this.panel9 = new JPanel();
        this.label6 = new JLabel();
        this.txtKillPwd = new JTextField();
        this.label7 = new JLabel();
        this.btnKill = new JButton();
        this.setLayout(null);
        this.panel3.setBackground(new Color(238, 238, 238));
        this.panel3.setBorder(new TitledBorder("Filter"));
        this.panel3.setLayout(null);
        this.label1.setText("Data:");
        this.panel3.add(this.label1);
        this.label1.setBounds(new Rectangle(new Point(20, 30), this.label1.getPreferredSize()));
        this.scrollPane2.setViewportView(this.txtFilterData);
        this.panel3.add(this.scrollPane2);
        this.scrollPane2.setBounds(60, 15, 330, 50);
        this.label2.setText("Ptr:");
        this.panel3.add(this.label2);
        this.label2.setBounds(new Rectangle(new Point(420, 35), this.label2.getPreferredSize()));
        this.panel3.add(this.txtFilterStart);
        this.txtFilterStart.setBounds(445, 30, 65, this.txtFilterStart.getPreferredSize().height);
        this.label3.setText("Len:");
        this.panel3.add(this.label3);
        this.label3.setBounds(new Rectangle(new Point(530, 35), this.label3.getPreferredSize()));
        this.panel3.add(this.txtFilterLen);
        this.txtFilterLen.setBounds(560, 30, 60, this.txtFilterLen.getPreferredSize().height);
        this.panel4.setMinimumSize(new Dimension(30, 10));
        this.panel4.setLayout(new BorderLayout());
        this.panel3.add(this.panel4);
        this.panel4.setBounds(730, 30, this.panel4.getPreferredSize().width, 0);
        this.panel5.setPreferredSize(new Dimension(10, 50));
        this.panel5.setBorder(LineBorder.createBlackLineBorder());
        this.panel5.setToolTipText("\u8fc7\u6ee4");
        this.panel5.setLayout(null);
        this.rbFilterEpc.setText("EPC");
        this.panel5.add(this.rbFilterEpc);
        this.rbFilterEpc.setBounds(new Rectangle(new Point(5, 15), this.rbFilterEpc.getPreferredSize()));
        this.rbFliterTid.setText("Tid");
        this.panel5.add(this.rbFliterTid);
        this.rbFliterTid.setBounds(new Rectangle(new Point(75, 15), this.rbFliterTid.getPreferredSize()));
        this.rbFilterUser.setText("User");
        this.panel5.add(this.rbFilterUser);
        this.rbFilterUser.setBounds(new Rectangle(new Point(140, 15), this.rbFilterUser.getPreferredSize()));
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.panel5.getComponentCount(); ++i2) {
            bounds = this.panel5.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.panel5.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel5.setMinimumSize(preferredSize);
        this.panel5.setPreferredSize(preferredSize);
        this.panel3.add(this.panel5);
        this.panel5.setBounds(635, 20, 215, this.panel5.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i3 = 0; i3 < this.panel3.getComponentCount(); ++i3) {
            bounds = this.panel3.getComponent(i3).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel3.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel3.setMinimumSize(preferredSize);
        this.panel3.setPreferredSize(preferredSize);
        this.add(this.panel3);
        this.panel3.setBounds(10, 15, 875, 80);
        this.panel6.setBackground(new Color(238, 238, 238));
        this.panel6.setBorder(new TitledBorder("Lock"));
        this.panel6.setLayout(null);
        this.panel7.setMinimumSize(new Dimension(30, 10));
        this.panel7.setLayout(new BorderLayout());
        this.panel6.add(this.panel7);
        this.panel7.setBounds(730, 30, this.panel7.getPreferredSize().width, 0);
        this.label4.setText("Access Pwd:");
        this.panel6.add(this.label4);
        this.label4.setBounds(new Rectangle(new Point(20, 35), this.label4.getPreferredSize()));
        this.panel6.add(this.txtAccessPwd);
        this.txtAccessPwd.setBounds(105, 30, 185, 30);
        this.label5.setText("(Default password cannot be used)  ");
        this.panel6.add(this.label5);
        this.label5.setBounds(300, 35, this.label5.getPreferredSize().width, 17);
        this.panel10.setPreferredSize(new Dimension(10, 50));
        this.panel10.setBorder(LineBorder.createBlackLineBorder());
        this.panel10.setToolTipText("\u8fc7\u6ee4");
        this.panel10.setLayout(null);
        this.rbOpen.setText("Open");
        this.rbOpen.addActionListener(e2 -> this.rbOpenActionPerformed(e2));
        this.panel10.add(this.rbOpen);
        this.rbOpen.setBounds(5, 15, 70, this.rbOpen.getPreferredSize().height);
        this.rbLock.setText("Lock");
        this.rbLock.addActionListener(e2 -> this.rbLockActionPerformed(e2));
        this.panel10.add(this.rbLock);
        this.rbLock.setBounds(75, 15, 55, this.rbLock.getPreferredSize().height);
        this.rbPOpen.setText("Permanent Opening");
        this.rbPOpen.addActionListener(e2 -> this.rbPOpenActionPerformed(e2));
        this.panel10.add(this.rbPOpen);
        this.rbPOpen.setBounds(new Rectangle(new Point(140, 15), this.rbPOpen.getPreferredSize()));
        this.rbPLock.setText("Permanent lock  ");
        this.rbPLock.addActionListener(e2 -> this.rbPLockActionPerformed(e2));
        this.panel10.add(this.rbPLock);
        this.rbPLock.setBounds(new Rectangle(new Point(290, 15), this.rbPLock.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i4 = 0; i4 < this.panel10.getComponentCount(); ++i4) {
            bounds = this.panel10.getComponent(i4).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel10.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel10.setMinimumSize(preferredSize);
        this.panel10.setPreferredSize(preferredSize);
        this.panel6.add(this.panel10);
        this.panel10.setBounds(25, 75, 425, 50);
        this.btnLock.setText("LOCK");
        this.btnLock.addActionListener(e2 -> this.btnLockActionPerformed(e2));
        this.panel6.add(this.btnLock);
        this.btnLock.setBounds(170, 235, 150, 50);
        this.panel11.setPreferredSize(new Dimension(10, 50));
        this.panel11.setBorder(LineBorder.createBlackLineBorder());
        this.panel11.setToolTipText("\u8fc7\u6ee4");
        this.panel11.setLayout(null);
        this.rbKillPwd.setText("Kill-pwd");
        this.rbKillPwd.addActionListener(e2 -> this.rbKillPwdActionPerformed(e2));
        this.panel11.add(this.rbKillPwd);
        this.rbKillPwd.setBounds(5, 15, 85, this.rbKillPwd.getPreferredSize().height);
        this.rbAccessPwd.setText("Access-pwd");
        this.rbAccessPwd.addActionListener(e2 -> this.rbAccessPwdActionPerformed(e2));
        this.panel11.add(this.rbAccessPwd);
        this.rbAccessPwd.setBounds(95, 15, 115, this.rbAccessPwd.getPreferredSize().height);
        this.rbEpc.setText("EPC");
        this.rbEpc.addActionListener(e2 -> this.rbEpcActionPerformed(e2));
        this.panel11.add(this.rbEpc);
        this.rbEpc.setBounds(215, 15, 60, this.rbEpc.getPreferredSize().height);
        this.rbTid.setText("TID");
        this.rbTid.addActionListener(e2 -> this.rbTidActionPerformed(e2));
        this.panel11.add(this.rbTid);
        this.rbTid.setBounds(275, 15, 60, 21);
        this.rbUser.setText("USER");
        this.rbUser.addActionListener(e2 -> this.rbUserActionPerformed(e2));
        this.panel11.add(this.rbUser);
        this.rbUser.setBounds(335, 15, 75, 21);
        preferredSize = new Dimension();
        for (int i5 = 0; i5 < this.panel11.getComponentCount(); ++i5) {
            bounds = this.panel11.getComponent(i5).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel11.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel11.setMinimumSize(preferredSize);
        this.panel11.setPreferredSize(preferredSize);
        this.panel6.add(this.panel11);
        this.panel11.setBounds(25, 140, 425, 50);
        this.label8.setText("LockCode:");
        this.panel6.add(this.label8);
        this.label8.setBounds(35, 205, 80, this.label8.getPreferredSize().height);
        this.lblLockCode.setText(" ");
        this.panel6.add(this.lblLockCode);
        this.lblLockCode.setBounds(110, 205, 130, this.lblLockCode.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i6 = 0; i6 < this.panel6.getComponentCount(); ++i6) {
            bounds = this.panel6.getComponent(i6).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel6.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel6.setMinimumSize(preferredSize);
        this.panel6.setPreferredSize(preferredSize);
        this.add(this.panel6);
        this.panel6.setBounds(10, 105, 525, 295);
        this.panel8.setBackground(new Color(238, 238, 238));
        this.panel8.setBorder(new TitledBorder("Destruction"));
        this.panel8.setLayout(null);
        this.panel9.setMinimumSize(new Dimension(30, 10));
        this.panel9.setLayout(new BorderLayout());
        this.panel8.add(this.panel9);
        this.panel9.setBounds(730, 30, this.panel9.getPreferredSize().width, 0);
        this.label6.setText("Destroy Password :");
        this.panel8.add(this.label6);
        this.label6.setBounds(25, 40, this.label6.getPreferredSize().width, 17);
        this.panel8.add(this.txtKillPwd);
        this.txtKillPwd.setBounds(145, 35, 185, 30);
        this.label7.setText("(Default password cannot be used)  ");
        this.panel8.add(this.label7);
        this.label7.setBounds(150, 70, this.label7.getPreferredSize().width, 17);
        this.btnKill.setText("Destruction");
        this.btnKill.addActionListener(e2 -> this.btnKillActionPerformed(e2));
        this.panel8.add(this.btnKill);
        this.btnKill.setBounds(125, 105, 150, 50);
        preferredSize = new Dimension();
        for (int i7 = 0; i7 < this.panel8.getComponentCount(); ++i7) {
            bounds = this.panel8.getComponent(i7).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel8.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel8.setMinimumSize(preferredSize);
        this.panel8.setPreferredSize(preferredSize);
        this.add(this.panel8);
        this.panel8.setBounds(560, 105, 425, 290);
        preferredSize = new Dimension();
        for (int i8 = 0; i8 < this.getComponentCount(); ++i8) {
            bounds = this.getComponent(i8).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.setMinimumSize(preferredSize);
        this.setPreferredSize(preferredSize);
    }
}

