/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.form;

import com.rscja.deviceapi.interfaces.IUpgradeProgress;
import com.uhf.UHFMainForm;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FirmwareUpgradeForm
extends JPanel {
    private JLabel label1;
    private JTextField textField;
    private JButton btnSelect;
    private JButton btnUHF;
    private JProgressBar pgbar;

    public FirmwareUpgradeForm() {
        this.initComponents();
    }

    private void btnSelectActionPerformed(ActionEvent e2) {
        JFileChooser chooser = new JFileChooser(new File("/"));
        chooser.setFileFilter(new BinFilter());
        int returnValue = chooser.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = chooser.getSelectedFile();
            this.textField.setText(selectedFile.getAbsolutePath());
        }
    }

    private void btnUHFActionPerformed(ActionEvent e2) {
        this.pgbar.setValue(0);
        String filePath = this.textField.getText();
        if (filePath == null) {
            JOptionPane.showMessageDialog(this, "Please select the upgrade file!", "", 0);
        } else if (filePath.endsWith(".bin")) {
            this.btnUHF.setEnabled(false);
            new UHFProgress(this.pgbar, filePath).start();
        } else if (filePath.endsWith(".apk")) {
            this.btnUHF.setEnabled(false);
            new ProgressTCPServer(this.pgbar, filePath).start();
        } else {
            JOptionPane.showMessageDialog(this, "File error, please select the uhf firmware!", "", 0);
        }
    }

    private void initComponents() {
        this.label1 = new JLabel();
        this.textField = new JTextField();
        this.btnSelect = new JButton();
        this.btnUHF = new JButton();
        this.pgbar = new JProgressBar();
        this.setLayout(null);
        this.label1.setText("path\uff1a");
        this.label1.setFont(this.label1.getFont().deriveFont((float)this.label1.getFont().getSize() + 3.0f));
        this.add(this.label1);
        this.label1.setBounds(new Rectangle(new Point(115, 85), this.label1.getPreferredSize()));
        this.textField.setFont(this.textField.getFont().deriveFont((float)this.textField.getFont().getSize() + 3.0f));
        this.add(this.textField);
        this.textField.setBounds(160, 80, 490, 30);
        this.btnSelect.setText("Select Upgrade File  ");
        this.btnSelect.setFont(this.btnSelect.getFont().deriveFont((float)this.btnSelect.getFont().getSize() + 3.0f));
        this.btnSelect.addActionListener(e2 -> this.btnSelectActionPerformed(e2));
        this.add(this.btnSelect);
        this.btnSelect.setBounds(650, 80, this.btnSelect.getPreferredSize().width, 30);
        this.btnUHF.setText("Upgrade UHF Firmware");
        this.btnUHF.setFont(this.btnUHF.getFont().deriveFont((float)this.btnUHF.getFont().getSize() + 3.0f));
        this.btnUHF.addActionListener(e2 -> this.btnUHFActionPerformed(e2));
        this.add(this.btnUHF);
        this.btnUHF.setBounds(new Rectangle(new Point(380, 170), this.btnUHF.getPreferredSize()));
        this.pgbar.setPreferredSize(new Dimension(146, 10));
        this.add(this.pgbar);
        this.pgbar.setBounds(160, 250, 560, 25);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Rectangle bounds = this.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.setMinimumSize(preferredSize);
        this.setPreferredSize(preferredSize);
    }

    private class ProgressTCPServer
    extends Thread {
        JProgressBar progressBar;
        String uFile;

        ProgressTCPServer(JProgressBar progressBar, String path) {
            this.progressBar = progressBar;
            this.uFile = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UHFMainForm.ur4.setUpgradeProgress(new IUpgradeProgress(){

                @Override
                public void progress(int value) {
                    ProgressTCPServer.this.progressBar.setValue(value);
                }

                @Override
                public void mesage(String msg) {
                    System.out.print("msg=" + msg);
                }
            });
            boolean result = false;
            long uFileSize = this.uFile.length();
            BufferedInputStream inputStream = null;
            UHFMainForm.ur4.readyUpgradeTcpService();
            try {
                inputStream = new BufferedInputStream(new FileInputStream(this.uFile));
                byte[] buff = new byte[4096];
                int len = 0;
                while ((len = inputStream.read(buff)) != -1) {
                    UHFMainForm.ur4.setUpgradeTcpServiceData(Arrays.copyOf(buff, len));
                }
                inputStream.close();
                result = UHFMainForm.ur4.startUpgradeTcpService();
                JOptionPane.showMessageDialog(FirmwareUpgradeForm.this, "result=" + result, "result=", 1);
            }
            catch (Exception e2) {
                System.out.println("\u5347\u7ea7Exception:" + e2.toString());
            }
            finally {
                FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
            }
        }

        private void sleep(int time) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
    }

    private class UHFProgress
    extends Thread {
        JProgressBar progressBar;
        String mFileName;

        UHFProgress(JProgressBar progressBar, String path) {
            this.progressBar = progressBar;
            this.mFileName = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean result = false;
                File uFile = new File(this.mFileName);
                if (!uFile.exists()) {
                    System.out.println("fail");
                    JOptionPane.showConfirmDialog(FirmwareUpgradeForm.this, "fail", "", -1, 1);
                    FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
                    return;
                }
                long uFileSize = uFile.length();
                System.out.println("uFileSize=" + uFileSize);
                int packageCount = (int)(uFileSize / 64L);
                System.out.println("packageCount=" + packageCount);
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(this.mFileName, "r");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (raf == null) {
                    System.out.println("fail");
                    JOptionPane.showConfirmDialog(FirmwareUpgradeForm.this, "fail", "", -1, 1);
                    FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
                    return;
                }
                String version = UHFMainForm.ur4.getVersion();
                System.out.println("UHF version=" + version);
                System.out.println("UHF uhfJump2Boot begin");
                if (!UHFMainForm.ur4.uhfJump2Boot()) {
                    System.out.println("uhfJump2Boot fail");
                }
                Thread.sleep(2000L);
                System.out.println("UHF uhfStartUpdate begin");
                if (!UHFMainForm.ur4.uhfStartUpdate()) {
                    System.out.println("uhfStartUpdate \u5931\u8d25");
                    JOptionPane.showConfirmDialog(FirmwareUpgradeForm.this, "fail", "", -1, 1);
                    FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
                    return;
                }
                Thread.sleep(2000L);
                int temp = 0;
                int pakeSize = 64;
                byte[] currData = new byte[(int)uFileSize];
                for (int k2 = 0; k2 < packageCount; ++k2) {
                    int index = k2 * pakeSize;
                    try {
                        int n = raf.read(currData, index, pakeSize);
                    }
                    catch (IOException e2) {
                        this.stopUpgrader();
                        System.out.println("\u5931\u8d25!");
                        JOptionPane.showConfirmDialog(FirmwareUpgradeForm.this, "fail", "", -1, 1);
                        FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
                        return;
                    }
                    System.out.println("send : " + ++temp);
                    if (!UHFMainForm.ur4.uhfUpdating(Arrays.copyOfRange(currData, index, index + pakeSize))) {
                        System.out.println("uhfUpdating \u5931\u8d25");
                        this.stopUpgrader();
                        JOptionPane.showConfirmDialog(FirmwareUpgradeForm.this, "fail", "", -1, 1);
                        FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
                        return;
                    }
                    result = true;
                    this.setprogressValue(index + pakeSize, (int)uFileSize);
                }
                if (uFileSize % (long)pakeSize != 0L) {
                    int index = packageCount * pakeSize;
                    int len = (int)(uFileSize % (long)pakeSize);
                    try {
                        int rsize = raf.read(currData, index, len);
                        System.out.println("beginPack=" + index + " countPack=" + len + " rsize=" + rsize);
                    }
                    catch (IOException e3) {
                        System.out.println("IOException ");
                        this.stopUpgrader();
                        JOptionPane.showConfirmDialog(FirmwareUpgradeForm.this, "fail", "", -1, 1);
                        FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
                        FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
                        return;
                    }
                    if (UHFMainForm.ur4.uhfUpdating(Arrays.copyOfRange(currData, index, index + len))) {
                        result = true;
                        this.setprogressValue((int)uFileSize, (int)uFileSize);
                        JOptionPane.showConfirmDialog(FirmwareUpgradeForm.this, "success", "", -1, 1);
                    } else {
                        System.out.println("uhfUpdating \u5931\u8d25");
                        this.stopUpgrader();
                        JOptionPane.showConfirmDialog(FirmwareUpgradeForm.this, "fail", "", -1, 1);
                        FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
                        return;
                    }
                }
                this.stopUpgrader();
                JOptionPane.showConfirmDialog(FirmwareUpgradeForm.this, "success", "", -1, 1);
                this.progressBar.setIndeterminate(false);
            }
            catch (Exception exception) {
            }
            finally {
                FirmwareUpgradeForm.this.btnUHF.setEnabled(true);
            }
        }

        private void setprogressValue(int value, int total) {
            this.progressBar.setValue(value * 100 / total);
        }

        private void stopUpgrader() {
            UHFMainForm.ur4.uhfStopUpdate();
        }
    }

    class BinFilter
    extends FileFilter {
        BinFilter() {
        }

        @Override
        public boolean accept(File f2) {
            if (f2.isDirectory()) {
                return true;
            }
            if (f2.isFile()) {
                return f2.getName().endsWith(".bin") || f2.getName().endsWith(".apk");
            }
            return true;
        }

        @Override
        public String getDescription() {
            return "*.bin|*.apk";
        }
    }
}

