/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.function;

import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.Function;
import nu.xom.jaxen.FunctionCallException;
import nu.xom.jaxen.Navigator;
import nu.xom.jaxen.function.StringFunction;

public class StringLengthFunction
implements Function {
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 0) {
            return StringLengthFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (list.size() == 1) {
            return StringLengthFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string-length() requires one argument.");
    }

    public static Double evaluate(Object object, Navigator navigator) throws FunctionCallException {
        String string = StringFunction.evaluate(object, navigator);
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            ++n;
            if (c2 < '\ud800' || c2 > '\udfff') continue;
            try {
                char c3 = cArray[i2 + 1];
                if (c3 < '\udc00' || c3 > '\udfff') {
                    throw new FunctionCallException("Bad surrogate pair in string " + string);
                }
                ++i2;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new FunctionCallException("Bad surrogate pair in string " + string);
            }
        }
        return new Double(n);
    }
}

