/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.function;

import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.Function;
import nu.xom.jaxen.FunctionCallException;
import nu.xom.jaxen.Navigator;

public class NamespaceUriFunction
implements Function {
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 0) {
            return NamespaceUriFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (list.size() == 1) {
            return NamespaceUriFunction.evaluate(list, context.getNavigator());
        }
        throw new FunctionCallException("namespace-uri() requires zero or one argument.");
    }

    public static String evaluate(List list, Navigator navigator) throws FunctionCallException {
        if (!list.isEmpty()) {
            Object e2 = list.get(0);
            if (e2 instanceof List) {
                return NamespaceUriFunction.evaluate((List)e2, navigator);
            }
            if (navigator.isElement(e2)) {
                return navigator.getElementNamespaceUri(e2);
            }
            if (navigator.isAttribute(e2)) {
                String string = navigator.getAttributeNamespaceUri(e2);
                if (string == null) {
                    return "";
                }
                return string;
            }
            if (navigator.isProcessingInstruction(e2)) {
                return "";
            }
            if (navigator.isNamespace(e2)) {
                return "";
            }
            if (navigator.isDocument(e2)) {
                return "";
            }
            if (navigator.isComment(e2)) {
                return "";
            }
            if (navigator.isText(e2)) {
                return "";
            }
            throw new FunctionCallException("The argument to the namespace-uri function must be a node-set");
        }
        return "";
    }
}

