/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import nu.xom.Builder;
import nu.xom.IllegalCharacterDataException;
import nu.xom.IllegalDataException;
import nu.xom.IllegalNameException;
import nu.xom.MalformedURIException;
import nu.xom.URIUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class Verifier {
    private static final byte XML_CHARACTER = 1;
    private static final byte NAME_CHARACTER = 2;
    private static final byte NAME_START_CHARACTER = 4;
    private static final byte NCNAME_CHARACTER = 8;
    private static byte[] flags = null;
    private static boolean[] C0Table;
    private static URICache cache;
    private static XMLReader parser;
    static /* synthetic */ Class class$nu$xom$Verifier;

    private Verifier() {
    }

    private static void loadFlags(ClassLoader classLoader) {
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = classLoader.getResourceAsStream("nu/xom/characters.dat");
            if (inputStream == null) {
                throw new RuntimeException("Broken XOM installation: could not load nu/xom/characters.dat");
            }
            filterInputStream = new DataInputStream(inputStream);
            flags = new byte[65536];
            ((DataInputStream)filterInputStream).readFully(flags);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Broken XOM installation: could not load nu/xom/characters.dat");
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static void checkNCName(String string) {
        char c2;
        int n;
        if (string == null) {
            Verifier.throwIllegalNameException(string, "NCNames cannot be null");
        }
        if ((n = string.length()) == 0) {
            Verifier.throwIllegalNameException(string, "NCNames cannot be empty");
        }
        if ((flags[c2 = string.charAt(0)] & 4) == 0) {
            Verifier.throwIllegalNameException(string, "NCNames cannot start with the character " + Integer.toHexString(c2));
        }
        for (int i2 = 1; i2 < n; ++i2) {
            char c3 = string.charAt(i2);
            if ((flags[c3] & 8) != 0) continue;
            if (c3 == ':') {
                Verifier.throwIllegalNameException(string, "NCNames cannot contain colons");
                continue;
            }
            Verifier.throwIllegalNameException(string, "0x" + Integer.toHexString(c3) + " is not a legal NCName character");
        }
    }

    private static void throwIllegalNameException(String string, String string2) {
        IllegalNameException illegalNameException = new IllegalNameException(string2);
        illegalNameException.setData(string);
        throw illegalNameException;
    }

    private static void throwIllegalCharacterDataException(String string, String string2) {
        IllegalCharacterDataException illegalCharacterDataException = new IllegalCharacterDataException(string2);
        illegalCharacterDataException.setData(string);
        throw illegalCharacterDataException;
    }

    private static void throwMalformedURIException(String string, String string2) {
        MalformedURIException malformedURIException = new MalformedURIException(string2);
        malformedURIException.setData(string);
        throw malformedURIException;
    }

    static void checkPCDATA(String string) {
        if (string == null) {
            throw new IllegalCharacterDataException("Null text");
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            char c2 = cArray[i2];
            if (c2 >= '\ud800' && c2 <= '\udbff') {
                try {
                    char c3 = cArray[i2 + 1];
                    if (c3 < '\udc00' || c3 > '\udfff') {
                        IllegalCharacterDataException illegalCharacterDataException = new IllegalCharacterDataException("Bad surrogate pair");
                        illegalCharacterDataException.setData(string);
                        throw illegalCharacterDataException;
                    }
                    ++i2;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    IllegalCharacterDataException illegalCharacterDataException = new IllegalCharacterDataException("Bad Surrogate Pair", arrayIndexOutOfBoundsException);
                    illegalCharacterDataException.setData(string);
                    throw illegalCharacterDataException;
                }
            }
            if ((flags[c2] & 1) != 0) continue;
            Verifier.throwIllegalCharacterDataException(string, "0x" + Integer.toHexString(c2) + " is not allowed in XML content");
        }
    }

    static void checkURIReference(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        URIUtil.ParsedURI parsedURI = new URIUtil.ParsedURI(string);
        try {
            if (parsedURI.scheme != null) {
                Verifier.checkScheme(parsedURI.scheme);
            }
            if (parsedURI.authority != null) {
                Verifier.checkAuthority(parsedURI.authority);
            }
            Verifier.checkPath(parsedURI.path);
            if (parsedURI.fragment != null) {
                Verifier.checkFragment(parsedURI.fragment);
            }
            if (parsedURI.query != null) {
                Verifier.checkQuery(parsedURI.query);
            }
        }
        catch (MalformedURIException malformedURIException) {
            malformedURIException.setData(string);
            throw malformedURIException;
        }
    }

    private static void checkQuery(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '%') {
                try {
                    if (!Verifier.isHexDigit(string.charAt(i2 + 1)) || !Verifier.isHexDigit(string.charAt(i2 + 2))) {
                        Verifier.throwMalformedURIException(string, "Bad percent escape sequence");
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    Verifier.throwMalformedURIException(string, "Bad percent escape sequence");
                }
                i2 += 2;
                continue;
            }
            if (Verifier.isQueryCharacter(c2)) continue;
            throw new MalformedURIException("Illegal query character " + c2);
        }
    }

    private static boolean isQueryCharacter(char c2) {
        switch (c2) {
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return false;
            }
            case '$': {
                return true;
            }
            case '%': {
                return false;
            }
            case '&': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return true;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return true;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return true;
            }
            case '@': {
                return true;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
            case '{': {
                return false;
            }
            case '|': {
                return false;
            }
            case '}': {
                return false;
            }
            case '~': {
                return true;
            }
        }
        return false;
    }

    private static void checkFragment(String string) {
        Verifier.checkQuery(string);
    }

    private static void checkPath(String string) {
        int n = string.length();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < n; ++i2) {
            char c2 = cArray[i2];
            if (c2 == '/') {
                if (i2 >= n - 1 || cArray[i2 + 1] != '/') continue;
                Verifier.throwMalformedURIException(string, "Double slash (//) in path");
                continue;
            }
            if (c2 == '%') {
                try {
                    if (!Verifier.isHexDigit(cArray[i2 + 1]) || !Verifier.isHexDigit(cArray[i2 + 2])) {
                        Verifier.throwMalformedURIException(string, "Bad percent escape sequence");
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    Verifier.throwMalformedURIException(string, "Bad percent escape sequence");
                }
                i2 += 2;
                continue;
            }
            if (Verifier.isPathCharacter(c2)) continue;
            Verifier.throwMalformedURIException(string, "Illegal path character " + c2);
        }
    }

    private static void checkAuthority(String string) {
        int n;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n2 = string.indexOf(64);
        if (n2 != -1) {
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 1);
        }
        if (string.startsWith("[")) {
            n = string.indexOf("]:");
            if (n != -1) {
                ++n;
            }
        } else {
            n = string.indexOf(58);
        }
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        if (string2 != null) {
            Verifier.checkUserInfo(string2);
        }
        if (string4 != null) {
            Verifier.checkPort(string4);
        }
        Verifier.checkHost(string3);
    }

    private static void checkHost(String string) {
        int n = string.length();
        if (n == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        if (cArray[0] == '[') {
            if (cArray[n - 1] != ']') {
                throw new MalformedURIException("Missing closing ]");
            }
            Verifier.checkIP6Address(string.substring(1, n - 1));
        } else {
            if (n > 255) {
                throw new MalformedURIException("Host name too long: " + string);
            }
            for (int i2 = 0; i2 < n; ++i2) {
                char c2 = cArray[i2];
                if (c2 == '%') {
                    try {
                        if (!Verifier.isHexDigit(cArray[i2 + 1]) || !Verifier.isHexDigit(cArray[i2 + 2])) {
                            Verifier.throwMalformedURIException(string, "Bad percent escape sequence");
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        Verifier.throwMalformedURIException(string, "Bad percent escape sequence");
                    }
                    i2 += 2;
                    continue;
                }
                if (Verifier.isRegNameCharacter(c2)) continue;
                Verifier.throwMalformedURIException(string, "Illegal host character " + c2);
            }
        }
    }

    private static boolean isRegNameCharacter(char c2) {
        switch (c2) {
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return false;
            }
            case '$': {
                return true;
            }
            case '%': {
                return false;
            }
            case '&': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return false;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return false;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return false;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
            case '{': {
                return false;
            }
            case '|': {
                return false;
            }
            case '}': {
                return false;
            }
            case '~': {
                return true;
            }
        }
        return false;
    }

    private static void checkPort(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            throw new MalformedURIException("Bad port: " + string);
        }
    }

    private static void checkUserInfo(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '%') {
                try {
                    if (!Verifier.isHexDigit(string.charAt(i2 + 1)) || !Verifier.isHexDigit(string.charAt(i2 + 2))) {
                        Verifier.throwMalformedURIException(string, "Bad percent escape sequence");
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    Verifier.throwMalformedURIException(string, "Bad percent escape sequence");
                }
                i2 += 2;
                continue;
            }
            if (Verifier.isUserInfoCharacter(c2)) continue;
            throw new MalformedURIException("Bad user info: " + string);
        }
    }

    private static void checkScheme(String string) {
        if ("http".equals(string)) {
            return;
        }
        if (string.length() == 0) {
            throw new MalformedURIException("URIs cannot begin with a colon");
        }
        char c2 = string.charAt(0);
        if (!Verifier.isAlpha(c2)) {
            throw new MalformedURIException("Illegal initial scheme character " + c2);
        }
        for (int i2 = string.length() - 1; i2 >= 1; --i2) {
            c2 = string.charAt(i2);
            if (Verifier.isSchemeCharacter(c2)) continue;
            throw new MalformedURIException("Illegal scheme character " + c2);
        }
    }

    private static void checkIP6Address(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
        int n = stringTokenizer.countTokens();
        if (n > 15 || n < 2) {
            throw new MalformedURIException("Illegal IP6 host address: " + string);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            String string2 = stringTokenizer.nextToken();
            if (":".equals(string2)) continue;
            try {
                int n2 = Integer.parseInt(string2, 16);
                if (n2 >= 0) continue;
                throw new MalformedURIException("Illegal IP6 host address: " + string);
            }
            catch (NumberFormatException numberFormatException) {
                if (i2 == n - 1) {
                    Verifier.checkIP4Address(string2, string);
                    continue;
                }
                Verifier.throwMalformedURIException(string, "Illegal IP6 host address: " + string);
            }
        }
        if (string.indexOf("::") != string.lastIndexOf("::")) {
            throw new MalformedURIException("Illegal IP6 host address: " + string);
        }
    }

    private static void checkIP4Address(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        if (n != 4) {
            throw new MalformedURIException("Illegal IP6 host address: " + string2);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            String string3 = stringTokenizer.nextToken();
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 <= 255 && n2 >= 0) continue;
                throw new MalformedURIException("Illegal IP6 host address: " + string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURIException("Illegal IP6 host address: " + string2);
            }
        }
    }

    static void checkXMLName(String string) {
        char c2;
        int n;
        if (string == null) {
            Verifier.throwIllegalNameException(string, "XML names cannot be null");
        }
        if ((n = string.length()) == 0) {
            Verifier.throwIllegalNameException(string, "XML names cannot be empty");
        }
        if ((flags[c2 = string.charAt(0)] & 4) == 0) {
            Verifier.throwIllegalNameException(string, "XML names cannot start with the character " + Integer.toHexString(c2));
        }
        for (int i2 = 1; i2 < n; ++i2) {
            char c3 = string.charAt(i2);
            if ((flags[c3] & 2) != 0) continue;
            Verifier.throwIllegalNameException(string, "0x" + Integer.toHexString(c3) + " is not a legal name character");
        }
    }

    static boolean isXMLSpaceCharacter(char c2) {
        if (c2 > ' ') {
            return false;
        }
        return C0Table[c2];
    }

    private static boolean isHexDigit(char c2) {
        switch (c2) {
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return false;
            }
            case ';': {
                return false;
            }
            case '<': {
                return false;
            }
            case '=': {
                return false;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return false;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return false;
            }
            case 'H': {
                return false;
            }
            case 'I': {
                return false;
            }
            case 'J': {
                return false;
            }
            case 'K': {
                return false;
            }
            case 'L': {
                return false;
            }
            case 'M': {
                return false;
            }
            case 'N': {
                return false;
            }
            case 'O': {
                return false;
            }
            case 'P': {
                return false;
            }
            case 'Q': {
                return false;
            }
            case 'R': {
                return false;
            }
            case 'S': {
                return false;
            }
            case 'T': {
                return false;
            }
            case 'U': {
                return false;
            }
            case 'V': {
                return false;
            }
            case 'W': {
                return false;
            }
            case 'X': {
                return false;
            }
            case 'Y': {
                return false;
            }
            case 'Z': {
                return false;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return false;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
        }
        return false;
    }

    static void checkAbsoluteURIReference(String string) {
        if (cache.contains(string)) {
            return;
        }
        URIUtil.ParsedURI parsedURI = new URIUtil.ParsedURI(string);
        try {
            if (parsedURI.scheme == null) {
                Verifier.throwMalformedURIException(string, "Missing scheme in absolute URI reference");
            }
            Verifier.checkScheme(parsedURI.scheme);
            if (parsedURI.authority != null) {
                Verifier.checkAuthority(parsedURI.authority);
            }
            Verifier.checkPath(parsedURI.path);
            if (parsedURI.fragment != null) {
                Verifier.checkFragment(parsedURI.fragment);
            }
            if (parsedURI.query != null) {
                Verifier.checkQuery(parsedURI.query);
            }
            cache.put(string);
        }
        catch (MalformedURIException malformedURIException) {
            malformedURIException.setData(string);
            throw malformedURIException;
        }
    }

    static boolean isAlpha(char c2) {
        switch (c2) {
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return false;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
        }
        return false;
    }

    static boolean isSchemeCharacter(char c2) {
        switch (c2) {
            case '+': {
                return true;
            }
            case ',': {
                return false;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return false;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return false;
            }
            case ';': {
                return false;
            }
            case '<': {
                return false;
            }
            case '=': {
                return false;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return false;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return false;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
        }
        return false;
    }

    private static boolean isPathCharacter(char c2) {
        switch (c2) {
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return false;
            }
            case '$': {
                return true;
            }
            case '%': {
                return false;
            }
            case '&': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return false;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return true;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return true;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
            case '{': {
                return false;
            }
            case '|': {
                return false;
            }
            case '}': {
                return false;
            }
            case '~': {
                return true;
            }
        }
        return false;
    }

    private static boolean isUserInfoCharacter(char c2) {
        switch (c2) {
            case '!': {
                return true;
            }
            case '\"': {
                return false;
            }
            case '#': {
                return false;
            }
            case '$': {
                return true;
            }
            case '%': {
                return false;
            }
            case '&': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '(': {
                return true;
            }
            case ')': {
                return true;
            }
            case '*': {
                return true;
            }
            case '+': {
                return true;
            }
            case ',': {
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case '/': {
                return true;
            }
            case '0': {
                return true;
            }
            case '1': {
                return true;
            }
            case '2': {
                return true;
            }
            case '3': {
                return true;
            }
            case '4': {
                return true;
            }
            case '5': {
                return true;
            }
            case '6': {
                return true;
            }
            case '7': {
                return true;
            }
            case '8': {
                return true;
            }
            case '9': {
                return true;
            }
            case ':': {
                return true;
            }
            case ';': {
                return true;
            }
            case '<': {
                return false;
            }
            case '=': {
                return true;
            }
            case '>': {
                return false;
            }
            case '?': {
                return false;
            }
            case '@': {
                return false;
            }
            case 'A': {
                return true;
            }
            case 'B': {
                return true;
            }
            case 'C': {
                return true;
            }
            case 'D': {
                return true;
            }
            case 'E': {
                return true;
            }
            case 'F': {
                return true;
            }
            case 'G': {
                return true;
            }
            case 'H': {
                return true;
            }
            case 'I': {
                return true;
            }
            case 'J': {
                return true;
            }
            case 'K': {
                return true;
            }
            case 'L': {
                return true;
            }
            case 'M': {
                return true;
            }
            case 'N': {
                return true;
            }
            case 'O': {
                return true;
            }
            case 'P': {
                return true;
            }
            case 'Q': {
                return true;
            }
            case 'R': {
                return true;
            }
            case 'S': {
                return true;
            }
            case 'T': {
                return true;
            }
            case 'U': {
                return true;
            }
            case 'V': {
                return true;
            }
            case 'W': {
                return true;
            }
            case 'X': {
                return true;
            }
            case 'Y': {
                return true;
            }
            case 'Z': {
                return true;
            }
            case '[': {
                return false;
            }
            case '\\': {
                return false;
            }
            case ']': {
                return false;
            }
            case '^': {
                return false;
            }
            case '_': {
                return true;
            }
            case '`': {
                return false;
            }
            case 'a': {
                return true;
            }
            case 'b': {
                return true;
            }
            case 'c': {
                return true;
            }
            case 'd': {
                return true;
            }
            case 'e': {
                return true;
            }
            case 'f': {
                return true;
            }
            case 'g': {
                return true;
            }
            case 'h': {
                return true;
            }
            case 'i': {
                return true;
            }
            case 'j': {
                return true;
            }
            case 'k': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'm': {
                return true;
            }
            case 'n': {
                return true;
            }
            case 'o': {
                return true;
            }
            case 'p': {
                return true;
            }
            case 'q': {
                return true;
            }
            case 'r': {
                return true;
            }
            case 's': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'u': {
                return true;
            }
            case 'v': {
                return true;
            }
            case 'w': {
                return true;
            }
            case 'x': {
                return true;
            }
            case 'y': {
                return true;
            }
            case 'z': {
                return true;
            }
            case '{': {
                return false;
            }
            case '|': {
                return false;
            }
            case '}': {
                return false;
            }
            case '~': {
                return true;
            }
        }
        return false;
    }

    static void checkAbsoluteURI(String string) {
        URIUtil.ParsedURI parsedURI = new URIUtil.ParsedURI(string);
        try {
            if (parsedURI.scheme == null) {
                Verifier.throwMalformedURIException(string, "Missing scheme in absolute URI");
            }
            Verifier.checkScheme(parsedURI.scheme);
            if (parsedURI.authority != null) {
                Verifier.checkAuthority(parsedURI.authority);
            }
            Verifier.checkPath(parsedURI.path);
            if (parsedURI.fragment != null) {
                Verifier.throwMalformedURIException(string, "URIs cannot have fragment identifiers");
            }
            if (parsedURI.query != null) {
                Verifier.checkQuery(parsedURI.query);
            }
        }
        catch (MalformedURIException malformedURIException) {
            malformedURIException.setData(string);
            throw malformedURIException;
        }
    }

    static synchronized void checkInternalDTDSubset(String string) {
        Object object;
        if (parser == null) {
            object = new InputSource(new EmptyReader());
            parser = Builder.findParser(false);
            parser.setEntityResolver(new EntityResolver((InputSource)object){
                private final /* synthetic */ InputSource val$empty;
                {
                    this.val$empty = inputSource;
                }

                public InputSource resolveEntity(String string, String string2) {
                    return this.val$empty;
                }
            });
        }
        object = "<!DOCTYPE a [" + string + "]><a/>";
        try {
            InputSource inputSource = new InputSource(new StringReader((String)object));
            inputSource.setSystemId("http://www.example.org/");
            parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            IllegalDataException illegalDataException = new IllegalDataException("Malformed internal DTD subset: " + sAXException.getMessage(), sAXException);
            illegalDataException.setData(string);
            throw illegalDataException;
        }
        catch (IOException iOException) {
            throw new RuntimeException("BUG: I don't think this can happen");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ClassLoader classLoader = (class$nu$xom$Verifier == null ? (class$nu$xom$Verifier = Verifier.class$("nu.xom.Verifier")) : class$nu$xom$Verifier).getClassLoader();
        if (classLoader != null) {
            Verifier.loadFlags(classLoader);
        }
        if (flags == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            Verifier.loadFlags(classLoader);
        }
        C0Table = new boolean[33];
        Verifier.C0Table[10] = true;
        Verifier.C0Table[13] = true;
        Verifier.C0Table[9] = true;
        Verifier.C0Table[32] = true;
        cache = new URICache();
    }

    private static class EmptyReader
    extends Reader {
        private EmptyReader() {
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            return -1;
        }

        public void close() {
        }
    }

    private static final class URICache {
        private static final int LOAD = 6;
        private String[] cache = new String[6];
        private int position = 0;

        private URICache() {
        }

        synchronized boolean contains(String string) {
            for (int i2 = 0; i2 < 6; ++i2) {
                if (string != this.cache[i2]) continue;
                return true;
            }
            return false;
        }

        synchronized void put(String string) {
            this.cache[this.position] = string;
            ++this.position;
            if (this.position == 6) {
                this.position = 0;
            }
        }
    }
}

