/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ezmorph.MorphUtils;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.bean.MorphDynaBean;
import net.sf.ezmorph.bean.MorphDynaClass;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONString;
import net.sf.json.JsonConfig;
import net.sf.json.regexp.RegexpUtils;
import org.apache.commons.beanutils.DynaBean;

public final class JSONUtils {
    public static final String DOUBLE_QUOTE = "\"";
    public static final String SINGLE_QUOTE = "'";
    private static final String FUNCTION_BODY_PATTERN = "^function[ ]?\\(.*?\\)[ \n\t]*\\{(.*?)\\}$";
    private static final String FUNCTION_HEADER_PATTERN = "^function[ ]?\\(.*?\\)$";
    private static final String FUNCTION_PARAMS_PATTERN = "^function[ ]?\\((.*?)\\).*";
    private static final String FUNCTION_PATTERN = "^function[ ]?\\(.*?\\)[ \n\t]*\\{.*?\\}$";
    private static final String FUNCTION_PREFIX = "function";
    private static final MorpherRegistry morpherRegistry = new MorpherRegistry();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$net$sf$json$JSONFunction;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$net$sf$json$JSONArray;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Character;

    public static String convertToJavaIdentifier(String key) {
        return JSONUtils.convertToJavaIdentifier(key, new JsonConfig());
    }

    public static String convertToJavaIdentifier(String key, JsonConfig jsonConfig) {
        try {
            return jsonConfig.getJavaIdentifierTransformer().transformToJavaIdentifier(key);
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e2) {
            throw new JSONException(e2);
        }
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        String s = Double.toString(d2);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String getFunctionBody(String function) {
        return RegexpUtils.getMatcher(FUNCTION_BODY_PATTERN, true).getGroupIfMatches(function, 1);
    }

    public static String getFunctionParams(String function) {
        return RegexpUtils.getMatcher(FUNCTION_PARAMS_PATTERN, true).getGroupIfMatches(function, 1);
    }

    public static Class getInnerComponentType(Class type) {
        if (!type.isArray()) {
            return type;
        }
        return JSONUtils.getInnerComponentType(type.getComponentType());
    }

    public static MorpherRegistry getMorpherRegistry() {
        return morpherRegistry;
    }

    public static Map getProperties(JSONObject jsonObject) {
        HashMap<String, Class> properties = new HashMap<String, Class>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            properties.put(key, JSONUtils.getTypeClass(jsonObject.get(key)));
        }
        return properties;
    }

    public static Class getTypeClass(Object obj) {
        if (JSONUtils.isNull(obj)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = JSONUtils.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (JSONUtils.isArray(obj)) {
            return class$java$util$List == null ? (class$java$util$List = JSONUtils.class$("java.util.List")) : class$java$util$List;
        }
        if (JSONUtils.isFunction(obj)) {
            return class$net$sf$json$JSONFunction == null ? (class$net$sf$json$JSONFunction = JSONUtils.class$("net.sf.json.JSONFunction")) : class$net$sf$json$JSONFunction;
        }
        if (JSONUtils.isBoolean(obj)) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSONUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (JSONUtils.isNumber(obj)) {
            Number n = (Number)obj;
            if (JSONUtils.isInteger(n)) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = JSONUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (JSONUtils.isLong(n)) {
                return class$java$lang$Long == null ? (class$java$lang$Long = JSONUtils.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (JSONUtils.isFloat(n)) {
                return class$java$lang$Float == null ? (class$java$lang$Float = JSONUtils.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (JSONUtils.isBigInteger(n)) {
                return class$java$math$BigInteger == null ? (class$java$math$BigInteger = JSONUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger;
            }
            if (JSONUtils.isBigDecimal(n)) {
                return class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JSONUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
            }
            if (JSONUtils.isDouble(n)) {
                return class$java$lang$Double == null ? (class$java$lang$Double = JSONUtils.class$("java.lang.Double")) : class$java$lang$Double;
            }
            throw new JSONException("Unsupported type");
        }
        if (JSONUtils.isString(obj)) {
            return class$java$lang$String == null ? (class$java$lang$String = JSONUtils.class$("java.lang.String")) : class$java$lang$String;
        }
        if (JSONUtils.isObject(obj)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = JSONUtils.class$("java.lang.Object")) : class$java$lang$Object;
        }
        throw new JSONException("Unsupported type");
    }

    public static int hashCode(Object value) {
        if (value == null) {
            return JSONNull.getInstance().hashCode();
        }
        if (value instanceof JSON || value instanceof String || value instanceof JSONFunction) {
            return value.hashCode();
        }
        return String.valueOf(value).hashCode();
    }

    public static boolean isArray(Class clazz) {
        return clazz != null && (clazz.isArray() || (class$java$util$Collection == null ? (class$java$util$Collection = JSONUtils.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz) || (class$net$sf$json$JSONArray == null ? (class$net$sf$json$JSONArray = JSONUtils.class$("net.sf.json.JSONArray")) : class$net$sf$json$JSONArray).isAssignableFrom(clazz));
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray() || obj instanceof Collection || obj instanceof JSONArray;
    }

    public static boolean isBoolean(Class clazz) {
        return clazz != null && (Boolean.TYPE.isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSONUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz));
    }

    public static boolean isBoolean(Object obj) {
        return obj instanceof Boolean || obj != null && obj.getClass() == Boolean.TYPE;
    }

    public static boolean isDouble(Class clazz) {
        return clazz != null && (Double.TYPE.isAssignableFrom(clazz) || (class$java$lang$Double == null ? (class$java$lang$Double = JSONUtils.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz));
    }

    public static boolean isFunction(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return str.startsWith(FUNCTION_PREFIX) && RegexpUtils.getMatcher(FUNCTION_PATTERN, true).matches(str);
        }
        return obj instanceof JSONFunction;
    }

    public static boolean isFunctionHeader(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return str.startsWith(FUNCTION_PREFIX) && RegexpUtils.getMatcher(FUNCTION_HEADER_PATTERN, true).matches(str);
        }
        return false;
    }

    public static boolean isJavaIdentifier(String str) {
        if (str.length() == 0 || !Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < str.length(); ++i2) {
            if (Character.isJavaIdentifierPart(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNull(Object obj) {
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).isNullObject();
        }
        return JSONNull.getInstance().equals(obj);
    }

    public static boolean isNumber(Class clazz) {
        return clazz != null && (Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || (class$java$lang$Number == null ? (class$java$lang$Number = JSONUtils.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz));
    }

    public static boolean isNumber(Object obj) {
        if (obj != null && obj.getClass() == Byte.TYPE || obj != null && obj.getClass() == Short.TYPE || obj != null && obj.getClass() == Integer.TYPE || obj != null && obj.getClass() == Long.TYPE || obj != null && obj.getClass() == Float.TYPE || obj != null && obj.getClass() == Double.TYPE) {
            return true;
        }
        return obj instanceof Number;
    }

    public static boolean isObject(Object obj) {
        return !JSONUtils.isNumber(obj) && !JSONUtils.isString(obj) && !JSONUtils.isBoolean(obj) && !JSONUtils.isArray(obj) && !JSONUtils.isFunction(obj) || JSONUtils.isNull(obj);
    }

    public static boolean isString(Class clazz) {
        return clazz != null && ((class$java$lang$String == null ? (class$java$lang$String = JSONUtils.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || (class$java$lang$Character == null ? (class$java$lang$Character = JSONUtils.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz));
    }

    public static boolean isString(Object obj) {
        return obj instanceof String || obj instanceof Character || obj != null && (obj.getClass() == Character.TYPE || (class$java$lang$String == null ? (class$java$lang$String = JSONUtils.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(obj.getClass()));
    }

    public static boolean mayBeJSON(String string) {
        return string != null && ("null".equals(string) || string.startsWith("[") && string.endsWith("]") || string.startsWith("{") && string.endsWith("}"));
    }

    public static DynaBean newDynaBean(JSONObject jsonObject) {
        return JSONUtils.newDynaBean(jsonObject, new JsonConfig());
    }

    public static DynaBean newDynaBean(JSONObject jsonObject, JsonConfig jsonConfig) {
        Map props = JSONUtils.getProperties(jsonObject);
        Iterator entries = props.entrySet().iterator();
        while (entries.hasNext()) {
            String parsedKey;
            Map.Entry entry = entries.next();
            String key = (String)entry.getKey();
            if (JSONUtils.isJavaIdentifier(key) || (parsedKey = JSONUtils.convertToJavaIdentifier(key, jsonConfig)).compareTo(key) == 0) continue;
            props.put(parsedKey, props.remove(key));
        }
        MorphDynaClass dynaClass = new MorphDynaClass(props);
        MorphDynaBean dynaBean = null;
        try {
            dynaBean = (MorphDynaBean)dynaClass.newInstance();
            dynaBean.setDynaBeanClass(dynaClass);
        }
        catch (Exception e2) {
            throw new JSONException(e2);
        }
        return dynaBean;
    }

    public static String numberToString(Number n) {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        JSONUtils.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String quote(String string) {
        if (JSONUtils.isFunction(string)) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c2 = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len * 2);
        char[] chars = string.toCharArray();
        char[] buffer = new char[1030];
        int bufferIndex = 0;
        sb.append('\"');
        block11: for (int i2 = 0; i2 < len; ++i2) {
            if (bufferIndex > 1024) {
                sb.append(buffer, 0, bufferIndex);
                bufferIndex = 0;
            }
            char b2 = c2;
            c2 = chars[i2];
            switch (c2) {
                case '\"': 
                case '\\': {
                    buffer[bufferIndex++] = 92;
                    buffer[bufferIndex++] = c2;
                    continue block11;
                }
                case '/': {
                    if (b2 == '<') {
                        buffer[bufferIndex++] = 92;
                    }
                    buffer[bufferIndex++] = c2;
                    continue block11;
                }
                default: {
                    if (c2 < ' ') {
                        switch (c2) {
                            case '\b': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 98;
                                continue block11;
                            }
                            case '\t': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 116;
                                continue block11;
                            }
                            case '\n': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 110;
                                continue block11;
                            }
                            case '\f': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 102;
                                continue block11;
                            }
                            case '\r': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 114;
                                continue block11;
                            }
                        }
                        String t = "000" + Integer.toHexString(c2);
                        int tLength = t.length();
                        buffer[bufferIndex++] = 92;
                        buffer[bufferIndex++] = 117;
                        buffer[bufferIndex++] = t.charAt(tLength - 4);
                        buffer[bufferIndex++] = t.charAt(tLength - 3);
                        buffer[bufferIndex++] = t.charAt(tLength - 2);
                        buffer[bufferIndex++] = t.charAt(tLength - 1);
                        continue block11;
                    }
                    buffer[bufferIndex++] = c2;
                }
            }
        }
        sb.append(buffer, 0, bufferIndex);
        sb.append('\"');
        return sb.toString();
    }

    public static String stripQuotes(String input) {
        if (input.length() < 2) {
            return input;
        }
        if (input.startsWith(SINGLE_QUOTE) && input.endsWith(SINGLE_QUOTE)) {
            return input.substring(1, input.length() - 1);
        }
        if (input.startsWith(DOUBLE_QUOTE) && input.endsWith(DOUBLE_QUOTE)) {
            return input.substring(1, input.length() - 1);
        }
        return input;
    }

    public static boolean hasQuotes(String input) {
        if (input == null || input.length() < 2) {
            return false;
        }
        return input.startsWith(SINGLE_QUOTE) && input.endsWith(SINGLE_QUOTE) || input.startsWith(DOUBLE_QUOTE) && input.endsWith(DOUBLE_QUOTE);
    }

    public static boolean isJsonKeyword(String input, JsonConfig jsonConfig) {
        if (input == null) {
            return false;
        }
        return "null".equals(input) || "true".equals(input) || "false".equals(input) || jsonConfig.isJavascriptCompliant() && "undefined".equals(input);
    }

    public static void testValidity(Object o) {
        if (o != null) {
            if (o instanceof Double) {
                if (((Double)o).isInfinite() || ((Double)o).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers");
                }
            } else if (o instanceof Float) {
                if (((Float)o).isInfinite() || ((Float)o).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers.");
                }
            } else if (o instanceof BigDecimal || o instanceof BigInteger) {
                return;
            }
        }
    }

    public static Number transformNumber(Number input) {
        if (input instanceof Float) {
            return new Double(input.toString());
        }
        if (input instanceof Short) {
            return new Integer(input.intValue());
        }
        if (input instanceof Byte) {
            return new Integer(input.intValue());
        }
        if (input instanceof Long) {
            Long max = new Long(Integer.MAX_VALUE);
            if (input.longValue() <= max && input.longValue() >= Integer.MIN_VALUE) {
                return new Integer(input.intValue());
            }
        }
        return input;
    }

    public static String valueToString(Object value) {
        if (value == null || JSONUtils.isNull(value)) {
            return "null";
        }
        if (value instanceof JSONFunction) {
            return ((JSONFunction)value).toString();
        }
        if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e2) {
                throw new JSONException(e2);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return JSONUtils.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        return JSONUtils.quote(value.toString());
    }

    public static String valueToString(Object value, int indentFactor, int indent) {
        if (value == null || JSONUtils.isNull(value)) {
            return "null";
        }
        if (value instanceof JSONFunction) {
            return ((JSONFunction)value).toString();
        }
        if (value instanceof JSONString) {
            return ((JSONString)value).toJSONString();
        }
        if (value instanceof Number) {
            return JSONUtils.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        return JSONUtils.quote(value.toString());
    }

    private static boolean isBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return true;
        }
        try {
            new BigDecimal(String.valueOf(n));
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private static boolean isBigInteger(Number n) {
        if (n instanceof BigInteger) {
            return true;
        }
        try {
            new BigInteger(String.valueOf(n));
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private static boolean isDouble(Number n) {
        if (n instanceof Double) {
            return true;
        }
        try {
            double d2 = Double.parseDouble(String.valueOf(n));
            return !Double.isInfinite(d2);
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private static boolean isFloat(Number n) {
        if (n instanceof Float) {
            return true;
        }
        try {
            float f2 = Float.parseFloat(String.valueOf(n));
            return !Float.isInfinite(f2);
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private static boolean isInteger(Number n) {
        if (n instanceof Integer) {
            return true;
        }
        try {
            Integer.parseInt(String.valueOf(n));
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private static boolean isLong(Number n) {
        if (n instanceof Long) {
            return true;
        }
        try {
            Long.parseLong(String.valueOf(n));
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    private JSONUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MorphUtils.registerStandardMorphers(morpherRegistry);
    }
}

