/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.form;

import com.rscja.deviceapi.entity.ReaderIPEntity;
import com.rscja.deviceapi.entity.WifiConfig;
import com.uhf.UHFMainForm;
import com.uhf.utils.StringUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class WifiAndInterForm
extends JPanel {
    private final Map<String, Integer> IS_STATIC_IP_MAP = new HashMap<String, Integer>(){
        {
            this.put("Dynamic", 0);
            this.put("Static", 1);
        }
    };
    private final String[] tableColumnName = new String[]{"INDEX", "SSID", "BSSID", "Status", "Security Type"};
    private final DefaultTableModel tableModel = new DefaultTableModel(this.tableColumnName, 0);
    private ListSelectionListener selectionListener;
    private JPanel panel1;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JTextField tfEthernetIP;
    private JTextField tfEthernetGateway;
    private JTextField tfEthernetSubnetMask;
    private JTextField tfEthernetDNS1;
    private JTextField tfEthernetDNS2;
    private JButton btnEthernetSet;
    private JButton btnEthernetGet;
    private JCheckBox cboxEthernetIpSelfIncrease;
    private JPanel panel2;
    private JLabel label6;
    private JTextField tfPort;
    private JButton btnPortSet;
    private JPanel panel3;
    private JLabel label7;
    private JLabel labWifiPassword;
    private JLabel lWifiSafeMode;
    private JLabel label10;
    private JTextField tfWifiSSID;
    private JTextField tfWifiPassword;
    private JComboBox<String> cbWifiSecurityType;
    private JComboBox<String> cbWifiProxy;
    private JCheckBox cboxStaticIP;
    private JLabel labWifiIP;
    private JTextField tfWifiIP;
    private JLabel labWifiGateway;
    private JLabel labWifiSubnetMask;
    private JLabel labWifiDNS1;
    private JLabel labWifiDNS2;
    private JTextField tfWifiDNS2;
    private JTextField tfWifiDNS1;
    private JTextField tfWifiSubnetMask;
    private JTextField tfWifiGateway;
    private JButton btnWifiSet;
    private JButton btnWifiGet;
    private JCheckBox cboxWifiIpSelfIncrease;
    private JScrollPane scrollPane1;
    private JTable table;
    private JButton btnOpenWifi;
    private JButton btnCloseWifi;
    private JButton btnClear;
    private JButton btnGetWifiInfo;

    public WifiAndInterForm() {
        this.initComponents();
        this.initUI();
    }

    private void initUI() {
        this.table.setModel(this.tableModel);
        DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();
        tcr.setHorizontalAlignment(0);
        this.table.setDefaultRenderer(Object.class, tcr);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(300);
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                WifiAndInterForm.this.tfWifiSSID.setText((String)WifiAndInterForm.this.tableModel.getValueAt(WifiAndInterForm.this.table.getSelectedRow(), 1));
                String securityType = (String)WifiAndInterForm.this.tableModel.getValueAt(WifiAndInterForm.this.table.getSelectedRow(), 4);
                if (securityType.contains("WEP")) {
                    WifiAndInterForm.this.cbWifiSecurityType.setSelectedIndex(0);
                } else if (securityType.contains("WPA")) {
                    WifiAndInterForm.this.cbWifiSecurityType.setSelectedIndex(1);
                } else if (securityType.contains("NOPASS")) {
                    WifiAndInterForm.this.cbWifiSecurityType.setSelectedIndex(2);
                } else {
                    WifiAndInterForm.this.cbWifiSecurityType.setSelectedIndex(3);
                }
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
    }

    private boolean verifyIPConfig(String ip, String gateWay, String subNetMask, String dns1, String dns2) {
        if (!StringUtils.isIPAddress(ip)) {
            JOptionPane.showMessageDialog(this, "The IP address is invalid!", "", 0);
            return false;
        }
        if (!StringUtils.isIPAddress(gateWay)) {
            JOptionPane.showMessageDialog(this, "The Gateway is invalid!", "", 0);
            return false;
        }
        if (!StringUtils.isIPAddress(subNetMask)) {
            JOptionPane.showMessageDialog(this, "The Subnet Mask is invalid!", "", 0);
            return false;
        }
        if (!StringUtils.isIPAddress(dns1)) {
            JOptionPane.showMessageDialog(this, "The DNS1 is invalid!", "", 0);
            return false;
        }
        if (!dns2.equals("") && !StringUtils.isIPAddress(dns2)) {
            JOptionPane.showMessageDialog(this, "The DNS2 is invalid!", "", 0);
            return false;
        }
        return true;
    }

    private String IPIncrease(String ip) {
        String[] ips = ip.split("\\.");
        String res = "";
        try {
            int ip0 = Integer.parseInt(ips[0]);
            int ip1 = Integer.parseInt(ips[1]);
            int ip2 = Integer.parseInt(ips[2]);
            int ip3 = Integer.parseInt(ips[3]) + 1;
            if (ip3 >= 256) {
                ip3 = 0;
                if (++ip2 >= 256) {
                    ip2 = 0;
                    if (++ip1 >= 256) {
                        ip1 = 0;
                        if (++ip0 >= 256) {
                            ip0 = 0;
                        }
                    }
                }
            }
            res = "" + ip0 + "." + ip1 + "." + ip2 + "." + ip3;
        }
        catch (Exception e2) {
            return "";
        }
        return res;
    }

    private void btnEthernetSetActionPerformed(ActionEvent e2) {
        if (!this.verifyIPConfig(this.tfEthernetIP.getText(), this.tfEthernetGateway.getText(), this.tfEthernetSubnetMask.getText(), this.tfEthernetDNS1.getText(), this.tfEthernetDNS2.getText())) {
            return;
        }
        ReaderIPEntity ipConfig = new ReaderIPEntity();
        ipConfig.setIp(this.tfEthernetIP.getText());
        ipConfig.setGateway(this.tfEthernetGateway.getText());
        ipConfig.setSubnetMask(this.tfEthernetSubnetMask.getText());
        ipConfig.setDns1(this.tfEthernetDNS1.getText());
        ipConfig.setDns2(this.tfEthernetDNS2.getText());
        boolean result = UHFMainForm.ur4.setEthernetConfigInfo(ipConfig);
        if (result) {
            JOptionPane.showMessageDialog(this, "Set Success!", "", 1);
            if (this.cboxEthernetIpSelfIncrease.isSelected()) {
                this.tfEthernetIP.setText(this.IPIncrease(this.tfEthernetIP.getText()));
            }
        } else {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", 0);
        }
    }

    private void btnEthernetGetActionPerformed(ActionEvent e2) {
        String ethIpConfig = UHFMainForm.ur4.getEthernetIpConfig();
        if (ethIpConfig != null && !ethIpConfig.isEmpty()) {
            try {
                JSONObject jsonObject = JSONObject.fromObject(ethIpConfig);
                this.tfEthernetIP.setText((String)jsonObject.get("ip"));
                this.tfEthernetGateway.setText((String)jsonObject.get("gateway"));
                this.tfEthernetSubnetMask.setText((String)jsonObject.get("subnetMask"));
                this.tfEthernetDNS1.setText((String)jsonObject.get("dns1"));
                this.tfEthernetDNS2.setText((String)jsonObject.get("dsn2"));
            }
            catch (Exception e1) {
                System.out.println("ex:" + e1.toString());
            }
        } else {
            JOptionPane.showMessageDialog(this, "fail", "", 0);
        }
    }

    private void btnPortSetActionPerformed(ActionEvent e2) {
        int port;
        try {
            port = Integer.parseInt(this.tfPort.getText());
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "The Port is invalid!", "", 0);
            return;
        }
        boolean result = UHFMainForm.ur4.setTcpServicePort(port);
        if (result) {
            JOptionPane.showMessageDialog(this, "Set Success!", "", 1);
        } else {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", 0);
        }
    }

    private void btnWifiSetActionPerformed(ActionEvent e2) {
        boolean result;
        if (this.tfWifiSSID.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "The SSID is invalid!", "", 0);
            return;
        }
        if (this.tfWifiPassword.isEnabled() && this.tfWifiPassword.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "The Password is invalid!!", "", 0);
            return;
        }
        WifiConfig wifiConfig = new WifiConfig();
        wifiConfig.setSsid(this.tfWifiSSID.getText());
        if (this.tfWifiPassword.isEnabled()) {
            wifiConfig.setPassword(this.tfWifiPassword.getText());
        }
        wifiConfig.setSecurityType(this.cbWifiSecurityType.getSelectedIndex());
        wifiConfig.setProxy(this.cbWifiProxy.getSelectedIndex());
        if (this.cboxStaticIP.isSelected()) {
            ReaderIPEntity staticIPConfig = new ReaderIPEntity();
            if (!this.verifyIPConfig(this.tfWifiIP.getText(), this.tfWifiGateway.getText(), this.tfWifiSubnetMask.getText(), this.tfWifiDNS1.getText(), this.tfWifiDNS2.getText())) {
                return;
            }
            staticIPConfig.setIp(this.tfWifiIP.getText());
            staticIPConfig.setGateway(this.tfWifiGateway.getText());
            staticIPConfig.setSubnetMask(this.tfWifiSubnetMask.getText());
            staticIPConfig.setDns1(this.tfWifiDNS1.getText());
            staticIPConfig.setDns2(this.tfWifiDNS2.getText());
            wifiConfig.setStaticIp(true);
            wifiConfig.setStaticIpConfig(staticIPConfig);
        }
        if (result = UHFMainForm.ur4.setWifiConfigInfo(wifiConfig)) {
            JOptionPane.showMessageDialog(this, "Set Success!", "", 1);
            if (this.cboxWifiIpSelfIncrease.isSelected() && this.cboxStaticIP.isSelected()) {
                this.tfWifiIP.setText(this.IPIncrease(this.tfWifiIP.getText()));
            }
        } else {
            JOptionPane.showMessageDialog(this, "Set Failed!", "", 0);
        }
    }

    private void btnWifiGetActionPerformed(ActionEvent e2) {
        String wifiIpConfig = UHFMainForm.ur4.getWifiIpConfig();
        System.out.println("WifiIpConfig\uff1a" + wifiIpConfig);
        if (wifiIpConfig != null && !wifiIpConfig.isEmpty()) {
            try {
                JSONObject jsonObject = JSONObject.fromObject(wifiIpConfig);
                this.tfWifiSSID.setText((String)jsonObject.get("ssid"));
                this.tfWifiIP.setText((String)jsonObject.get("ip"));
                this.tfWifiGateway.setText((String)jsonObject.get("gateway"));
                this.tfWifiSubnetMask.setText((String)jsonObject.get("subnetMask"));
                this.tfWifiDNS1.setText((String)jsonObject.get("dns1"));
                this.tfWifiDNS2.setText((String)jsonObject.get("dns2"));
            }
            catch (Exception e1) {
                System.out.println("ex:" + e1.toString());
            }
        } else {
            JOptionPane.showMessageDialog(this, "fail", "", 0);
        }
    }

    private void btnOpenWifiActionPerformed(ActionEvent e2) {
        boolean result = UHFMainForm.ur4.openWifi();
        if (result) {
            JOptionPane.showMessageDialog(this, "Success!", "", 1);
        } else {
            JOptionPane.showMessageDialog(this, "Failed!", "", 0);
        }
    }

    private void btnCloseWifiActionPerformed(ActionEvent e2) {
        boolean result = UHFMainForm.ur4.closeWifi();
        if (result) {
            JOptionPane.showMessageDialog(this, "Success!", "", 1);
        } else {
            JOptionPane.showMessageDialog(this, "Failed!", "", 0);
        }
    }

    private void btnGetWifiInfoActionPerformed(ActionEvent e2) {
        this.btnClearActionPerformed(null);
        String wifiInfo = UHFMainForm.ur4.GetWifiInfo();
        if (wifiInfo != null && !wifiInfo.isEmpty()) {
            try {
                JSONArray jsonArray = JSONArray.fromObject(wifiInfo);
                for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
                    JSONObject jsonObject = JSONObject.fromObject(jsonArray.get(i2));
                    Object[] column = new String[]{String.valueOf(i2 + 1), (String)jsonObject.get("ssid"), (String)jsonObject.get("bssid"), (String)jsonObject.get("state"), (String)jsonObject.get("securityType")};
                    this.tableModel.addRow(column);
                }
                this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, "Failed", "", 0);
                e1.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Failed", "", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnClearActionPerformed(ActionEvent e2) {
        this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.table.clearSelection();
        for (int i2 = this.tableModel.getRowCount() - 1; i2 >= 0; --i2) {
            DefaultTableModel defaultTableModel = this.tableModel;
            synchronized (defaultTableModel) {
                this.tableModel.removeRow(i2);
                continue;
            }
        }
    }

    private void cbWifiSecurityTypeItemStateChanged(ItemEvent e2) {
        if (e2.getItem().equals("WEP")) {
            this.labWifiPassword.setEnabled(false);
            this.tfWifiPassword.setText("");
            this.tfWifiPassword.setEnabled(false);
        } else {
            this.labWifiPassword.setEnabled(true);
            this.tfWifiPassword.setEnabled(true);
        }
    }

    private void cboxStaticIPItemStateChanged(ItemEvent e2) {
        if (this.cboxStaticIP.isSelected()) {
            this.labWifiIP.setEnabled(true);
            this.labWifiGateway.setEnabled(true);
            this.labWifiSubnetMask.setEnabled(true);
            this.labWifiDNS1.setEnabled(true);
            this.labWifiDNS2.setEnabled(true);
            this.tfWifiIP.setEnabled(true);
            this.tfWifiGateway.setEnabled(true);
            this.tfWifiSubnetMask.setEnabled(true);
            this.tfWifiDNS1.setEnabled(true);
            this.tfWifiDNS2.setEnabled(true);
        } else {
            this.labWifiIP.setEnabled(false);
            this.labWifiGateway.setEnabled(false);
            this.labWifiSubnetMask.setEnabled(false);
            this.labWifiDNS1.setEnabled(false);
            this.labWifiDNS2.setEnabled(false);
            this.tfWifiIP.setEnabled(false);
            this.tfWifiGateway.setEnabled(false);
            this.tfWifiSubnetMask.setEnabled(false);
            this.tfWifiDNS1.setEnabled(false);
            this.tfWifiDNS2.setEnabled(false);
        }
    }

    private void initComponents() {
        Rectangle bounds;
        this.panel1 = new JPanel();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.label4 = new JLabel();
        this.label5 = new JLabel();
        this.tfEthernetIP = new JTextField();
        this.tfEthernetGateway = new JTextField();
        this.tfEthernetSubnetMask = new JTextField();
        this.tfEthernetDNS1 = new JTextField();
        this.tfEthernetDNS2 = new JTextField();
        this.btnEthernetSet = new JButton();
        this.btnEthernetGet = new JButton();
        this.cboxEthernetIpSelfIncrease = new JCheckBox();
        this.panel2 = new JPanel();
        this.label6 = new JLabel();
        this.tfPort = new JTextField();
        this.btnPortSet = new JButton();
        this.panel3 = new JPanel();
        this.label7 = new JLabel();
        this.labWifiPassword = new JLabel();
        this.lWifiSafeMode = new JLabel();
        this.label10 = new JLabel();
        this.tfWifiSSID = new JTextField();
        this.tfWifiPassword = new JTextField();
        this.cbWifiSecurityType = new JComboBox();
        this.cbWifiProxy = new JComboBox();
        this.cboxStaticIP = new JCheckBox();
        this.labWifiIP = new JLabel();
        this.tfWifiIP = new JTextField();
        this.labWifiGateway = new JLabel();
        this.labWifiSubnetMask = new JLabel();
        this.labWifiDNS1 = new JLabel();
        this.labWifiDNS2 = new JLabel();
        this.tfWifiDNS2 = new JTextField();
        this.tfWifiDNS1 = new JTextField();
        this.tfWifiSubnetMask = new JTextField();
        this.tfWifiGateway = new JTextField();
        this.btnWifiSet = new JButton();
        this.btnWifiGet = new JButton();
        this.cboxWifiIpSelfIncrease = new JCheckBox();
        this.scrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.btnOpenWifi = new JButton();
        this.btnCloseWifi = new JButton();
        this.btnClear = new JButton();
        this.btnGetWifiInfo = new JButton();
        this.setLayout(null);
        this.panel1.setBorder(new TitledBorder("Ethernet"));
        this.panel1.setToolTipText("333");
        this.panel1.setLayout(null);
        this.label1.setText("IP\uff1a");
        this.panel1.add(this.label1);
        this.label1.setBounds(new Rectangle(new Point(20, 30), this.label1.getPreferredSize()));
        this.label2.setText("Gateway\uff1a");
        this.panel1.add(this.label2);
        this.label2.setBounds(new Rectangle(new Point(20, 60), this.label2.getPreferredSize()));
        this.label3.setText("SubnetMask\uff1a");
        this.panel1.add(this.label3);
        this.label3.setBounds(new Rectangle(new Point(20, 90), this.label3.getPreferredSize()));
        this.label4.setText("DNS1\uff1a");
        this.panel1.add(this.label4);
        this.label4.setBounds(new Rectangle(new Point(20, 120), this.label4.getPreferredSize()));
        this.label5.setText("DNS2\uff1a");
        this.panel1.add(this.label5);
        this.label5.setBounds(new Rectangle(new Point(20, 150), this.label5.getPreferredSize()));
        this.tfEthernetIP.setText("192.168.1.100");
        this.panel1.add(this.tfEthernetIP);
        this.tfEthernetIP.setBounds(100, 25, 175, this.tfEthernetIP.getPreferredSize().height);
        this.tfEthernetGateway.setText("192.168.1.1");
        this.panel1.add(this.tfEthernetGateway);
        this.tfEthernetGateway.setBounds(100, 55, 175, this.tfEthernetGateway.getPreferredSize().height);
        this.tfEthernetSubnetMask.setText("255.255.255.0");
        this.panel1.add(this.tfEthernetSubnetMask);
        this.tfEthernetSubnetMask.setBounds(100, 85, 175, this.tfEthernetSubnetMask.getPreferredSize().height);
        this.tfEthernetDNS1.setText("192.168.99.1");
        this.panel1.add(this.tfEthernetDNS1);
        this.tfEthernetDNS1.setBounds(100, 115, 175, this.tfEthernetDNS1.getPreferredSize().height);
        this.panel1.add(this.tfEthernetDNS2);
        this.tfEthernetDNS2.setBounds(100, 145, 175, this.tfEthernetDNS2.getPreferredSize().height);
        this.btnEthernetSet.setText("Set");
        this.btnEthernetSet.addActionListener(e2 -> this.btnEthernetSetActionPerformed(e2));
        this.panel1.add(this.btnEthernetSet);
        this.btnEthernetSet.setBounds(130, 185, 65, this.btnEthernetSet.getPreferredSize().height);
        this.btnEthernetGet.setText("Get");
        this.btnEthernetGet.addActionListener(e2 -> this.btnEthernetGetActionPerformed(e2));
        this.panel1.add(this.btnEthernetGet);
        this.btnEthernetGet.setBounds(210, 185, 65, this.btnEthernetGet.getPreferredSize().height);
        this.cboxEthernetIpSelfIncrease.setText("IP self-increase");
        this.panel1.add(this.cboxEthernetIpSelfIncrease);
        this.cboxEthernetIpSelfIncrease.setBounds(new Rectangle(new Point(15, 190), this.cboxEthernetIpSelfIncrease.getPreferredSize()));
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.panel1.getComponentCount(); ++i2) {
            bounds = this.panel1.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.panel1.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel1.setMinimumSize(preferredSize);
        this.panel1.setPreferredSize(preferredSize);
        this.add(this.panel1);
        this.panel1.setBounds(10, 15, 285, 225);
        this.panel2.setBorder(new TitledBorder("Port"));
        this.panel2.setLayout(null);
        this.label6.setText("port\uff1a");
        this.panel2.add(this.label6);
        this.label6.setBounds(new Rectangle(new Point(20, 30), this.label6.getPreferredSize()));
        this.tfPort.setText("9160");
        this.panel2.add(this.tfPort);
        this.tfPort.setBounds(80, 25, 155, this.tfPort.getPreferredSize().height);
        this.btnPortSet.setText("Set");
        this.btnPortSet.addActionListener(e2 -> this.btnPortSetActionPerformed(e2));
        this.panel2.add(this.btnPortSet);
        this.btnPortSet.setBounds(270, 25, 100, this.btnPortSet.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i3 = 0; i3 < this.panel2.getComponentCount(); ++i3) {
            bounds = this.panel2.getComponent(i3).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel2.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel2.setMinimumSize(preferredSize);
        this.panel2.setPreferredSize(preferredSize);
        this.add(this.panel2);
        this.panel2.setBounds(10, 250, 900, 65);
        this.panel3.setBorder(new TitledBorder("WiFi"));
        this.panel3.setLayout(null);
        this.label7.setText("SSID\uff1a");
        this.panel3.add(this.label7);
        this.label7.setBounds(new Rectangle(new Point(20, 30), this.label7.getPreferredSize()));
        this.labWifiPassword.setText("Password:");
        this.panel3.add(this.labWifiPassword);
        this.labWifiPassword.setBounds(new Rectangle(new Point(20, 60), this.labWifiPassword.getPreferredSize()));
        this.lWifiSafeMode.setText("Safe Mode:");
        this.panel3.add(this.lWifiSafeMode);
        this.lWifiSafeMode.setBounds(new Rectangle(new Point(20, 90), this.lWifiSafeMode.getPreferredSize()));
        this.label10.setText("Proxy:");
        this.panel3.add(this.label10);
        this.label10.setBounds(new Rectangle(new Point(20, 120), this.label10.getPreferredSize()));
        this.panel3.add(this.tfWifiSSID);
        this.tfWifiSSID.setBounds(90, 25, 155, this.tfWifiSSID.getPreferredSize().height);
        this.panel3.add(this.tfWifiPassword);
        this.tfWifiPassword.setBounds(90, 55, 155, this.tfWifiPassword.getPreferredSize().height);
        this.cbWifiSecurityType.setModel(new DefaultComboBoxModel<String>(new String[]{"WEP", "WPA", "NOPASS", "INVALID"}));
        this.cbWifiSecurityType.setSelectedIndex(1);
        this.cbWifiSecurityType.addItemListener(e2 -> this.cbWifiSecurityTypeItemStateChanged(e2));
        this.panel3.add(this.cbWifiSecurityType);
        this.cbWifiSecurityType.setBounds(90, 85, 155, this.cbWifiSecurityType.getPreferredSize().height);
        this.cbWifiProxy.setModel(new DefaultComboBoxModel<String>(new String[]{"NO", "Manual", "Auto"}));
        this.panel3.add(this.cbWifiProxy);
        this.cbWifiProxy.setBounds(90, 115, 155, this.cbWifiProxy.getPreferredSize().height);
        this.cboxStaticIP.setText("Static IP");
        this.cboxStaticIP.setSelected(true);
        this.cboxStaticIP.addItemListener(e2 -> this.cboxStaticIPItemStateChanged(e2));
        this.panel3.add(this.cboxStaticIP);
        this.cboxStaticIP.setBounds(new Rectangle(new Point(140, 150), this.cboxStaticIP.getPreferredSize()));
        this.labWifiIP.setText("IP\uff1a");
        this.panel3.add(this.labWifiIP);
        this.labWifiIP.setBounds(new Rectangle(new Point(290, 30), this.labWifiIP.getPreferredSize()));
        this.tfWifiIP.setText("192.168.1.100");
        this.panel3.add(this.tfWifiIP);
        this.tfWifiIP.setBounds(370, 25, 155, this.tfWifiIP.getPreferredSize().height);
        this.labWifiGateway.setText("Gateway\uff1a");
        this.panel3.add(this.labWifiGateway);
        this.labWifiGateway.setBounds(new Rectangle(new Point(290, 60), this.labWifiGateway.getPreferredSize()));
        this.labWifiSubnetMask.setText("SubnetMask\uff1a");
        this.panel3.add(this.labWifiSubnetMask);
        this.labWifiSubnetMask.setBounds(new Rectangle(new Point(290, 90), this.labWifiSubnetMask.getPreferredSize()));
        this.labWifiDNS1.setText("DNS1\uff1a");
        this.panel3.add(this.labWifiDNS1);
        this.labWifiDNS1.setBounds(new Rectangle(new Point(290, 120), this.labWifiDNS1.getPreferredSize()));
        this.labWifiDNS2.setText("DNS2\uff1a");
        this.panel3.add(this.labWifiDNS2);
        this.labWifiDNS2.setBounds(new Rectangle(new Point(290, 150), this.labWifiDNS2.getPreferredSize()));
        this.panel3.add(this.tfWifiDNS2);
        this.tfWifiDNS2.setBounds(370, 145, 155, this.tfWifiDNS2.getPreferredSize().height);
        this.tfWifiDNS1.setText("192.168.99.1");
        this.panel3.add(this.tfWifiDNS1);
        this.tfWifiDNS1.setBounds(370, 115, 155, this.tfWifiDNS1.getPreferredSize().height);
        this.tfWifiSubnetMask.setText("255.255.255.0");
        this.panel3.add(this.tfWifiSubnetMask);
        this.tfWifiSubnetMask.setBounds(370, 85, 155, this.tfWifiSubnetMask.getPreferredSize().height);
        this.tfWifiGateway.setText("192.168.1.1");
        this.panel3.add(this.tfWifiGateway);
        this.tfWifiGateway.setBounds(370, 55, 155, this.tfWifiGateway.getPreferredSize().height);
        this.btnWifiSet.setText("Set");
        this.btnWifiSet.addActionListener(e2 -> this.btnWifiSetActionPerformed(e2));
        this.panel3.add(this.btnWifiSet);
        this.btnWifiSet.setBounds(20, 185, 95, this.btnWifiSet.getPreferredSize().height);
        this.btnWifiGet.setText("Get");
        this.btnWifiGet.addActionListener(e2 -> this.btnWifiGetActionPerformed(e2));
        this.panel3.add(this.btnWifiGet);
        this.btnWifiGet.setBounds(140, 185, 95, this.btnWifiGet.getPreferredSize().height);
        this.cboxWifiIpSelfIncrease.setText("IP self-increase");
        this.panel3.add(this.cboxWifiIpSelfIncrease);
        this.cboxWifiIpSelfIncrease.setBounds(new Rectangle(new Point(20, 150), this.cboxWifiIpSelfIncrease.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i4 = 0; i4 < this.panel3.getComponentCount(); ++i4) {
            bounds = this.panel3.getComponent(i4).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel3.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel3.setMinimumSize(preferredSize);
        this.panel3.setPreferredSize(preferredSize);
        this.add(this.panel3);
        this.panel3.setBounds(305, 15, 605, 225);
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"INDEX", "SSID", "BSSID", "Status", "Security Type"}));
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setMaxWidth(100);
        cm.getColumn(4).setMinWidth(200);
        this.scrollPane1.setViewportView(this.table);
        this.add(this.scrollPane1);
        this.scrollPane1.setBounds(10, 330, 900, 290);
        this.btnOpenWifi.setText("OPEN WiFi");
        this.btnOpenWifi.setFont(this.btnOpenWifi.getFont().deriveFont((float)this.btnOpenWifi.getFont().getSize() + 2.0f));
        this.btnOpenWifi.addActionListener(e2 -> this.btnOpenWifiActionPerformed(e2));
        this.add(this.btnOpenWifi);
        this.btnOpenWifi.setBounds(930, 330, 150, this.btnOpenWifi.getPreferredSize().height);
        this.btnCloseWifi.setText("CLOSE WiFi");
        this.btnCloseWifi.setFont(this.btnCloseWifi.getFont().deriveFont((float)this.btnCloseWifi.getFont().getSize() + 2.0f));
        this.btnCloseWifi.addActionListener(e2 -> this.btnCloseWifiActionPerformed(e2));
        this.add(this.btnCloseWifi);
        this.btnCloseWifi.setBounds(930, 375, 150, this.btnCloseWifi.getPreferredSize().height);
        this.btnClear.setText("CLEAR");
        this.btnClear.setFont(this.btnClear.getFont().deriveFont((float)this.btnClear.getFont().getSize() + 2.0f));
        this.btnClear.addActionListener(e2 -> this.btnClearActionPerformed(e2));
        this.add(this.btnClear);
        this.btnClear.setBounds(930, 465, 150, this.btnClear.getPreferredSize().height);
        this.btnGetWifiInfo.setText("GET WiFi LIST");
        this.btnGetWifiInfo.setFont(this.btnGetWifiInfo.getFont().deriveFont((float)this.btnGetWifiInfo.getFont().getSize() + 2.0f));
        this.btnGetWifiInfo.addActionListener(e2 -> this.btnGetWifiInfoActionPerformed(e2));
        this.add(this.btnGetWifiInfo);
        this.btnGetWifiInfo.setBounds(930, 420, 150, this.btnGetWifiInfo.getPreferredSize().height);
        this.setPreferredSize(new Dimension(1090, 630));
    }
}

