/*
 * Decompiled with CFR 0.152.
 */
package com.uhf;

import com.rscja.deviceapi.ConnectionState;
import com.rscja.deviceapi.RFIDWithUHFNetworkA4;
import com.rscja.deviceapi.RFIDWithUHFSerialPortA4;
import com.rscja.deviceapi.interfaces.ConnectionStateCallback;
import com.rscja.deviceapi.interfaces.IUHFA4;
import com.uhf.form.ConfigForm;
import com.uhf.form.FirmwareUpgradeForm;
import com.uhf.form.GPIOForm;
import com.uhf.form.IPv6Form;
import com.uhf.form.InventoryForm;
import com.uhf.form.LockKillForm;
import com.uhf.form.ReadWriteForm;
import com.uhf.form.TemperatureForm;
import com.uhf.form.UHFInfoForm;
import com.uhf.form.WifiAndInterForm;
import com.uhf.utils.StringUtils;
import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;

public class UHFMainForm
extends JFrame {
    public static IUHFA4 ur4 = null;
    RFIDWithUHFNetworkA4 ur4Network = null;
    RFIDWithUHFSerialPortA4 ur4SerialPort = null;
    ArrayList<JPanel> formList = new ArrayList();
    InventoryForm inventoryForm = new InventoryForm();
    ReadWriteForm readWriteForm = new ReadWriteForm();
    ConfigForm configForm = new ConfigForm();
    LockKillForm lockKillForm = new LockKillForm();
    UHFInfoForm uhfInfoForm = new UHFInfoForm();
    TemperatureForm temperatureForm = new TemperatureForm();
    FirmwareUpgradeForm upgradeForm = new FirmwareUpgradeForm();
    GPIOForm gpioForm = new GPIOForm();
    WifiAndInterForm wifiAndInterForm = new WifiAndInterForm();
    IPv6Form iPv6Form = new IPv6Form();
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel3;
    private JPanel panel1;
    private JTabbedPane tabPane;
    private JPanel panel5;
    private JPanel panel6;
    private JComboBox<String> cmbCommunicationMode;
    private JLabel label1;
    private JPanel panelSerialPort;
    private JLabel label3;
    private JComboBox cmbPortNumber;
    private JPanel panelNetWork;
    private JLabel label2;
    private JTextField txtIP;
    private JLabel label4;
    private JTextField txtPort;
    private JButton btnConnect;

    public static void main(String[] args) {
        UHFMainForm frame = new UHFMainForm();
        frame.setVisible(true);
    }

    public UHFMainForm() {
        this.initComponents();
        this.initUI();
    }

    private void initUI() {
        this.tabPane.addTab("Inventory", null, this.inventoryForm, null);
        this.tabPane.addTab("Read Write", null, this.readWriteForm, null);
        this.tabPane.addTab("Config", null, this.configForm, null);
        this.tabPane.addTab("Lock-Destroy", null, this.lockKillForm, null);
        this.tabPane.addTab("Version", null, this.uhfInfoForm, null);
        this.tabPane.addTab("Temperature", null, this.temperatureForm, null);
        this.tabPane.addTab("Upgrade", null, this.upgradeForm, null);
        this.tabPane.addTab("GPIO", null, this.gpioForm, null);
        this.tabPane.addTab("Wifi-Ethernet", null, this.wifiAndInterForm, null);
        this.tabPane.addTab("Current IP", null, this.iPv6Form, null);
        this.tabPane.setTitleAt(0, "Inventory");
        this.tabPane.setTitleAt(1, "Read Write");
        this.tabPane.setTitleAt(2, "Config");
        this.tabPane.setTitleAt(3, "Lock-Destroy");
        this.tabPane.setTitleAt(4, "Version");
        this.tabPane.setTitleAt(5, "Temperature");
        this.tabPane.setTitleAt(6, "Upgrade");
        this.tabPane.setTitleAt(7, "GPIO");
        this.tabPane.setTitleAt(8, "Wifi-Ethernet");
        this.tabPane.setTitleAt(9, "Current IP");
        this.formList.add(this.inventoryForm);
        this.formList.add(this.readWriteForm);
        this.formList.add(this.configForm);
        this.formList.add(this.lockKillForm);
        this.formList.add(this.uhfInfoForm);
        this.formList.add(this.temperatureForm);
        this.formList.add(this.upgradeForm);
        this.cmbCommunicationMode.setSelectedIndex(0);
        this.cmbCommunicationModeActionPerformed(null);
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            this.cmbPortNumber.addItem("/dev/ttyS1");
            this.cmbPortNumber.addItem("/dev/ttyS2");
            this.cmbPortNumber.addItem("/dev/ttyS3");
            this.cmbPortNumber.addItem("/dev/ttyUSB0");
            this.cmbPortNumber.addItem("/dev/ttyUSB1");
            this.cmbPortNumber.addItem("/dev/ttyUSB2");
            this.cmbPortNumber.addItem("/dev/ttyUSB3");
        }
    }

    private void tabPaneStateChanged(ChangeEvent e2) {
        int index = this.tabPane.getSelectedIndex();
        for (int i2 = 0; i2 < this.formList.size(); ++i2) {
            if (i2 == index) {
                this.formList.get(i2).setVisible(true);
                continue;
            }
            this.formList.get(i2).setVisible(false);
        }
    }

    private void btnConnectActionPerformed(ActionEvent e2) {
        if (this.btnConnect.getText().equals("Connect")) {
            if (ur4 instanceof RFIDWithUHFSerialPortA4) {
                String com = (String)this.cmbPortNumber.getSelectedItem();
                boolean rsult = this.ur4SerialPort.init(com);
                if (!rsult) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Failed to open the serial port!", "", 0);
                    return;
                }
                this.btnConnect.setText("Disconnect");
                this.cmbCommunicationMode.setEnabled(false);
                this.cmbPortNumber.setEnabled(false);
            } else {
                String ip = this.txtIP.getText();
                String port = this.txtPort.getText();
                if (!StringUtils.isIPAddress(ip)) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "The IP address is illegal!", "", 0);
                    return;
                }
                if (StringUtils.isEmpty(port)) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "The Port cannot be empty!", "", 0);
                    return;
                }
                boolean rsult = this.ur4Network.init(ip, Integer.parseInt(port));
                if (!rsult) {
                    JOptionPane.showMessageDialog(this.getContentPane(), "Connect failed!", "", 0);
                    return;
                }
                this.btnConnect.setText("Disconnect");
                this.cmbCommunicationMode.setEnabled(false);
                this.txtIP.setEnabled(false);
                this.txtPort.setEnabled(false);
            }
        } else {
            if (this.inventoryForm.isVisible()) {
                this.inventoryForm.stopInventory();
            }
            ur4.free();
            this.btnConnect.setText("Connect");
            this.txtIP.setEnabled(true);
            this.txtPort.setEnabled(true);
            this.cmbPortNumber.setEnabled(true);
            this.cmbCommunicationMode.setEnabled(true);
        }
    }

    private void cmbCommunicationModeActionPerformed(ActionEvent e2) {
        if (this.cmbCommunicationMode.getSelectedIndex() == 0) {
            ArrayList<String> comList = this.getComList();
            this.cmbPortNumber.removeAllItems();
            for (String item : comList) {
                this.cmbPortNumber.addItem(item);
            }
            System.out.println("serial port");
            this.panelSerialPort.setVisible(true);
            this.panelNetWork.setVisible(false);
            if (this.ur4SerialPort == null) {
                this.ur4SerialPort = new RFIDWithUHFSerialPortA4();
            }
            ur4 = this.ur4SerialPort;
            this.ur4SerialPort.setConnectionStateCallback(new ConnectionStateCallback(){

                @Override
                public void getState(ConnectionState connectionState, Object o) {
                    if (connectionState == ConnectionState.DISCONNECTED) {
                        System.out.println("\u8fde\u63a5\u65ad\u5f00");
                        if (UHFMainForm.this.inventoryForm.isVisible()) {
                            UHFMainForm.this.inventoryForm.stopInventory();
                        }
                        ur4.free();
                        UHFMainForm.this.btnConnect.setText("Connect");
                        UHFMainForm.this.txtIP.setEnabled(true);
                        UHFMainForm.this.txtPort.setEnabled(true);
                        UHFMainForm.this.cmbPortNumber.setEnabled(true);
                        UHFMainForm.this.cmbCommunicationMode.setEnabled(true);
                    }
                }
            });
        } else if (this.cmbCommunicationMode.getSelectedIndex() == 1) {
            System.out.println("network");
            this.panelSerialPort.setVisible(false);
            this.panelNetWork.setVisible(true);
            if (this.ur4Network == null) {
                this.ur4Network = new RFIDWithUHFNetworkA4();
            }
            ur4 = this.ur4Network;
            this.ur4Network.setConnectionStateCallback(new ConnectionStateCallback(){

                @Override
                public void getState(ConnectionState connectionState, Object o) {
                    if (connectionState == ConnectionState.DISCONNECTED) {
                        if (UHFMainForm.this.inventoryForm.isVisible()) {
                            UHFMainForm.this.inventoryForm.stopInventory();
                        }
                        ur4.free();
                        UHFMainForm.this.btnConnect.setText("Connect");
                        UHFMainForm.this.txtIP.setEnabled(true);
                        UHFMainForm.this.txtPort.setEnabled(true);
                        UHFMainForm.this.cmbPortNumber.setEnabled(true);
                        UHFMainForm.this.cmbCommunicationMode.setEnabled(true);
                    }
                }
            });
        }
    }

    public ArrayList<String> getComList() {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> list = new ArrayList<String>();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1) continue;
            list.add(portId.getName());
        }
        if (list != null && list.size() == 0) {
            list = null;
        }
        return list;
    }

    private void initComponents() {
        Rectangle bounds;
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel3 = new JPanel();
        this.panel1 = new JPanel();
        this.tabPane = new JTabbedPane();
        this.panel5 = new JPanel();
        this.panel6 = new JPanel();
        this.cmbCommunicationMode = new JComboBox();
        this.label1 = new JLabel();
        this.panelSerialPort = new JPanel();
        this.label3 = new JLabel();
        this.cmbPortNumber = new JComboBox();
        this.panelNetWork = new JPanel();
        this.label2 = new JLabel();
        this.txtIP = new JTextField();
        this.label4 = new JLabel();
        this.txtPort = new JTextField();
        this.btnConnect = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setBackground(new Color(238, 238, 238));
        this.contentPanel.setLayout(null);
        this.panel3.setLayout(null);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.panel3.getComponentCount(); ++i2) {
            bounds = this.panel3.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.panel3.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel3.setMinimumSize(preferredSize);
        this.panel3.setPreferredSize(preferredSize);
        this.contentPanel.add(this.panel3);
        this.panel3.setBounds(10, 240, this.panel3.getPreferredSize().width, 285);
        this.panel1.setLayout(null);
        preferredSize = new Dimension();
        for (int i3 = 0; i3 < this.panel1.getComponentCount(); ++i3) {
            bounds = this.panel1.getComponent(i3).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel1.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel1.setMinimumSize(preferredSize);
        this.panel1.setPreferredSize(preferredSize);
        this.contentPanel.add(this.panel1);
        this.panel1.setBounds(new Rectangle(new Point(300, 40), this.panel1.getPreferredSize()));
        this.tabPane.setTabLayoutPolicy(1);
        this.tabPane.addChangeListener(e2 -> this.tabPaneStateChanged(e2));
        this.contentPanel.add(this.tabPane);
        this.tabPane.setBounds(5, 80, 1105, 655);
        this.panel5.setLayout(null);
        preferredSize = new Dimension();
        for (int i4 = 0; i4 < this.panel5.getComponentCount(); ++i4) {
            bounds = this.panel5.getComponent(i4).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel5.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel5.setMinimumSize(preferredSize);
        this.panel5.setPreferredSize(preferredSize);
        this.contentPanel.add(this.panel5);
        this.panel5.setBounds(new Rectangle(new Point(25, 90), this.panel5.getPreferredSize()));
        this.panel6.setBackground(new Color(138, 154, 249));
        this.panel6.setLayout(null);
        this.cmbCommunicationMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Serial Port", "Network Port"}));
        this.cmbCommunicationMode.addActionListener(e2 -> this.cmbCommunicationModeActionPerformed(e2));
        this.panel6.add(this.cmbCommunicationMode);
        this.cmbCommunicationMode.setBounds(155, 20, 155, this.cmbCommunicationMode.getPreferredSize().height);
        this.label1.setText("Communication Mode:");
        this.panel6.add(this.label1);
        this.label1.setBounds(new Rectangle(new Point(20, 25), this.label1.getPreferredSize()));
        this.panelSerialPort.setBackground(new Color(138, 154, 249));
        this.panelSerialPort.setLayout(null);
        this.label3.setText("Serial Port:");
        this.panelSerialPort.add(this.label3);
        this.label3.setBounds(new Rectangle(new Point(5, 15), this.label3.getPreferredSize()));
        this.panelSerialPort.add(this.cmbPortNumber);
        this.cmbPortNumber.setBounds(85, 5, 115, 30);
        preferredSize = new Dimension();
        for (int i5 = 0; i5 < this.panelSerialPort.getComponentCount(); ++i5) {
            bounds = this.panelSerialPort.getComponent(i5).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panelSerialPort.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panelSerialPort.setMinimumSize(preferredSize);
        this.panelSerialPort.setPreferredSize(preferredSize);
        this.panel6.add(this.panelSerialPort);
        this.panelSerialPort.setBounds(330, 10, 210, 45);
        this.panelNetWork.setBackground(new Color(138, 154, 249));
        this.panelNetWork.setLayout(null);
        this.label2.setText("IP:");
        this.panelNetWork.add(this.label2);
        this.label2.setBounds(new Rectangle(new Point(5, 15), this.label2.getPreferredSize()));
        this.txtIP.setText("192.168.1.100");
        this.panelNetWork.add(this.txtIP);
        this.txtIP.setBounds(25, 10, 210, this.txtIP.getPreferredSize().height);
        this.label4.setText("Port:");
        this.panelNetWork.add(this.label4);
        this.label4.setBounds(245, 15, this.label4.getPreferredSize().width, 17);
        this.txtPort.setText("9160");
        this.panelNetWork.add(this.txtPort);
        this.txtPort.setBounds(280, 10, 75, this.txtPort.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i6 = 0; i6 < this.panelNetWork.getComponentCount(); ++i6) {
            bounds = this.panelNetWork.getComponent(i6).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panelNetWork.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panelNetWork.setMinimumSize(preferredSize);
        this.panelNetWork.setPreferredSize(preferredSize);
        this.panel6.add(this.panelNetWork);
        this.panelNetWork.setBounds(555, 10, 360, 45);
        this.btnConnect.setText("Connect");
        this.btnConnect.setBackground(new Color(238, 238, 238));
        this.btnConnect.addActionListener(e2 -> this.btnConnectActionPerformed(e2));
        this.panel6.add(this.btnConnect);
        this.btnConnect.setBounds(945, 15, 115, 40);
        preferredSize = new Dimension();
        for (int i7 = 0; i7 < this.panel6.getComponentCount(); ++i7) {
            bounds = this.panel6.getComponent(i7).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel6.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel6.setMinimumSize(preferredSize);
        this.panel6.setPreferredSize(preferredSize);
        this.contentPanel.add(this.panel6);
        this.panel6.setBounds(-10, -5, 1115, 80);
        preferredSize = new Dimension();
        for (int i8 = 0; i8 < this.contentPanel.getComponentCount(); ++i8) {
            bounds = this.contentPanel.getComponent(i8).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.dialogPane.add((Component)this.contentPanel, "North");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

