/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.utility;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class StringUtility {
    public static boolean DEBUG = false;
    public static String TAG = "DeviceAPI_";

    public static String byte2Bit(byte by) {
        return "" + (byte)(by >> 7 & 1) + (byte)(by >> 6 & 1) + (byte)(by >> 5 & 1) + (byte)(by >> 4 & 1) + (byte)(by >> 3 & 1) + (byte)(by >> 2 & 1) + (byte)(by >> 1 & 1) + (byte)(by & 1);
    }

    public static byte BitToByte(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.length();
        if (n != 4 && n != 8) {
            return 0;
        }
        int n2 = n == 8 && string.charAt(0) != '0' ? Integer.parseInt(string, 2) - 256 : Integer.parseInt(string, 2);
        return (byte)n2;
    }

    public static String bytes2HexString(byte by) {
        String string = Integer.toHexString(by & 0xFF);
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    public static String bytes2HexString(byte[] byArray, int n) {
        String string = "";
        try {
            for (int i2 = 0; i2 < n; ++i2) {
                String string2 = Integer.toHexString(byArray[i2] & 0xFF);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                string = string + string2.toUpperCase();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String bytes2HexString2(byte[] byArray, int n) {
        if (byArray == null || byArray.length == 0 || byArray.length < n) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (int i2 = 0; i2 < n; ++i2) {
                String string = Integer.toHexString(byArray[i2] & 0xFF);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuilder.append(string.toUpperCase());
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public static String bytes2HexString(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0 || byArray.length < n + n2) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (int i2 = n; i2 < n + n2; ++i2) {
                String string = Integer.toHexString(byArray[i2] & 0xFF);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuilder.append(string.toUpperCase());
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public static String bytes2HexString(byte[] byArray) {
        return StringUtility.bytes2HexString(byArray, byArray.length);
    }

    public static String bytesToHexString(byte[] byArray, int n) {
        String string = "";
        try {
            for (int i2 = 0; i2 < n; ++i2) {
                String string2 = StringUtility.byte2HexString(byArray[i2]);
                string = string + string2;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static byte[] charsTobytes(char[] cArray, int n) {
        if (cArray == null || cArray.length == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        try {
            for (int i2 = 0; i2 < n; ++i2) {
                byArray[i2] = (byte)cArray[i2];
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public static char[] bytesTochars(byte[] byArray, int n) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        char[] cArray = new char[n];
        try {
            for (int i2 = 0; i2 < n; ++i2) {
                cArray[i2] = (char)(byArray[i2] & 0xFF);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return cArray;
    }

    public static String byte2HexString(byte by) {
        String string = "";
        try {
            String string2 = Integer.toHexString(by & 0xFF);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            string = string + string2.toUpperCase();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String chars2HexString(char[] cArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i2 = 0; i2 < n; ++i2) {
                char c2 = cArray[i2];
                String string = Integer.toHexString(c2);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                stringBuffer.append(string.toUpperCase());
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static byte[] long2Bytes(long l2) {
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            int n = 64 - (i2 + 1 << 3);
            byArray[i2] = (byte)(l2 >> n & 0xFFL);
        }
        return byArray;
    }

    public static byte[] int2Bytes(int n) {
        byte[] byArray = new byte[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2 = 32 - (i2 + 1 << 3);
            byArray[i2] = (byte)(n >> n2);
        }
        return byArray;
    }

    public static long byteArrayTolong(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        int n = 7;
        int n2 = byArray.length - 1;
        while (n >= 0) {
            byArray2[n] = n2 >= 0 ? byArray[n2] : (byte)0;
            --n;
            --n2;
        }
        long l2 = (long)(byArray2[0] & 0xFF) << 56;
        long l3 = (long)(byArray2[1] & 0xFF) << 48;
        long l4 = (long)(byArray2[2] & 0xFF) << 40;
        long l5 = (long)(byArray2[3] & 0xFF) << 32;
        long l6 = (long)(byArray2[4] & 0xFF) << 24;
        long l7 = (long)(byArray2[5] & 0xFF) << 16;
        long l8 = (long)(byArray2[6] & 0xFF) << 8;
        long l9 = byArray2[7] & 0xFF;
        return l2 | l3 | l4 | l5 | l6 | l7 | l8 | l9;
    }

    public static int bytesToInt(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        n |= byArray[1] << 8 & 0xFF00;
        n |= byArray[2] << 16 & 0xFF0000;
        return n |= byArray[3] << 24 & 0xFF000000;
    }

    public static byte[] Int2bytes(int n) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)Integer.parseInt("" + (n >>> 24), 16);
        byArray2[1] = (byte)Integer.parseInt("" + (n >> 16 & 0xFF), 16);
        byArray2[2] = (byte)Integer.parseInt("" + (n >> 8 & 0xFF), 16);
        byArray2[3] = (byte)Integer.parseInt("" + (n & 0xFF), 16);
        for (n = 0; n < 4; ++n) {
            System.out.println("Int2bytes() bytes = " + String.format("%02x", byArray2[n]));
        }
        return byArray2;
    }

    public static long charArrayTolong(char[] cArray) {
        char[] cArray2 = new char[8];
        int n = 7;
        int n2 = cArray.length - 1;
        while (n >= 0) {
            cArray2[n] = n2 >= 0 ? cArray[n2] : (char)'\u0000';
            --n;
            --n2;
        }
        long l2 = (long)(cArray2[0] & 0xFF) << 56;
        long l3 = (long)(cArray2[1] & 0xFF) << 48;
        long l4 = (long)(cArray2[2] & 0xFF) << 40;
        long l5 = (long)(cArray2[3] & 0xFF) << 32;
        long l6 = (long)(cArray2[4] & 0xFF) << 24;
        long l7 = (long)(cArray2[5] & 0xFF) << 16;
        long l8 = (long)(cArray2[6] & 0xFF) << 8;
        long l9 = cArray2[7] & 0xFF;
        System.out.println(l2 + "@" + l3 + "@" + l4 + "@" + l5 + "@" + l6 + "@" + l7 + "@" + l8 + "@" + l9);
        return l2 | l3 | l4 | l5 | l6 | l7 | l8 | l9;
    }

    public static byte[] reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - 1 - i2];
        }
        return byArray2;
    }

    private static final BigInteger readUnsignedShort(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 2) {
            return new BigInteger("0");
        }
        byte[] byArray2 = new byte[3];
        byte[] byArray3 = byArray2;
        byArray2[2] = 0;
        System.arraycopy(byArray, 0, byArray3, 0, 2);
        return new BigInteger(StringUtility.reverse(byArray3));
    }

    public static final BigInteger readUnsignedInt64(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 8) {
            return new BigInteger("0");
        }
        byte[] byArray2 = new byte[9];
        byte[] byArray3 = byArray2;
        byArray2[8] = 0;
        System.arraycopy(byArray, 0, byArray3, 0, 8);
        return new BigInteger(StringUtility.reverse(byArray3));
    }

    public static long chars2Long(char[] objectArray, int n, int n2) {
        objectArray = StringUtility.getBytes(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            System.out.println("chars2Long bytes[i]:" + objectArray[n]);
        }
        return StringUtility.byteArrayTolong((byte[])objectArray);
    }

    public static String char2HexString(char c2) {
        char[] cArray = new char[1];
        char[] cArray2 = cArray;
        cArray[0] = c2;
        return StringUtility.chars2HexString(cArray2, 1);
    }

    public static boolean isOctNumber(String string) {
        boolean bl = false;
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c2 = string.charAt(i2);
            if (!(c2 == '0' | c2 == '1' | c2 == '2' | c2 == '3' | c2 == '4' | c2 == '5' | c2 == '6' | c2 == '7' | c2 == '8' | c2 == '9')) continue;
            bl = true;
        }
        return bl;
    }

    @Deprecated
    public static boolean isHexNumber(String string) {
        boolean bl = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '0' && c2 != '1' && c2 != '2' && c2 != '3' && c2 != '4' && c2 != '5' && c2 != '6' && c2 != '7' && c2 != '8' && c2 != '9' && c2 != 'A' && c2 != 'B' && c2 != 'C' && c2 != 'D' && c2 != 'E' && c2 != 'F' && c2 != 'a' && c2 != 'b' && c2 != 'c' && c2 != 'c' && c2 != 'd' && c2 != 'e' && c2 != 'f') continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isOctNumberRex(String string) {
        String string2 = "\\d+";
        return string.matches(string2);
    }

    public static boolean isHexNumberRex(String string) {
        String string2 = "(?i)[0-9a-f]+";
        return string.matches(string2);
    }

    public static char[] hexString2Chars(String string) {
        string = string.replace(" ", "");
        char[] cArray = new char[string.length() / 2];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = (char)Integer.parseInt(string.substring(2 * i2, 2 * i2 + 2), 16);
        }
        return cArray;
    }

    public static byte[] getBytes(char[] object) {
        Charset charset = Charset.forName("UTF-8");
        CharBuffer charBuffer = CharBuffer.allocate(((char[])object).length);
        charBuffer.put((char[])object);
        charBuffer.flip();
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        object = byteBuffer;
        return byteBuffer.array();
    }

    public static char[] getChars(byte[] object) {
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer = ByteBuffer.allocate(((byte[])object).length);
        byteBuffer.put((byte[])object);
        byteBuffer.flip();
        CharBuffer charBuffer = charset.decode(byteBuffer);
        object = charBuffer;
        return charBuffer.array();
    }

    public static boolean isDecimal(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c2;
            if ((c2 = string.charAt(n2++)) >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    public static byte[] hexString2Bytes(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)Integer.parseInt(string.substring(2 * i2, 2 * i2 + 2), 16);
        }
        return byArray;
    }

    public static byte[] hexStringToBytes(String object) {
        if (object == null || ((String)object).equals("")) {
            return null;
        }
        object = ((String)object).toUpperCase();
        int n = ((String)object).length() / 2;
        object = ((String)object).toCharArray();
        byte[] byArray = new byte[n];
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = i2 << 1;
            byArray[i2] = (byte)(StringUtility.charToByte((char)object[n2]) << 4 | StringUtility.charToByte((char)object[n2 + 1]));
        }
        return byArray;
    }

    private static byte charToByte(char c2) {
        return (byte)"0123456789ABCDEF".indexOf(c2);
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isNum(String string) {
        return string.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
    }

    public static String int2HexString(int n) {
        String string = Integer.toHexString(n);
        int n2 = string.length();
        if (n2 == 1) {
            return "0" + string;
        }
        return string.substring(n2 - 2, n2);
    }

    public static String ints2HexString(int[] nArray, int n) {
        String string = "";
        try {
            for (int i2 = 0; i2 < n; ++i2) {
                int n2 = nArray[i2];
                String string2 = Integer.toHexString(n2);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                string = string + string2.toUpperCase();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static boolean isIPAddress(String string) {
        if (StringUtility.isEmpty(string)) {
            return false;
        }
        return string.matches("([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}");
    }

    public static int string2Int(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static void setDebug(boolean bl) {
        DEBUG = bl;
    }
}

