/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi.linux.usb;

import com.rscja.deviceapi.ConnectionState;
import com.rscja.deviceapi.RFIDWithUHFBase;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.InventoryModeEntity$Builder;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.ConnectionStateCallback;
import com.rscja.deviceapi.interfaces.ISingleAntenna;
import com.rscja.deviceapi.interfaces.IUHF;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.deviceapi.linux.LinuxUHFAndHFAPI;
import com.rscja.deviceapi.linux.a;
import com.rscja.deviceapi.linux.usb.UsbLinux$InventoryThread;
import com.rscja.utility.StringUtility;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UsbLinux
extends RFIDWithUHFBase
implements ISingleAntenna,
IUHF {
    private static final String TAG = StringUtility.TAG + "UHF";
    private static UsbLinux single = null;
    private boolean DEBUG = StringUtility.DEBUG;
    private IUHFInventoryCallback inventoryCallback;
    private int isFilterRepeatBank = 0;
    private UsbLinux$InventoryThread inventoryThread = null;
    protected boolean isRuning = false;
    private ConnectionState connectionState = ConnectionState.DISCONNECTED;
    protected List<UHFTAGInfo> uhfinfoList = null;
    private LinuxUHFAndHFAPI linuxUHFAndHFAPI = null;
    private ConnectionStateCallback btStateCallback;
    private byte[] tempBuffData = new byte[150];
    private int[] buffLen = new int[10];
    private byte zero = 0;

    public UsbLinux(File file) {
        if (file != null) {
            a.a().a(file.getAbsolutePath());
        } else {
            a.a().a(a.a);
        }
        this.linuxUHFAndHFAPI = a.a().c();
    }

    @Override
    public boolean init(String string) {
        if (this.linuxUHFAndHFAPI.UsbOpen() == 0) {
            this.connectionState = ConnectionState.CONNECTED;
            this.setPowerOn(true);
            return true;
        }
        return false;
    }

    @Override
    public void setConnectionStateCallback(ConnectionStateCallback connectionStateCallback) {
        this.btStateCallback = connectionStateCallback;
    }

    @Override
    public boolean free() {
        this.stopInventory();
        this.linuxUHFAndHFAPI.UsbClose();
        this.connectionState = ConnectionState.DISCONNECTED;
        return true;
    }

    @Override
    public String getVersion() {
        byte[] byArray = new byte[50];
        if (this.linuxUHFAndHFAPI.UHFGetSoftwareVersion(byArray) == 0) {
            byte by = byArray[0];
            byArray = Arrays.copyOfRange(byArray, 1, by + 1);
            return new String(byArray);
        }
        return null;
    }

    @Override
    public int getPower() {
        byte[] byArray = new byte[1];
        if (this.linuxUHFAndHFAPI.UHFGetPower(byArray) == 0) {
            return byArray[0];
        }
        return -1;
    }

    @Override
    public boolean setPower(int n) {
        return this.linuxUHFAndHFAPI.UHFSetPower((byte)1, (byte)n) == 0;
    }

    @Override
    public int getFrequencyMode() {
        byte[] byArray = new byte[1];
        if (this.linuxUHFAndHFAPI.UHFGetRegion(byArray) == 0) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public boolean setFrequencyMode(byte by) {
        return this.linuxUHFAndHFAPI.UHFSetRegion((byte)1, by) == 0;
    }

    @Override
    public boolean startInventoryTag() {
        if (this.isRuning) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (this.uhfinfoList != null) {
            this.uhfinfoList.clear();
        }
        if (this.linuxUHFAndHFAPI.UHFInventory() == 0) {
            this.isRuning = true;
            this.startInventoryThread();
            return true;
        }
        return false;
    }

    @Override
    public UHFTAGInfo readTagFromBuffer() {
        Arrays.fill(this.buffLen, 0);
        Arrays.fill(this.tempBuffData, this.zero);
        if (this.linuxUHFAndHFAPI.UHF_GetReceived_EX(this.buffLen, this.tempBuffData) == 0) {
            byte[] byArray = null;
            byte by = this.tempBuffData[0];
            byte by2 = this.tempBuffData[by + 1];
            int n = by + 2;
            int n2 = n + by2;
            int n3 = n2 + 2;
            Object object = Arrays.copyOfRange(this.tempBuffData, 1, by + 1);
            Arrays.copyOfRange(object, 0, 2);
            byte[] byArray2 = Arrays.copyOfRange(object, 2, ((byte[])object).length);
            object = StringUtility.bytes2HexString(byArray2);
            if (by2 > 12) {
                int n4 = n;
                byArray = Arrays.copyOfRange(this.tempBuffData, n4, n4 + 12);
                Arrays.copyOfRange(this.tempBuffData, n + 12, n2);
            } else if (by2 > 0) {
                byArray = Arrays.copyOfRange(this.tempBuffData, n, n2);
            }
            byte[] byArray3 = Arrays.copyOfRange(this.tempBuffData, n2, n3);
            int n5 = 65535 - (byArray3[1] & 0xFF | (byArray3[0] & 0xFF) << 8);
            float f2 = (float)n5 / 10.0f;
            String string = "N/A";
            if (f2 < 200.0f && f2 > 0.0f) {
                DecimalFormat decimalFormat = new DecimalFormat("##0.00");
                string = "-" + decimalFormat.format(f2);
            }
            UHFTAGInfo uHFTAGInfo = new UHFTAGInfo();
            uHFTAGInfo.setEPC((String)object);
            uHFTAGInfo.setEpcBytes(byArray2);
            if (byArray != null) {
                uHFTAGInfo.setTid(StringUtility.bytes2HexString(byArray));
            }
            uHFTAGInfo.setTidBytes(byArray);
            uHFTAGInfo.setUser(null);
            uHFTAGInfo.setRssi(string);
            return uHFTAGInfo;
        }
        return null;
    }

    @Override
    public boolean stopInventory() {
        boolean bl = false;
        if (this.linuxUHFAndHFAPI.UHFStopGet() == 0) {
            bl = true;
        }
        this.isRuning = false;
        this.stopInventoryThread();
        return bl;
    }

    @Override
    public boolean lockMem(String object, int n, int n2, int n3, String object2, String object3) {
        return this.linuxUHFAndHFAPI.UHFLockTag((byte[])(object = (Object)StringUtility.hexString2Bytes((String)object)), (byte)n, n2, n3, (byte[])(object2 = n3 == 0 ? (Object)new byte[1] : (Object)StringUtility.hexString2Bytes((String)object2)), (byte[])(object3 = (Object)StringUtility.hexString2Bytes((String)object3))) == 0;
    }

    @Override
    public boolean lockMem(String string, String string2) {
        return this.lockMem(string, 1, 0, 0, null, string2);
    }

    @Override
    public UHFTAGInfo inventorySingleTag() {
        byte[] byArray = new byte[10];
        byte[] byArray2 = new byte[256];
        if (this.linuxUHFAndHFAPI.UHFInventorySingle(byArray, byArray2) == 0) {
            byte[] byArray3 = null;
            byte by = byArray2[0];
            byte by2 = byArray2[by + 1];
            int n = by + 2;
            int n2 = n + by2;
            int n3 = n2 + 2;
            Object object = Arrays.copyOfRange(byArray2, 1, by + 1);
            Arrays.copyOfRange(object, 0, 2);
            byte[] byArray4 = Arrays.copyOfRange(object, 2, ((byte[])object).length);
            object = StringUtility.bytes2HexString(byArray4);
            if (by2 > 12) {
                int n4 = n;
                byArray3 = Arrays.copyOfRange(byArray2, n4, n4 + 12);
                Arrays.copyOfRange(byArray2, n + 12, n2);
            } else if (by2 > 0) {
                byArray3 = Arrays.copyOfRange(byArray2, n, n2);
            }
            byArray2 = Arrays.copyOfRange(byArray2, n2, n3);
            int n5 = (byArray2[1] | byArray2[0] << 8) - 65535;
            float f2 = (float)(65535 - n5) / 10.0f;
            String string = "N/A";
            if (f2 < 200.0f && f2 > 0.0f) {
                DecimalFormat decimalFormat = new DecimalFormat("##0.00");
                string = "-" + decimalFormat.format(f2);
            }
            UHFTAGInfo uHFTAGInfo = new UHFTAGInfo();
            uHFTAGInfo.setEPC((String)object);
            uHFTAGInfo.setEpcBytes(byArray4);
            uHFTAGInfo.setTid(null);
            uHFTAGInfo.setTidBytes(byArray3);
            uHFTAGInfo.setUser(null);
            uHFTAGInfo.setRssi(string);
            return uHFTAGInfo;
        }
        return null;
    }

    @Override
    public String readData(String string, int n, int n2, int n3) {
        return this.readData(string, 0, 0, 0, "00", n, n2, n3);
    }

    @Override
    public String readData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6) {
        try {
            Object object3 = new StringBuilder();
            ((StringBuilder)object3).append("\r\n\u5bc6\u7801\uff1a" + (String)object);
            ((StringBuilder)object3).append("\r\n\u8fc7\u6ee4\u6570\u636e\u5757\uff08 1\uff1aEPC, 2:TID, 3:USR\uff09\uff1a" + n);
            ((StringBuilder)object3).append("\r\n\u8fc7\u6ee4\u8d77\u59cb\u5730\u5740\uff1a" + n2);
            ((StringBuilder)object3).append("\r\n\u8fc7\u6ee4\u957f\u5ea6\uff1a" + n3);
            ((StringBuilder)object3).append("\r\n\u8fc7\u6ee4\u6570\u636e\uff1a" + (String)object2);
            ((StringBuilder)object3).append("\r\n");
            ((StringBuilder)object3).append("\r\n\u8bfb\u53d6\u7684\u6570\u636e\u5757\uff1a" + n4);
            ((StringBuilder)object3).append("\r\n\u8bfb\u53d6\u7684\u6570\u636e\u8d77\u59cb\u5730\u5740\uff1a" + n5);
            ((StringBuilder)object3).append("\r\n\u8bfb\u53d6\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n6);
            ((StringBuilder)object3).append("\r\n");
            object = StringUtility.hexString2Bytes((String)object);
            n = (byte)n;
            n2 = (byte)n2;
            n3 = (byte)n3;
            object2 = StringUtility.hexString2Bytes((String)object2);
            n4 = (byte)n4;
            object3 = new byte[1024];
            int n7 = this.linuxUHFAndHFAPI.UHFReadData((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte)n4, n5, n6, (byte[])object3);
            if (n7 == 0) {
                return StringUtility.bytes2HexString(Arrays.copyOf((byte[])object3, n6 << 1));
            }
        }
        catch (Exception exception) {
            System.out.println("readData ex=" + exception.toString());
        }
        return null;
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2) {
        return this.writeData(string, 0, 0, 0, "00", n, n2, n3, string2);
    }

    @Override
    public boolean writeData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6, String object3) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\r\n\u5bc6\u7801\uff1a" + (String)object);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\u5757\uff08 1\uff1aEPC, 2:TID, 3:USR\uff09\uff1a" + n);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u8d77\u59cb\u5730\u5740\uff1a" + n2);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u957f\u5ea6\uff1a" + n3);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\uff1a" + (String)object2);
            stringBuilder.append("\r\n");
            stringBuilder.append("\r\n\u5199\u7684\u6570\u636e\u5757\uff1a" + n4);
            stringBuilder.append("\r\n\u5199\u7684\u6570\u636e\u8d77\u59cb\u5730\u5740\uff1a" + n5);
            stringBuilder.append("\r\n\u5199\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n6);
            stringBuilder.append("\r\n");
            object = StringUtility.hexString2Bytes((String)object);
            n = (byte)n;
            n2 = (byte)n2;
            n3 = (byte)n3;
            object2 = StringUtility.hexString2Bytes((String)object2);
            n4 = (byte)n4;
            n6 = (byte)n6;
            object3 = StringUtility.hexString2Bytes((String)object3);
            int n7 = this.linuxUHFAndHFAPI.UHFWriteData((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte)n4, n5, (byte)n6, (byte[])object3);
            if (n7 == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("writeData ex=" + exception.toString());
        }
        return false;
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String string2) {
        return this.blockWriteData(string, 0, 0, 0, "00", n, n2, n3, string2);
    }

    @Override
    public boolean blockWriteData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6, String object3) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\r\n\u5bc6\u7801\uff1a" + (String)object);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\u5757\uff08 1\uff1aEPC, 2:TID, 3:USR\uff09\uff1a" + n);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u8d77\u59cb\u5730\u5740\uff1a" + n2);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u957f\u5ea6\uff1a" + n3);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\uff1a" + (String)object2);
            stringBuilder.append("\r\n");
            stringBuilder.append("\r\nblock\u5199\u7684\u6570\u636e\u5757\uff1a" + n4);
            stringBuilder.append("\r\nblock\u5199\u7684\u6570\u636e\u8d77\u59cb\u5730\u5740\uff1a" + n5);
            stringBuilder.append("\r\nblock\u5199\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n6);
            stringBuilder.append("\r\n");
            object = StringUtility.hexString2Bytes((String)object);
            n = (byte)n;
            n2 = (byte)n2;
            n3 = (byte)n3;
            object2 = StringUtility.hexString2Bytes((String)object2);
            n4 = (byte)n4;
            n6 = (byte)n6;
            object3 = StringUtility.hexString2Bytes((String)object3);
            int n7 = this.linuxUHFAndHFAPI.UHFBlockWriteData((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte)n4, n5, n6, (byte[])object3);
            if (n7 == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("blockWriteData ex=" + exception.toString());
        }
        return false;
    }

    @Override
    public boolean eraseData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\r\n\u5bc6\u7801\uff1a" + (String)object);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\u5757\uff08 1\uff1aEPC, 2:TID, 3:USR\uff09\uff1a" + n);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u8d77\u59cb\u5730\u5740\uff1a" + n2);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u957f\u5ea6\uff1a" + n3);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\uff1a" + (String)object2);
            stringBuilder.append("\r\n");
            stringBuilder.append("\r\nerase\u5199\u7684\u6570\u636e\u5757\uff1a" + n4);
            stringBuilder.append("\r\nerase\u5199\u7684\u6570\u636e\u8d77\u59cb\u5730\u5740\uff1a" + n5);
            stringBuilder.append("\r\nerase\u5199\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n6);
            stringBuilder.append("\r\n");
            object = StringUtility.hexString2Bytes((String)object);
            n = (byte)n;
            n2 = (byte)n2;
            n3 = (byte)n3;
            object2 = StringUtility.hexString2Bytes((String)object2);
            n4 = (byte)n4;
            n6 = (byte)n6;
            int n7 = this.linuxUHFAndHFAPI.UHFBlockEraseData((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte)n4, n5, (byte)n6);
            if (n7 == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("eraseData ex=" + exception.toString());
        }
        return false;
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3) {
        return this.eraseData(string, 0, 0, 0, "00", n, n2, n3);
    }

    @Override
    public boolean setFilter(int n, int n2, int n3, String object) {
        return this.linuxUHFAndHFAPI.UHFSetFilter((byte)1, (byte)n, n2, n3, (byte[])(object = (Object)StringUtility.hexString2Bytes((String)object))) == 0;
    }

    @Override
    public boolean killTag(String string) {
        return this.killTag(string, 0, 0, 0, "00");
    }

    @Override
    public boolean killTag(String object, int n, int n2, int n3, String object2) {
        int n4 = this.linuxUHFAndHFAPI.UHFKillTag((byte[])(object = (Object)StringUtility.hexString2Bytes((String)object)), (byte)n, n2, n3, (byte[])(object2 = (Object)StringUtility.hexString2Bytes((String)object2)));
        return n4 == 0;
    }

    @Override
    public boolean setProtocol(int n) {
        return this.linuxUHFAndHFAPI.UHFSetProtocolType((byte)n) == 0;
    }

    @Override
    public int getProtocol() {
        byte[] byArray = new byte[1];
        if (this.linuxUHFAndHFAPI.UHFGetProtocolType(byArray) == 0) {
            return byArray[0];
        }
        return -1;
    }

    @Override
    public boolean setFreHop(float f2) {
        Object object = "" + f2;
        if (((String)object).length() == 3) {
            object = (String)object + "000";
        } else if (((String)object).length() == 4) {
            object = (String)object + "00";
        } else if (((String)object).length() == 5) {
            object = (String)object + "0";
        }
        object = new int[]{Integer.parseInt((String)object)};
        return this.linuxUHFAndHFAPI.UHFSetJumpFrequency((byte)1, (int[])object) == 0;
    }

    @Override
    public boolean setRFLink(int n) {
        return this.linuxUHFAndHFAPI.UHFSetRFLink((byte)1, (byte)n) == 0;
    }

    @Override
    public int getRFLink() {
        byte[] byArray = new byte[1];
        if (this.linuxUHFAndHFAPI.UHFGetRFLink(byArray) == 0) {
            return byArray[0];
        }
        return -1;
    }

    @Override
    public boolean setFastID(boolean bl) {
        boolean bl2 = bl = bl;
        return this.linuxUHFAndHFAPI.UHFSetFastID((byte)(bl ? 1 : 0)) == 0;
    }

    @Override
    public boolean setTagFocus(boolean bl) {
        boolean bl2 = bl = bl;
        return this.linuxUHFAndHFAPI.UHFSetTagfocus((byte)(bl ? 1 : 0)) == 0;
    }

    @Override
    public boolean setEPCMode() {
        return this.linuxUHFAndHFAPI.UHFSetEPCTIDUSERMode((byte)0, (byte)0, (byte)0, (byte)0) == 0;
    }

    @Override
    public boolean setEPCAndTIDMode() {
        return this.linuxUHFAndHFAPI.UHFSetEPCTIDUSERMode((byte)0, (byte)1, (byte)0, (byte)0) == 0;
    }

    @Override
    public boolean setEPCAndTIDUserMode(int n, int n2) {
        return this.linuxUHFAndHFAPI.UHFSetEPCTIDUSERMode((byte)0, (byte)2, (byte)n, (byte)n2) == 0;
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        byte[] byArray = new byte[10];
        int n = this.linuxUHFAndHFAPI.UHFGetEPCTIDUSERMode((byte)0, (byte)0, byArray);
        if (n > 0) {
            InventoryModeEntity$Builder inventoryModeEntity$Builder = new InventoryModeEntity$Builder();
            inventoryModeEntity$Builder.setMode(byArray[0]);
            if (byArray[0] == 2) {
                inventoryModeEntity$Builder.setUserOffset(byArray[1]);
                inventoryModeEntity$Builder.setUserLength(byArray[2]);
            }
            return inventoryModeEntity$Builder.build();
        }
        return null;
    }

    @Override
    public int getTemperature() {
        int[] nArray = new int[1];
        if (this.linuxUHFAndHFAPI.UHFGetTemperature(nArray) == 0) {
            return nArray[0];
        }
        return -1;
    }

    @Override
    public boolean uhfBlockPermalock(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6, int n7, byte[] byArray) {
        return this.linuxUHFAndHFAPI.UHFBlockPermalock((byte[])(object = (Object)StringUtility.hexString2Bytes((String)object)), (byte)(n = (int)((byte)n)), n2, n3, (byte[])(object2 = (Object)StringUtility.hexString2Bytes((String)object2)), (byte)(n4 = (int)((byte)n4)), (byte)(n5 = (int)((byte)n5)), n6, (byte)(n7 = (int)((byte)n7)), byArray) == 0;
    }

    @Override
    public boolean setGen2(Gen2Entity gen2Entity) {
        byte by = (byte)gen2Entity.getSelectTarget();
        byte by2 = (byte)gen2Entity.getSelectAction();
        byte by3 = (byte)gen2Entity.getSelectTruncate();
        byte by4 = (byte)gen2Entity.getQ();
        byte by5 = (byte)gen2Entity.getStartQ();
        byte by6 = (byte)gen2Entity.getMinQ();
        byte by7 = (byte)gen2Entity.getMaxQ();
        byte by8 = (byte)gen2Entity.getQueryDR();
        byte by9 = (byte)gen2Entity.getQueryM();
        byte by10 = (byte)gen2Entity.getQueryTRext();
        byte by11 = (byte)gen2Entity.getQuerySel();
        byte by12 = (byte)gen2Entity.getQuerySession();
        byte by13 = (byte)gen2Entity.getQueryTarget();
        int n = gen2Entity.getLinkFrequency();
        n = this.linuxUHFAndHFAPI.UHFSetGen2(by, by2, by3, by4, by5, by6, by7, by8, by9, by10, by11, by12, by13, (byte)n);
        System.out.println("UHFSetGen2 result=" + n);
        return n == 0;
    }

    @Override
    public Gen2Entity getGen2() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = new byte[1];
        byte[] byArray5 = new byte[1];
        byte[] byArray6 = new byte[1];
        byte[] byArray7 = new byte[1];
        byte[] byArray8 = new byte[1];
        byte[] byArray9 = new byte[1];
        byte[] byArray10 = new byte[1];
        byte[] byArray11 = new byte[1];
        byte[] byArray12 = new byte[1];
        byte[] byArray13 = new byte[1];
        byte[] byArray14 = new byte[1];
        int n = this.linuxUHFAndHFAPI.UHFGetGen2(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8, byArray9, byArray10, byArray11, byArray12, byArray13, byArray14);
        if (n == 0) {
            Gen2Entity gen2Entity = new Gen2Entity();
            gen2Entity.setSelectTarget(byArray[0]);
            gen2Entity.setSelectAction(byArray2[0]);
            gen2Entity.setSelectTruncate(byArray3[0]);
            gen2Entity.setQ(byArray4[0]);
            gen2Entity.setStartQ(byArray5[0]);
            gen2Entity.setMinQ(byArray6[0]);
            gen2Entity.setMaxQ(byArray7[0]);
            gen2Entity.setQueryDR(byArray8[0]);
            gen2Entity.setQueryM(byArray9[0]);
            gen2Entity.setQueryTRext(byArray10[0]);
            gen2Entity.setQuerySel(byArray11[0]);
            gen2Entity.setQuerySession(byArray12[0]);
            gen2Entity.setQueryTarget(byArray13[0]);
            gen2Entity.setLinkFrequency(byArray14[0]);
            return gen2Entity;
        }
        return null;
    }

    @Override
    public boolean setPwm(int n, int n2) {
        byte by = (byte)(n >> 8);
        byte by2 = (byte)(n2 >> 8);
        return this.linuxUHFAndHFAPI.UHFSetWorkTime((byte)1, by, (byte)(n = (int)((byte)n)), by2, (byte)(n2 = (int)((byte)n2))) == 0;
    }

    @Override
    public int[] getPwm() {
        byte[] byArray = new byte[10];
        int n = this.linuxUHFAndHFAPI.UHFGetWorkTime(byArray);
        if (n == -1) {
            return null;
        }
        n = byArray[1] | byArray[0] << 8;
        int n2 = byArray[3] | byArray[2] << 8;
        return new int[]{n, n2};
    }

    @Override
    public boolean setCW(int n) {
        return this.linuxUHFAndHFAPI.UHFSetCW((byte)n) == 0;
    }

    @Override
    public int getCW() {
        byte[] byArray = new byte[1];
        if (this.linuxUHFAndHFAPI.UHFGetCW(byArray) == 0) {
            return byArray[0];
        }
        return -1;
    }

    @Override
    public boolean uhfJump2Boot() {
        return this.linuxUHFAndHFAPI.UHFJump2Boot((byte)1) == 0;
    }

    @Override
    public boolean uhfJump2BootToSTM32() {
        return this.linuxUHFAndHFAPI.UHFJump2Boot((byte)0) == 0;
    }

    @Override
    public boolean uhfStartUpdate() {
        return this.linuxUHFAndHFAPI.UHFStartUpd() == 0;
    }

    @Override
    public boolean uhfUpdating(byte[] byArray) {
        return this.linuxUHFAndHFAPI.UHFUpdating(byArray) == 0;
    }

    @Override
    public boolean uhfStopUpdate() {
        return this.linuxUHFAndHFAPI.UHFStopUpdate() == 0;
    }

    @Override
    public char[] getBeep() {
        char[] cArray = new char[2];
        byte[] byArray = new byte[10];
        if (this.linuxUHFAndHFAPI.UHFGetBeep(byArray) == 0) {
            cArray[0] = '\u0000';
            cArray[1] = (char)byArray[0];
            return cArray;
        }
        return null;
    }

    @Override
    public boolean setBeep(int n) {
        return this.linuxUHFAndHFAPI.UHFSetBeep((byte)n) == 0;
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        this.inventoryCallback = iUHFInventoryCallback;
    }

    @Override
    public ConnectionState getConnectStatus() {
        return this.connectionState;
    }

    public void setFilterRepeatData(int n) {
        block3: {
            block4: {
                block2: {
                    if (n <= 0 || n > 2) {
                        throw new IllegalArgumentException("bank invalid!");
                    }
                    this.isFilterRepeatBank = n;
                    if (n != 0) break block2;
                    if (this.uhfinfoList == null) break block3;
                    break block4;
                }
                if (this.uhfinfoList == null) {
                    this.uhfinfoList = new ArrayList<UHFTAGInfo>();
                }
            }
            this.uhfinfoList.clear();
        }
    }

    private void startInventoryThread() {
        if (this.inventoryThread == null) {
            this.inventoryThread = new UsbLinux$InventoryThread(this);
            this.inventoryThread.start();
        }
    }

    private void stopInventoryThread() {
        if (this.inventoryThread != null) {
            this.inventoryThread.stopThread();
            this.inventoryThread = null;
        }
    }

    static /* synthetic */ int access$000(UsbLinux usbLinux) {
        return usbLinux.isFilterRepeatBank;
    }

    static /* synthetic */ IUHFInventoryCallback access$100(UsbLinux usbLinux) {
        return usbLinux.inventoryCallback;
    }
}

