/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.ConnectionState;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.RFIDWithUHFBase;
import com.rscja.deviceapi.RFIDWithUHFNetworkUR4$1;
import com.rscja.deviceapi.RFIDWithUHFNetworkUR4$InventoryThread;
import com.rscja.deviceapi.SocketManageUR4;
import com.rscja.deviceapi.a;
import com.rscja.deviceapi.c;
import com.rscja.deviceapi.e;
import com.rscja.deviceapi.entity.AntennaNameEnum;
import com.rscja.deviceapi.entity.AntennaPowerEntity;
import com.rscja.deviceapi.entity.AntennaState;
import com.rscja.deviceapi.entity.GPIStateEntity;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.InventoryModeEntity$Builder;
import com.rscja.deviceapi.entity.ReaderIPEntity;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.ConnectionStateCallback;
import com.rscja.deviceapi.interfaces.IUHF;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.deviceapi.interfaces.IUR4;
import com.rscja.deviceapi.l;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.List;

public class RFIDWithUHFNetworkUR4
extends RFIDWithUHFBase
implements IUHF,
IUR4 {
    protected SocketManageUR4 socketManage = new SocketManageUR4();
    private static final String TAG = StringUtility.TAG + "UHFNetwork";
    private boolean DEBUG = false;
    protected a config;
    private char[] uhfdata = new char[512];
    private DeviceAPI deviceAPI = null;
    protected l uhfProtocolParse = null;
    private ConnectionStateCallback btStatusCallback = null;
    private boolean isStoping = false;
    private RFIDWithUHFNetworkUR4$InventoryThread inventoryThread = null;
    private IUHFInventoryCallback inventoryCallback = null;
    protected boolean isRuning = false;
    private e socketUdp = null;
    boolean autoCheckConnectStatus = false;

    public RFIDWithUHFNetworkUR4() {
        this.config = new a("");
        this.socketManage.setObserver(new RFIDWithUHFNetworkUR4$1(this));
        this.uhfProtocolParse = this.socketManage.uhfProtocolParse;
    }

    public synchronized void setPort(int n) {
        this.config.a(n);
    }

    @Override
    public synchronized boolean init(String string) {
        return this.init(string, this.config.a());
    }

    public synchronized boolean init(String string, int n) {
        System.out.println("init begin");
        this.config.a(n);
        boolean bl = this.socketManage.connect(string, n, true);
        System.out.println("init end host=" + string + ", port=" + n + ">>result=" + bl);
        if (bl) {
            this.stopInventory();
            this.setPowerOn(true);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean free() {
        this.isRuning = false;
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        this.socketManage.close();
        this.setPowerOn(false);
        if (this.inventoryThread != null) {
            this.inventoryThread.stopThread();
            this.inventoryThread = null;
        }
        this.isStoping = false;
        return true;
    }

    @Override
    public synchronized String getVersion() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getVersionSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseVersionData(object.d);
        System.out.println("getVersion() vesionString:" + (String)object);
        return object;
    }

    @Override
    public boolean setPower(AntennaNameEnum object, int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setPower");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (n > 30) {
            n = 30;
        } else if (n <= 0) {
            n = 1;
        }
        object = this.uhfProtocolParse.setPowerSendData(object.getValue(), n);
        object = this.socketManage.sendAndReceive((byte[])object);
        if (object == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetPowerData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("setPower() err :" + bl);
        return bl;
    }

    @Override
    public synchronized List<AntennaPowerEntity> getPowerAll() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getPowerAll");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getPowerSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        List<AntennaPowerEntity> list = this.uhfProtocolParse.parseGetPowerAllData(object.d);
        object = list;
        return list;
    }

    @Override
    public synchronized int getPower(AntennaNameEnum antennaNameEnum) {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getPowerSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        object = this.uhfProtocolParse.parseGetPowerAllData(((com.rscja.deviceapi.b.c)object).d);
        for (int i2 = 0; i2 < object.size(); ++i2) {
            if (((AntennaPowerEntity)object.get(i2)).getAntennaNameEnum() != antennaNameEnum) continue;
            return ((AntennaPowerEntity)object.get(i2)).getPower();
        }
        System.out.println("getPower() err :-1");
        return -1;
    }

    @Override
    public synchronized int getFrequencyMode() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getFrequencyModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        byte by = this.uhfProtocolParse.parseGetFrequencyModeData(object.d);
        System.out.println("getFrequencyMode() err :" + by);
        return by;
    }

    @Override
    public synchronized boolean setFrequencyMode(byte by) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFrequencyModeSendData(by);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetFrequencyModeData(object.d);
        System.out.println("setFrequencyMode() err :" + bl);
        return bl;
    }

    @Override
    public synchronized boolean startInventoryTag() {
        return this.startInventoryTag(0, 0, 6);
    }

    private synchronized boolean startInventoryTag(int n, int n2, int n3) {
        if (this.isRuning) {
            System.out.println("waiting for the stop!");
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        this.socketManage.getUHFDataHandleBase().b();
        this.socketManage.setInventoryFlag(true);
        byte[] byArray = this.uhfProtocolParse.getStartInventoryTagSendData();
        boolean bl = this.socketManage.send(byArray);
        if (!bl) {
            this.socketManage.setInventoryFlag(false);
            return false;
        }
        System.out.println("startInventory() result :" + true);
        this.isRuning = true;
        if (this.inventoryCallback != null && this.inventoryThread == null) {
            this.inventoryThread = new RFIDWithUHFNetworkUR4$InventoryThread(this);
            this.inventoryThread.start();
        }
        return true;
    }

    @Override
    @Deprecated
    public synchronized UHFTAGInfo readTagFromBuffer() {
        Object object = this.socketManage.receiveTagData();
        if (object == null) {
            return null;
        }
        object = this.uhfProtocolParse.c(((com.rscja.deviceapi.b.c)object).c);
        return object;
    }

    @Override
    public synchronized boolean stopInventory() {
        System.out.println("stopInventory()");
        byte[] byArray = this.uhfProtocolParse.getStopInventorySendData();
        this.socketManage.send(byArray);
        this.isRuning = false;
        if (this.inventoryThread != null) {
            this.inventoryThread.stopThread();
            this.inventoryThread = null;
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {}
        this.socketManage.setInventoryFlag(false);
        return true;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> arrayList, int n) {
        if (arrayList == null || arrayList.size() == 0 || n < 0) {
            return null;
        }
        switch (n) {
            case 16: 
            case 32: 
            case 48: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException("lockMode error");
            }
        }
        return super.generateLockCode(arrayList, n);
    }

    @Override
    public synchronized boolean lockMem(String string, String string2) {
        StringUtility.hexString2Chars(string);
        StringUtility.hexString2Chars(string2);
        boolean bl = this.lockMem(string, 1, 0, 0, "", string2);
        if (bl) {
            return true;
        }
        System.out.println("lockMem() err :" + bl);
        return false;
    }

    @Override
    public boolean lockMem(String object, int n, int n2, int n3, String string, String string2) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getLockSendData((String)object, n, n2, n3, string, string2);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseLockData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("lockMem() err :" + bl);
        return bl;
    }

    @Override
    public synchronized UHFTAGInfo inventorySingleTag() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getInventorySingleTagSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        UHFTAGInfo uHFTAGInfo = this.uhfProtocolParse.a(object.c, true);
        object = uHFTAGInfo;
        return uHFTAGInfo;
    }

    @Override
    public String readData(String string, int n, int n2, int n3) {
        if (StringUtility.isEmpty(string) || !StringUtility.isHexNumberRex(string)) {
            return null;
        }
        return this.readData(string, 1, 0, 0, "00", n, n2, n3);
    }

    @Override
    public String readData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        if (!this.isPowerOn()) {
            return null;
        }
        object = this.uhfProtocolParse.getReadSendData((String)object, n, n2, n3, string, n4, n5, n6);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseReadData(((com.rscja.deviceapi.b.c)object).d);
        return object;
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2) {
        if (StringUtility.isEmpty(string) || StringUtility.isEmpty(string2)) {
            return false;
        }
        String string3 = "00";
        boolean bl = this.writeData(string, 1, 32, 0, string3, n, n2, n3, string2);
        return bl;
    }

    @Override
    public boolean writeData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6, String string2) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getWriteSendData((String)object, n, n2, n3, string, n4, n5, n6, string2);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseWriteData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean blockWriteData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6, String string2) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.blockWriteDataSendData((String)object, (char)n, n2, n3, string, (char)n4, n5, (char)n6, string2);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBlockWriteData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String string2) {
        return this.blockWriteData(string, 1, 0, 0, "00", n, n2, n3, string2);
    }

    @Override
    public boolean eraseData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.blockEraseDataSendData((String)object, (char)n, n2, n3, string, (char)n4, n5, (char)n6);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBlockEraseDataData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3) {
        return this.eraseData(string, 1, 0, 0, "00", n, n2, n3);
    }

    @Override
    public boolean setFilter(int n, int n2, int n3, String string) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFilterSendData((char)n, n2, n3, string);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetFilterData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean killTag(String string) {
        return this.killTag(string, 0, 0, 0, "00");
    }

    @Override
    public boolean killTag(String object, int n, int n2, int n3, String string) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getKillSendData((String)object, n, n2, n3, string);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseKillData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public synchronized boolean setProtocol(int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setProtocolSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetProtocolData(object.d);
        return bl;
    }

    @Override
    public synchronized int getProtocol() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getProtocolSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetProtocolData(object.d);
        return n;
    }

    @Override
    public synchronized boolean setFreHop(float f2) {
        if (!this.isPowerOn()) {
            return false;
        }
        int n = (int)(f2 * 1000.0f);
        Object object = this.uhfProtocolParse.setJumpFrequencySendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetJumpFrequencyData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean setRFLink(int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setRFLinkSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetRFLinkData(object.d);
        return bl;
    }

    @Override
    public synchronized int getRFLink() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getRFLinkSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetRFLinkData(object.d);
        return n;
    }

    @Override
    public synchronized boolean setFastID(boolean bl) {
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean setTagFocus(boolean bl) {
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean setEPCMode() {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCModeData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean setEPCAndTIDMode() {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCAndTIDModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCAndTIDModeData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean setEPCAndTIDUserMode(int n, int n2) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCAndTIDUserModeSendData(n, n2);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCAndTIDUserModeData(object.d);
        return bl;
    }

    @Override
    public synchronized int getTemperature() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getTemperatureSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseTemperatureData(object.d);
        return n;
    }

    @Override
    public boolean uhfBlockPermalock(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, int n7, byte[] byArray) {
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public boolean setGen2(Gen2Entity object) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.setGen2SendData((Gen2Entity)object);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetGen2Data(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public Gen2Entity getGen2() {
        Object object;
        System.out.println("GetGen2()=========");
        if (!this.isPowerOn()) {
            return null;
        }
        Object object2 = this.uhfProtocolParse.getGen2SendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object2);
        object2 = c2;
        if (c2 == null) {
            return null;
        }
        object2 = this.uhfProtocolParse.parseGetGen2Data(object2.d);
        if (object2 == null) {
            return null;
        }
        if (this.DEBUG) {
            object = new StringBuilder();
            ((StringBuilder)object).append("target data[2]=");
            ((StringBuilder)object).append(String.valueOf(object2[0]));
            ((StringBuilder)object).append(",action data[3]=");
            ((StringBuilder)object).append(String.valueOf(object2[1]));
            ((StringBuilder)object).append(",t data[4]=");
            ((StringBuilder)object).append(String.valueOf(object2[2]));
            ((StringBuilder)object).append(",q data[5]=");
            ((StringBuilder)object).append(String.valueOf(object2[3]));
            ((StringBuilder)object).append(",startQ data[6]=");
            ((StringBuilder)object).append(String.valueOf(object2[4]));
            ((StringBuilder)object).append(",minQ data[7]=");
            ((StringBuilder)object).append(String.valueOf(object2[5]));
            ((StringBuilder)object).append(",maxQ data[8]=");
            ((StringBuilder)object).append(String.valueOf(object2[6]));
            ((StringBuilder)object).append(",dr data[9]=");
            ((StringBuilder)object).append(String.valueOf(object2[7]));
            ((StringBuilder)object).append(",coding data[10]=");
            ((StringBuilder)object).append(String.valueOf(object2[8]));
            ((StringBuilder)object).append(", p data[11]=");
            ((StringBuilder)object).append(String.valueOf(object2[9]));
            ((StringBuilder)object).append(",Sel data[12]=");
            ((StringBuilder)object).append(String.valueOf(object2[10]));
            ((StringBuilder)object).append(",Session data[13]=");
            ((StringBuilder)object).append(String.valueOf(object2[11]));
            ((StringBuilder)object).append(",g data[14]=");
            ((StringBuilder)object).append(String.valueOf(object2[12]));
            ((StringBuilder)object).append(",linkFrequency data[15]=");
            ((StringBuilder)object).append(String.valueOf(object2[13]));
            System.out.println(((StringBuilder)object).toString());
        }
        object = new Gen2Entity();
        ((Gen2Entity)object).setSelectTarget(object2[0]);
        ((Gen2Entity)object).setSelectAction(object2[1]);
        ((Gen2Entity)object).setSelectTruncate(object2[2]);
        ((Gen2Entity)object).setQ(object2[3]);
        ((Gen2Entity)object).setStartQ(object2[4]);
        ((Gen2Entity)object).setMinQ(object2[5]);
        ((Gen2Entity)object).setMaxQ(object2[6]);
        ((Gen2Entity)object).setQueryDR(object2[7]);
        ((Gen2Entity)object).setQueryM(object2[8]);
        ((Gen2Entity)object).setQueryTRext(object2[9]);
        ((Gen2Entity)object).setQuerySel(object2[10]);
        ((Gen2Entity)object).setQuerySession(object2[11]);
        ((Gen2Entity)object).setQueryTarget(object2[12]);
        ((Gen2Entity)object).setLinkFrequency(object2[13]);
        return object;
    }

    @Override
    public synchronized boolean setPwm(int n, int n2) {
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public synchronized int[] getPwm() {
        if (!this.isPowerOn()) {
            return null;
        }
        return null;
    }

    @Override
    public synchronized boolean uhfJump2Boot() {
        if (!this.isPowerOn()) {
            return false;
        }
        this.autoCheckConnectStatus = this.socketManage.autoCheckConnectStatus;
        this.socketManage.autoCheckConnectStatus = false;
        Object object = this.uhfProtocolParse.uhfJump2BootSendData('\u0001');
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFJump2BootData(object.d);
        if (!bl) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
        }
        return bl;
    }

    @Override
    public synchronized boolean uhfStartUpdate() {
        if (!this.isPowerOn()) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
            return false;
        }
        Object object = this.uhfProtocolParse.uhfStartUpdateSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFStartUpdateData(object.d);
        if (!bl) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
        }
        return bl;
    }

    @Override
    public synchronized boolean uhfUpdating(byte[] object) {
        int n;
        byte[] byArray = new byte[64];
        if (((byte[])object).length < 64) {
            for (n = 0; n < ((byte[])object).length; ++n) {
                byArray[n] = object[n];
            }
        } else {
            for (n = 0; n < 64; ++n) {
                byArray[n] = object[n];
            }
        }
        if (!this.isPowerOn()) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
            return false;
        }
        byte[] byArray2 = this.uhfProtocolParse.uhfUpdatingSendData(byArray);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive(byArray2, -1);
        object = c2;
        if (c2 == null) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFUpdatingData(object.d);
        if (!bl) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
        }
        return bl;
    }

    @Override
    public synchronized boolean uhfStopUpdate() {
        if (!this.isPowerOn()) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
            return false;
        }
        Object object = this.uhfProtocolParse.UHFStopUpdateSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFStopUpdateData(object.d);
        this.socketManage.autoCheckConnectStatus = this.autoCheckConnectStatus;
        return bl;
    }

    @Override
    public synchronized int getCW() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getCWSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        return this.uhfProtocolParse.parseGetCWData(object.d);
    }

    @Override
    public boolean setCW(int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setCWSendData((char)n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetCWData(object.d);
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getEPCTIDModeSendData('\u0000', '\u0000');
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseGetEPCTIDModeData(object.d);
        if (object == null || ((byte[])object).length == 0) {
            return null;
        }
        InventoryModeEntity$Builder inventoryModeEntity$Builder = new InventoryModeEntity$Builder();
        inventoryModeEntity$Builder.setMode(object[0]);
        if (object[0] == 2) {
            inventoryModeEntity$Builder.setUserOffset(object[1]);
            inventoryModeEntity$Builder.setUserLength(object[2]);
        }
        return inventoryModeEntity$Builder.build();
    }

    @Override
    public boolean setBeep(int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.getBeepSendData(n == 1);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseBeepData(object.d);
    }

    @Override
    public char[] getBeep() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getReaderBeepStatusSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        int n = this.uhfProtocolParse.parseGetReaderBeepStatusData(object.d);
        if (n == 0 || n == 1) {
            return new char[]{'\u0000', (char)n};
        }
        return null;
    }

    @Override
    public boolean setIPAndPort(ReaderIPEntity object) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.setReaderIpSendData((ReaderIPEntity)object);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetReaderIpData(((com.rscja.deviceapi.b.c)object).d);
    }

    @Override
    public ReaderIPEntity getIPAndPort() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getReaderIpSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        ReaderIPEntity readerIPEntity = this.uhfProtocolParse.parseGetReaderIpData(object.d);
        object = readerIPEntity;
        if (readerIPEntity == null) {
            return null;
        }
        return object;
    }

    @Override
    public boolean resetUHFSoft() {
        if (!this.isPowerOn()) {
            return false;
        }
        System.out.println("resetUHFSoft begin");
        Object object = this.uhfProtocolParse.getSetSoftResetSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetSoftResetData(object.d);
        System.out.println("resetUHFSoft emd");
        return bl;
    }

    @Override
    public boolean isPowerOn() {
        return this.powerOn && this.socketManage.getConnectStatus() == c.STATUS_CONNECT;
    }

    @Override
    public boolean setAntenna(List<AntennaState> object) {
        if (object == null || object.size() == 0) {
            return false;
        }
        byte[] byArray = new byte[2];
        for (int i2 = 0; i2 < object.size(); ++i2) {
            if (!object.get(i2).isEnable()) continue;
            if (object.get(i2).getAntennaName() == AntennaNameEnum.ANT1) {
                byArray[1] = (byte)(byArray[1] | 1);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT2) {
                byArray[1] = (byte)(byArray[1] | 2);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT3) {
                byArray[1] = (byte)(byArray[1] | 4);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT4) {
                byArray[1] = (byte)(byArray[1] | 8);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT5) {
                byArray[1] = (byte)(byArray[1] | 0x10);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT6) {
                byArray[1] = (byte)(byArray[1] | 0x20);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT7) {
                byArray[1] = (byte)(byArray[1] | 0x40);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT8) {
                byArray[1] = (byte)(byArray[1] | 0x80);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT9) {
                byArray[0] = (byte)(byArray[0] | 1);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT10) {
                byArray[0] = (byte)(byArray[0] | 2);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT11) {
                byArray[0] = (byte)(byArray[0] | 4);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT12) {
                byArray[0] = (byte)(byArray[0] | 8);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT13) {
                byArray[0] = (byte)(byArray[0] | 0x10);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT14) {
                byArray[0] = (byte)(byArray[0] | 0x20);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT15) {
                byArray[0] = (byte)(byArray[0] | 0x40);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() != AntennaNameEnum.ANT16) continue;
            byArray[0] = (byte)(byArray[0] | 0x80);
        }
        byte[] byArray2 = this.uhfProtocolParse.setAntSendData('\u0001', byArray);
        object = this.socketManage.sendAndReceive(byArray2);
        if (object == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetAntData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public List<AntennaState> getAntenna() {
        Object object = this.uhfProtocolParse.getAntSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseGetAntData(object.d);
        if (object == null || ((byte[])object).length < 2) {
            return null;
        }
        ArrayList<AntennaState> arrayList = new ArrayList<AntennaState>();
        arrayList.add(new AntennaState(AntennaNameEnum.ANT1, (object[1] & 1) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT2, (object[1] & 2) == 2));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT3, (object[1] & 4) == 4));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT4, (object[1] & 8) == 8));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT5, (object[1] & 0x10) == 8));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT6, (object[1] & 0x20) == 8));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT7, (object[1] & 0x40) == 8));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT8, (object[1] & 0x80) == 8));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT9, (object[0] & 1) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT10, (object[0] & 2) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT11, (object[0] & 4) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT12, (object[0] & 8) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT13, (object[0] & 0x10) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT14, (object[0] & 0x20) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT15, (object[0] & 0x40) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT16, (object[0] & 0x80) == 1));
        return arrayList;
    }

    @Override
    public boolean setAntennaWorkTime(AntennaNameEnum object, int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        if (n < 10 || n > 65535) {
            throw new IllegalArgumentException("WorkTime error !");
        }
        object = this.uhfProtocolParse.setAntWorkTimeSendData((byte)object.getValue(), n);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetAntWorkTimeReceiveData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("setAntWorkTime() reuslt :" + bl);
        return bl;
    }

    @Override
    public int getAntennaWorkTime(AntennaNameEnum object) {
        if (!this.isPowerOn()) {
            return -1;
        }
        object = this.uhfProtocolParse.getAntWorkTimeSendData((byte)object.getValue());
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetAntWorkTimeReceiveData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("getAntWorkTime() result :" + n);
        return n;
    }

    @Override
    public boolean uhfJump2BootToSTM32() {
        return false;
    }

    @Override
    public boolean setGPO(byte by, byte by2, byte by3) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setIOControlSendData(by, by2, by3);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetIOControlReceiveData(object.d);
    }

    @Override
    public List<GPIStateEntity> getGPI() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getIOControlSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        return this.uhfProtocolParse.parseGetIOControlReceiveData(object.d);
    }

    @Override
    public void setConnectionStateCallback(ConnectionStateCallback connectionStateCallback) {
        this.btStatusCallback = connectionStateCallback;
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        this.inventoryCallback = iUHFInventoryCallback;
    }

    @Override
    public ConnectionState getConnectStatus() {
        if (this.socketManage.getConnectStatus() == c.STATUS_CONNECT) {
            return ConnectionState.CONNECTED;
        }
        return ConnectionState.DISCONNECTED;
    }

    @Override
    public boolean setWorkMode(int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setWorkModeSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetWorkModeReceiveData(object.d);
        System.out.println("setWorkMode() result :" + bl);
        return bl;
    }

    @Override
    public int getWorkMode() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getWorkModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetWorkModeReceiveData(object.d);
        System.out.println("setWorkMode() result :" + n);
        return n;
    }

    @Override
    public boolean setDestinationIPAndPort(ReaderIPEntity object) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.setReaderDestIpSendData((ReaderIPEntity)object);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetReaderDestIpData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("setDestinationIPAndPort() result :" + bl);
        return bl;
    }

    @Override
    public ReaderIPEntity getDestinationIPAndPort() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getReaderDestIpSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        ReaderIPEntity readerIPEntity = this.uhfProtocolParse.parseGetReaderDestIpData(((com.rscja.deviceapi.b.c)object).d);
        object = readerIPEntity;
        if (readerIPEntity == null) {
            return null;
        }
        System.out.println("ip=" + ((ReaderIPEntity)object).getIp() + ", port=" + ((ReaderIPEntity)object).getPort());
        return object;
    }

    public void startReciveUHFTagsByUDP(int n, IUHFInventoryCallback iUHFInventoryCallback) {
        if (this.socketUdp == null) {
            this.socketUdp = new e();
        }
        this.socketUdp.a(n, iUHFInventoryCallback);
    }

    public void stopReceiveUHFTagsByUDP() {
        if (this.socketUdp != null) {
            this.socketUdp.a();
        }
    }

    static /* synthetic */ ConnectionStateCallback access$000(RFIDWithUHFNetworkUR4 rFIDWithUHFNetworkUR4) {
        return rFIDWithUHFNetworkUR4.btStatusCallback;
    }

    static /* synthetic */ String access$100() {
        return TAG;
    }

    static /* synthetic */ IUHFInventoryCallback access$200(RFIDWithUHFNetworkUR4 rFIDWithUHFNetworkUR4) {
        return rFIDWithUHFNetworkUR4.inventoryCallback;
    }
}

