/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.ConnectionState;
import com.rscja.deviceapi.RFIDWithUHFBase;
import com.rscja.deviceapi.RFIDWithUHFSerialPortUR4$1;
import com.rscja.deviceapi.entity.AntennaNameEnum;
import com.rscja.deviceapi.entity.AntennaPowerEntity;
import com.rscja.deviceapi.entity.AntennaState;
import com.rscja.deviceapi.entity.GPIStateEntity;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.ReaderIPEntity;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.ConnectionStateCallback;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.deviceapi.interfaces.IUR4;
import com.rscja.deviceapi.linux.serialport.SPUR4Linux;
import com.rscja.deviceapi.windows.serialport.SPUR4Windows;
import java.io.File;
import java.util.List;

public class RFIDWithUHFSerialPortUR4
extends RFIDWithUHFBase
implements IUR4 {
    private ConnectionState currStatus = ConnectionState.DISCONNECTED;
    private IUR4 iuhf = null;
    private File dllOrSoPathFile = null;
    private ConnectionStateCallback stateCallback = null;

    /*
     * Enabled aggressive block sorting
     */
    public void setDllOrSOFilePath(String string, String string2) {
        if (string != null && string2 != null) {
            this.dllOrSoPathFile = new File(string, string2);
            return;
        }
        if (string == null) {
            if (string2 == null) return;
            this.dllOrSoPathFile = new File("", string2);
            return;
        }
        boolean bl = System.getProperty("os.name").toLowerCase().contains("win");
        if (bl) {
            this.dllOrSoPathFile = new File(string, "UHFAPI.dll");
            return;
        }
        this.dllOrSoPathFile = new File(string, "libDeviceAPI.so");
    }

    @Override
    public void setConnectionStateCallback(ConnectionStateCallback connectionStateCallback) {
        this.stateCallback = connectionStateCallback;
    }

    @Override
    public boolean init(String string) {
        boolean bl;
        if (this.iuhf == null) {
            bl = System.getProperty("os.name").toLowerCase().contains("win");
            this.iuhf = bl ? new SPUR4Windows(this.dllOrSoPathFile) : new SPUR4Linux(this.dllOrSoPathFile);
            this.iuhf.setConnectionStateCallback(new RFIDWithUHFSerialPortUR4$1(this));
        }
        this.currStatus = (bl = this.iuhf.init(string)) ? ConnectionState.CONNECTED : ConnectionState.DISCONNECTED;
        return bl;
    }

    @Override
    public boolean free() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.free();
    }

    @Override
    public String getVersion() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getVersion();
    }

    @Override
    public int getFrequencyMode() {
        if (this.iuhf == null) {
            return -1;
        }
        return this.iuhf.getFrequencyMode();
    }

    @Override
    public boolean setFrequencyMode(byte by) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setFrequencyMode(by);
    }

    @Override
    public boolean startInventoryTag() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.startInventoryTag();
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        if (this.iuhf == null) {
            return;
        }
        this.iuhf.setInventoryCallback(iUHFInventoryCallback);
    }

    @Override
    public ConnectionState getConnectStatus() {
        return this.currStatus;
    }

    @Override
    public UHFTAGInfo readTagFromBuffer() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.readTagFromBuffer();
    }

    @Override
    public boolean stopInventory() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.stopInventory();
    }

    @Override
    public boolean lockMem(String string, int n, int n2, int n3, String string2, String string3) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.lockMem(string, n, n2, n3, string2, string3);
    }

    @Override
    public boolean lockMem(String string, String string2) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.lockMem(string, string2);
    }

    @Override
    public UHFTAGInfo inventorySingleTag() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.inventorySingleTag();
    }

    @Override
    public String readData(String string, int n, int n2, int n3) {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.readData(string, n, n2, n3);
    }

    @Override
    public String readData(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6) {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.readData(string, n, n2, n3, string2, n4, n5, n6);
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.writeData(string, n, n2, n3, string2);
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, String string3) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.writeData(string, n, n2, n3, string2, n4, n5, n6, string3);
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String string2) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.blockWriteData(string, n, n2, n3, string2);
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, String string3) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.blockWriteData(string, n, n2, n3, string2, n4, n5, n6, string3);
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.eraseData(string, n, n2, n3, string2, n4, n5, n6);
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.eraseData(string, n, n2, n3);
    }

    @Override
    public boolean setFilter(int n, int n2, int n3, String string) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setFilter(n, n2, n3, string);
    }

    @Override
    public boolean killTag(String string) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.killTag(string);
    }

    @Override
    public boolean killTag(String string, int n, int n2, int n3, String string2) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.killTag(string, n, n2, n3, string2);
    }

    @Override
    public boolean setProtocol(int n) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setProtocol(n);
    }

    @Override
    public int getProtocol() {
        if (this.iuhf == null) {
            return -1;
        }
        return this.iuhf.getProtocol();
    }

    @Override
    public boolean setFreHop(float f2) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setFreHop(f2);
    }

    @Override
    public boolean setRFLink(int n) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setRFLink(n);
    }

    @Override
    public int getRFLink() {
        if (this.iuhf == null) {
            return -1;
        }
        return this.iuhf.getRFLink();
    }

    @Override
    public boolean setFastID(boolean bl) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setFastID(bl);
    }

    @Override
    public boolean setTagFocus(boolean bl) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setTagFocus(bl);
    }

    @Override
    public boolean setEPCMode() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setEPCMode();
    }

    @Override
    public boolean setEPCAndTIDMode() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setEPCAndTIDMode();
    }

    @Override
    public boolean setEPCAndTIDUserMode(int n, int n2) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setEPCAndTIDUserMode(n, n2);
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getEPCAndTIDUserMode();
    }

    @Override
    public int getTemperature() {
        if (this.iuhf == null) {
            return -1;
        }
        return this.iuhf.getTemperature();
    }

    @Override
    public boolean uhfBlockPermalock(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, int n7, byte[] byArray) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.uhfBlockPermalock(string, n, n2, n3, string2, n4, n5, n6, n7, byArray);
    }

    @Override
    public boolean setGen2(Gen2Entity gen2Entity) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setGen2(gen2Entity);
    }

    @Override
    public Gen2Entity getGen2() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getGen2();
    }

    @Override
    public boolean setPwm(int n, int n2) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setPwm(n, n2);
    }

    @Override
    public int[] getPwm() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getPwm();
    }

    @Override
    public boolean setCW(int n) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setCW(n);
    }

    @Override
    public int getCW() {
        if (this.iuhf == null) {
            return -1;
        }
        return this.iuhf.getCW();
    }

    @Override
    public boolean uhfJump2Boot() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.uhfJump2Boot();
    }

    @Override
    public boolean uhfJump2BootToSTM32() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.uhfJump2BootToSTM32();
    }

    @Override
    public boolean uhfStartUpdate() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.uhfStartUpdate();
    }

    @Override
    public boolean uhfUpdating(byte[] byArray) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.uhfUpdating(byArray);
    }

    @Override
    public boolean uhfStopUpdate() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.uhfStopUpdate();
    }

    @Override
    public char[] getBeep() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getBeep();
    }

    @Override
    public boolean setBeep(int n) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setBeep(n);
    }

    @Override
    public boolean setGPO(byte by, byte by2, byte by3) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setGPO(by, by2, by3);
    }

    @Override
    public List<GPIStateEntity> getGPI() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getGPI();
    }

    @Override
    public boolean setAntennaWorkTime(AntennaNameEnum antennaNameEnum, int n) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setAntennaWorkTime(antennaNameEnum, n);
    }

    @Override
    public int getAntennaWorkTime(AntennaNameEnum antennaNameEnum) {
        if (this.iuhf == null) {
            return -1;
        }
        return this.iuhf.getAntennaWorkTime(antennaNameEnum);
    }

    @Override
    public boolean setAntenna(List<AntennaState> list) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setAntenna(list);
    }

    @Override
    public List<AntennaState> getAntenna() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getAntenna();
    }

    @Override
    public boolean resetUHFSoft() {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.resetUHFSoft();
    }

    @Override
    public boolean setIPAndPort(ReaderIPEntity readerIPEntity) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setIPAndPort(readerIPEntity);
    }

    @Override
    public ReaderIPEntity getIPAndPort() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getIPAndPort();
    }

    @Override
    public boolean setWorkMode(int n) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setWorkMode(n);
    }

    @Override
    public int getWorkMode() {
        if (this.iuhf == null) {
            return -1;
        }
        return this.iuhf.getWorkMode();
    }

    @Override
    public boolean setDestinationIPAndPort(ReaderIPEntity readerIPEntity) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setDestinationIPAndPort(readerIPEntity);
    }

    @Override
    public ReaderIPEntity getDestinationIPAndPort() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getDestinationIPAndPort();
    }

    @Override
    public boolean setPower(AntennaNameEnum antennaNameEnum, int n) {
        if (this.iuhf == null) {
            return false;
        }
        return this.iuhf.setPower(antennaNameEnum, n);
    }

    @Override
    public int getPower(AntennaNameEnum antennaNameEnum) {
        if (this.iuhf == null) {
            return -1;
        }
        return this.iuhf.getPower(antennaNameEnum);
    }

    @Override
    public List<AntennaPowerEntity> getPowerAll() {
        if (this.iuhf == null) {
            return null;
        }
        return this.iuhf.getPowerAll();
    }

    static /* synthetic */ ConnectionStateCallback access$000(RFIDWithUHFSerialPortUR4 rFIDWithUHFSerialPortUR4) {
        return rFIDWithUHFSerialPortUR4.stateCallback;
    }
}

