/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.ConnectionState;
import com.rscja.deviceapi.RFIDWithUHFBase;
import com.rscja.deviceapi.RFIDWithUHFSerialPortAxBase$1;
import com.rscja.deviceapi.RFIDWithUHFSerialPortAxBase$InventoryThread;
import com.rscja.deviceapi.RFIDWithUHFSerialPortAxBase$ReceiveDataThread;
import com.rscja.deviceapi.b;
import com.rscja.deviceapi.b.c;
import com.rscja.deviceapi.b.e;
import com.rscja.deviceapi.entity.AntennaNameEnum;
import com.rscja.deviceapi.entity.AntennaPowerEntity;
import com.rscja.deviceapi.entity.AntennaState;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.InventoryModeEntity$Builder;
import com.rscja.deviceapi.entity.ReaderIPEntity;
import com.rscja.deviceapi.entity.ReaderInfo;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.entity.WifiConfig;
import com.rscja.deviceapi.i;
import com.rscja.deviceapi.interfaces.ConnectionStateCallback;
import com.rscja.deviceapi.interfaces.IGPIStateCallback;
import com.rscja.deviceapi.interfaces.IUHFAx;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.deviceapi.interfaces.IUpgradeProgress;
import com.rscja.utility.StringUtility;
import gnu.io.CommPortIdentifier;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

abstract class RFIDWithUHFSerialPortAxBase
extends RFIDWithUHFBase
implements IUHFAx,
Observer {
    protected final int timeOut = 3000;
    protected i uhfProtocolParse = new i();
    protected b rs232Common = new b();
    private e uhfhAxDataHandle = new e();
    private int ConnectTimeOut = 10000;
    private IUpgradeProgress iUpgradeProgress = null;
    private boolean autoCheckConnectStatus = true;
    private boolean isParse = true;
    private boolean isCheckGPIO = true;
    private int index = 0;
    protected boolean isRuning = false;
    private ConnectionState curr_status = ConnectionState.DISCONNECTED;
    private ConnectionStateCallback btStateCallback;
    protected List<UHFTAGInfo> uhfinfoList = null;
    private RFIDWithUHFSerialPortAxBase$ReceiveDataThread receiveDataThread = null;
    private ArrayList<Byte> upgradeDataList = new ArrayList();
    private RFIDWithUHFSerialPortAxBase$InventoryThread inventoryThread = null;
    private int isFilterRepeatBank = 0;
    private IUHFInventoryCallback inventoryCallback = null;
    protected IGPIStateCallback uhfGPIOStateCallback = null;
    protected ReaderInfo readerInfo = null;

    RFIDWithUHFSerialPortAxBase() {
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    private void updateConnectionState(ConnectionState connectionState) {
        if (this.curr_status != connectionState) {
            this.curr_status = connectionState;
            System.out.println("updateConnectionState() status :" + (Object)((Object)connectionState));
            if (this.btStateCallback != null) {
                new Thread(new RFIDWithUHFSerialPortAxBase$1(this, connectionState)).start();
            }
        }
    }

    @Override
    public boolean init(String string) {
        boolean bl = false;
        this.readerInfo = null;
        if (string != null && string.length() > 0) {
            bl = this.rs232Common.a(string);
            RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase = this;
            rFIDWithUHFSerialPortAxBase.send(rFIDWithUHFSerialPortAxBase.uhfProtocolParse.activateRS232SendData());
        }
        if (bl) {
            if (!this.checkConnectState()) {
                this.free();
                return false;
            }
            if (this.receiveDataThread == null) {
                this.receiveDataThread = new RFIDWithUHFSerialPortAxBase$ReceiveDataThread(this);
                this.receiveDataThread.start();
            }
            this.updateConnectionState(ConnectionState.CONNECTED);
        } else {
            this.updateConnectionState(ConnectionState.DISCONNECTED);
        }
        this.setPowerOn(bl);
        return bl;
    }

    @Override
    public boolean free() {
        RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase = this;
        rFIDWithUHFSerialPortAxBase.send(rFIDWithUHFSerialPortAxBase.uhfProtocolParse.disableRS232SendData());
        this.readerInfo = null;
        this.rs232Common.a();
        if (this.receiveDataThread != null) {
            this.receiveDataThread.stopThread();
            this.receiveDataThread = null;
        }
        this.setPowerOn(false);
        this.updateConnectionState(ConnectionState.DISCONNECTED);
        return true;
    }

    @Override
    public String getVersion() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getVersionSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseVersionData(object.d);
        System.out.println("getVersion() vesionString:" + (String)object);
        return object;
    }

    @Override
    public int getFrequencyMode() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getFrequencyModeSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        byte by = this.uhfProtocolParse.parseGetFrequencyModeData(object.d);
        System.out.println("getFrequencyMode() err :" + by);
        return by;
    }

    @Override
    public boolean setFrequencyMode(byte by) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFrequencyModeSendData(by);
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetFrequencyModeData(object.d);
        System.out.println("setFrequencyMode() err :" + bl);
        return bl;
    }

    @Override
    public boolean startInventoryTag() {
        return this.startInventoryTag(0, 0, 6);
    }

    private synchronized boolean startInventoryTag(int n, int n2, int n3) {
        if (this.isRuning) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (this.uhfinfoList != null) {
            this.uhfinfoList.clear();
        }
        this.uhfhAxDataHandle.b();
        byte[] byArray = this.uhfProtocolParse.getStartInventoryTagSendData();
        boolean bl = this.send(byArray);
        if (!bl) {
            return false;
        }
        this.isRuning = true;
        this.startInventoryThread();
        return true;
    }

    @Override
    public UHFTAGInfo readTagFromBuffer() {
        Object object = this.receiveTagData();
        if (object == null) {
            return null;
        }
        object = this.uhfProtocolParse.c(((c)object).c);
        return object;
    }

    @Override
    public boolean stopInventory() {
        byte[] byArray = this.uhfProtocolParse.getStopInventorySendData();
        this.send(byArray);
        this.isRuning = false;
        this.stopInventoryThread();
        return true;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> arrayList, int n) {
        if (arrayList == null || arrayList.size() == 0 || n < 0) {
            return null;
        }
        switch (n) {
            case 16: 
            case 32: 
            case 48: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException("lockMode error");
            }
        }
        return super.generateLockCode(arrayList, n);
    }

    @Override
    public boolean lockMem(String object, int n, int n2, int n3, String string, String string2) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getLockSendData((String)object, n, n2, n3, string, string2);
        if ((object = this.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseLockData(((c)object).d);
        System.out.println("lockMem() err :" + bl);
        return bl;
    }

    @Override
    public boolean lockMem(String string, String string2) {
        StringUtility.hexString2Chars(string);
        StringUtility.hexString2Chars(string2);
        boolean bl = this.lockMem(string, 1, 0, 0, "", string2);
        if (bl) {
            return true;
        }
        System.out.println("lockMem() err :" + bl);
        return false;
    }

    @Override
    public UHFTAGInfo inventorySingleTag() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getInventorySingleTagSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        UHFTAGInfo uHFTAGInfo = this.uhfProtocolParse.a(object.d, true);
        object = uHFTAGInfo;
        return uHFTAGInfo;
    }

    @Override
    public String readData(String string, int n, int n2, int n3) {
        if (StringUtility.isEmpty(string) || !StringUtility.isHexNumberRex(string)) {
            return null;
        }
        return this.readData(string, 1, 0, 0, "00", n, n2, n3);
    }

    @Override
    public String readData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        if (!this.isPowerOn()) {
            return null;
        }
        object = this.uhfProtocolParse.getReadSendData((String)object, n, n2, n3, string, n4, n5, n6);
        if ((object = this.sendAndReceive((byte[])object)) == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseReadData(((c)object).d);
        return object;
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2) {
        if (StringUtility.isEmpty(string) || StringUtility.isEmpty(string2)) {
            return false;
        }
        String string3 = "00";
        boolean bl = this.writeData(string, 1, 32, 0, string3, n, n2, n3, string2);
        return bl;
    }

    @Override
    public boolean writeData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6, String string2) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getWriteSendData((String)object, n, n2, n3, string, n4, n5, n6, string2);
        if ((object = this.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseWriteData(((c)object).d);
        return bl;
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String string2) {
        return this.blockWriteData(string, 1, 0, 0, "00", n, n2, n3, string2);
    }

    @Override
    public boolean blockWriteData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6, String string2) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.blockWriteDataSendData((String)object, (char)n, n2, n3, string, (char)n4, n5, (char)n6, string2);
        if ((object = this.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBlockWriteData(((c)object).d);
        return bl;
    }

    @Override
    public boolean eraseData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.blockEraseDataSendData((String)object, (char)n, n2, n3, string, (char)n4, n5, (char)n6);
        if ((object = this.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBlockEraseDataData(((c)object).d);
        return bl;
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3) {
        return this.eraseData(string, 1, 0, 0, "00", n, n2, n3);
    }

    @Override
    public boolean setFilter(int n, int n2, int n3, String string) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFilterSendData((char)n, n2, n3, string);
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetFilterData(object.d);
        return bl;
    }

    @Override
    public boolean killTag(String string) {
        return this.killTag(string, 0, 0, 0, "00");
    }

    @Override
    public boolean killTag(String object, int n, int n2, int n3, String string) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getKillSendData((String)object, n, n2, n3, string);
        if ((object = this.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseKillData(((c)object).d);
        return bl;
    }

    @Override
    public boolean setProtocol(int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setProtocolSendData(n);
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetProtocolData(object.d);
        return bl;
    }

    @Override
    public int getProtocol() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getProtocolSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetProtocolData(object.d);
        return n;
    }

    @Override
    public boolean setFreHop(float f2) {
        if (!this.isPowerOn()) {
            return false;
        }
        int n = (int)(f2 * 1000.0f);
        Object object = this.uhfProtocolParse.setJumpFrequencySendData(n);
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetJumpFrequencyData(object.d);
        return bl;
    }

    @Override
    public boolean setRFLink(int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setRFLinkSendData(n);
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetRFLinkData(object.d);
        return bl;
    }

    @Override
    public int getRFLink() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getRFLinkSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetRFLinkData(object.d);
        return n;
    }

    @Override
    public boolean setFastID(boolean bl) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFastIdSendData(bl ? 1 : 0);
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl2 = this.uhfProtocolParse.parseFastIdData(object.d);
        return bl2;
    }

    @Override
    public boolean setTagFocus(boolean bl) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setTagfocusSendData(bl ? (char)'\u0001' : '\u0000');
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl2 = this.uhfProtocolParse.parseSetTagfocusData(object.d);
        return bl2;
    }

    @Override
    public boolean setEPCMode() {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCModeSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCModeData(object.d);
        return bl;
    }

    @Override
    public boolean setEPCAndTIDMode() {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCAndTIDModeSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCAndTIDModeData(object.d);
        return bl;
    }

    @Override
    public boolean setEPCAndTIDUserMode(int n, int n2) {
        Object object = this.uhfProtocolParse.setEPCAndTIDUserModeSendData(n, n2);
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCAndTIDUserModeData(object.d);
        return bl;
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getEPCTIDModeSendData('\u0000', '\u0000');
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseGetEPCTIDModeData(object.d);
        if (object == null || ((byte[])object).length == 0) {
            return null;
        }
        InventoryModeEntity$Builder inventoryModeEntity$Builder = new InventoryModeEntity$Builder();
        inventoryModeEntity$Builder.setMode(object[0]);
        if (object[0] == 2) {
            inventoryModeEntity$Builder.setUserOffset(object[1]);
            inventoryModeEntity$Builder.setUserLength(object[2]);
        }
        return inventoryModeEntity$Builder.build();
    }

    @Override
    public int getTemperature() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getTemperatureSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseTemperatureData(object.d);
        return n;
    }

    @Override
    public boolean uhfBlockPermalock(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, int n7, byte[] byArray) {
        return false;
    }

    @Override
    public boolean setGen2(Gen2Entity object) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.setGen2SendData((Gen2Entity)object);
        if ((object = this.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetGen2Data(((c)object).d);
        return bl;
    }

    @Override
    public Gen2Entity getGen2() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getGen2SendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseGetGen2Data(object.d);
        if (object == null) {
            return null;
        }
        Gen2Entity gen2Entity = new Gen2Entity();
        gen2Entity.setSelectTarget(object[0]);
        gen2Entity.setSelectAction(object[1]);
        gen2Entity.setSelectTruncate(object[2]);
        gen2Entity.setQ(object[3]);
        gen2Entity.setStartQ(object[4]);
        gen2Entity.setMinQ(object[5]);
        gen2Entity.setMaxQ(object[6]);
        gen2Entity.setQueryDR(object[7]);
        gen2Entity.setQueryM(object[8]);
        gen2Entity.setQueryTRext(object[9]);
        gen2Entity.setQuerySel(object[10]);
        gen2Entity.setQuerySession(object[11]);
        gen2Entity.setQueryTarget(object[12]);
        gen2Entity.setLinkFrequency(object[13]);
        return gen2Entity;
    }

    @Override
    public boolean setPwm(int n, int n2) {
        return false;
    }

    @Override
    public int[] getPwm() {
        return null;
    }

    @Override
    public boolean setCW(int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setCWSendData((char)n);
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetCWData(object.d);
    }

    @Override
    public int getCW() {
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getCWSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        return this.uhfProtocolParse.parseGetCWData(object.d);
    }

    @Override
    public boolean uhfJump2Boot() {
        this.isCheckGPIO = false;
        Object object = this.uhfProtocolParse.uhfJump2BootSendData('\u0001');
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.isCheckGPIO = true;
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFJump2BootData(object.d);
        if (!bl) {
            this.isCheckGPIO = true;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    @Override
    public boolean uhfJump2BootToSTM32() {
        return false;
    }

    @Override
    public boolean uhfStartUpdate() {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.uhfStartUpdateSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.isCheckGPIO = true;
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFStartUpdateData(object.d);
        if (!bl) {
            this.isCheckGPIO = true;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    @Override
    public boolean uhfUpdating(byte[] object) {
        int n;
        byte[] byArray = new byte[64];
        if (((byte[])object).length < 64) {
            for (n = 0; n < ((byte[])object).length; ++n) {
                byArray[n] = object[n];
            }
        } else {
            for (n = 0; n < 64; ++n) {
                byArray[n] = object[n];
            }
        }
        if (!this.isPowerOn()) {
            return false;
        }
        byte[] byArray2 = this.uhfProtocolParse.uhfUpdatingSendData(byArray);
        c c2 = this.sendAndReceive(byArray2, -1, 5000);
        object = c2;
        if (c2 == null) {
            this.isCheckGPIO = true;
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFUpdatingData(object.d);
        if (!bl) {
            this.isCheckGPIO = true;
        }
        return bl;
    }

    @Override
    public boolean uhfStopUpdate() {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.UHFStopUpdateSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.isCheckGPIO = true;
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFStopUpdateData(object.d);
        this.isCheckGPIO = true;
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    @Override
    public char[] getBeep() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getReaderBeepStatusSendData();
        c c2 = this.sendAndReceive((byte[])object, 8);
        object = c2;
        if (c2 == null) {
            System.out.println("send data null");
            return null;
        }
        int n = this.uhfProtocolParse.parseGetReaderBeepStatusData(object.d);
        char[] cArray = new char[]{'\u0000', (char)n};
        return cArray;
    }

    @Override
    public boolean setBeep(int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.getBeepSendData(n == 1);
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBeepData(object.d);
        return bl;
    }

    @Override
    public void buzzerOn(int n) {
        if (n < 100 || n > 65535) {
            throw new IllegalArgumentException("Invalid parameter!");
        }
        Object object = this.uhfProtocolParse.setBuzzerOnOfAndroidSendData(n);
        c c2 = this.sendAndReceive((byte[])object, 13);
        object = c2;
        if (c2 == null) {
            return;
        }
        this.uhfProtocolParse.parseSetBuzzerOnOfAndroidData(object.d);
    }

    @Override
    public void buzzerOff() {
        if (!this.isPowerOn()) {
            return;
        }
        Object object = this.uhfProtocolParse.setBuzzerOffOfAndroidSendData();
        c c2 = this.sendAndReceive((byte[])object, 13);
        object = c2;
        if (c2 == null) {
            return;
        }
        this.uhfProtocolParse.parseSetBuzzeroffOfAndroidData(object.d);
    }

    @Override
    public String getTcpServiceVersion() {
        if (!this.isPowerOn()) {
            return "";
        }
        Object object = this.uhfProtocolParse.getUpgradeTcpServiceVersionSendData();
        c c2 = this.sendAndReceive((byte[])object, 22);
        object = c2;
        if (c2 == null) {
            return null;
        }
        return this.uhfProtocolParse.parseGetUpgradeTcpServiceVersionData(object.d);
    }

    @Override
    public boolean setEthernetConfigInfo(ReaderIPEntity object) {
        if (object == null || ((ReaderIPEntity)object).getIp() == null) {
            return false;
        }
        if (!StringUtility.isIPAddress(((ReaderIPEntity)object).getIp())) {
            throw new IllegalArgumentException("ip error!");
        }
        if (!StringUtility.isIPAddress(((ReaderIPEntity)object).getGateway())) {
            throw new IllegalArgumentException("gateway error!");
        }
        if (!StringUtility.isIPAddress(((ReaderIPEntity)object).getSubnetMask())) {
            throw new IllegalArgumentException("subnetMask error!");
        }
        if (!StringUtility.isIPAddress(((ReaderIPEntity)object).getDns1())) {
            throw new IllegalArgumentException("dns1 error!");
        }
        if (((ReaderIPEntity)object).getDns2() != null && !((ReaderIPEntity)object).getDns2().isEmpty() && !StringUtility.isIPAddress(((ReaderIPEntity)object).getDns2())) {
            throw new IllegalArgumentException("dns2 error!");
        }
        if (this.isRuning) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.setEthernetConfigInfoSendData((ReaderIPEntity)object);
        if ((object = this.sendAndReceive((byte[])object, 24)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseEthernetConfigInfoData(((c)object).d);
        return bl;
    }

    @Override
    public boolean setWifiConfigInfo(WifiConfig object) {
        Object object2;
        if (object == null || ((WifiConfig)object).getSsid() == null) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (((WifiConfig)object).isStaticIp()) {
            object2 = ((WifiConfig)object).getStaticIpConfig();
            if (!StringUtility.isIPAddress(((ReaderIPEntity)object2).getIp())) {
                throw new IllegalArgumentException("ip error!");
            }
            if (!StringUtility.isIPAddress(((ReaderIPEntity)object2).getGateway())) {
                throw new IllegalArgumentException("gateway error!");
            }
            if (!StringUtility.isIPAddress(((ReaderIPEntity)object2).getSubnetMask())) {
                throw new IllegalArgumentException("subnetMask error!");
            }
            if (!StringUtility.isIPAddress(((ReaderIPEntity)object2).getDns1())) {
                throw new IllegalArgumentException("dns1 error!");
            }
            if (((ReaderIPEntity)object2).getDns2() != null && !((ReaderIPEntity)object2).getDns2().isEmpty() && !StringUtility.isIPAddress(((ReaderIPEntity)object2).getDns2())) {
                throw new IllegalArgumentException("dns2 error!");
            }
        }
        if ((object = this.sendAndReceive((byte[])(object2 = (Object)this.uhfProtocolParse.setWifiConfigInfoSendData((WifiConfig)object)), 25)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseWifiConfigInfoData(((c)object).d);
        return bl;
    }

    @Override
    public boolean setTcpServicePort(int n) {
        if (n <= 0) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setPortSendData(n);
        c c2 = this.sendAndReceive((byte[])object, 32);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parsePortData(object.d);
        return bl;
    }

    @Override
    public String GetWifiInfo() {
        byte[] byArray = this.uhfProtocolParse.getWifiInfoSendData();
        this.isParse = false;
        this.cleanReceiveData();
        int n = this.send(byArray);
        byte[] byArray2 = new byte[10240];
        int n2 = 0;
        int n3 = 0;
        if (n != 0) {
            for (n = 0; n < 80; ++n) {
                byte[] byArray3 = this.rs232Common.b();
                if (byArray3 != null) {
                    System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
                    System.out.println("receive data index=" + (n2 += byArray3.length));
                } else {
                    System.out.println("receive data buff==null");
                    if (n2 > 0) {
                        ++n3;
                    }
                    if (n3 >= 30) break;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
            }
            this.isParse = true;
            if (n2 > 0) {
                String string = null;
                try {
                    string = new String(byArray2, 0, n2, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("receive ex=" + unsupportedEncodingException);
                }
                System.out.println("receive data =" + string);
                return string;
            }
        }
        return "";
    }

    @Override
    public boolean openWifi() {
        Object object = this.uhfProtocolParse.openWifiSendData(true);
        System.out.println("send data" + StringUtility.bytes2HexString(object, ((byte[])object).length));
        c c2 = this.sendAndReceive((byte[])object, 35);
        object = c2;
        if (c2 == null) {
            System.out.println("send data null");
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseOpenWifiData(object.d);
        return bl;
    }

    @Override
    public boolean closeWifi() {
        Object object = this.uhfProtocolParse.openWifiSendData(false);
        System.out.println("send data" + StringUtility.bytes2HexString(object, ((byte[])object).length));
        c c2 = this.sendAndReceive((byte[])object, 35);
        object = c2;
        if (c2 == null) {
            System.out.println("send data null");
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseOpenWifiData(object.d);
        return bl;
    }

    @Override
    public void readyUpgradeTcpService() {
        this.upgradeDataList.clear();
    }

    @Override
    public boolean setUpgradeTcpServiceData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.upgradeDataList.add(byArray[i2]);
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean startUpgradeTcpService() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        this.inventoryCallback = iUHFInventoryCallback;
    }

    @Override
    public void setUpgradeProgress(IUpgradeProgress iUpgradeProgress) {
        this.iUpgradeProgress = iUpgradeProgress;
    }

    @Override
    public void setGPIStateCallback(IGPIStateCallback iGPIStateCallback) {
        this.uhfGPIOStateCallback = iGPIStateCallback;
    }

    @Override
    public void setConnectionStateCallback(ConnectionStateCallback connectionStateCallback) {
        this.btStateCallback = connectionStateCallback;
    }

    public ArrayList<String> getComList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<CommPortIdentifier> arrayList2 = b.c();
        for (int i2 = 0; arrayList2 != null && i2 < arrayList2.size(); ++i2) {
            arrayList.add(arrayList2.get(i2).getName());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    @Override
    public String getAndroidDeviceHardwareVersion() {
        Object object = this.uhfProtocolParse.getAndroidDeviceHardwareVersionSendData();
        System.out.println("send data" + StringUtility.bytes2HexString(object, ((byte[])object).length));
        c c2 = this.sendAndReceive((byte[])object, 36);
        object = c2;
        if (c2 == null) {
            System.out.println("send data null");
            return "";
        }
        String string = this.uhfProtocolParse.parseAndroidDeviceHardwareVersionData(object.d);
        object = string;
        return string;
    }

    @Override
    public String getEthernetIpConfig() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getEthernetIpConfigSendData();
        c c2 = this.sendAndReceive((byte[])object, 37);
        object = c2;
        if (c2 == null) {
            return null;
        }
        String string = this.uhfProtocolParse.parseGetEthernetIpConfigData(object.d);
        object = string;
        return string;
    }

    @Override
    public String getWifiIpConfig() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getWifiIpConfigSendData();
        c c2 = this.sendAndReceive((byte[])object, 38);
        object = c2;
        if (c2 == null) {
            return null;
        }
        String string = this.uhfProtocolParse.parseGetWifiIpConfigData(object.d);
        object = string;
        return string;
    }

    @Override
    public boolean setAntennaWorkTime(AntennaNameEnum object, int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        if (n < 10 || n > 65535) {
            throw new IllegalArgumentException("WorkTime error !");
        }
        object = this.uhfProtocolParse.setAntWorkTimeSendData((byte)object.getValue(), n);
        if ((object = this.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetAntWorkTimeReceiveData(((c)object).d);
        System.out.println("setAntWorkTime() reuslt :" + bl);
        return bl;
    }

    @Override
    public int getAntennaWorkTime(AntennaNameEnum object) {
        if (!this.isPowerOn()) {
            return -1;
        }
        object = this.uhfProtocolParse.getAntWorkTimeSendData((byte)object.getValue());
        if ((object = this.sendAndReceive((byte[])object)) == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetAntWorkTimeReceiveData(((c)object).d);
        System.out.println("getAntWorkTime() result :" + n);
        return n;
    }

    @Override
    public boolean setAntenna(List<AntennaState> object) {
        if (object == null || object.size() == 0) {
            return false;
        }
        byte[] byArray = new byte[2];
        for (int i2 = 0; i2 < object.size(); ++i2) {
            if (!object.get(i2).isEnable()) continue;
            if (object.get(i2).getAntennaName() == AntennaNameEnum.ANT1) {
                byArray[1] = (byte)(byArray[1] | 1);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT2) {
                byArray[1] = (byte)(byArray[1] | 2);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT3) {
                byArray[1] = (byte)(byArray[1] | 4);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT4) {
                byArray[1] = (byte)(byArray[1] | 8);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT5) {
                byArray[1] = (byte)(byArray[1] | 0x10);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT6) {
                byArray[1] = (byte)(byArray[1] | 0x20);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT7) {
                byArray[1] = (byte)(byArray[1] | 0x40);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() != AntennaNameEnum.ANT8) continue;
            byArray[1] = (byte)(byArray[1] | 0x80);
        }
        byte[] byArray2 = this.uhfProtocolParse.setAntSendData('\u0001', byArray);
        object = this.sendAndReceive(byArray2);
        if (object == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetAntData(((c)object).d);
        return bl;
    }

    @Override
    public List<AntennaState> getAntenna() {
        Object object = this.uhfProtocolParse.getAntSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseGetAntData(object.d);
        if (object == null || ((byte[])object).length < 2) {
            return null;
        }
        ArrayList<AntennaState> arrayList = new ArrayList<AntennaState>();
        arrayList.add(new AntennaState(AntennaNameEnum.ANT1, (object[1] & 0xFF & 1) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT2, (object[1] & 0xFF & 2) == 2));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT3, (object[1] & 0xFF & 4) == 4));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT4, (object[1] & 0xFF & 8) == 8));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT5, (object[1] & 0xFF & 0x10) == 16));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT6, (object[1] & 0xFF & 0x20) == 32));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT7, (object[1] & 0xFF & 0x40) == 64));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT8, (object[1] & 0xFF & 0x80) == 128));
        return arrayList;
    }

    @Override
    public boolean rebootDevice() {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.getAndroidDeviceRebootSendData();
        c c2 = this.sendAndReceive((byte[])object, 41);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseAndroidDeviceRebootData(object.d);
        return bl;
    }

    @Override
    public boolean setPower(AntennaNameEnum object, int n) {
        if (!this.isPowerOn()) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (n > 30) {
            n = 30;
        } else if (n <= 0) {
            n = 1;
        }
        object = this.uhfProtocolParse.setPowerSendData(object.getValue(), n);
        object = this.sendAndReceive((byte[])object);
        if (object == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetPowerData(((c)object).d);
        System.out.println("setPower() err :" + bl);
        return bl;
    }

    @Override
    public int getPower(AntennaNameEnum antennaNameEnum) {
        List<AntennaPowerEntity> list = this.getPowerAll();
        if (list == null || list.size() == 0) {
            return -1;
        }
        for (AntennaPowerEntity antennaPowerEntity : list) {
            if (antennaPowerEntity.getAntennaNameEnum() != antennaNameEnum) continue;
            return antennaPowerEntity.getPower();
        }
        return -1;
    }

    @Override
    public boolean setEthernetIpDynamicAssign() {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEthernetDynamicSendData();
        c c2 = this.sendAndReceive((byte[])object, 50);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEthernetDynamicResultData(object.d);
        return bl;
    }

    public void setFilterRepeatData(int n) {
        block3: {
            block4: {
                block2: {
                    if (n <= 0 || n > 2) {
                        throw new IllegalArgumentException("bank invalid!");
                    }
                    this.isFilterRepeatBank = n;
                    if (n != 0) break block2;
                    if (this.uhfinfoList == null) break block3;
                    break block4;
                }
                if (this.uhfinfoList == null) {
                    this.uhfinfoList = new ArrayList<UHFTAGInfo>();
                }
            }
            this.uhfinfoList.clear();
        }
    }

    @Override
    public ReaderIPEntity getReaderCurrentIp() {
        if (!this.isPowerOn()) {
            return null;
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getUHFCurrentIpConfigSendData();
        c c2 = this.sendAndReceive((byte[])object, 54, 4000);
        object = c2;
        if (c2 == null) {
            return null;
        }
        ReaderIPEntity readerIPEntity = this.uhfProtocolParse.parseUHFCurrentIpConfigResultData(object.d);
        object = readerIPEntity;
        return readerIPEntity;
    }

    private boolean sendUpgradeFileSizeAndMd5(long l2, String string) {
        Object object = this.uhfProtocolParse.startUpgradeTcpServiceSendData(l2, StringUtility.hexStringToBytes(string));
        c c2 = this.sendAndReceive((byte[])object, 21);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseStartUpgradeTcpServiceData(object.d);
        return bl;
    }

    @Override
    public ReaderInfo getReaderInfo() {
        if (!this.isPowerOn()) {
            return null;
        }
        if (this.readerInfo != null) {
            return this.readerInfo;
        }
        Object object = this.uhfProtocolParse.getReaderInfoSendData();
        c c2 = this.sendAndReceive((byte[])object, 66);
        object = c2;
        if (c2 == null) {
            return null;
        }
        ReaderInfo readerInfo = this.uhfProtocolParse.parseGetReaderInfoResultData(object.d);
        object = readerInfo;
        if (readerInfo != null) {
            this.readerInfo = object;
        }
        return object;
    }

    private static String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return simpleDateFormat.format(new Date());
    }

    protected c receiveGPIOData() {
        return this.uhfhAxDataHandle.d();
    }

    protected byte[] receiveData() {
        return this.rs232Common.b();
    }

    protected void cleanReceiveData() {
        for (int i2 = 0; i2 < 20; ++i2) {
            byte[] byArray = this.rs232Common.b();
            if (byArray != null) {
                System.out.println("data=" + byArray.length);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected c receiveTagData() {
        return this.uhfhAxDataHandle.a();
    }

    protected synchronized boolean send(byte[] byArray) {
        return this.rs232Common.a(byArray);
    }

    protected c sendAndReceive(byte[] byArray) {
        return this.sendAndReceive(byArray, -1, 2000);
    }

    protected c sendAndReceive(byte[] byArray, int n) {
        return this.sendAndReceive(byArray, n, 2000);
    }

    protected c sendAndReceive(byte[] byArray, int n, int n2) {
        long l2 = System.currentTimeMillis();
        if (this.curr_status != ConnectionState.CONNECTED) {
            return null;
        }
        boolean bl = this.send(byArray);
        if (bl) {
            int n3 = (byArray[4] & 0xFF) + 1;
            while (System.currentTimeMillis() - l2 < (long)n2) {
                List<c> list = this.uhfhAxDataHandle.a(n3, n);
                if (list != null) {
                    return list.get(0);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    list = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
        }
        return null;
    }

    public boolean checkConnectState() {
        System.out.println("cheackConnectState()");
        byte[] byArray = this.uhfProtocolParse.getReaderInfoSendData();
        try {
            this.rs232Common.a(byArray);
        }
        catch (Exception exception) {
            System.out.println("cheackConnectState outputStream.write ex=" + exception.toString());
        }
        boolean bl = false;
        long l2 = 0L;
        for (int i2 = 0; i2 < 100; ++i2) {
            try {
                byte[] byArray2 = this.rs232Common.b();
                if (byArray2 != null && byArray2.length > 0) {
                    bl = true;
                    l2 = System.currentTimeMillis();
                    this.readerInfo = this.uhfProtocolParse.parseGetReaderInfoResultData(byArray2);
                    System.out.println("cheackConnectState return true! readerInfo=" + this.readerInfo);
                    System.out.println("cheackConnectState()" + StringUtility.bytes2HexString2(byArray2, byArray2.length));
                    if (this.readerInfo != null) {
                        return true;
                    }
                }
                Thread.sleep(100L);
                if (i2 % 40 == 0) {
                    this.rs232Common.a(byArray);
                }
            }
            catch (Exception exception) {
                System.out.println("cheackConnectState outputStream.write exception=" + exception.toString());
            }
            if (!bl || System.currentTimeMillis() - l2 <= 2000L) continue;
            return true;
        }
        System.out.println("cheackConnectState()= false");
        return false;
    }

    private void startInventoryThread() {
        if (this.inventoryThread == null) {
            this.inventoryThread = new RFIDWithUHFSerialPortAxBase$InventoryThread(this);
            this.inventoryThread.start();
        }
    }

    private void stopInventoryThread() {
        if (this.inventoryThread != null) {
            this.inventoryThread.stopThread();
            this.inventoryThread = null;
        }
    }

    @Override
    public ConnectionState getConnectStatus() {
        return this.curr_status;
    }

    static /* synthetic */ ConnectionStateCallback access$000(RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase) {
        return rFIDWithUHFSerialPortAxBase.btStateCallback;
    }

    static /* synthetic */ boolean access$100(RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase) {
        return rFIDWithUHFSerialPortAxBase.isParse;
    }

    static /* synthetic */ e access$200(RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase) {
        return rFIDWithUHFSerialPortAxBase.uhfhAxDataHandle;
    }

    static /* synthetic */ boolean access$300(RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase) {
        return rFIDWithUHFSerialPortAxBase.isCheckGPIO;
    }

    static /* synthetic */ boolean access$400(RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase) {
        return rFIDWithUHFSerialPortAxBase.autoCheckConnectStatus;
    }

    static /* synthetic */ int access$500(RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase) {
        return rFIDWithUHFSerialPortAxBase.ConnectTimeOut;
    }

    static /* synthetic */ RFIDWithUHFSerialPortAxBase$ReceiveDataThread access$602(RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase, RFIDWithUHFSerialPortAxBase$ReceiveDataThread rFIDWithUHFSerialPortAxBase$ReceiveDataThread) {
        rFIDWithUHFSerialPortAxBase.receiveDataThread = rFIDWithUHFSerialPortAxBase$ReceiveDataThread;
        return rFIDWithUHFSerialPortAxBase.receiveDataThread;
    }

    static /* synthetic */ int access$700(RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase) {
        return rFIDWithUHFSerialPortAxBase.isFilterRepeatBank;
    }

    static /* synthetic */ IUHFInventoryCallback access$800(RFIDWithUHFSerialPortAxBase rFIDWithUHFSerialPortAxBase) {
        return rFIDWithUHFSerialPortAxBase.inventoryCallback;
    }
}

