/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.RFIDWithUHFSerialPortA8$GPIOStateThread;
import com.rscja.deviceapi.RFIDWithUHFSerialPortAxBase;
import com.rscja.deviceapi.b.c;
import com.rscja.deviceapi.entity.AntennaPowerEntity;
import com.rscja.deviceapi.entity.GPIOInfo;
import com.rscja.deviceapi.entity.GPIStateEntity;
import com.rscja.deviceapi.entity.GPOEntity;
import com.rscja.deviceapi.h;
import com.rscja.deviceapi.interfaces.IUHFA8;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;

public class RFIDWithUHFSerialPortA8
extends RFIDWithUHFSerialPortAxBase
implements IUHFA8,
Observer {
    private RFIDWithUHFSerialPortA8$GPIOStateThread gpioStateThread = null;
    private h uhfProtocolParseA4 = new h();
    private boolean isGPIStateReverse = false;
    private GPIOInfo gpioInfo = null;

    @Override
    public boolean init(String string) {
        boolean bl = super.init(string);
        if (bl && this.gpioStateThread == null) {
            this.gpioStateThread = new RFIDWithUHFSerialPortA8$GPIOStateThread(this);
            this.gpioStateThread.start();
        }
        return bl;
    }

    @Override
    public synchronized boolean free() {
        if (this.gpioStateThread != null) {
            this.gpioStateThread.stopThread();
            this.gpioStateThread = null;
        }
        boolean bl = super.free();
        this.gpioInfo = null;
        return bl;
    }

    @Override
    public void output3OnAndOff(boolean bl) {
        if (!this.isPowerOn()) {
            return;
        }
        Object object = this.uhfProtocolParseA4.setA4GPIO03SendData(bl ? 1 : 0);
        c c2 = this.sendAndReceive((byte[])object, 16);
        object = c2;
        if (c2 == null) {
            return;
        }
        this.uhfProtocolParseA4.parseSetA4GPIO03Data(object.d);
    }

    @Override
    public void output4OnAndOff(boolean bl) {
        if (!this.isPowerOn()) {
            return;
        }
        Object object = this.uhfProtocolParseA4.setA4GPIO04SendData(bl ? 1 : 0);
        c c2 = this.sendAndReceive((byte[])object, 17);
        object = c2;
        if (c2 == null) {
            return;
        }
        this.uhfProtocolParseA4.parseSetA4GPIO04Data(object.d);
    }

    @Override
    public void outputOnAndOff(List<GPOEntity> list) {
        Object object;
        byte[] byArray = new byte[]{-1, -1, -1, -1, -1, -1};
        block16: for (int i2 = 0; i2 < list.size() && i2 < 6; ++i2) {
            object = list.get(i2);
            switch (((GPOEntity)object).getGpoName()) {
                case "GPO1": {
                    byArray[0] = (byte)((GPOEntity)object).getGpoState();
                    continue block16;
                }
                case "GPO2": {
                    byArray[1] = (byte)((GPOEntity)object).getGpoState();
                    continue block16;
                }
                case "GPO3": {
                    byArray[2] = (byte)((GPOEntity)object).getGpoState();
                    continue block16;
                }
                case "GPO4": {
                    byArray[3] = (byte)((GPOEntity)object).getGpoState();
                    continue block16;
                }
                case "WiegandData0": {
                    byArray[4] = (byte)((GPOEntity)object).getGpoState();
                    continue block16;
                }
                case "WiegandData1": {
                    byArray[5] = (byte)((GPOEntity)object).getGpoState();
                }
            }
        }
        if (!this.isPowerOn()) {
            return;
        }
        byte[] byArray2 = this.uhfProtocolParseA4.outputOnAndOffSendData(byArray);
        object = this.sendAndReceive(byArray2, 23);
        if (object == null) {
            return;
        }
        this.uhfProtocolParseA4.parseOutputOnAndOffData(((c)object).d);
    }

    @Override
    public List<AntennaPowerEntity> getPowerAll() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getPowerSendData();
        c c2 = this.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseGetPowerAllData(((c)object).d);
        for (int i2 = (v31488).size() - 1; i2 >= 0; --i2) {
            if (((AntennaPowerEntity)object.get(i2)).getAntennaNameEnum().getValue() <= 8) continue;
            object.remove(i2);
        }
        return object;
    }

    @Override
    public void setGPIStateReverse(boolean bl) {
        this.isGPIStateReverse = bl;
    }

    private int reversal0And1(int n) {
        if (!this.isGPIStateReverse) {
            return n;
        }
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    private void parseGPIO(c c2) {
        if (c2 != null) {
            if (this.uhfGPIOStateCallback != null) {
                int n = (c2.c[1] & 0xFF) << 8 | c2.c[2] & 0xFF;
                int n2 = n & 1;
                int n3 = (n & 2) == 2 ? 1 : 0;
                int n4 = n = (n & 4) == 4 ? 1 : 0;
                if (n2 == 1 && this.uhfGPIOStateCallback != null) {
                    Object object = this.gpioInfo;
                    n3 = this.reversal0And1(n3);
                    n = this.reversal0And1(n);
                    if (object == null || ((GPIOInfo)object).getData().length != c2.c.length) {
                        ArrayList<GPIStateEntity> arrayList = new ArrayList<GPIStateEntity>();
                        arrayList.add(new GPIStateEntity("GPI1", n3));
                        arrayList.add(new GPIStateEntity("GPI2", n));
                        this.uhfGPIOStateCallback.callback(arrayList);
                    } else {
                        for (int i2 = 0; i2 < ((GPIOInfo)object).getData().length; ++i2) {
                            if (((GPIOInfo)object).getData()[i2] == c2.c[i2]) continue;
                            object = new ArrayList<GPIStateEntity>();
                            object.add(new GPIStateEntity("GPI1", n3));
                            object.add(new GPIStateEntity("GPI2", n));
                            this.uhfGPIOStateCallback.callback((List<GPIStateEntity>)object);
                            break;
                        }
                    }
                }
            }
            if (this.gpioInfo != null) {
                this.gpioInfo.setData(c2.c);
                this.gpioInfo.setFullData(c2.d);
                return;
            }
            this.gpioInfo = new GPIOInfo();
            this.gpioInfo.setControlWork(c2.c[0]);
            this.gpioInfo.setData(c2.c);
            this.gpioInfo.setFullData(c2.d);
        }
    }

    static /* synthetic */ void access$000(RFIDWithUHFSerialPortA8 rFIDWithUHFSerialPortA8, c c2) {
        rFIDWithUHFSerialPortA8.parseGPIO(c2);
    }

    static /* synthetic */ GPIOInfo access$102(RFIDWithUHFSerialPortA8 rFIDWithUHFSerialPortA8, GPIOInfo gPIOInfo) {
        rFIDWithUHFSerialPortA8.gpioInfo = gPIOInfo;
        return rFIDWithUHFSerialPortA8.gpioInfo;
    }
}

