/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.RFIDWithUHFNetworkA4;
import com.rscja.deviceapi.RFIDWithUHFNetworkChannelGate$1;
import com.rscja.deviceapi.RFIDWithUHFNetworkChannelGate$2;
import com.rscja.deviceapi.RFIDWithUHFNetworkChannelGate$3;
import com.rscja.deviceapi.RFIDWithUHFNetworkChannelGate$4;
import com.rscja.deviceapi.RFIDWithUHFNetworkChannelGate$5;
import com.rscja.deviceapi.RFIDWithUHFNetworkChannelGate$6;
import com.rscja.deviceapi.RFIDWithUHFNetworkChannelGate$7;
import com.rscja.deviceapi.RFIDWithUHFNetworkChannelGate$8;
import com.rscja.deviceapi.RFIDWithUHFNetworkChannelGate$BuzzerNotifyThread;
import com.rscja.deviceapi.entity.GPIStateEntity;
import com.rscja.deviceapi.interfaces.IChannelGate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class RFIDWithUHFNetworkChannelGate
extends RFIDWithUHFNetworkA4 {
    private String TAG = "RFIDWithUHFNetworkChannelGate";
    private Timer timerStopInventory = new Timer();
    private Timer timerClerState = new Timer();
    private Timer timerClerOutState = null;
    private Timer timerClerEnterState = null;
    private int GPIO1_previous = 0;
    private int GPIO2_previous = 0;
    private int start_value = 0;
    private Object lockObject = new Object();
    private boolean isReadyInventory = false;
    private RFIDWithUHFNetworkChannelGate$BuzzerNotifyThread buzzerNotifyThread;
    private boolean isAutoTrigge = true;
    private IChannelGate iChannelGate;
    private int gpio_start_value = 0;
    private int enter_start = 0;
    private int out_start = 0;
    int out_state = 0;
    int enter_state = 0;

    @Override
    public boolean init(String string, int n) {
        boolean bl = super.init(string, n);
        if (bl) {
            this.openBuzzerNotifyThread();
        }
        this.turnOffBlueLight();
        this.turnOffRedLight();
        this.setBaseParameter();
        return bl;
    }

    @Override
    public boolean free() {
        this.closeBuzzerNotifyThread();
        this.turnOffBlueLight();
        this.turnOffRedLight();
        boolean bl = super.free();
        return bl;
    }

    private void setBaseParameter() {
        super.setGPIStateCallback(new RFIDWithUHFNetworkChannelGate$1(this));
    }

    public void turnOnBlueLight() {
        this.output1OnAndOff(true);
    }

    public void turnOffBlueLight() {
        this.output1OnAndOff(false);
    }

    public void turnOnRedLight() {
        this.output2OnAndOff(true);
    }

    public void turnOffRedLight() {
        this.output2OnAndOff(false);
    }

    public void setBuzzerOnLargerSound(int n) {
        if (n < 100) {
            n = 100;
        }
        this.buzzer(n);
    }

    public void setBuzzerOffLargerSound() {
        this.buzzer(0);
    }

    private void buzzer(int n) {
        if (this.buzzerNotifyThread != null) {
            this.buzzerNotifyThread.activatorNotify(n);
        }
    }

    private void closeBuzzerNotifyThread() {
        if (this.buzzerNotifyThread != null) {
            this.buzzerNotifyThread.stopThread();
            this.buzzerNotifyThread = null;
        }
    }

    private void openBuzzerNotifyThread() {
        if (this.buzzerNotifyThread == null) {
            this.buzzerNotifyThread = new RFIDWithUHFNetworkChannelGate$BuzzerNotifyThread(this, null);
            this.buzzerNotifyThread.start();
        }
    }

    public void setIChannelGate(IChannelGate iChannelGate) {
        this.iChannelGate = iChannelGate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean startInventoryTag() {
        this.isReadyInventory = true;
        if (this.isStoping) {
            Object object = this.lockObject;
            synchronized (object) {
                this.lockObject.notifyAll();
            }
        }
        return super.startInventoryTag();
    }

    @Override
    public synchronized boolean stopInventory() {
        this.isReadyInventory = false;
        if (!this.isStoping) {
            this.isStoping = true;
            new Thread(new RFIDWithUHFNetworkChannelGate$2(this)).start();
        }
        return true;
    }

    private void stopInventory2() {
        super.stopInventory();
    }

    private void channelGateState(List<GPIStateEntity> list) {
        int[] nArray = new int[4];
        int[] nArray2 = nArray;
        nArray[0] = list.get(0).getGPIState();
        nArray2[1] = list.get(1).getGPIState();
        nArray2[2] = list.get(2).getGPIState();
        nArray2[3] = list.get(3).getGPIState();
        if (nArray2[0] == this.GPIO1_previous && nArray2[1] == this.GPIO2_previous) {
            return;
        }
        int n = nArray2[0];
        int n2 = nArray2[1];
        if (n == 1 && n2 == 0) {
            if (this.enter_state == 1 || this.enter_state == 2) {
                this.enter_state = 2;
                if (this.timerClerEnterState != null) {
                    this.timerClerEnterState.cancel();
                    this.timerClerEnterState = null;
                }
            } else if (this.out_state == 0) {
                this.out_state = 1;
                if (this.iChannelGate != null) {
                    this.iChannelGate.outing();
                }
            }
        } else if (n == 0 && n2 == 1) {
            if (this.out_state == 1 || this.out_state == 2) {
                this.out_state = 2;
                if (this.timerClerOutState != null) {
                    this.timerClerOutState.cancel();
                    this.timerClerOutState = null;
                }
            } else if (this.enter_state == 0) {
                this.enter_state = 1;
                if (this.iChannelGate != null) {
                    this.iChannelGate.entering();
                }
            }
        } else if (n == 1 && n2 == 1) {
            if (this.enter_state == 1) {
                this.enter_state = 2;
                if (this.timerClerEnterState != null) {
                    this.timerClerEnterState.cancel();
                    this.timerClerEnterState = null;
                }
            } else if (this.out_state == 1) {
                this.out_state = 2;
                if (this.timerClerOutState != null) {
                    this.timerClerOutState.cancel();
                    this.timerClerOutState = null;
                }
            }
        } else if (n == 0 && n2 == 0) {
            if (this.out_state == 2) {
                this.out_state = 0;
                if (this.iChannelGate != null) {
                    this.iChannelGate.outed();
                }
            } else if (this.enter_state == 2) {
                this.enter_state = 0;
                if (this.iChannelGate != null) {
                    this.iChannelGate.entered();
                }
            } else {
                if (this.enter_state == 1 && this.timerClerEnterState == null) {
                    this.timerClerEnterState = new Timer();
                    this.timerClerEnterState.schedule((TimerTask)new RFIDWithUHFNetworkChannelGate$3(this), 2000L);
                }
                if (this.out_state == 1 && this.timerClerOutState == null) {
                    this.timerClerOutState = new Timer();
                    this.timerClerOutState.schedule((TimerTask)new RFIDWithUHFNetworkChannelGate$4(this), 2000L);
                }
            }
        }
        this.GPIO1_previous = nArray2[0];
        this.GPIO2_previous = nArray2[1];
    }

    private static String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return simpleDateFormat.format(new Date());
    }

    private void autoTriggeInventory(int[] nArray) {
        if (nArray[0] == this.GPIO1_previous && nArray[1] == this.GPIO2_previous) {
            System.out.println("inputStateCallback==> gpio1\u30012 \u6ca1\u6709\u53d1\u9001\u6539\u53d8!");
            return;
        }
        System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>input1:" + (nArray[0] == 1 ? "\u906e\u6321" : "\u65e0") + "  input2:" + (nArray[1] == 1 ? "\u906e\u6321" : "\u65e0") + "  input3:" + nArray[2] + "  input4:" + nArray[3]);
        if (nArray[0] == 1 && this.start_value == 0) {
            boolean bl = this.startInventoryTag();
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u91cc\u9762\u51fa\u6765\u7684 \uff0c\u89e6\u53d1\u7b2c\u4e00\u7ec4\u7ea2\u5916\u5f00\u59cb\u76d8\u70b9(" + bl + ") start_value==0    \u8bbe\u7f6estart_value=1   | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 1;
        } else if (nArray[0] == 1 && nArray[1] == 1 && this.start_value == 1) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u91cc\u9762\u51fa\u6765\u7684\uff0c\u4e24\u7ec4\u7ea2\u5916\u540c\u65f6\u88ab\u6321\uff0c\u6682\u4e0d\u5904\u7406  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 2;
        } else if (nArray[1] == 1 && this.start_value == 1) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u91cc\u9762\u51fa\u6765\u7684\uff0c\u7b2c\u4e8c\u7ec4\u88ab\u906e\u6321 start_value==1,  \u8bbe\u7f6estart_value=0  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 2;
        } else if (nArray[0] == 0 && nArray[1] == 0 && this.start_value == 2) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u91cc\u9762\u51fa\u6765\u7684\uff0c\u89e6\u53d1\u7b2c\u4e8c\u7ec4\u7ea2\u5916\u505c\u6b62\u76d8\u70b9 start_value==1,  \u8bbe\u7f6estart_value=0  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            if (this.timerStopInventory != null) {
                this.timerStopInventory.cancel();
                this.timerStopInventory = null;
            }
            this.stopInventory();
            this.start_value = 0;
        } else if (nArray[1] == 1 && this.start_value == 0) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u5916\u9762\u8fdb\u5165\uff0c\u89e6\u53d1\u7b2c\u4e8c\u7ec4\u7ea2\u5916\u505c\u6b62\u76d8\u70b9 start_value==1,  \u8bbe\u7f6estart_value=2  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 2;
            if (this.timerClerState == null) {
                this.timerClerState = new Timer();
            }
            this.timerClerState.schedule((TimerTask)new RFIDWithUHFNetworkChannelGate$5(this), 2000L);
        } else if (nArray[0] == 1 && nArray[1] == 1 && this.start_value == 2) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u5916\u9762\u8fdb\u5165\uff0c\u4e24\u7ec4\u7ea2\u5916\u540c\u65f6\u88ab\u6321\uff0c\u6682\u4e0d\u5904\u7406  | input1:" + nArray[0] + "  input2:" + nArray[1]);
        } else if (nArray[0] == 1 && this.start_value == 2) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u5916\u9762\u8fdb\u5165\uff0c\u89e6\u53d1\u7b2c\u4e00\u7ec4\u7ea2\u5916start_value==2,  \u8bbe\u7f6estart_value=0 | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 0;
            if (this.timerClerState != null) {
                this.timerClerState.cancel();
                this.timerClerState = null;
            }
        } else if (nArray[0] == 0) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>start_value=" + this.start_value + "   isRuning=" + this.isRuning + "  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            if (this.start_value == 1 && this.isRuning) {
                if (this.timerStopInventory == null) {
                    this.timerStopInventory = new Timer();
                }
                this.timerStopInventory.schedule((TimerTask)new RFIDWithUHFNetworkChannelGate$6(this), 2000L);
            }
        }
        this.GPIO1_previous = nArray[0];
        this.GPIO2_previous = nArray[1];
    }

    private void autoTriggeInventory_Back(int[] nArray) {
        if (nArray[0] == this.GPIO1_previous && nArray[1] == this.GPIO2_previous) {
            System.out.println("inputStateCallback==> gpio1\u30012 \u6ca1\u6709\u53d1\u9001\u6539\u53d8!");
            return;
        }
        System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>input1:" + (nArray[0] == 1 ? "\u906e\u6321" : "\u65e0") + "  input2:" + (nArray[1] == 1 ? "\u906e\u6321" : "\u65e0") + "  input3:" + nArray[2] + "  input4:" + nArray[3]);
        if (nArray[0] == 1 && this.start_value == 0) {
            boolean bl = this.startInventoryTag();
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u91cc\u9762\u51fa\u6765\u7684 \uff0c\u89e6\u53d1\u7b2c\u4e00\u7ec4\u7ea2\u5916\u5f00\u59cb\u76d8\u70b9(" + bl + ") start_value==0    \u8bbe\u7f6estart_value=1   | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 1;
        } else if (nArray[0] == 1 && nArray[1] == 1 && this.start_value == 1) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u91cc\u9762\u51fa\u6765\u7684\uff0c\u4e24\u7ec4\u7ea2\u5916\u540c\u65f6\u88ab\u6321\uff0c\u6682\u4e0d\u5904\u7406  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 2;
        } else if (nArray[1] == 1 && this.start_value == 1) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u91cc\u9762\u51fa\u6765\u7684\uff0c\u7b2c\u4e8c\u7ec4\u88ab\u906e\u6321 start_value==1,  \u8bbe\u7f6estart_value=0  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 2;
        } else if (nArray[0] == 0 && nArray[1] == 0 && this.start_value == 2) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u91cc\u9762\u51fa\u6765\u7684\uff0c\u89e6\u53d1\u7b2c\u4e8c\u7ec4\u7ea2\u5916\u505c\u6b62\u76d8\u70b9 start_value==1,  \u8bbe\u7f6estart_value=0  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            if (this.timerStopInventory != null) {
                this.timerStopInventory.cancel();
                this.timerStopInventory = null;
            }
            this.stopInventory();
            this.start_value = 0;
        } else if (nArray[1] == 1 && this.start_value == 0) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u5916\u9762\u8fdb\u5165\uff0c\u89e6\u53d1\u7b2c\u4e8c\u7ec4\u7ea2\u5916\u505c\u6b62\u76d8\u70b9 start_value==1,  \u8bbe\u7f6estart_value=2  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 2;
            if (this.timerClerState == null) {
                this.timerClerState = new Timer();
            }
            this.timerClerState.schedule((TimerTask)new RFIDWithUHFNetworkChannelGate$7(this), 2000L);
        } else if (nArray[0] == 1 && nArray[1] == 1 && this.start_value == 2) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u5916\u9762\u8fdb\u5165\uff0c\u4e24\u7ec4\u7ea2\u5916\u540c\u65f6\u88ab\u6321\uff0c\u6682\u4e0d\u5904\u7406  | input1:" + nArray[0] + "  input2:" + nArray[1]);
        } else if (nArray[0] == 1 && this.start_value == 2) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>\u4ece\u5916\u9762\u8fdb\u5165\uff0c\u89e6\u53d1\u7b2c\u4e00\u7ec4\u7ea2\u5916start_value==2,  \u8bbe\u7f6estart_value=0 | input1:" + nArray[0] + "  input2:" + nArray[1]);
            this.start_value = 0;
            if (this.timerClerState != null) {
                this.timerClerState.cancel();
                this.timerClerState = null;
            }
        } else if (nArray[0] == 0) {
            System.out.println(RFIDWithUHFNetworkChannelGate.getDateTime() + " inputStateCallback==>start_value=" + this.start_value + "   isRuning=" + this.isRuning + "  | input1:" + nArray[0] + "  input2:" + nArray[1]);
            if (this.start_value == 1 && this.isRuning) {
                if (this.timerStopInventory == null) {
                    this.timerStopInventory = new Timer();
                }
                this.timerStopInventory.schedule((TimerTask)new RFIDWithUHFNetworkChannelGate$8(this), 2000L);
            }
        }
        this.GPIO1_previous = nArray[0];
        this.GPIO2_previous = nArray[1];
    }

    static /* synthetic */ void access$000(RFIDWithUHFNetworkChannelGate rFIDWithUHFNetworkChannelGate, List list) {
        rFIDWithUHFNetworkChannelGate.channelGateState(list);
    }

    static /* synthetic */ Object access$200(RFIDWithUHFNetworkChannelGate rFIDWithUHFNetworkChannelGate) {
        return rFIDWithUHFNetworkChannelGate.lockObject;
    }

    static /* synthetic */ boolean access$300(RFIDWithUHFNetworkChannelGate rFIDWithUHFNetworkChannelGate) {
        return rFIDWithUHFNetworkChannelGate.isReadyInventory;
    }

    static /* synthetic */ void access$400(RFIDWithUHFNetworkChannelGate rFIDWithUHFNetworkChannelGate) {
        rFIDWithUHFNetworkChannelGate.stopInventory2();
    }

    static /* synthetic */ IChannelGate access$500(RFIDWithUHFNetworkChannelGate rFIDWithUHFNetworkChannelGate) {
        return rFIDWithUHFNetworkChannelGate.iChannelGate;
    }

    static /* synthetic */ Timer access$602(RFIDWithUHFNetworkChannelGate rFIDWithUHFNetworkChannelGate, Timer timer) {
        rFIDWithUHFNetworkChannelGate.timerClerEnterState = timer;
        return rFIDWithUHFNetworkChannelGate.timerClerEnterState;
    }

    static /* synthetic */ Timer access$702(RFIDWithUHFNetworkChannelGate rFIDWithUHFNetworkChannelGate, Timer timer) {
        rFIDWithUHFNetworkChannelGate.timerClerOutState = timer;
        return rFIDWithUHFNetworkChannelGate.timerClerOutState;
    }

    static /* synthetic */ String access$800() {
        return RFIDWithUHFNetworkChannelGate.getDateTime();
    }

    static /* synthetic */ int access$902(RFIDWithUHFNetworkChannelGate rFIDWithUHFNetworkChannelGate, int n) {
        rFIDWithUHFNetworkChannelGate.start_value = n;
        return rFIDWithUHFNetworkChannelGate.start_value;
    }
}

