/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.RFIDWithUHFBase;
import com.rscja.deviceapi.RFIDWithUHFNetworkAx$1;
import com.rscja.deviceapi.RFIDWithUHFNetworkAx$2;
import com.rscja.deviceapi.RFIDWithUHFNetworkAx$InventoryThread;
import com.rscja.deviceapi.SocketManageAx;
import com.rscja.deviceapi.a.a;
import com.rscja.deviceapi.c;
import com.rscja.deviceapi.entity.AntennaNameEnum;
import com.rscja.deviceapi.entity.AntennaPowerEntity;
import com.rscja.deviceapi.entity.AntennaState;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.InventoryModeEntity$Builder;
import com.rscja.deviceapi.entity.ReaderIPEntity;
import com.rscja.deviceapi.entity.ReaderInfo;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.entity.WifiConfig;
import com.rscja.deviceapi.i;
import com.rscja.deviceapi.interfaces.ConnectionStateCallback;
import com.rscja.deviceapi.interfaces.IGPIStateCallback;
import com.rscja.deviceapi.interfaces.IObserver;
import com.rscja.deviceapi.interfaces.IUHFAx;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.deviceapi.interfaces.IUpgradeProgress;
import com.rscja.utility.LogUtility;
import com.rscja.utility.StringUtility;
import com.rscja.utility.b;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

abstract class RFIDWithUHFNetworkAx
extends RFIDWithUHFBase
implements IObserver,
IUHFAx {
    protected List<UHFTAGInfo> uhfinfoList = null;
    private HashMap<String, Long> listAntSendLastTime = new HashMap();
    protected SocketManageAx socketManage = new SocketManageAx();
    private static final String TAG = "RFIDWithUHFNetworkAx";
    private boolean DEBUG = false;
    protected com.rscja.deviceapi.a config;
    private char[] uhfdata = new char[512];
    protected i uhfProtocolParse = null;
    private ConnectionStateCallback btStatusCallback = null;
    protected boolean isStoping = false;
    private RFIDWithUHFNetworkAx$InventoryThread inventoryThread = null;
    private IUHFInventoryCallback inventoryCallback = null;
    protected boolean isRuning = false;
    protected IGPIStateCallback uhfGPIOStateCallback = null;
    private IUpgradeProgress iUpgradeProgress = null;
    private ArrayList<Byte> upgradeDataList = new ArrayList();
    protected int stopInventory_delayed = 1000;
    private int isFilterRepeatBank = 0;

    public RFIDWithUHFNetworkAx() {
        this.config = new com.rscja.deviceapi.a("");
        this.socketManage.setObserver(this);
        this.uhfProtocolParse = this.socketManage.a;
    }

    @Override
    public void setUpgradeProgress(IUpgradeProgress iUpgradeProgress) {
        this.iUpgradeProgress = iUpgradeProgress;
    }

    @Override
    public void setGPIStateCallback(IGPIStateCallback iGPIStateCallback) {
        this.uhfGPIOStateCallback = iGPIStateCallback;
        LogUtility.myLogDebug(TAG, "setUHFGPIOStateCallback  uhfGPIOStateCallback=" + iGPIStateCallback);
    }

    private boolean sendUpgradeFileSizeAndMd5(long l2, String string) {
        Object object = this.uhfProtocolParse.startUpgradeTcpServiceSendData(l2, StringUtility.hexStringToBytes(string));
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "\u53d1\u9001\u5347\u7ea7\u6587\u4ef6\u7684MD5\u7801!");
        }
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 21);
        object = c2;
        if (c2 == null) {
            if (this.socketManage.getLogger() != null) {
                this.socketManage.getLogger().a(TAG, "\u53d1\u9001\u5347\u7ea7\u6587\u4ef6\u7684MD5\u7801\u6ca1\u6709\u6570\u636e\u8fd4\u56de!");
            }
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseStartUpgradeTcpServiceData(object.d);
        return bl;
    }

    @Override
    public String getTcpServiceVersion() {
        if (!this.isPowerOn()) {
            return "";
        }
        Object object = this.uhfProtocolParse.getUpgradeTcpServiceVersionSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 22);
        object = c2;
        if (c2 == null) {
            return null;
        }
        return this.uhfProtocolParse.parseGetUpgradeTcpServiceVersionData(object.d);
    }

    @Override
    public boolean setEthernetConfigInfo(ReaderIPEntity object) {
        if (object == null || ((ReaderIPEntity)object).getIp() == null) {
            return false;
        }
        if (!StringUtility.isIPAddress(((ReaderIPEntity)object).getIp())) {
            throw new IllegalArgumentException("ip error!");
        }
        if (!StringUtility.isIPAddress(((ReaderIPEntity)object).getGateway())) {
            throw new IllegalArgumentException("gateway error!");
        }
        if (!StringUtility.isIPAddress(((ReaderIPEntity)object).getSubnetMask())) {
            throw new IllegalArgumentException("subnetMask error!");
        }
        if (!StringUtility.isIPAddress(((ReaderIPEntity)object).getDns1())) {
            throw new IllegalArgumentException("dns1 error!");
        }
        if (((ReaderIPEntity)object).getDns2() != null && !((ReaderIPEntity)object).getDns2().isEmpty() && !StringUtility.isIPAddress(((ReaderIPEntity)object).getDns2())) {
            throw new IllegalArgumentException("dns2 error!");
        }
        if (this.isRuning) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.setEthernetConfigInfoSendData((ReaderIPEntity)object);
        if ((object = this.socketManage.sendAndReceive((byte[])object, 24)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseEthernetConfigInfoData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean setWifiConfigInfo(WifiConfig object) {
        Object object2;
        if (object == null || ((WifiConfig)object).getSsid() == null) {
            return false;
        }
        if (this.isRuning) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (((WifiConfig)object).isStaticIp()) {
            object2 = ((WifiConfig)object).getStaticIpConfig();
            if (!StringUtility.isIPAddress(((ReaderIPEntity)object2).getIp())) {
                throw new IllegalArgumentException("ip error!");
            }
            if (!StringUtility.isIPAddress(((ReaderIPEntity)object2).getGateway())) {
                throw new IllegalArgumentException("gateway error!");
            }
            if (!StringUtility.isIPAddress(((ReaderIPEntity)object2).getSubnetMask())) {
                throw new IllegalArgumentException("subnetMask error!");
            }
            if (!StringUtility.isIPAddress(((ReaderIPEntity)object2).getDns1())) {
                throw new IllegalArgumentException("dns1 error!");
            }
            if (((ReaderIPEntity)object2).getDns2() != null && !((ReaderIPEntity)object2).getDns2().isEmpty() && !StringUtility.isIPAddress(((ReaderIPEntity)object2).getDns2())) {
                throw new IllegalArgumentException("dns2 error!");
            }
        }
        if ((object = this.socketManage.sendAndReceive((byte[])(object2 = (Object)this.uhfProtocolParse.setWifiConfigInfoSendData((WifiConfig)object)), 25)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseWifiConfigInfoData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean setTcpServicePort(int n) {
        if (n <= 0) {
            return false;
        }
        if (this.isRuning) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setPortSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 32);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parsePortData(object.d);
        return bl;
    }

    private boolean sendUhfUpgradeFileSizeAndMd5(long l2, String string) {
        Object object = this.uhfProtocolParse.startUpgradeUhfSendData(l2, StringUtility.hexStringToBytes(string));
        System.out.println("send data" + StringUtility.bytes2HexString(object, ((byte[])object).length));
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 21);
        object = c2;
        if (c2 == null) {
            System.out.println("send data null");
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseStartUpgradeUhfData(object.d);
        return bl;
    }

    @Override
    public String GetWifiInfo() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "GetWifiInfo");
        }
        byte[] byArray = this.uhfProtocolParse.getWifiInfoSendData();
        this.socketManage.setParse(false);
        this.socketManage.cleanReceiveData();
        int n = this.socketManage.send(byArray);
        byte[] byArray2 = new byte[10240];
        int n2 = 0;
        int n3 = 0;
        if (n != 0) {
            for (n = 0; n < 60; ++n) {
                byte[] byArray3 = this.socketManage.receiveData();
                if (byArray3 != null) {
                    System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
                    System.out.println("receive data index=" + (n2 += byArray3.length));
                } else {
                    System.out.println("receive data buff==null");
                    if (n2 > 0) {
                        ++n3;
                    }
                    if (n3 >= 10) break;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
            }
            this.socketManage.setParse(true);
            if (n2 > 0) {
                String string = null;
                try {
                    string = new String(byArray2, 0, n2, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("receive ex=" + unsupportedEncodingException);
                }
                System.out.println("receive data =" + string);
                return string;
            }
        }
        return "";
    }

    @Override
    public void readyUpgradeTcpService() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "readyUpgradeTcpService");
        }
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "TCP\u670d\u52a1\u5347\u7ea7\u7b2c\u4e00\u6b65,\u51c6\u5907\u5347\u7ea7tcp\u670d\u52a1");
        }
        this.upgradeDataList.clear();
    }

    @Override
    public boolean setUpgradeTcpServiceData(byte[] byArray) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setUpgradeTcpServiceData");
        }
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.upgradeDataList.add(byArray[i2]);
        }
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "TCP\u670d\u52a1\u5347\u7ea7\u7b2c\u4e8c\u6b65,\u586b\u5145\u5347\u7ea7\u6570\u636eLEN:" + this.upgradeDataList.size());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean startUpgradeTcpService() {
        block39: {
            boolean bl;
            block37: {
                block38: {
                    int n;
                    if (this.socketManage.getLogger() != null) {
                        this.socketManage.getLogger().a(TAG, "TCP\u670d\u52a1\u5347\u7ea7\u7b2c\u4e09\u6b65,\u5f00\u59cb\u53d1\u9001\u6570\u636e\u5230\u670d\u52a1\u5668LEN:" + this.upgradeDataList.size());
                    }
                    if (this.upgradeDataList.size() == 0) {
                        if (this.iUpgradeProgress == null) return false;
                        this.iUpgradeProgress.mesage("no data!");
                        return false;
                    }
                    byte[] byArray = new byte[this.upgradeDataList.size()];
                    for (n = 0; n < this.upgradeDataList.size(); ++n) {
                        byArray[n] = this.upgradeDataList.get(n);
                    }
                    this.upgradeDataList.clear();
                    if (this.iUpgradeProgress != null) {
                        this.iUpgradeProgress.progress(0);
                    }
                    n = byArray.length;
                    if (this.socketManage.getLogger() != null) {
                        this.socketManage.getLogger().a(TAG, "TCP\u670d\u52a1\u5347\u7ea7\u7b2c\u4e09\u6b65,\u53d1\u9001\u6587\u4ef6\u957f\u5ea6uFileSize:" + n);
                    }
                    String string = b.a(byArray);
                    if (this.socketManage.getLogger() != null) {
                        this.socketManage.getLogger().a(TAG, "TCP\u670d\u52a1\u5347\u7ea7\u7b2c\u4e09\u6b65,hexMD5:" + string);
                    }
                    this.socketManage.a(false);
                    this.socketManage.cleanReceiveData();
                    bl = true;
                    try {
                        int n2;
                        boolean bl2 = this.sendUpgradeFileSizeAndMd5(n, string);
                        if (!bl2) {
                            if (this.socketManage.getLogger() != null) {
                                this.socketManage.getLogger().a(TAG, "\u53d1\u9001\u5347\u7ea7\u547d\u4ee4\u5931\u8d25!");
                            }
                            if (this.iUpgradeProgress != null) {
                                this.iUpgradeProgress.mesage("Send command fail!");
                            }
                            this.socketManage.close();
                            break block37;
                        }
                        this.socketManage.setParse(false);
                        this.socketManage.cleanReceiveData();
                        byte[] byArray2 = new byte[10240];
                        int n3 = n / 10240;
                        int n4 = n % 10240;
                        int n5 = 0;
                        if (n4 != 0) {
                            ++n3;
                        }
                        for (n2 = 0; n2 < n3; ++n2) {
                            int n6;
                            int n7;
                            ++n5;
                            if (n4 != 0 && n2 == n3 - 1) {
                                byArray2 = Arrays.copyOfRange(byArray, n - n4, n);
                                this.socketManage.send(byArray2);
                            } else {
                                n7 = n2 * 10240;
                                System.arraycopy(byArray, n7, byArray2, 0, 10240);
                                this.socketManage.send(byArray2);
                            }
                            n7 = 0;
                            for (n6 = 0; n6 < 50; ++n6) {
                                Object object = this.socketManage.receiveData();
                                if (object != null) {
                                    object = new String((byte[])object, 0, ((byte[])object).length);
                                    if (this.socketManage.getLogger() != null) {
                                        this.socketManage.getLogger().a(TAG, "\u53d1\u9001\u5347\u7ea7\u547d\u4ee4\u8fd4\u56de=" + (String)object);
                                    }
                                    if (object.contains("success")) {
                                        n7 = 1;
                                        break;
                                    }
                                    if (object.contains("\"state\":\"fail\"")) {
                                        System.out.println("isClose = false");
                                        bl = false;
                                    }
                                }
                                Thread.sleep(100L);
                            }
                            if (n7 == 0) {
                                if (this.socketManage.getLogger() != null) {
                                    this.socketManage.getLogger().a(TAG, "\u5347\u7ea7\u5931\u8d25!");
                                }
                                if (this.iUpgradeProgress == null) return false;
                                this.iUpgradeProgress.mesage("Send command fail2!");
                                return false;
                            }
                            if (this.iUpgradeProgress == null) continue;
                            n6 = n5 * 100 / n3;
                            if (n6 >= 100) {
                                n6 = 99;
                            }
                            this.iUpgradeProgress.progress(n6);
                        }
                        if (this.socketManage.getLogger() != null) {
                            this.socketManage.getLogger().a(TAG, "\u53d1\u9001\u5347\u7ea7\u6570\u636eend");
                        }
                        for (n2 = 0; n2 < 30; ++n2) {
                            Thread.sleep(100L);
                            byte[] byArray3 = this.socketManage.receiveData();
                            if (byArray3 == null) continue;
                            String string2 = new String(byArray3);
                            if (this.socketManage.getLogger() != null) {
                                this.socketManage.getLogger().a(TAG, "result resultData=" + string2);
                            }
                            if (string2.contains("upgrade_result") && string2.contains("success")) {
                                if (this.iUpgradeProgress != null) {
                                    Thread.sleep(5000L);
                                    this.iUpgradeProgress.mesage("success!");
                                }
                                bl = false;
                                this.socketManage.a(true);
                                this.socketManage.setParse(true);
                                if (this.iUpgradeProgress == null) return true;
                                this.iUpgradeProgress.progress(100);
                                return true;
                            }
                            bl = false;
                        }
                        if (!bl) break block38;
                    }
                    catch (Exception exception) {
                        if (this.socketManage.getLogger() != null) {
                            this.socketManage.getLogger().a(TAG, "\u5347\u7ea7Exception:" + exception.toString());
                        }
                        break block39;
                    }
                    this.socketManage.close();
                }
                this.socketManage.a(true);
                this.socketManage.setParse(true);
                if (this.iUpgradeProgress != null) {
                    this.iUpgradeProgress.progress(100);
                }
                break block39;
            }
            this.socketManage.a(true);
            this.socketManage.setParse(true);
            if (this.iUpgradeProgress == null) return false;
            this.iUpgradeProgress.progress(100);
            return false;
            finally {
                if (bl) {
                    this.socketManage.close();
                }
                this.socketManage.a(true);
                this.socketManage.setParse(true);
                if (this.iUpgradeProgress != null) {
                    this.iUpgradeProgress.progress(100);
                }
            }
        }
        if (this.iUpgradeProgress == null) return false;
        this.iUpgradeProgress.mesage("fail!");
        return false;
    }

    @Override
    public synchronized boolean uhfJump2Boot() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "uhfJump2Boot");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        this.socketManage.a(false);
        Object object = this.uhfProtocolParse.uhfJump2BootSendData('\u0001');
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.socketManage.a(true);
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFJump2BootData(object.d);
        if (!bl) {
            this.socketManage.a(true);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    @Override
    public synchronized boolean uhfStartUpdate() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "uhfStartUpdate");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.uhfStartUpdateSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.socketManage.a(true);
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFStartUpdateData(object.d);
        if (!bl) {
            this.socketManage.a(true);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    @Override
    public synchronized boolean uhfUpdating(byte[] object) {
        int n;
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "uhfUpdating");
        }
        byte[] byArray = new byte[64];
        if (((byte[])object).length < 64) {
            for (n = 0; n < ((byte[])object).length; ++n) {
                byArray[n] = object[n];
            }
        } else {
            for (n = 0; n < 64; ++n) {
                byArray[n] = object[n];
            }
        }
        if (!this.isPowerOn()) {
            return false;
        }
        byte[] byArray2 = this.uhfProtocolParse.uhfUpdatingSendData(byArray);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive(byArray2, -1, 5000);
        object = c2;
        if (c2 == null) {
            this.socketManage.a(true);
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFUpdatingData(object.d);
        if (!bl) {
            this.socketManage.a(true);
        }
        return bl;
    }

    @Override
    public synchronized boolean uhfStopUpdate() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "uhfStopUpdate");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.UHFStopUpdateSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            this.socketManage.a(true);
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseUHFStopUpdateData(object.d);
        this.socketManage.a(true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        return bl;
    }

    /*
     * Exception decompiling
     */
    private boolean startUpgradeTcpService(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void setPort(int n) {
        this.config.a(n);
    }

    @Override
    public synchronized boolean init(String string) {
        return this.init(string, this.config.a());
    }

    public synchronized boolean init(String string, int n) {
        System.out.println("0321");
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "20211209 init \u5f00\u59cb\u8fde\u63a5  host=" + string + "  port=" + n);
        }
        this.config.a(n);
        this.socketManage.b = null;
        boolean bl = this.socketManage.connect(string, n, true);
        System.out.println("init end host=" + string + ", port=" + n + ">>result=" + bl);
        if (bl) {
            this.setPowerOn(true);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean free() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "free \u65ad\u5f00\u8fde\u63a5");
        }
        this.isRuning = false;
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        this.socketManage.b = null;
        this.socketManage.close();
        this.setPowerOn(false);
        this.stopInventoryThread();
        this.isStoping = false;
        this.socketManage.cleanTagCmd();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    @Override
    public synchronized String getVersion() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getVersion");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getVersionSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseVersionData(object.d);
        System.out.println("getVersion() vesionString:" + (String)object);
        return object;
    }

    @Override
    public boolean setPower(AntennaNameEnum object, int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setPower");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (n > 30) {
            n = 30;
        } else if (n <= 0) {
            n = 1;
        }
        object = this.uhfProtocolParse.setPowerSendData(object.getValue(), n);
        object = this.socketManage.sendAndReceive((byte[])object);
        if (object == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetPowerData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("setPower() err :" + bl);
        return bl;
    }

    @Override
    public synchronized int getFrequencyMode() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getFrequencyMode");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getFrequencyModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        byte by = this.uhfProtocolParse.parseGetFrequencyModeData(object.d);
        System.out.println("getFrequencyMode() err :" + by);
        return by;
    }

    @Override
    public synchronized boolean setFrequencyMode(byte by) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setFrequencyMode");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFrequencyModeSendData(by);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetFrequencyModeData(object.d);
        System.out.println("setFrequencyMode() err :" + bl);
        return bl;
    }

    @Override
    public synchronized boolean startInventoryTag() {
        return this.startInventoryTag(0, 0, 6);
    }

    private synchronized boolean startInventoryTag(int n, int n2, int n3) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "20220323\u5f00\u59cb\u76d8\u70b9 startInventory() begin");
        }
        if (this.isRuning) {
            if (this.socketManage.getLogger() != null) {
                this.socketManage.getLogger().a(TAG, "\u4e0d\u80fd\u91cd\u590d\u5f00\u59cb\u76d8\u70b9!");
            }
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (this.uhfinfoList != null) {
            this.uhfinfoList.clear();
        }
        this.socketManage.cleanTagCmd();
        byte[] byArray = this.uhfProtocolParse.getStartInventoryTagSendData();
        boolean bl = this.socketManage.send(byArray);
        if (!bl) {
            if (this.socketManage.getLogger() != null) {
                this.socketManage.getLogger().a(TAG, "\u5f00\u59cb\u76d8\u70b9 \u5931\u8d25!");
            }
            return false;
        }
        this.isRuning = true;
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "\u5f00\u59cb\u76d8\u70b9 startInventory() result :  inventoryCallback=" + this.inventoryCallback + "  inventoryThread=" + this.inventoryThread);
        }
        this.startInventoryThread();
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "\u5f00\u59cb\u76d8\u70b9 startInventory() end");
        }
        return true;
    }

    @Override
    public synchronized UHFTAGInfo readTagFromBuffer() {
        Object object = this.socketManage.receiveTagData();
        if (object == null) {
            return null;
        }
        object = this.uhfProtocolParse.c(((com.rscja.deviceapi.b.c)object).c);
        return object;
    }

    @Override
    public synchronized boolean stopInventory() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "\u505c\u6b62\u76d8\u70b9stopInventory() inventoryThread=" + this.inventoryThread);
        }
        byte[] byArray = this.uhfProtocolParse.getStopInventorySendData();
        this.socketManage.send(byArray);
        this.isRuning = false;
        this.stopInventoryThread();
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "\u505c\u6b62\u76d8\u70b9stopInventory() end");
        }
        return true;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> arrayList, int n) {
        if (arrayList == null || arrayList.size() == 0 || n < 0) {
            return null;
        }
        switch (n) {
            case 16: 
            case 32: 
            case 48: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException("lockMode error");
            }
        }
        return super.generateLockCode(arrayList, n);
    }

    @Override
    public synchronized boolean lockMem(String string, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "lockMem");
        }
        StringUtility.hexString2Chars(string);
        StringUtility.hexString2Chars(string2);
        boolean bl = this.lockMem(string, 1, 0, 0, "", string2);
        if (bl) {
            return true;
        }
        System.out.println("lockMem() err :" + bl);
        return false;
    }

    @Override
    public boolean lockMem(String object, int n, int n2, int n3, String string, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "lockMem");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getLockSendData((String)object, n, n2, n3, string, string2);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseLockData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("lockMem() err :" + bl);
        return bl;
    }

    @Override
    public synchronized UHFTAGInfo inventorySingleTag() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "inventorySingleTag");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getInventorySingleTagSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        UHFTAGInfo uHFTAGInfo = this.uhfProtocolParse.a(object.d, true);
        object = uHFTAGInfo;
        return uHFTAGInfo;
    }

    @Override
    public String readData(String string, int n, int n2, int n3) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "readData");
        }
        if (StringUtility.isEmpty(string) || !StringUtility.isHexNumberRex(string)) {
            return null;
        }
        return this.readData(string, 1, 0, 0, "00", n, n2, n3);
    }

    @Override
    public String readData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "readData");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        object = this.uhfProtocolParse.getReadSendData((String)object, n, n2, n3, string, n4, n5, n6);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseReadData(((com.rscja.deviceapi.b.c)object).d);
        return object;
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "writeData");
        }
        if (StringUtility.isEmpty(string) || StringUtility.isEmpty(string2)) {
            return false;
        }
        String string3 = "00";
        boolean bl = this.writeData(string, 1, 32, 0, string3, n, n2, n3, string2);
        return bl;
    }

    @Override
    public boolean writeData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "writeData");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getWriteSendData((String)object, n, n2, n3, string, n4, n5, n6, string2);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseWriteData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean blockWriteData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6, String string2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "blockWriteData");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.blockWriteDataSendData((String)object, (char)n, n2, n3, string, (char)n4, n5, (char)n6, string2);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBlockWriteData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String string2) {
        return this.blockWriteData(string, 1, 0, 0, "00", n, n2, n3, string2);
    }

    @Override
    public boolean eraseData(String object, int n, int n2, int n3, String string, int n4, int n5, int n6) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "eraseData");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.blockEraseDataSendData((String)object, (char)n, n2, n3, string, (char)n4, n5, (char)n6);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBlockEraseDataData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3) {
        return this.eraseData(string, 1, 0, 0, "00", n, n2, n3);
    }

    @Override
    public boolean setFilter(int n, int n2, int n3, String string) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setFilter");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFilterSendData((char)n, n2, n3, string);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetFilterData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean killTag(String string) {
        return this.killTag(string, 0, 0, 0, "00");
    }

    @Override
    public boolean killTag(String object, int n, int n2, int n3, String string) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "killTag");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.getKillSendData((String)object, n, n2, n3, string);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseKillData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public synchronized boolean setProtocol(int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setProtocol");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setProtocolSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetProtocolData(object.d);
        return bl;
    }

    @Override
    public synchronized int getProtocol() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getProtocol");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getProtocolSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetProtocolData(object.d);
        return n;
    }

    @Override
    public synchronized boolean setFreHop(float f2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setFreHop");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        int n = (int)(f2 * 1000.0f);
        Object object = this.uhfProtocolParse.setJumpFrequencySendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetJumpFrequencyData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean setRFLink(int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setRFLink");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setRFLinkSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetRFLinkData(object.d);
        return bl;
    }

    @Override
    public synchronized int getRFLink() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getRFLink");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getRFLinkSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetRFLinkData(object.d);
        return n;
    }

    @Override
    public synchronized boolean setFastID(boolean bl) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setFastID");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setFastIdSendData(bl ? 1 : 0);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl2 = this.uhfProtocolParse.parseFastIdData(object.d);
        return bl2;
    }

    @Override
    public synchronized boolean setTagFocus(boolean bl) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setTagFocus");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setTagfocusSendData(bl ? (char)'\u0001' : '\u0000');
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl2 = this.uhfProtocolParse.parseSetTagfocusData(object.d);
        return bl2;
    }

    @Override
    public synchronized boolean setEPCMode() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setEPCMode");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCModeData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean setEPCAndTIDMode() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setEPCAndTIDMode");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCAndTIDModeSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCAndTIDModeData(object.d);
        return bl;
    }

    @Override
    public synchronized boolean setEPCAndTIDUserMode(int n, int n2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setEPCAndTIDUserMode");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEPCAndTIDUserModeSendData(n, n2);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEPCAndTIDUserModeData(object.d);
        return bl;
    }

    @Override
    public synchronized int getTemperature() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getTemperature");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getTemperatureSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseTemperatureData(object.d);
        return n;
    }

    @Override
    public boolean uhfBlockPermalock(String string, int n, int n2, int n3, String string2, int n4, int n5, int n6, int n7, byte[] byArray) {
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public boolean setGen2(Gen2Entity object) {
        if (!this.isPowerOn()) {
            return false;
        }
        object = this.uhfProtocolParse.setGen2SendData((Gen2Entity)object);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetGen2Data(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public Gen2Entity getGen2() {
        Object object;
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getGen2");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object2 = this.uhfProtocolParse.getGen2SendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object2);
        object2 = c2;
        if (c2 == null) {
            return null;
        }
        object2 = this.uhfProtocolParse.parseGetGen2Data(object2.d);
        if (object2 == null) {
            return null;
        }
        if (this.DEBUG) {
            object = new StringBuilder();
            ((StringBuilder)object).append("target data[2]=");
            ((StringBuilder)object).append(String.valueOf(object2[0]));
            ((StringBuilder)object).append(",action data[3]=");
            ((StringBuilder)object).append(String.valueOf(object2[1]));
            ((StringBuilder)object).append(",t data[4]=");
            ((StringBuilder)object).append(String.valueOf(object2[2]));
            ((StringBuilder)object).append(",q data[5]=");
            ((StringBuilder)object).append(String.valueOf(object2[3]));
            ((StringBuilder)object).append(",startQ data[6]=");
            ((StringBuilder)object).append(String.valueOf(object2[4]));
            ((StringBuilder)object).append(",minQ data[7]=");
            ((StringBuilder)object).append(String.valueOf(object2[5]));
            ((StringBuilder)object).append(",maxQ data[8]=");
            ((StringBuilder)object).append(String.valueOf(object2[6]));
            ((StringBuilder)object).append(",dr data[9]=");
            ((StringBuilder)object).append(String.valueOf(object2[7]));
            ((StringBuilder)object).append(",coding data[10]=");
            ((StringBuilder)object).append(String.valueOf(object2[8]));
            ((StringBuilder)object).append(", p data[11]=");
            ((StringBuilder)object).append(String.valueOf(object2[9]));
            ((StringBuilder)object).append(",Sel data[12]=");
            ((StringBuilder)object).append(String.valueOf(object2[10]));
            ((StringBuilder)object).append(",Session data[13]=");
            ((StringBuilder)object).append(String.valueOf(object2[11]));
            ((StringBuilder)object).append(",g data[14]=");
            ((StringBuilder)object).append(String.valueOf(object2[12]));
            ((StringBuilder)object).append(",linkFrequency data[15]=");
            ((StringBuilder)object).append(String.valueOf(object2[13]));
            System.out.println(((StringBuilder)object).toString());
        }
        object = new Gen2Entity();
        ((Gen2Entity)object).setSelectTarget(object2[0]);
        ((Gen2Entity)object).setSelectAction(object2[1]);
        ((Gen2Entity)object).setSelectTruncate(object2[2]);
        ((Gen2Entity)object).setQ(object2[3]);
        ((Gen2Entity)object).setStartQ(object2[4]);
        ((Gen2Entity)object).setMinQ(object2[5]);
        ((Gen2Entity)object).setMaxQ(object2[6]);
        ((Gen2Entity)object).setQueryDR(object2[7]);
        ((Gen2Entity)object).setQueryM(object2[8]);
        ((Gen2Entity)object).setQueryTRext(object2[9]);
        ((Gen2Entity)object).setQuerySel(object2[10]);
        ((Gen2Entity)object).setQuerySession(object2[11]);
        ((Gen2Entity)object).setQueryTarget(object2[12]);
        ((Gen2Entity)object).setLinkFrequency(object2[13]);
        return object;
    }

    @Override
    public synchronized boolean setPwm(int n, int n2) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setPwm");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        return false;
    }

    @Override
    public synchronized int[] getPwm() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getPwm");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        return null;
    }

    @Override
    public synchronized int getCW() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getCW");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        Object object = this.uhfProtocolParse.getCWSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return -1;
        }
        return this.uhfProtocolParse.parseGetCWData(object.d);
    }

    @Override
    public boolean setCW(int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setCW");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setCWSendData((char)n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        return this.uhfProtocolParse.parseSetCWData(object.d);
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getEPCAndTIDUserMode");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getEPCTIDModeSendData('\u0000', '\u0000');
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseGetEPCTIDModeData(object.d);
        if (object == null || ((byte[])object).length == 0) {
            return null;
        }
        InventoryModeEntity$Builder inventoryModeEntity$Builder = new InventoryModeEntity$Builder();
        inventoryModeEntity$Builder.setMode(object[0]);
        if (object[0] == 2) {
            inventoryModeEntity$Builder.setUserOffset(object[1]);
            inventoryModeEntity$Builder.setUserLength(object[2]);
        }
        return inventoryModeEntity$Builder.build();
    }

    @Override
    public void update(a a2, Object object) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "RFIDWithUHFNetworkMT update status=" + object.toString());
        }
        if (Integer.parseInt(object.toString()) == c.STATUS_CONNECT) {
            this.setPowerOn(true);
            if (this.btStatusCallback != null) {
                new RFIDWithUHFNetworkAx$1(this).start();
                return;
            }
        } else {
            this.setPowerOn(false);
            if (this.btStatusCallback != null) {
                new RFIDWithUHFNetworkAx$2(this).start();
            }
        }
    }

    @Override
    public boolean isPowerOn() {
        return this.powerOn && this.socketManage.getConnectStatus() == c.STATUS_CONNECT;
    }

    @Override
    public boolean setAntenna(List<AntennaState> object) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setAnt");
        }
        if (object == null || object.size() == 0) {
            return false;
        }
        byte[] byArray = new byte[2];
        for (int i2 = 0; i2 < object.size(); ++i2) {
            if (!object.get(i2).isEnable()) continue;
            if (object.get(i2).getAntennaName() == AntennaNameEnum.ANT1) {
                byArray[1] = (byte)(byArray[1] | 1);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT2) {
                byArray[1] = (byte)(byArray[1] | 2);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT3) {
                byArray[1] = (byte)(byArray[1] | 4);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT4) {
                byArray[1] = (byte)(byArray[1] | 8);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT5) {
                byArray[1] = (byte)(byArray[1] | 0x10);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT6) {
                byArray[1] = (byte)(byArray[1] | 0x20);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() == AntennaNameEnum.ANT7) {
                byArray[1] = (byte)(byArray[1] | 0x40);
            }
            if (((AntennaState)object.get(i2)).getAntennaName() != AntennaNameEnum.ANT8) continue;
            byArray[1] = (byte)(byArray[1] | 0x80);
        }
        byte[] byArray2 = this.uhfProtocolParse.setAntSendData('\u0001', byArray);
        object = this.socketManage.sendAndReceive(byArray2);
        if (object == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetAntData(((com.rscja.deviceapi.b.c)object).d);
        return bl;
    }

    @Override
    public List<AntennaState> getAntenna() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getAnt");
        }
        Object object = this.uhfProtocolParse.getAntSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return null;
        }
        object = this.uhfProtocolParse.parseGetAntData(object.d);
        if (object == null || ((byte[])object).length < 2) {
            return null;
        }
        ArrayList<AntennaState> arrayList = new ArrayList<AntennaState>();
        arrayList.add(new AntennaState(AntennaNameEnum.ANT1, (object[1] & 0xFF & 1) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT2, (object[1] & 0xFF & 2) == 2));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT3, (object[1] & 0xFF & 4) == 4));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT4, (object[1] & 0xFF & 8) == 8));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT5, (object[1] & 0xFF & 0x10) == 16));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT6, (object[1] & 0xFF & 0x20) == 32));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT7, (object[1] & 0xFF & 0x40) == 64));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT8, (object[1] & 0xFF & 0x80) == 128));
        return arrayList;
    }

    @Override
    public boolean setAntennaWorkTime(AntennaNameEnum object, int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setAntWorkTime");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (n < 10 || n > 65535) {
            throw new IllegalArgumentException("WorkTime error !");
        }
        object = this.uhfProtocolParse.setAntWorkTimeSendData((byte)object.getValue(), n);
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetAntWorkTimeReceiveData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("setAntWorkTime() reuslt :" + bl);
        return bl;
    }

    @Override
    public int getAntennaWorkTime(AntennaNameEnum object) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getAntWorkTime");
        }
        if (!this.isPowerOn()) {
            return -1;
        }
        object = this.uhfProtocolParse.getAntWorkTimeSendData((byte)object.getValue());
        if ((object = this.socketManage.sendAndReceive((byte[])object)) == null) {
            return -1;
        }
        int n = this.uhfProtocolParse.parseGetAntWorkTimeReceiveData(((com.rscja.deviceapi.b.c)object).d);
        System.out.println("getAntWorkTime() result :" + n);
        return n;
    }

    @Override
    public boolean uhfJump2BootToSTM32() {
        return false;
    }

    @Override
    public void setConnectionStateCallback(ConnectionStateCallback connectionStateCallback) {
        this.btStatusCallback = connectionStateCallback;
    }

    @Override
    public boolean openWifi() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "openWifi");
        }
        Object object = this.uhfProtocolParse.openWifiSendData(true);
        System.out.println("send data" + StringUtility.bytes2HexString(object, ((byte[])object).length));
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 35);
        object = c2;
        if (c2 == null) {
            System.out.println("send data null");
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseOpenWifiData(object.d);
        return bl;
    }

    @Override
    public boolean closeWifi() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "closeWifi");
        }
        Object object = this.uhfProtocolParse.openWifiSendData(false);
        System.out.println("send data" + StringUtility.bytes2HexString(object, ((byte[])object).length));
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 35);
        object = c2;
        if (c2 == null) {
            System.out.println("send data null");
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseOpenWifiData(object.d);
        return bl;
    }

    @Override
    public boolean setBeep(int n) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setBeep");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.getBeepSendData(n == 1);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseBeepData(object.d);
        return bl;
    }

    @Override
    public char[] getBeep() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getBeep");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getReaderBeepStatusSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 8);
        object = c2;
        if (c2 == null) {
            System.out.println("send data null");
            return null;
        }
        int n = this.uhfProtocolParse.parseGetReaderBeepStatusData(object.d);
        char[] cArray = new char[]{'\u0000', (char)n};
        return cArray;
    }

    @Override
    public String getAndroidDeviceHardwareVersion() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getAndroidDeviceHardwareVersion");
        }
        Object object = this.uhfProtocolParse.getAndroidDeviceHardwareVersionSendData();
        System.out.println("send data" + StringUtility.bytes2HexString(object, ((byte[])object).length));
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 36);
        object = c2;
        if (c2 == null) {
            System.out.println("send data null");
            return "";
        }
        String string = this.uhfProtocolParse.parseAndroidDeviceHardwareVersionData(object.d);
        object = string;
        return string;
    }

    @Override
    public String getEthernetIpConfig() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getEthernetIpConfig");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getEthernetIpConfigSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 37);
        object = c2;
        if (c2 == null) {
            return null;
        }
        String string = this.uhfProtocolParse.parseGetEthernetIpConfigData(object.d);
        object = string;
        return string;
    }

    @Override
    public String getWifiIpConfig() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "getWifiIpConfig");
        }
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getWifiIpConfigSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 38);
        object = c2;
        if (c2 == null) {
            return null;
        }
        String string = this.uhfProtocolParse.parseGetWifiIpConfigData(object.d);
        object = string;
        return string;
    }

    @Override
    public boolean rebootDevice() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "rebootAndroidDevice");
        }
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.getAndroidDeviceRebootSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 41);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseAndroidDeviceRebootData(object.d);
        return bl;
    }

    @Override
    public void buzzerOn(int n) {
        if (!this.isPowerOn()) {
            return;
        }
        if (n < 100 || n > 65535) {
            throw new IllegalArgumentException("Invalid parameter!");
        }
        Object object = this.uhfProtocolParse.setBuzzerOnOfAndroidSendData(n);
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 13);
        object = c2;
        if (c2 == null) {
            return;
        }
        this.uhfProtocolParse.parseSetBuzzerOnOfAndroidData(object.d);
    }

    @Override
    public void buzzerOff() {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setBuzzerOffOfAndroid");
        }
        if (!this.isPowerOn()) {
            return;
        }
        Object object = this.uhfProtocolParse.setBuzzerOffOfAndroidSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 13);
        object = c2;
        if (c2 == null) {
            return;
        }
        this.uhfProtocolParse.parseSetBuzzeroffOfAndroidData(object.d);
    }

    @Override
    public int getPower(AntennaNameEnum antennaNameEnum) {
        List<AntennaPowerEntity> list = this.getPowerAll();
        if (list == null || list.size() == 0) {
            return -1;
        }
        for (AntennaPowerEntity antennaPowerEntity : list) {
            if (antennaPowerEntity.getAntennaNameEnum() != antennaNameEnum) continue;
            return antennaPowerEntity.getPower();
        }
        return -1;
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().a(TAG, "setInventoryCallback inventoryCallback=" + iUHFInventoryCallback);
        }
        this.inventoryCallback = iUHFInventoryCallback;
    }

    private void startInventoryThread() {
        if (this.inventoryThread == null) {
            if (this.socketManage.getLogger() != null) {
                this.socketManage.getLogger().a(TAG, "\u5f00\u542f\u76d8\u70b9\u7ebf\u7a0b");
            }
            this.inventoryThread = new RFIDWithUHFNetworkAx$InventoryThread(this);
            this.inventoryThread.start();
        }
    }

    private void stopInventoryThread() {
        if (this.inventoryThread != null) {
            this.inventoryThread.stopThread();
            this.inventoryThread = null;
        }
    }

    @Override
    public boolean setEthernetIpDynamicAssign() {
        if (!this.isPowerOn()) {
            return false;
        }
        Object object = this.uhfProtocolParse.setEthernetDynamicSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 50);
        object = c2;
        if (c2 == null) {
            return false;
        }
        boolean bl = this.uhfProtocolParse.parseSetEthernetDynamicResultData(object.d);
        return bl;
    }

    @Override
    public ReaderIPEntity getReaderCurrentIp() {
        LogUtility.myLogDebug(TAG, "getUHFCurrentIpConfig");
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.uhfProtocolParse.getUHFCurrentIpConfigSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 54, 4000);
        object = c2;
        if (c2 == null) {
            return null;
        }
        ReaderIPEntity readerIPEntity = this.uhfProtocolParse.parseUHFCurrentIpConfigResultData(object.d);
        object = readerIPEntity;
        return readerIPEntity;
    }

    @Override
    public ReaderInfo getReaderInfo() {
        LogUtility.myLogDebug(TAG, "getReaderInfo");
        if (!this.isPowerOn()) {
            return null;
        }
        if (this.socketManage.b != null) {
            return this.socketManage.b;
        }
        Object object = this.uhfProtocolParse.getReaderInfoSendData();
        com.rscja.deviceapi.b.c c2 = this.socketManage.sendAndReceive((byte[])object, 66);
        object = c2;
        if (c2 == null) {
            return null;
        }
        ReaderInfo readerInfo = this.uhfProtocolParse.parseGetReaderInfoResultData(object.d);
        object = readerInfo;
        if (readerInfo != null) {
            this.socketManage.b = object;
        }
        return object;
    }

    private static String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return simpleDateFormat.format(new Date());
    }

    public void setFilterRepeatData(int n) {
        block3: {
            block4: {
                block2: {
                    if (n <= 0 || n > 2) {
                        throw new IllegalArgumentException("bank invalid!");
                    }
                    this.isFilterRepeatBank = n;
                    if (n != 0) break block2;
                    if (this.uhfinfoList == null) break block3;
                    break block4;
                }
                if (this.uhfinfoList == null) {
                    this.uhfinfoList = new ArrayList<UHFTAGInfo>();
                }
            }
            this.uhfinfoList.clear();
        }
    }

    private void sendAntState(String string) {
        if (string != null && !string.isEmpty()) {
            Long l2 = this.listAntSendLastTime.get(string);
            if (l2 == null) {
                this.listAntSendLastTime.put(string, System.currentTimeMillis());
                this.setAntBlink(string);
                return;
            }
            long l3 = l2;
            if (System.currentTimeMillis() - l3 > 300L) {
                this.listAntSendLastTime.put(string, System.currentTimeMillis());
                this.setAntBlink(string);
            }
        }
    }

    private void setAntBlink(String object) {
        if (this.socketManage.getLogger() != null) {
            this.socketManage.getLogger().d(TAG, "setAntBlink strAnt=" + (String)object);
        }
        byte[] byArray = new byte[2];
        if ("1".equals(object)) {
            byArray[1] = 1;
        } else if ("2".equals(object)) {
            byArray[1] = 2;
        } else if ("3".equals(object)) {
            byArray[1] = 4;
        } else if ("4".equals(object)) {
            byArray[1] = 8;
        } else if ("5".equals(object)) {
            byArray[1] = 16;
        } else if ("6".equals(object)) {
            byArray[1] = 32;
        } else if ("7".equals(object)) {
            byArray[1] = 64;
        } else if ("8".equals(object)) {
            byArray[1] = -128;
        }
        object = this.uhfProtocolParse.setAntBlinkSendData(byArray);
        this.socketManage.send((byte[])object);
    }

    static /* synthetic */ ConnectionStateCallback access$000(RFIDWithUHFNetworkAx rFIDWithUHFNetworkAx) {
        return rFIDWithUHFNetworkAx.btStatusCallback;
    }

    static /* synthetic */ int access$100(RFIDWithUHFNetworkAx rFIDWithUHFNetworkAx) {
        return rFIDWithUHFNetworkAx.isFilterRepeatBank;
    }

    static /* synthetic */ void access$200(RFIDWithUHFNetworkAx rFIDWithUHFNetworkAx, String string) {
        rFIDWithUHFNetworkAx.sendAntState(string);
    }

    static /* synthetic */ IUHFInventoryCallback access$300(RFIDWithUHFNetworkAx rFIDWithUHFNetworkAx) {
        return rFIDWithUHFNetworkAx.inventoryCallback;
    }
}

