/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.function;

import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.Function;
import nu.xom.jaxen.FunctionCallException;
import nu.xom.jaxen.Navigator;

public class BooleanFunction
implements Function {
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 1) {
            return BooleanFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("boolean() requires one argument");
    }

    public static Boolean evaluate(Object object, Navigator navigator) {
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 0) {
                return Boolean.FALSE;
            }
            object = list.get(0);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            if (d2 == 0.0 || Double.isNaN(d2)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (object instanceof String) {
            return ((String)object).length() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return object != null ? Boolean.TRUE : Boolean.FALSE;
    }
}

