/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.io.IOException;
import java.io.Writer;
import net.sf.json.JSONException;
import net.sf.json.util.JSONUtils;

public class JSONBuilder {
    private static final int MAXDEPTH = 20;
    private boolean comma = false;
    protected char mode = (char)105;
    private char[] stack = new char[20];
    private int top = 0;
    protected Writer writer;

    public JSONBuilder(Writer w) {
        this.writer = w;
    }

    private JSONBuilder append(String s) {
        if (s == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            try {
                if (this.comma && this.mode == 'a') {
                    this.writer.write(44);
                }
                this.writer.write(s);
            }
            catch (IOException e2) {
                throw new JSONException(e2);
            }
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    public JSONBuilder array() {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push('a');
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    private JSONBuilder end(char m2, char c2) {
        if (this.mode != m2) {
            throw new JSONException(m2 == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m2);
        try {
            this.writer.write(c2);
        }
        catch (IOException e2) {
            throw new JSONException(e2);
        }
        this.comma = true;
        return this;
    }

    public JSONBuilder endArray() {
        return this.end('a', ']');
    }

    public JSONBuilder endObject() {
        return this.end('k', '}');
    }

    public JSONBuilder key(String s) {
        if (s == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            try {
                if (this.comma) {
                    this.writer.write(44);
                }
                this.writer.write(JSONUtils.quote(s));
                this.writer.write(58);
                this.comma = false;
                this.mode = (char)111;
                return this;
            }
            catch (IOException e2) {
                throw new JSONException(e2);
            }
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONBuilder object() {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push('k');
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    private void pop(char c2) {
        if (this.top <= 0 || this.stack[this.top - 1] != c2) {
            throw new JSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : this.stack[this.top - 1]);
    }

    private void push(char c2) {
        if (this.top >= 20) {
            throw new JSONException("Nesting too deep.");
        }
        this.stack[this.top] = c2;
        this.mode = c2;
        ++this.top;
    }

    public JSONBuilder value(boolean b2) {
        return this.append(b2 ? "true" : "false");
    }

    public JSONBuilder value(double d2) {
        return this.value(new Double(d2));
    }

    public JSONBuilder value(long l2) {
        return this.append(Long.toString(l2));
    }

    public JSONBuilder value(Object o) {
        return this.append(JSONUtils.valueToString(o));
    }
}

