/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.io.Serializable;
import net.sf.json.JSONException;
import net.sf.json.util.JSONUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class JSONFunction
implements Serializable {
    private static final String[] EMPTY_PARAM_ARRAY = new String[0];
    private String[] params;
    private String text;

    public static JSONFunction parse(String str) {
        if (!JSONUtils.isFunction(str)) {
            throw new JSONException("String is not a function. " + str);
        }
        String params = JSONUtils.getFunctionParams(str);
        String text = JSONUtils.getFunctionBody(str);
        return new JSONFunction(params != null ? StringUtils.split(params, ",") : null, text != null ? text : "");
    }

    public JSONFunction(String text) {
        this(null, text);
    }

    public JSONFunction(String[] params, String text) {
        String string = this.text = text != null ? text.trim() : "";
        if (params != null) {
            if (params.length == 1 && params[0].trim().equals("")) {
                this.params = EMPTY_PARAM_ARRAY;
            } else {
                this.params = new String[params.length];
                System.arraycopy(params, 0, this.params, 0, params.length);
                for (int i2 = 0; i2 < params.length; ++i2) {
                    this.params[i2] = this.params[i2].trim();
                }
            }
        } else {
            this.params = EMPTY_PARAM_ARRAY;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            try {
                JSONFunction other = JSONFunction.parse((String)obj);
                return this.equals(other);
            }
            catch (JSONException e2) {
                return false;
            }
        }
        if (!(obj instanceof JSONFunction)) {
            return false;
        }
        JSONFunction other = (JSONFunction)obj;
        if (this.params.length != other.params.length) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        for (int i2 = 0; i2 < this.params.length; ++i2) {
            builder.append(this.params[i2], other.params[i2]);
        }
        builder.append(this.text, other.text);
        return builder.isEquals();
    }

    public String[] getParams() {
        return this.params;
    }

    public String getText() {
        return this.text;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (int i2 = 0; i2 < this.params.length; ++i2) {
            builder.append(this.params[i2]);
        }
        builder.append(this.text);
        return builder.toHashCode();
    }

    public String toString() {
        StringBuffer b2 = new StringBuffer("function(");
        if (this.params.length > 0) {
            for (int i2 = 0; i2 < this.params.length - 1; ++i2) {
                b2.append(this.params[i2]).append(',');
            }
            b2.append(this.params[this.params.length - 1]);
        }
        b2.append("){");
        if (this.text.length() > 0) {
            b2.append(' ').append(this.text).append(' ');
        }
        b2.append('}');
        return b2.toString();
    }
}

