/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.primitive;

import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.primitive.AbstractPrimitiveMorpher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class BooleanMorpher
extends AbstractPrimitiveMorpher {
    private boolean defaultValue;

    public BooleanMorpher() {
    }

    public BooleanMorpher(boolean defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanMorpher)) {
            return false;
        }
        BooleanMorpher other = (BooleanMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append(this.getDefaultValue(), other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isUseDefault()) {
            builder.append(this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public boolean morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            if (value instanceof Double && (Double.isInfinite(((Number)value).doubleValue()) || Double.isNaN(((Number)value).doubleValue()))) {
                return true;
            }
            if (value instanceof Float && (Float.isInfinite(((Number)value).floatValue()) || Float.isNaN(((Number)value).floatValue()))) {
                return true;
            }
            long l2 = ((Number)value).longValue();
            return l2 != 0L;
        }
        String s = String.valueOf(value);
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("off")) {
            return false;
        }
        if (this.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Can't morph value: " + value);
    }

    public Class morphsTo() {
        return Boolean.TYPE;
    }
}

