/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.bean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.MorphUtils;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.bean.MorphDynaBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class MorphDynaClass
implements DynaClass,
Serializable {
    private static final Comparator dynaPropertyComparator = new Comparator(){

        public int compare(Object a2, Object b2) {
            if (a2 instanceof DynaProperty && b2 instanceof DynaProperty) {
                DynaProperty p1 = (DynaProperty)a2;
                DynaProperty p2 = (DynaProperty)b2;
                return p1.getName().compareTo(p2.getName());
            }
            return -1;
        }
    };
    private static final long serialVersionUID = -613214016860871560L;
    private Map attributes;
    private Class beanClass;
    private DynaProperty[] dynaProperties;
    private String name;
    private Map properties = new HashMap();
    private Class type;
    static /* synthetic */ Class class$0;

    public MorphDynaClass(Map attributes) {
        this(null, null, attributes);
    }

    public MorphDynaClass(Map attributes, boolean exceptionOnEmptyAttributes) {
        this(null, null, attributes, exceptionOnEmptyAttributes);
    }

    public MorphDynaClass(String name, Class type, Map attributes) {
        this(name, type, attributes, false);
    }

    public MorphDynaClass(String name, Class type, Map attributes, boolean exceptionOnEmptyAttributes) {
        Class<?> clazz;
        if (name == null) {
            name = "MorphDynaClass";
        }
        if (type == null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("net.sf.ezmorph.bean.MorphDynaBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            type = clazz2;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.ezmorph.bean.MorphDynaBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(type)) {
            throw new MorphException("MorphDynaBean is not assignable from " + type.getName());
        }
        if (attributes == null || attributes.isEmpty()) {
            if (exceptionOnEmptyAttributes) {
                throw new MorphException("Attributes map is null or empty.");
            }
            attributes = new HashMap();
        }
        this.name = name;
        this.type = type;
        this.attributes = attributes;
        this.process();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MorphDynaClass)) {
            return false;
        }
        MorphDynaClass other = (MorphDynaClass)obj;
        EqualsBuilder builder = new EqualsBuilder().append(this.name, other.name).append(this.type, other.type);
        if (this.dynaProperties.length != other.dynaProperties.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.dynaProperties.length) {
            DynaProperty a2 = this.dynaProperties[i2];
            DynaProperty b2 = other.dynaProperties[i2];
            builder.append(a2.getName(), b2.getName());
            builder.append(a2.getType(), b2.getType());
            ++i2;
        }
        return builder.isEquals();
    }

    public DynaProperty[] getDynaProperties() {
        return this.dynaProperties;
    }

    public DynaProperty getDynaProperty(String propertyName) {
        if (propertyName == null) {
            throw new MorphException("Unnespecified bean property name");
        }
        return (DynaProperty)this.properties.get(propertyName);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append(this.name).append(this.type);
        int i2 = 0;
        while (i2 < this.dynaProperties.length) {
            builder.append(this.dynaProperties[i2].getName());
            builder.append(this.dynaProperties[i2].getType());
            ++i2;
        }
        return builder.toHashCode();
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return this.newInstance(null);
    }

    public DynaBean newInstance(MorpherRegistry morpherRegistry) throws IllegalAccessException, InstantiationException {
        if (morpherRegistry == null) {
            morpherRegistry = new MorpherRegistry();
            MorphUtils.registerStandardMorphers(morpherRegistry);
        }
        MorphDynaBean dynaBean = (MorphDynaBean)this.getBeanClass().newInstance();
        dynaBean.setDynaBeanClass(this);
        dynaBean.setMorpherRegistry(morpherRegistry);
        Iterator keys = this.attributes.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            dynaBean.set(key, null);
        }
        return dynaBean;
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).append("type", this.type).append("attributes", this.attributes).toString();
    }

    protected Class getBeanClass() {
        if (this.beanClass == null) {
            this.process();
        }
        return this.beanClass;
    }

    private void process() {
        this.beanClass = this.type;
        try {
            Iterator entries = this.attributes.entrySet().iterator();
            this.dynaProperties = new DynaProperty[this.attributes.size()];
            int i2 = 0;
            while (entries.hasNext()) {
                Class klass;
                Map.Entry entry = entries.next();
                String pname = (String)entry.getKey();
                Object pclass = entry.getValue();
                DynaProperty dynaProperty = null;
                if (pclass instanceof String) {
                    klass = Class.forName((String)pclass);
                    if (klass.isArray() && klass.getComponentType().isArray()) {
                        throw new MorphException("Multidimensional arrays are not supported");
                    }
                    dynaProperty = new DynaProperty(pname, klass);
                } else if (pclass instanceof Class) {
                    klass = (Class)pclass;
                    if (klass.isArray() && klass.getComponentType().isArray()) {
                        throw new MorphException("Multidimensional arrays are not supported");
                    }
                    dynaProperty = new DynaProperty(pname, klass);
                } else {
                    throw new MorphException("Type must be String or Class");
                }
                this.properties.put(dynaProperty.getName(), dynaProperty);
                this.dynaProperties[i2++] = dynaProperty;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new MorphException(cnfe);
        }
        Arrays.sort(this.dynaProperties, 0, this.dynaProperties.length, dynaPropertyComparator);
    }
}

