/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.ObjectMorpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;

public class MorpherRegistry
implements Serializable {
    private static final long serialVersionUID = -3894767123320768419L;
    private Map morphers = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    public synchronized void clear() {
        this.morphers.clear();
    }

    public synchronized void clear(Class type) {
        List registered = (List)this.morphers.get(type);
        if (registered != null) {
            this.morphers.remove(type);
        }
    }

    public synchronized void deregisterMorpher(Morpher morpher) {
        List registered = (List)this.morphers.get(morpher.morphsTo());
        if (registered != null && !registered.isEmpty()) {
            registered.remove(morpher);
            if (registered.isEmpty()) {
                this.morphers.remove(morpher.morphsTo());
            }
        }
    }

    public synchronized Morpher getMorpherFor(Class clazz) {
        List registered = (List)this.morphers.get(clazz);
        if (registered == null || registered.isEmpty()) {
            return IdentityObjectMorpher.getInstance();
        }
        return (Morpher)registered.get(0);
    }

    public synchronized Morpher[] getMorphersFor(Class clazz) {
        List registered = (List)this.morphers.get(clazz);
        if (registered == null || registered.isEmpty()) {
            return new Morpher[]{IdentityObjectMorpher.getInstance()};
        }
        Morpher[] morphs = new Morpher[registered.size()];
        int k2 = 0;
        Iterator i2 = registered.iterator();
        while (i2.hasNext()) {
            morphs[k2++] = (Morpher)i2.next();
        }
        return morphs;
    }

    public Object morph(Class target, Object value) {
        if (value == null) {
            Morpher morpher = this.getMorpherFor(target);
            if (morpher instanceof ObjectMorpher) {
                return ((ObjectMorpher)morpher).morph(value);
            }
            try {
                Method morphMethod = morpher.getClass().getDeclaredMethod("morph", class$java$lang$Object == null ? (class$java$lang$Object = MorpherRegistry.class$("java.lang.Object")) : class$java$lang$Object);
                return morphMethod.invoke((Object)morpher, value);
            }
            catch (Exception e2) {
                throw new MorphException(e2);
            }
        }
        Morpher[] morphers = this.getMorphersFor(target);
        for (int i2 = 0; i2 < morphers.length; ++i2) {
            Morpher morpher = morphers[i2];
            if (!morpher.supports(value.getClass())) continue;
            if (morpher instanceof ObjectMorpher) {
                return ((ObjectMorpher)morpher).morph(value);
            }
            try {
                Method morphMethod = morpher.getClass().getDeclaredMethod("morph", class$java$lang$Object == null ? (class$java$lang$Object = MorpherRegistry.class$("java.lang.Object")) : class$java$lang$Object);
                return morphMethod.invoke((Object)morpher, value);
            }
            catch (Exception e3) {
                throw new MorphException(e3);
            }
        }
        return value;
    }

    public void registerMorpher(Morpher morpher) {
        this.registerMorpher(morpher, false);
    }

    public synchronized void registerMorpher(Morpher morpher, boolean override) {
        ArrayList<Morpher> registered = (ArrayList<Morpher>)this.morphers.get(morpher.morphsTo());
        if (override || registered == null) {
            registered = new ArrayList<Morpher>();
            this.morphers.put(morpher.morphsTo(), registered);
        }
        if (!registered.contains(morpher)) {
            registered.add(morpher);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

