/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.model;

import com.rscja.deviceapi.entity.UHFTAGInfo;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class InventoryTableModel
extends AbstractTableModel {
    private List<UHFTAGInfo> uhftagInfoList = new ArrayList<UHFTAGInfo>();
    private int total = 0;
    public String[] columnNames = new String[]{"INDEX", "EPC", "TID", "USER", "RSSI", "Count", "Ant"};

    public void addData(UHFTAGInfo info) {
        ++this.total;
        boolean[] exists = new boolean[1];
        int index = InventoryTableModel.getInsertIndex(this.uhftagInfoList, info, exists);
        if (exists[0]) {
            UHFTAGInfo temp = this.uhftagInfoList.get(index);
            temp.setCount(temp.getCount() + 1);
        } else {
            this.uhftagInfoList.add(index, info);
        }
    }

    public int getTagCount() {
        return this.uhftagInfoList.size();
    }

    public int getTotal() {
        return this.total;
    }

    @Override
    public int getRowCount() {
        if (this.uhftagInfoList != null) {
            return this.uhftagInfoList.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.uhftagInfoList != null) {
            UHFTAGInfo uhftagInfo = this.uhftagInfoList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(rowIndex + 1);
                }
                case 1: {
                    return uhftagInfo.getEPC();
                }
                case 2: {
                    return uhftagInfo.getTid();
                }
                case 3: {
                    return uhftagInfo.getUser();
                }
                case 4: {
                    return uhftagInfo.getRssi();
                }
                case 5: {
                    return uhftagInfo.getCount();
                }
                case 6: {
                    return uhftagInfo.getAnt();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return true;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }

    public void clear() {
        this.uhftagInfoList.clear();
        this.total = 0;
    }

    public static int getInsertIndex(List<UHFTAGInfo> listData, UHFTAGInfo newInfo, boolean[] exists) {
        int judgeIndex;
        int startIndex = 0;
        int endIndex = listData.size();
        if (endIndex == 0) {
            exists[0] = false;
            return 0;
        }
        --endIndex;
        while (true) {
            judgeIndex = (startIndex + endIndex) / 2;
            int ret = InventoryTableModel.compareBytes(newInfo.getEpcBytes(), listData.get(judgeIndex).getEpcBytes());
            if (ret > 0) {
                if (judgeIndex == endIndex) {
                    exists[0] = false;
                    return judgeIndex + 1;
                }
                startIndex = judgeIndex + 1;
                continue;
            }
            if (ret >= 0) break;
            if (judgeIndex == startIndex) {
                exists[0] = false;
                return judgeIndex;
            }
            endIndex = judgeIndex - 1;
        }
        exists[0] = true;
        return judgeIndex;
    }

    private static int compareBytes(byte[] b1, byte[] b2) {
        int len = b1.length < b2.length ? b1.length : b2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            int value1 = b1[i2] & 0xFF;
            int value2 = b2[i2] & 0xFF;
            if (value1 > value2) {
                return 1;
            }
            if (value1 >= value2) continue;
            return -1;
        }
        if (b1.length > b2.length) {
            return 2;
        }
        if (b1.length < b2.length) {
            return -2;
        }
        return 0;
    }
}

