/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.form;

import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.uhf.UHFMainForm;
import com.uhf.model.InventoryTableModel;
import com.uhf.utils.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class InventoryForm
extends JPanel {
    boolean isRuning = false;
    private int totalCount;
    private long totalTime;
    private long startReadTime;
    private InventoryTableModel inventoryTableModel = new InventoryTableModel();
    private JPanel panel1;
    private JPanel panel2;
    private JPanel panel3;
    private JLabel label1;
    private JScrollPane scrollPane2;
    private JTextArea txtFilterData;
    private JLabel label2;
    private JTextField txtFilterStart;
    private JLabel label3;
    private JTextField txtFilterLen;
    private JButton btnSetFilter;
    private JButton btnReset;
    private JPanel panel4;
    private JPanel panel5;
    private JRadioButton rbFilterEpc;
    private JRadioButton rbFliterTid;
    private JRadioButton rbFilterUser;
    private JLabel label5;
    private JLabel label6;
    private JScrollPane scrollPane1;
    private JTable table1;
    private JLabel label4;
    private JLabel lblTags;
    private JLabel lblCount;
    private JLabel label7;
    private JLabel label8;
    private JLabel lblTime;
    private JLabel label11;
    private JTextField txtTime;
    private JLabel label12;
    private JButton btnStartStop;
    private JButton btnClear;

    public InventoryForm() {
        this.initComponents();
        this.initUI();
    }

    public void initUI() {
        this.table1.setModel(this.inventoryTableModel);
        this.table1.getColumn(this.table1.getColumnName(0)).setPreferredWidth(10);
        this.table1.getColumn(this.table1.getColumnName(1)).setPreferredWidth(180);
        this.table1.getColumn(this.table1.getColumnName(2)).setPreferredWidth(150);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.table1.getColumn(this.table1.getColumnName(3)).setCellRenderer(renderer);
        this.table1.getColumn(this.table1.getColumnName(4)).setPreferredWidth(10);
        this.table1.getColumn(this.table1.getColumnName(5)).setPreferredWidth(10);
        this.table1.getColumn(this.table1.getColumnName(6)).setPreferredWidth(10);
        this.rbFilterEpc.setSelected(true);
        this.rbFilterUser.setSelected(false);
        this.rbFliterTid.setSelected(false);
    }

    private void btnSetFilterActionPerformed(ActionEvent e2) {
        String start = this.txtFilterStart.getText();
        String len = this.txtFilterLen.getText();
        String data = this.txtFilterData.getText();
        if (StringUtils.isEmpty(start)) {
            JOptionPane.showMessageDialog(this, "Ptr cannot be empty!", "", 0);
            return;
        }
        if (StringUtils.isEmpty(len)) {
            JOptionPane.showMessageDialog(this, "Len cannot be empty!", "", 0);
            return;
        }
        int bank = -1;
        if (this.rbFilterEpc.isSelected()) {
            bank = 1;
        } else if (this.rbFliterTid.isSelected()) {
            bank = 2;
        } else if (this.rbFilterUser.isSelected()) {
            bank = 3;
        }
        if (bank == -1) {
            JOptionPane.showMessageDialog(this, "Please select the data area that you want to filter for!", "", 0);
            return;
        }
        boolean result = UHFMainForm.ur4.setFilter(bank, Integer.parseInt(start), Integer.parseInt(len), data);
        if (result) {
            JOptionPane.showMessageDialog(this, "Set success!", "", 0);
        } else {
            JOptionPane.showMessageDialog(this, "Set failed!", "", 0);
        }
    }

    private void btnResetActionPerformed(ActionEvent e2) {
        boolean result = UHFMainForm.ur4.setFilter(1, 0, 0, null);
        if (result) {
            JOptionPane.showMessageDialog(this, "Set success!", "", 0);
        } else {
            JOptionPane.showMessageDialog(this, "Set failed!", "", 0);
        }
    }

    private void btnStartStopActionPerformed(ActionEvent e2) {
        UHFMainForm.ur4.setInventoryCallback(new IUHFInventoryCallback(){

            @Override
            public void callback(UHFTAGInfo uhftagInfo) {
                InventoryForm.this.inventoryTableModel.addData(uhftagInfo);
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            InventoryForm.this.table1.updateUI();
                            InventoryForm.this.lblTags.setText(InventoryForm.this.inventoryTableModel.getTagCount() + "");
                            InventoryForm.this.lblCount.setText(InventoryForm.this.inventoryTableModel.getTotal() + "");
                        }
                    });
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        if (this.btnStartStop.getText().equals("AUTO")) {
            boolean result = UHFMainForm.ur4.startInventoryTag();
            if (!result) {
                JOptionPane.showMessageDialog(this, "Start inventory failed!", "", 0);
                return;
            }
            this.startInventory();
        } else {
            this.stopInventory();
        }
    }

    public void startInventory() {
        this.isRuning = true;
        this.btnClear.setEnabled(false);
        this.btnStartStop.setText("STOP");
        this.startReadTime = System.currentTimeMillis();
        new Thread(){

            @Override
            public void run() {
                String inventoryTimeStr = InventoryForm.this.txtTime.getText();
                int inventoryTime = 0;
                if (inventoryTimeStr != null && !inventoryTimeStr.isEmpty()) {
                    inventoryTime = Integer.parseInt(inventoryTimeStr);
                }
                while (InventoryForm.this.isRuning) {
                    InventoryForm.this.totalTime = (System.currentTimeMillis() - InventoryForm.this.startReadTime) / 1000L;
                    InventoryForm.this.lblTime.setText(InventoryForm.this.totalTime + "s");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    if (inventoryTime == 0 || InventoryForm.this.totalTime < (long)inventoryTime) continue;
                    InventoryForm.this.stopInventory();
                }
            }
        }.start();
    }

    public void stopInventory() {
        this.isRuning = false;
        this.btnStartStop.setText("AUTO");
        if (UHFMainForm.ur4 != null) {
            UHFMainForm.ur4.stopInventory();
        }
        this.btnClear.setEnabled(true);
    }

    private void btnClearActionPerformed(ActionEvent e2) {
        this.inventoryTableModel.clear();
        this.table1.updateUI();
        this.lblTags.setText(this.inventoryTableModel.getTagCount() + "");
        this.lblCount.setText(this.inventoryTableModel.getTotal() + "");
    }

    private void rbFilterEpcActionPerformed(ActionEvent e2) {
        this.rbFilterEpc.setSelected(true);
        this.rbFilterUser.setSelected(false);
        this.rbFliterTid.setSelected(false);
    }

    private void rbFliterTidActionPerformed(ActionEvent e2) {
        this.rbFilterEpc.setSelected(false);
        this.rbFilterUser.setSelected(false);
        this.rbFliterTid.setSelected(true);
    }

    private void rbFilterUserActionPerformed(ActionEvent e2) {
        this.rbFilterEpc.setSelected(false);
        this.rbFilterUser.setSelected(true);
        this.rbFliterTid.setSelected(false);
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (!aFlag && this.btnStartStop.getText().equals("STOP")) {
            this.stopInventory();
        }
        super.setVisible(aFlag);
    }

    private void initComponents() {
        Rectangle bounds;
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.panel3 = new JPanel();
        this.label1 = new JLabel();
        this.scrollPane2 = new JScrollPane();
        this.txtFilterData = new JTextArea();
        this.label2 = new JLabel();
        this.txtFilterStart = new JTextField();
        this.label3 = new JLabel();
        this.txtFilterLen = new JTextField();
        this.btnSetFilter = new JButton();
        this.btnReset = new JButton();
        this.panel4 = new JPanel();
        this.panel5 = new JPanel();
        this.rbFilterEpc = new JRadioButton();
        this.rbFliterTid = new JRadioButton();
        this.rbFilterUser = new JRadioButton();
        this.label5 = new JLabel();
        this.label6 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.table1 = new JTable();
        this.label4 = new JLabel();
        this.lblTags = new JLabel();
        this.lblCount = new JLabel();
        this.label7 = new JLabel();
        this.label8 = new JLabel();
        this.lblTime = new JLabel();
        this.label11 = new JLabel();
        this.txtTime = new JTextField();
        this.label12 = new JLabel();
        this.btnStartStop = new JButton();
        this.btnClear = new JButton();
        this.setLayout(null);
        this.panel1.setLayout(null);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.panel1.getComponentCount(); ++i2) {
            bounds = this.panel1.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.panel1.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel1.setMinimumSize(preferredSize);
        this.panel1.setPreferredSize(preferredSize);
        this.add(this.panel1);
        this.panel1.setBounds(new Rectangle(new Point(60, 25), this.panel1.getPreferredSize()));
        this.panel2.setLayout(null);
        preferredSize = new Dimension();
        for (int i3 = 0; i3 < this.panel2.getComponentCount(); ++i3) {
            bounds = this.panel2.getComponent(i3).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel2.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel2.setMinimumSize(preferredSize);
        this.panel2.setPreferredSize(preferredSize);
        this.add(this.panel2);
        this.panel2.setBounds(70, 105, this.panel2.getPreferredSize().width, 0);
        this.panel3.setBackground(new Color(238, 238, 238));
        this.panel3.setBorder(new TitledBorder("Filter"));
        this.panel3.setLayout(null);
        this.label1.setText("Data:");
        this.panel3.add(this.label1);
        this.label1.setBounds(new Rectangle(new Point(20, 30), this.label1.getPreferredSize()));
        this.scrollPane2.setViewportView(this.txtFilterData);
        this.panel3.add(this.scrollPane2);
        this.scrollPane2.setBounds(65, 15, 320, 50);
        this.label2.setText("Ptr:");
        this.panel3.add(this.label2);
        this.label2.setBounds(new Rectangle(new Point(405, 35), this.label2.getPreferredSize()));
        this.panel3.add(this.txtFilterStart);
        this.txtFilterStart.setBounds(430, 25, 65, 35);
        this.label3.setText("Len:");
        this.panel3.add(this.label3);
        this.label3.setBounds(new Rectangle(new Point(530, 35), this.label3.getPreferredSize()));
        this.panel3.add(this.txtFilterLen);
        this.txtFilterLen.setBounds(560, 25, 60, 35);
        this.btnSetFilter.setText("Set Filter");
        this.btnSetFilter.addActionListener(e2 -> this.btnSetFilterActionPerformed(e2));
        this.panel3.add(this.btnSetFilter);
        this.btnSetFilter.setBounds(890, 25, this.btnSetFilter.getPreferredSize().width, 40);
        this.btnReset.setText("Cancel Filter ");
        this.btnReset.addActionListener(e2 -> this.btnResetActionPerformed(e2));
        this.panel3.add(this.btnReset);
        this.btnReset.setBounds(980, 25, this.btnReset.getPreferredSize().width, 40);
        this.panel4.setMinimumSize(new Dimension(30, 10));
        this.panel4.setLayout(new BorderLayout());
        this.panel3.add(this.panel4);
        this.panel4.setBounds(730, 30, this.panel4.getPreferredSize().width, 0);
        this.panel5.setPreferredSize(new Dimension(10, 50));
        this.panel5.setBorder(LineBorder.createBlackLineBorder());
        this.panel5.setToolTipText("\u8fc7\u6ee4");
        this.panel5.setLayout(null);
        this.rbFilterEpc.setText("EPC");
        this.rbFilterEpc.addActionListener(e2 -> this.rbFilterEpcActionPerformed(e2));
        this.panel5.add(this.rbFilterEpc);
        this.rbFilterEpc.setBounds(new Rectangle(new Point(5, 15), this.rbFilterEpc.getPreferredSize()));
        this.rbFliterTid.setText("Tid");
        this.rbFliterTid.addActionListener(e2 -> this.rbFliterTidActionPerformed(e2));
        this.panel5.add(this.rbFliterTid);
        this.rbFliterTid.setBounds(new Rectangle(new Point(75, 15), this.rbFliterTid.getPreferredSize()));
        this.rbFilterUser.setText("User");
        this.rbFilterUser.addActionListener(e2 -> this.rbFilterUserActionPerformed(e2));
        this.panel5.add(this.rbFilterUser);
        this.rbFilterUser.setBounds(new Rectangle(new Point(140, 15), this.rbFilterUser.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i4 = 0; i4 < this.panel5.getComponentCount(); ++i4) {
            bounds = this.panel5.getComponent(i4).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel5.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel5.setMinimumSize(preferredSize);
        this.panel5.setPreferredSize(preferredSize);
        this.panel3.add(this.panel5);
        this.panel5.setBounds(670, 20, 215, this.panel5.getPreferredSize().height);
        this.label5.setText("bit");
        this.panel3.add(this.label5);
        this.label5.setBounds(new Rectangle(new Point(495, 35), this.label5.getPreferredSize()));
        this.label6.setText("bit");
        this.panel3.add(this.label6);
        this.label6.setBounds(620, 35, this.label6.getPreferredSize().width, 17);
        preferredSize = new Dimension();
        for (int i5 = 0; i5 < this.panel3.getComponentCount(); ++i5) {
            bounds = this.panel3.getComponent(i5).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel3.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel3.setMinimumSize(preferredSize);
        this.panel3.setPreferredSize(preferredSize);
        this.add(this.panel3);
        this.panel3.setBounds(10, 15, 1080, 80);
        this.table1.setModel(new DefaultTableModel());
        this.scrollPane1.setViewportView(this.table1);
        this.add(this.scrollPane1);
        this.scrollPane1.setBounds(10, 120, 1075, 420);
        this.label4.setText("Labels:");
        this.add(this.label4);
        this.label4.setBounds(new Rectangle(new Point(35, 565), this.label4.getPreferredSize()));
        this.lblTags.setText("0");
        this.add(this.lblTags);
        this.lblTags.setBounds(90, 565, 60, this.lblTags.getPreferredSize().height);
        this.lblCount.setText("0");
        this.add(this.lblCount);
        this.lblCount.setBounds(265, 565, 115, 17);
        this.label7.setText("Count:");
        this.add(this.label7);
        this.label7.setBounds(215, 565, this.label7.getPreferredSize().width, 17);
        this.label8.setText("Time:");
        this.add(this.label8);
        this.label8.setBounds(new Rectangle(new Point(390, 565), this.label8.getPreferredSize()));
        this.lblTime.setText("0s");
        this.add(this.lblTime);
        this.lblTime.setBounds(425, 565, 110, this.lblTime.getPreferredSize().height);
        this.label11.setText("Work Time:");
        this.add(this.label11);
        this.label11.setBounds(new Rectangle(new Point(550, 565), this.label11.getPreferredSize()));
        this.txtTime.setText("0");
        this.add(this.txtTime);
        this.txtTime.setBounds(620, 560, 95, this.txtTime.getPreferredSize().height);
        this.label12.setText("S");
        this.add(this.label12);
        this.label12.setBounds(new Rectangle(new Point(720, 565), this.label12.getPreferredSize()));
        this.btnStartStop.setText("AUTO");
        this.btnStartStop.addActionListener(e2 -> this.btnStartStopActionPerformed(e2));
        this.add(this.btnStartStop);
        this.btnStartStop.setBounds(800, 555, 100, 40);
        this.btnClear.setText("CLEAR");
        this.btnClear.addActionListener(e2 -> this.btnClearActionPerformed(e2));
        this.add(this.btnClear);
        this.btnClear.setBounds(940, 555, 100, 40);
        preferredSize = new Dimension();
        for (int i6 = 0; i6 < this.getComponentCount(); ++i6) {
            bounds = this.getComponent(i6).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.setMinimumSize(preferredSize);
        this.setPreferredSize(preferredSize);
    }
}

