/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi.linux.serialport;

import com.rscja.deviceapi.ConnectionState;
import com.rscja.deviceapi.RFIDWithUHFBase;
import com.rscja.deviceapi.entity.AntennaNameEnum;
import com.rscja.deviceapi.entity.AntennaPowerEntity;
import com.rscja.deviceapi.entity.AntennaState;
import com.rscja.deviceapi.entity.GPIStateEntity;
import com.rscja.deviceapi.entity.Gen2Entity;
import com.rscja.deviceapi.entity.InventoryModeEntity;
import com.rscja.deviceapi.entity.InventoryModeEntity$Builder;
import com.rscja.deviceapi.entity.ReaderIPEntity;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.ConnectionStateCallback;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import com.rscja.deviceapi.interfaces.IUR4;
import com.rscja.deviceapi.linux.LinuxUHFAndHFAPI;
import com.rscja.deviceapi.linux.a;
import com.rscja.deviceapi.linux.serialport.SPUR4Linux$CheckConnectionState;
import com.rscja.deviceapi.linux.serialport.SPUR4Linux$InventoryThread;
import com.rscja.utility.StringUtility;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SPUR4Linux
extends RFIDWithUHFBase
implements IUR4 {
    private LinuxUHFAndHFAPI linuxUHFAndHFAPI = null;
    private byte[] tempBuffData = new byte[150];
    private int[] buffLen = new int[10];
    private IUHFInventoryCallback inventoryCallback;
    private byte zero = 0;
    protected boolean isRuning = false;
    protected List<UHFTAGInfo> uhfinfoList = null;
    private SPUR4Linux$InventoryThread inventoryThread = null;
    private int isFilterRepeatBank = 0;
    private ConnectionStateCallback stateCallback;
    private SPUR4Linux$CheckConnectionState checkConnectionState = null;
    ConnectionState currState = ConnectionState.DISCONNECTED;

    public SPUR4Linux(File file) {
        if (file != null) {
            a.a().a(file.getAbsolutePath());
        } else {
            a.a().a(a.a);
        }
        this.linuxUHFAndHFAPI = a.a().c();
    }

    @Override
    public boolean init(String string) {
        boolean bl = this.linuxUHFAndHFAPI.ComOpen(string.getBytes()) == 0;
        if (bl) {
            this.currState = ConnectionState.CONNECTED;
            if (this.stateCallback != null) {
                this.stateCallback.getState(ConnectionState.CONNECTED, null);
                this.startCheckConnectionThread();
            }
            this.setPowerOn(true);
        } else {
            this.currState = ConnectionState.DISCONNECTED;
            if (this.stateCallback != null) {
                this.stateCallback.getState(ConnectionState.DISCONNECTED, null);
            }
        }
        return bl;
    }

    @Override
    public boolean free() {
        ConnectionState connectionState = this.currState;
        this.currState = ConnectionState.DISCONNECTED;
        this.linuxUHFAndHFAPI.ClosePort();
        this.setPowerOn(false);
        this.stopCheckConnectionThread();
        if (this.stateCallback != null && connectionState != ConnectionState.DISCONNECTED) {
            this.stateCallback.getState(ConnectionState.DISCONNECTED, null);
        }
        return true;
    }

    @Override
    public String getVersion() {
        this.setStopCheackState();
        byte[] byArray = new byte[50];
        if (this.linuxUHFAndHFAPI.UHFGetSoftwareVersion(byArray) == 0) {
            byte by = byArray[0];
            byArray = Arrays.copyOfRange(byArray, 1, by + 1);
            this.setStartCheackState();
            return new String(byArray);
        }
        this.setStartCheackState();
        return null;
    }

    @Override
    public int getFrequencyMode() {
        this.setStopCheackState();
        byte[] byArray = new byte[1];
        if (this.linuxUHFAndHFAPI.UHFGetRegion(byArray) == 0) {
            this.setStartCheackState();
            return byArray[0] & 0xFF;
        }
        this.setStartCheackState();
        return -1;
    }

    @Override
    public boolean setFrequencyMode(byte by) {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetRegion((byte)1, by) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean startInventoryTag() {
        if (this.isRuning) {
            return false;
        }
        if (!this.isPowerOn()) {
            return false;
        }
        if (this.uhfinfoList != null) {
            this.uhfinfoList.clear();
        }
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFInventory() == 0) {
            this.isRuning = true;
            this.startInventoryThread();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public UHFTAGInfo readTagFromBuffer() {
        Arrays.fill(this.buffLen, 0);
        Arrays.fill(this.tempBuffData, this.zero);
        if (this.linuxUHFAndHFAPI.UHF_GetReceived_EX(this.buffLen, this.tempBuffData) == 0) {
            byte[] byArray = null;
            byte by = this.tempBuffData[0];
            byte by2 = this.tempBuffData[by + 1];
            int n = by + 2;
            int n2 = n + by2;
            int n3 = n2 + 2;
            Object object = Arrays.copyOfRange(this.tempBuffData, 1, by + 1);
            Arrays.copyOfRange(object, 0, 2);
            byte[] byArray2 = Arrays.copyOfRange(object, 2, ((byte[])object).length);
            object = StringUtility.bytes2HexString(byArray2);
            if (by2 > 12) {
                int n4 = n;
                byArray = Arrays.copyOfRange(this.tempBuffData, n4, n4 + 12);
                Arrays.copyOfRange(this.tempBuffData, n + 12, n2);
            } else if (by2 > 0) {
                byArray = Arrays.copyOfRange(this.tempBuffData, n, n2);
            }
            byte[] byArray3 = Arrays.copyOfRange(this.tempBuffData, n2, n3);
            int n5 = 65535 - (byArray3[1] & 0xFF | (byArray3[0] & 0xFF) << 8);
            float f2 = (float)n5 / 10.0f;
            String string = "N/A";
            if (f2 < 200.0f && f2 > 0.0f) {
                DecimalFormat decimalFormat = new DecimalFormat("##0.00");
                string = "-" + decimalFormat.format(f2);
            }
            UHFTAGInfo uHFTAGInfo = new UHFTAGInfo();
            uHFTAGInfo.setEPC((String)object);
            uHFTAGInfo.setEpcBytes(byArray2);
            if (byArray != null) {
                uHFTAGInfo.setTid(StringUtility.bytes2HexString(byArray));
            }
            uHFTAGInfo.setTidBytes(byArray);
            uHFTAGInfo.setUser(null);
            uHFTAGInfo.setRssi(string);
            return uHFTAGInfo;
        }
        return null;
    }

    @Override
    public boolean stopInventory() {
        boolean bl = false;
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFStopGet() == 0) {
            bl = true;
        }
        this.isRuning = false;
        this.stopInventoryThread();
        this.setStartCheackState();
        return bl;
    }

    @Override
    public boolean lockMem(String object, int n, int n2, int n3, String object2, String object3) {
        this.setStopCheackState();
        object = StringUtility.hexString2Bytes((String)object);
        object2 = n3 == 0 ? (Object)new byte[1] : (Object)StringUtility.hexString2Bytes((String)object2);
        object3 = StringUtility.hexString2Bytes((String)object3);
        if (this.linuxUHFAndHFAPI.UHFLockTag((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte[])object3) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean lockMem(String string, String string2) {
        return this.lockMem(string, 1, 0, 0, null, string2);
    }

    @Override
    public UHFTAGInfo inventorySingleTag() {
        byte[] byArray = new byte[10];
        byte[] byArray2 = new byte[256];
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFInventorySingle(byArray, byArray2) == 0) {
            this.setStartCheackState();
            byte[] byArray3 = null;
            byte by = byArray2[0];
            byte by2 = byArray2[by + 1];
            int n = by + 2;
            int n2 = n + by2;
            int n3 = n2 + 2;
            Object object = Arrays.copyOfRange(byArray2, 1, by + 1);
            Arrays.copyOfRange(object, 0, 2);
            byte[] byArray4 = Arrays.copyOfRange(object, 2, ((byte[])object).length);
            object = StringUtility.bytes2HexString(byArray4);
            if (by2 > 12) {
                int n4 = n;
                byArray3 = Arrays.copyOfRange(byArray2, n4, n4 + 12);
                Arrays.copyOfRange(byArray2, n + 12, n2);
            } else if (by2 > 0) {
                byArray3 = Arrays.copyOfRange(byArray2, n, n2);
            }
            byArray2 = Arrays.copyOfRange(byArray2, n2, n3);
            int n5 = (byArray2[1] | byArray2[0] << 8) - 65535;
            float f2 = (float)(65535 - n5) / 10.0f;
            String string = "N/A";
            if (f2 < 200.0f && f2 > 0.0f) {
                DecimalFormat decimalFormat = new DecimalFormat("##0.00");
                string = "-" + decimalFormat.format(f2);
            }
            UHFTAGInfo uHFTAGInfo = new UHFTAGInfo();
            uHFTAGInfo.setEPC((String)object);
            uHFTAGInfo.setEpcBytes(byArray4);
            uHFTAGInfo.setTid(null);
            uHFTAGInfo.setTidBytes(byArray3);
            uHFTAGInfo.setUser(null);
            uHFTAGInfo.setRssi(string);
            return uHFTAGInfo;
        }
        this.setStartCheackState();
        return null;
    }

    @Override
    public String readData(String string, int n, int n2, int n3) {
        return this.readData(string, 0, 0, 0, "00", n, n2, n3);
    }

    @Override
    public String readData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6) {
        try {
            Object object3 = new StringBuilder();
            ((StringBuilder)object3).append("\r\n\u5bc6\u7801\uff1a" + (String)object);
            ((StringBuilder)object3).append("\r\n\u8fc7\u6ee4\u6570\u636e\u5757\uff08 1\uff1aEPC, 2:TID, 3:USR\uff09\uff1a" + n);
            ((StringBuilder)object3).append("\r\n\u8fc7\u6ee4\u8d77\u59cb\u5730\u5740\uff1a" + n2);
            ((StringBuilder)object3).append("\r\n\u8fc7\u6ee4\u957f\u5ea6\uff1a" + n3);
            ((StringBuilder)object3).append("\r\n\u8fc7\u6ee4\u6570\u636e\uff1a" + (String)object2);
            ((StringBuilder)object3).append("\r\n");
            ((StringBuilder)object3).append("\r\n\u8bfb\u53d6\u7684\u6570\u636e\u5757\uff1a" + n4);
            ((StringBuilder)object3).append("\r\n\u8bfb\u53d6\u7684\u6570\u636e\u8d77\u59cb\u5730\u5740\uff1a" + n5);
            ((StringBuilder)object3).append("\r\n\u8bfb\u53d6\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n6);
            ((StringBuilder)object3).append("\r\n");
            object = StringUtility.hexString2Bytes((String)object);
            n = (byte)n;
            n2 = (byte)n2;
            n3 = (byte)n3;
            object2 = StringUtility.hexString2Bytes((String)object2);
            n4 = (byte)n4;
            object3 = new byte[1024];
            this.setStopCheackState();
            int n7 = this.linuxUHFAndHFAPI.UHFReadData((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte)n4, n5, n6, (byte[])object3);
            System.out.println("readData result=" + n7);
            if (n7 == 0) {
                this.setStartCheackState();
                return StringUtility.bytes2HexString(Arrays.copyOf((byte[])object3, n6 << 1));
            }
        }
        catch (Exception exception) {
            System.out.println("readData ex=" + exception.toString());
        }
        this.setStartCheackState();
        return null;
    }

    @Override
    public boolean writeData(String string, int n, int n2, int n3, String string2) {
        return this.writeData(string, 0, 0, 0, "00", n, n2, n3, string2);
    }

    @Override
    public boolean writeData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6, String object3) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\r\n\u5bc6\u7801\uff1a" + (String)object);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\u5757\uff08 1\uff1aEPC, 2:TID, 3:USR\uff09\uff1a" + n);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u8d77\u59cb\u5730\u5740\uff1a" + n2);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u957f\u5ea6\uff1a" + n3);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\uff1a" + (String)object2);
            stringBuilder.append("\r\n");
            stringBuilder.append("\r\n\u5199\u7684\u6570\u636e\u5757\uff1a" + n4);
            stringBuilder.append("\r\n\u5199\u7684\u6570\u636e\u8d77\u59cb\u5730\u5740\uff1a" + n5);
            stringBuilder.append("\r\n\u5199\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n6);
            stringBuilder.append("\r\n");
            object = StringUtility.hexString2Bytes((String)object);
            n = (byte)n;
            n2 = (byte)n2;
            n3 = (byte)n3;
            object2 = StringUtility.hexString2Bytes((String)object2);
            n4 = (byte)n4;
            n6 = (byte)n6;
            object3 = StringUtility.hexString2Bytes((String)object3);
            this.setStopCheackState();
            int n7 = this.linuxUHFAndHFAPI.UHFWriteData((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte)n4, n5, (byte)n6, (byte[])object3);
            if (n7 == 0) {
                this.setStartCheackState();
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("writeData ex=" + exception.toString());
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean blockWriteData(String string, int n, int n2, int n3, String string2) {
        return this.blockWriteData(string, 0, 0, 0, "00", n, n2, n3, string2);
    }

    @Override
    public boolean blockWriteData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6, String object3) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\r\n\u5bc6\u7801\uff1a" + (String)object);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\u5757\uff08 1\uff1aEPC, 2:TID, 3:USR\uff09\uff1a" + n);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u8d77\u59cb\u5730\u5740\uff1a" + n2);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u957f\u5ea6\uff1a" + n3);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\uff1a" + (String)object2);
            stringBuilder.append("\r\n");
            stringBuilder.append("\r\nblock\u5199\u7684\u6570\u636e\u5757\uff1a" + n4);
            stringBuilder.append("\r\nblock\u5199\u7684\u6570\u636e\u8d77\u59cb\u5730\u5740\uff1a" + n5);
            stringBuilder.append("\r\nblock\u5199\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n6);
            stringBuilder.append("\r\n");
            object = StringUtility.hexString2Bytes((String)object);
            n = (byte)n;
            n2 = (byte)n2;
            n3 = (byte)n3;
            object2 = StringUtility.hexString2Bytes((String)object2);
            n4 = (byte)n4;
            n6 = (byte)n6;
            object3 = StringUtility.hexString2Bytes((String)object3);
            this.setStopCheackState();
            int n7 = this.linuxUHFAndHFAPI.UHFBlockWriteData((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte)n4, n5, n6, (byte[])object3);
            if (n7 == 0) {
                this.setStartCheackState();
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("blockWriteData ex=" + exception.toString());
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean eraseData(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\r\n\u5bc6\u7801\uff1a" + (String)object);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\u5757\uff08 1\uff1aEPC, 2:TID, 3:USR\uff09\uff1a" + n);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u8d77\u59cb\u5730\u5740\uff1a" + n2);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u957f\u5ea6\uff1a" + n3);
            stringBuilder.append("\r\n\u8fc7\u6ee4\u6570\u636e\uff1a" + (String)object2);
            stringBuilder.append("\r\n");
            stringBuilder.append("\r\nerase\u5199\u7684\u6570\u636e\u5757\uff1a" + n4);
            stringBuilder.append("\r\nerase\u5199\u7684\u6570\u636e\u8d77\u59cb\u5730\u5740\uff1a" + n5);
            stringBuilder.append("\r\nerase\u5199\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n6);
            stringBuilder.append("\r\n");
            object = StringUtility.hexString2Bytes((String)object);
            n = (byte)n;
            n2 = (byte)n2;
            n3 = (byte)n3;
            object2 = StringUtility.hexString2Bytes((String)object2);
            n4 = (byte)n4;
            n6 = (byte)n6;
            this.setStopCheackState();
            int n7 = this.linuxUHFAndHFAPI.UHFBlockEraseData((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte)n4, n5, (byte)n6);
            if (n7 == 0) {
                this.setStartCheackState();
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("eraseData ex=" + exception.toString());
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean eraseData(String string, int n, int n2, int n3) {
        return this.eraseData(string, 0, 0, 0, "00", n, n2, n3);
    }

    @Override
    public boolean setFilter(int n, int n2, int n3, String object) {
        object = StringUtility.hexString2Bytes((String)object);
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetFilter((byte)0, (byte)n, n2, n3, (byte[])object) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean killTag(String string) {
        return this.killTag(string, 0, 0, 0, "00");
    }

    @Override
    public boolean killTag(String object, int n, int n2, int n3, String object2) {
        object = StringUtility.hexString2Bytes((String)object);
        object2 = StringUtility.hexString2Bytes((String)object2);
        this.setStopCheackState();
        int n4 = this.linuxUHFAndHFAPI.UHFKillTag((byte[])object, (byte)n, n2, n3, (byte[])object2);
        if (n4 == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean setProtocol(int n) {
        return this.linuxUHFAndHFAPI.UHFSetProtocolType((byte)n) == 0;
    }

    @Override
    public int getProtocol() {
        byte[] byArray = new byte[1];
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFGetProtocolType(byArray) == 0) {
            this.setStartCheackState();
            return byArray[0];
        }
        this.setStartCheackState();
        return -1;
    }

    @Override
    public boolean setFreHop(float f2) {
        Object object = "" + f2;
        if (((String)object).length() == 3) {
            object = (String)object + "000";
        } else if (((String)object).length() == 4) {
            object = (String)object + "00";
        } else if (((String)object).length() == 5) {
            object = (String)object + "0";
        }
        object = new int[]{Integer.parseInt((String)object)};
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetJumpFrequency((byte)1, (int[])object) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean setRFLink(int n) {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetRFLink((byte)1, (byte)n) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public int getRFLink() {
        byte[] byArray = new byte[1];
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFGetRFLink(byArray) == 0) {
            this.setStartCheackState();
            return byArray[0];
        }
        this.setStartCheackState();
        return -1;
    }

    @Override
    public boolean setFastID(boolean bl) {
        bl = bl;
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetFastID((byte)(bl ? 1 : 0)) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean setTagFocus(boolean bl) {
        bl = bl;
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetTagfocus((byte)(bl ? 1 : 0)) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean setEPCMode() {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetEPCTIDUSERMode((byte)0, (byte)0, (byte)0, (byte)0) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean setEPCAndTIDMode() {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetEPCTIDUSERMode((byte)0, (byte)1, (byte)0, (byte)0) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean setEPCAndTIDUserMode(int n, int n2) {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetEPCTIDUSERMode((byte)0, (byte)2, (byte)n, (byte)n2) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public InventoryModeEntity getEPCAndTIDUserMode() {
        byte[] byArray = new byte[10];
        this.setStopCheackState();
        int n = this.linuxUHFAndHFAPI.UHFGetEPCTIDUSERMode((byte)0, (byte)0, byArray);
        if (n > 0) {
            this.setStartCheackState();
            InventoryModeEntity$Builder inventoryModeEntity$Builder = new InventoryModeEntity$Builder();
            inventoryModeEntity$Builder.setMode(byArray[0]);
            if (byArray[0] == 2) {
                inventoryModeEntity$Builder.setUserOffset(byArray[1]);
                inventoryModeEntity$Builder.setUserLength(byArray[2]);
            }
            return inventoryModeEntity$Builder.build();
        }
        this.setStartCheackState();
        return null;
    }

    @Override
    public int getTemperature() {
        int[] nArray = new int[1];
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFGetTemperature(nArray) == 0) {
            this.setStartCheackState();
            return nArray[0];
        }
        this.setStartCheackState();
        return -1;
    }

    @Override
    public boolean uhfBlockPermalock(String object, int n, int n2, int n3, String object2, int n4, int n5, int n6, int n7, byte[] byArray) {
        object = StringUtility.hexString2Bytes((String)object);
        n = (byte)n;
        object2 = StringUtility.hexString2Bytes((String)object2);
        n4 = (byte)n4;
        n5 = (byte)n5;
        n7 = (byte)n7;
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFBlockPermalock((byte[])object, (byte)n, n2, n3, (byte[])object2, (byte)n4, (byte)n5, n6, (byte)n7, byArray) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean setGen2(Gen2Entity gen2Entity) {
        int n = gen2Entity.getSelectTarget();
        int n2 = gen2Entity.getSelectAction();
        int n3 = gen2Entity.getSelectTruncate();
        int n4 = gen2Entity.getQ();
        int n5 = gen2Entity.getStartQ();
        int n6 = gen2Entity.getMinQ();
        int n7 = gen2Entity.getMaxQ();
        int n8 = gen2Entity.getQueryDR();
        int n9 = gen2Entity.getQueryM();
        int n10 = gen2Entity.getQueryTRext();
        int n11 = gen2Entity.getQuerySel();
        int n12 = gen2Entity.getQuerySession();
        int n13 = gen2Entity.getQueryTarget();
        int n14 = gen2Entity.getLinkFrequency();
        this.setStopCheackState();
        n14 = this.linuxUHFAndHFAPI.UHFSetGen2((byte)n, (byte)n2, (byte)n3, (byte)n4, (byte)n5, (byte)n6, (byte)n7, (byte)n8, (byte)n9, (byte)n10, (byte)n11, (byte)n12, (byte)n13, (byte)n14);
        System.out.println("UHFSetGen2 result=" + n14);
        if (n14 == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public Gen2Entity getGen2() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = new byte[1];
        byte[] byArray5 = new byte[1];
        byte[] byArray6 = new byte[1];
        byte[] byArray7 = new byte[1];
        byte[] byArray8 = new byte[1];
        byte[] byArray9 = new byte[1];
        byte[] byArray10 = new byte[1];
        byte[] byArray11 = new byte[1];
        byte[] byArray12 = new byte[1];
        byte[] byArray13 = new byte[1];
        byte[] byArray14 = new byte[1];
        this.setStopCheackState();
        int n = this.linuxUHFAndHFAPI.UHFGetGen2(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8, byArray9, byArray10, byArray11, byArray12, byArray13, byArray14);
        if (n == 0) {
            this.setStartCheackState();
            Gen2Entity gen2Entity = new Gen2Entity();
            gen2Entity.setSelectTarget(byArray[0]);
            gen2Entity.setSelectAction(byArray2[0]);
            gen2Entity.setSelectTruncate(byArray3[0]);
            gen2Entity.setQ(byArray4[0]);
            gen2Entity.setStartQ(byArray5[0]);
            gen2Entity.setMinQ(byArray6[0]);
            gen2Entity.setMaxQ(byArray7[0]);
            gen2Entity.setQueryDR(byArray8[0]);
            gen2Entity.setQueryM(byArray9[0]);
            gen2Entity.setQueryTRext(byArray10[0]);
            gen2Entity.setQuerySel(byArray11[0]);
            gen2Entity.setQuerySession(byArray12[0]);
            gen2Entity.setQueryTarget(byArray13[0]);
            gen2Entity.setLinkFrequency(byArray14[0]);
            return gen2Entity;
        }
        this.setStartCheackState();
        return null;
    }

    @Override
    public boolean setPwm(int n, int n2) {
        byte by = (byte)(n >> 8);
        n = (byte)n;
        byte by2 = (byte)(n2 >> 8);
        n2 = (byte)n2;
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetWorkTime((byte)1, by, (byte)n, by2, (byte)n2) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public int[] getPwm() {
        byte[] byArray = new byte[10];
        this.setStopCheackState();
        int n = this.linuxUHFAndHFAPI.UHFGetWorkTime(byArray);
        if (n == -1) {
            this.setStartCheackState();
            return null;
        }
        n = byArray[1] | byArray[0] << 8;
        int n2 = byArray[3] | byArray[2] << 8;
        this.setStartCheackState();
        return new int[]{n, n2};
    }

    @Override
    public boolean setCW(int n) {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetCW((byte)n) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public int getCW() {
        this.setStopCheackState();
        byte[] byArray = new byte[1];
        if (this.linuxUHFAndHFAPI.UHFGetCW(byArray) == 0) {
            this.setStartCheackState();
            return byArray[0];
        }
        this.setStartCheackState();
        return -1;
    }

    @Override
    public boolean uhfJump2Boot() {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFJump2Boot((byte)1) == 0) {
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean uhfJump2BootToSTM32() {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFJump2Boot((byte)0) == 0) {
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean uhfStartUpdate() {
        if (this.linuxUHFAndHFAPI.UHFStartUpd() == 0) {
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean uhfUpdating(byte[] byArray) {
        if (this.linuxUHFAndHFAPI.UHFUpdating(byArray) == 0) {
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean uhfStopUpdate() {
        if (this.linuxUHFAndHFAPI.UHFStopUpdate() == 0) {
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public char[] getBeep() {
        char[] cArray = new char[2];
        byte[] byArray = new byte[10];
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFGetBeep(byArray) == 0) {
            this.setStartCheackState();
            cArray[0] = '\u0000';
            cArray[1] = (char)byArray[0];
            return cArray;
        }
        this.setStartCheackState();
        return null;
    }

    @Override
    public boolean setBeep(int n) {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetBeep((byte)n) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public boolean setGPO(byte by, byte by2, byte by3) {
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFSetIOControl(by, by2, by3) == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public List<GPIStateEntity> getGPI() {
        byte[] byArray = new byte[2];
        this.setStopCheackState();
        int n = this.linuxUHFAndHFAPI.UHFGetIOControl(byArray);
        if (n == 0) {
            this.setStartCheackState();
            ArrayList<GPIStateEntity> arrayList = new ArrayList<GPIStateEntity>();
            arrayList.add(new GPIStateEntity("GPI1", byArray[0]));
            arrayList.add(new GPIStateEntity("GPI2", byArray[1]));
            return arrayList;
        }
        this.setStartCheackState();
        return null;
    }

    @Override
    public boolean setAntennaWorkTime(AntennaNameEnum antennaNameEnum, int n) {
        this.setStopCheackState();
        int n2 = this.linuxUHFAndHFAPI.UHFSetANTWorkTime((byte)antennaNameEnum.getValue(), (byte)1, n);
        if (n2 == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public int getAntennaWorkTime(AntennaNameEnum antennaNameEnum) {
        int[] nArray = new int[1];
        this.setStopCheackState();
        int n = this.linuxUHFAndHFAPI.UHFGetANTWorkTime((byte)antennaNameEnum.getValue(), nArray);
        if (n == 0) {
            this.setStartCheackState();
            return nArray[0];
        }
        this.setStartCheackState();
        return -1;
    }

    @Override
    public boolean setAntenna(List<AntennaState> list) {
        int n;
        if (list == null || list.size() == 0) {
            return false;
        }
        byte[] byArray = new byte[2];
        for (n = 0; n < list.size(); ++n) {
            if (!list.get(n).isEnable()) continue;
            if (list.get(n).getAntennaName() == AntennaNameEnum.ANT1) {
                byArray[1] = (byte)(byArray[1] | 1);
            }
            if (list.get(n).getAntennaName() == AntennaNameEnum.ANT2) {
                byArray[1] = (byte)(byArray[1] | 2);
            }
            if (list.get(n).getAntennaName() == AntennaNameEnum.ANT3) {
                byArray[1] = (byte)(byArray[1] | 4);
            }
            if (list.get(n).getAntennaName() != AntennaNameEnum.ANT4) continue;
            byArray[1] = (byte)(byArray[1] | 8);
        }
        this.setStopCheackState();
        n = this.linuxUHFAndHFAPI.UHFSetANT((byte)1, byArray);
        if (n == 0) {
            this.setStartCheackState();
            return true;
        }
        this.setStartCheackState();
        return false;
    }

    @Override
    public List<AntennaState> getAntenna() {
        byte[] byArray = new byte[2];
        this.setStopCheackState();
        this.linuxUHFAndHFAPI.UHFGetANT(byArray);
        this.setStartCheackState();
        ArrayList<AntennaState> arrayList = new ArrayList<AntennaState>();
        arrayList.add(new AntennaState(AntennaNameEnum.ANT1, (byArray[1] & 1) == 1));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT2, (byArray[1] & 2) == 2));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT3, (byArray[1] & 4) == 4));
        arrayList.add(new AntennaState(AntennaNameEnum.ANT4, (byArray[1] & 8) == 8));
        return arrayList;
    }

    @Override
    public boolean resetUHFSoft() {
        this.setStopCheackState();
        boolean bl = this.linuxUHFAndHFAPI.UHFSetSoftReset() == 0;
        this.setStartCheackState();
        return bl;
    }

    @Override
    public boolean setIPAndPort(ReaderIPEntity readerIPEntity) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[2];
        String[] stringArray = readerIPEntity.getIp().split("\\.");
        byArray[0] = (byte)Integer.parseInt(stringArray[0]);
        byArray[1] = (byte)Integer.parseInt(stringArray[1]);
        byArray[2] = (byte)Integer.parseInt(stringArray[2]);
        byArray[3] = (byte)Integer.parseInt(stringArray[3]);
        stringArray = readerIPEntity.getSubnetMask().split("\\.");
        byArray2[0] = (byte)Integer.parseInt(stringArray[0]);
        byArray2[1] = (byte)Integer.parseInt(stringArray[1]);
        byArray2[2] = (byte)Integer.parseInt(stringArray[2]);
        byArray2[3] = (byte)Integer.parseInt(stringArray[3]);
        stringArray = readerIPEntity.getGateway().split("\\.");
        byArray3[0] = (byte)Integer.parseInt(stringArray[0]);
        byArray3[1] = (byte)Integer.parseInt(stringArray[1]);
        byArray3[2] = (byte)Integer.parseInt(stringArray[2]);
        byArray3[3] = (byte)Integer.parseInt(stringArray[3]);
        byArray4[0] = (byte)(readerIPEntity.getPort() >> 8);
        byArray4[1] = (byte)readerIPEntity.getPort();
        this.setStopCheackState();
        boolean bl = this.linuxUHFAndHFAPI.UHFSetIp(byArray, byArray4, byArray2, byArray3) == 0;
        this.setStartCheackState();
        return bl;
    }

    @Override
    public ReaderIPEntity getIPAndPort() {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[4];
        this.setStopCheackState();
        int n = this.linuxUHFAndHFAPI.UHFGetIp(byArray, byArray2, byArray3, byArray4);
        System.out.println("getIPAndPort result=" + n);
        if (n == 0) {
            this.setStartCheackState();
            ReaderIPEntity readerIPEntity = new ReaderIPEntity();
            readerIPEntity.setIp((byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF));
            readerIPEntity.setGateway((byArray4[0] & 0xFF) + "." + (byArray4[1] & 0xFF) + "." + (byArray4[2] & 0xFF) + "." + (byArray4[3] & 0xFF));
            readerIPEntity.setSubnetMask((byArray3[0] & 0xFF) + "." + (byArray3[1] & 0xFF) + "." + (byArray3[2] & 0xFF) + "." + (byArray3[3] & 0xFF));
            int n2 = (byArray2[0] & 0xFF) << 8 | byArray2[1] & 0xFF;
            readerIPEntity.setPort(n2);
            return readerIPEntity;
        }
        this.setStartCheackState();
        return null;
    }

    @Override
    public boolean setWorkMode(int n) {
        this.setStopCheackState();
        n = this.linuxUHFAndHFAPI.UHFSetWorkMode((byte)n);
        this.setStartCheackState();
        return n == 0;
    }

    @Override
    public int getWorkMode() {
        byte[] byArray = new byte[1];
        this.setStopCheackState();
        int n = this.linuxUHFAndHFAPI.UHFGetWorkMode(byArray);
        this.setStartCheackState();
        if (n != 0) {
            return -1;
        }
        return byArray[0];
    }

    @Override
    public boolean setDestinationIPAndPort(ReaderIPEntity readerIPEntity) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[2];
        String[] stringArray = readerIPEntity.getIp().split("\\.");
        byArray[0] = (byte)Integer.parseInt(stringArray[0]);
        byArray[1] = (byte)Integer.parseInt(stringArray[1]);
        byArray[2] = (byte)Integer.parseInt(stringArray[2]);
        byArray[3] = (byte)Integer.parseInt(stringArray[3]);
        byArray2[0] = (byte)(readerIPEntity.getPort() >> 8);
        byArray2[1] = (byte)readerIPEntity.getPort();
        this.setStopCheackState();
        boolean bl = this.linuxUHFAndHFAPI.UHFSetDestIp(byArray, byArray2) == 0;
        this.setStartCheackState();
        return bl;
    }

    @Override
    public ReaderIPEntity getDestinationIPAndPort() {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[2];
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFGetDestIp(byArray, byArray2) == 0) {
            this.setStartCheackState();
            ReaderIPEntity readerIPEntity = new ReaderIPEntity();
            readerIPEntity.setIp((byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF));
            int n = (byArray2[0] & 0xFF) << 8 | byArray2[1] & 0xFF;
            readerIPEntity.setPort(n);
            return readerIPEntity;
        }
        this.setStartCheackState();
        return null;
    }

    @Override
    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
        this.inventoryCallback = iUHFInventoryCallback;
    }

    @Override
    public ConnectionState getConnectStatus() {
        return this.currState;
    }

    public void setFilterRepeatData(int n) {
        block3: {
            block4: {
                block2: {
                    if (n <= 0 || n > 2) {
                        throw new IllegalArgumentException("bank invalid!");
                    }
                    this.isFilterRepeatBank = n;
                    if (n != 0) break block2;
                    if (this.uhfinfoList == null) break block3;
                    break block4;
                }
                if (this.uhfinfoList == null) {
                    this.uhfinfoList = new ArrayList<UHFTAGInfo>();
                }
            }
            this.uhfinfoList.clear();
        }
    }

    private void startInventoryThread() {
        if (this.inventoryThread == null) {
            this.inventoryThread = new SPUR4Linux$InventoryThread(this);
            this.inventoryThread.start();
        }
    }

    private void stopInventoryThread() {
        if (this.inventoryThread != null) {
            this.inventoryThread.stopThread();
            this.inventoryThread = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setPower(AntennaNameEnum antennaNameEnum, int n) {
        void var2_4;
        int bl = antennaNameEnum.getValue();
        if (var2_4 <= 0 || var2_4 > 30) {
            throw new IllegalArgumentException("power invalid!");
        }
        this.setStopCheackState();
        boolean bl2 = this.linuxUHFAndHFAPI.UHFSetAntennaPower((byte)1, (byte)bl, (byte)var2_4, (byte)var2_4) == 0;
        this.setStartCheackState();
        return bl2;
    }

    @Override
    public int getPower(AntennaNameEnum antennaNameEnum) {
        List<AntennaPowerEntity> list = this.getPowerAll();
        if (list == null) {
            return -1;
        }
        for (AntennaPowerEntity antennaPowerEntity : list) {
            if (antennaPowerEntity.getAntennaNameEnum() != antennaNameEnum) continue;
            return antennaPowerEntity.getPower();
        }
        return -1;
    }

    @Override
    public List<AntennaPowerEntity> getPowerAll() {
        byte by;
        int n;
        byte[] byArray = new byte[100];
        int[] nArray = new int[1];
        this.setStopCheackState();
        if (this.linuxUHFAndHFAPI.UHFGetAntennaPower(byArray, nArray) != 0) {
            this.setStartCheackState();
            return null;
        }
        this.setStartCheackState();
        byte by2 = 0;
        byte by3 = 0;
        ArrayList<AntennaPowerEntity> arrayList = new ArrayList<AntennaPowerEntity>();
        for (n = 0; n < nArray[0] / 3; ++n) {
            by = byArray[n * 3];
            byte by4 = byArray[n * 3 + 1];
            if (by == 0) {
                by3 = by4;
            }
            if (by == 1) {
                by2 = by4;
            } else if (by4 == 0) {
                by4 = by2;
            }
            System.out.println("k=" + n + " antNumber=" + by + " readPower" + by4);
            arrayList.add(new AntennaPowerEntity(AntennaNameEnum.getValue(by), by4));
        }
        if (by2 == 0) {
            by2 = by3;
        }
        System.out.println("list.size=" + arrayList.size());
        if (arrayList.size() > 0) {
            for (n = 1; n <= 4; ++n) {
                by = 0;
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    if (((AntennaPowerEntity)arrayList.get(i2)).getAntennaNameEnum() == null || n != ((AntennaPowerEntity)arrayList.get(i2)).getAntennaNameEnum().getValue()) continue;
                    by = 1;
                    break;
                }
                if (by != 0) continue;
                AntennaPowerEntity antennaPowerEntity = new AntennaPowerEntity();
                antennaPowerEntity.setAntennaNameEnum(AntennaNameEnum.getValue(n));
                antennaPowerEntity.setPower(by2);
                arrayList.add(antennaPowerEntity);
            }
        }
        return arrayList;
    }

    @Override
    public void setConnectionStateCallback(ConnectionStateCallback connectionStateCallback) {
        this.stateCallback = connectionStateCallback;
    }

    private void startCheckConnectionThread() {
        if (this.checkConnectionState == null) {
            this.checkConnectionState = new SPUR4Linux$CheckConnectionState(this);
            SPUR4Linux$CheckConnectionState.access$202(this.checkConnectionState, true);
            SPUR4Linux$CheckConnectionState.access$302(this.checkConnectionState, true);
            this.checkConnectionState.start();
        }
    }

    private void stopCheckConnectionThread() {
        if (this.checkConnectionState != null) {
            SPUR4Linux$CheckConnectionState.access$302(this.checkConnectionState, false);
            this.checkConnectionState.interrupt();
            this.checkConnectionState = null;
        }
    }

    private void setStopCheackState() {
        if (this.checkConnectionState != null) {
            SPUR4Linux$CheckConnectionState.access$202(this.checkConnectionState, false);
            while (!SPUR4Linux$CheckConnectionState.access$400(this.checkConnectionState)) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptedException interruptedException2 = interruptedException;
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    private void setStartCheackState() {
        if (this.checkConnectionState != null) {
            SPUR4Linux$CheckConnectionState.access$202(this.checkConnectionState, true);
        }
    }

    static /* synthetic */ int access$000(SPUR4Linux sPUR4Linux) {
        return sPUR4Linux.isFilterRepeatBank;
    }

    static /* synthetic */ IUHFInventoryCallback access$100(SPUR4Linux sPUR4Linux) {
        return sPUR4Linux.inventoryCallback;
    }

    static /* synthetic */ void access$500(SPUR4Linux sPUR4Linux) {
        sPUR4Linux.stopCheckConnectionThread();
    }

    static /* synthetic */ LinuxUHFAndHFAPI access$600(SPUR4Linux sPUR4Linux) {
        return sPUR4Linux.linuxUHFAndHFAPI;
    }
}

