/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.interfaces.ConnectionStateCallback;
import com.rscja.deviceapi.interfaces.IUHFInventoryCallback;
import java.util.ArrayList;

public abstract class RFIDWithUHFBase
extends Device {
    protected boolean isWorking = false;

    public boolean isWorking() {
        return this.isWorking;
    }

    public String generateLockCode(ArrayList<Integer> object, int n) {
        Object object2;
        if (object == null || ((ArrayList)object).size() == 0) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 16: 
            case 32: 
            case 48: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = 0;
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            object2 = (Integer)object.next();
            switch ((Integer)object2) {
                case 16: {
                    switch (n) {
                        case 16: {
                            n2 |= 0x200;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            n2 |= 0x200;
                        }
                        case 64: {
                            n2 |= 0x100;
                            n2 |= 0x40000;
                        }
                    }
                    n2 |= 0x80000;
                    break;
                }
                case 32: {
                    switch (n) {
                        case 16: {
                            n2 |= 0x80;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            n2 |= 0x80;
                        }
                        case 64: {
                            n2 |= 0x40;
                            n2 |= 0x10000;
                        }
                    }
                    n2 |= 0x20000;
                    break;
                }
                case 48: {
                    switch (n) {
                        case 16: {
                            n2 |= 0x20;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            n2 |= 0x20;
                        }
                        case 64: {
                            n2 |= 0x10;
                            n2 |= 0x4000;
                        }
                    }
                    n2 |= 0x8000;
                    break;
                }
                case 64: {
                    switch (n) {
                        case 16: {
                            n2 |= 8;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            n2 |= 8;
                        }
                        case 64: {
                            n2 |= 4;
                            n2 |= 0x1000;
                        }
                    }
                    n2 |= 0x2000;
                    break;
                }
                case 80: {
                    switch (n) {
                        case 16: {
                            n2 |= 2;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            n2 |= 2;
                        }
                        case 64: {
                            n2 |= 1;
                            n2 |= 0x400;
                        }
                    }
                    n2 |= 0x800;
                }
            }
        }
        object = "000000";
        object2 = Integer.toHexString(n2).toUpperCase();
        if (((String)object2).length() == 6) {
            return object2;
        }
        return ((String)object).substring(((String)object2).length()) + (String)object2;
    }

    public void setConnectionStateCallback(ConnectionStateCallback connectionStateCallback) {
    }

    public void setInventoryCallback(IUHFInventoryCallback iUHFInventoryCallback) {
    }
}

