/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.db.table;

import android.database.Cursor;
import com.lidroid.xutils.db.converter.ColumnConverter;
import com.lidroid.xutils.db.converter.ColumnConverterFactory;
import com.lidroid.xutils.db.sqlite.ColumnDbType;
import com.lidroid.xutils.db.table.ColumnUtils;
import com.lidroid.xutils.util.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Column {
    protected final String columnName;
    private final Object defaultValue;
    protected final Method getMethod;
    protected final Method setMethod;
    protected final Field columnField;
    protected final ColumnConverter columnConverter;

    protected Column(Class<?> entityType, Field field) {
        this.columnField = field;
        this.columnConverter = ColumnConverterFactory.getColumnConverter(field.getType());
        this.columnName = ColumnUtils.getColumnNameByField(field);
        this.defaultValue = this.columnConverter != null ? this.columnConverter.getFieldValue(ColumnUtils.getColumnDefaultValue(field)) : null;
        this.getMethod = ColumnUtils.getColumnGetMethod(entityType, field);
        this.setMethod = ColumnUtils.getColumnSetMethod(entityType, field);
    }

    public void setValue2Entity(Object entity, Cursor cursor, int index) {
        Object value = this.columnConverter.getFieldValue(cursor, index);
        if (value == null && this.defaultValue == null) {
            return;
        }
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(entity, value == null ? this.defaultValue : value);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        } else {
            try {
                this.columnField.setAccessible(true);
                this.columnField.set(entity, value == null ? this.defaultValue : value);
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        }
    }

    public Object getColumnValue(Object entity) {
        Object fieldValue = this.getFieldValue(entity);
        return this.columnConverter.fieldValue2ColumnValue(fieldValue);
    }

    public Object getFieldValue(Object entity) {
        Object fieldValue = null;
        if (entity != null) {
            if (this.getMethod != null) {
                try {
                    fieldValue = this.getMethod.invoke(entity, new Object[0]);
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            } else {
                try {
                    this.columnField.setAccessible(true);
                    fieldValue = this.columnField.get(entity);
                }
                catch (Throwable e) {
                    LogUtils.e(e.getMessage(), e);
                }
            }
        }
        return fieldValue;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Field getColumnField() {
        return this.columnField;
    }

    public ColumnDbType getColumnDbType() {
        return this.columnConverter.getColumnDbType();
    }
}

