/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.dsig.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.XmlSort;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.xpackage.x2006.digitalSignature.CTRelationshipReference;
import org.openxmlformats.schemas.xpackage.x2006.digitalSignature.RelationshipReferenceDocument;
import org.openxmlformats.schemas.xpackage.x2006.relationships.CTRelationship;
import org.openxmlformats.schemas.xpackage.x2006.relationships.CTRelationships;
import org.openxmlformats.schemas.xpackage.x2006.relationships.RelationshipsDocument;
import org.openxmlformats.schemas.xpackage.x2006.relationships.STTargetMode;
import org.w3.x2000.x09.xmldsig.TransformDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RelationshipTransformService
extends TransformService {
    public static final String TRANSFORM_URI = "http://schemas.openxmlformats.org/package/2006/RelationshipTransform";
    private final List<String> sourceIds;
    private static final POILogger LOG = POILogFactory.getLogger(RelationshipTransformService.class);

    public RelationshipTransformService() {
        LOG.log(1, "constructor");
        this.sourceIds = new ArrayList<String>();
    }

    public static synchronized void registerDsigProvider() {
        String dsigProvider = "POIXmlDsigProvider";
        if (Security.getProperty("POIXmlDsigProvider") == null) {
            Provider p = new Provider("POIXmlDsigProvider", 1.0, "POIXmlDsigProvider"){
                static final long serialVersionUID = 1L;
            };
            p.put("TransformService.http://schemas.openxmlformats.org/package/2006/RelationshipTransform", RelationshipTransformService.class.getName());
            p.put("TransformService.http://schemas.openxmlformats.org/package/2006/RelationshipTransform MechanismType", "DOM");
            Security.addProvider(p);
        }
    }

    @Override
    public void init(TransformParameterSpec params) throws InvalidAlgorithmParameterException {
        LOG.log(1, "init(params)");
        if (!(params instanceof RelationshipTransformParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        RelationshipTransformParameterSpec relParams = (RelationshipTransformParameterSpec)params;
        for (String sourceId : relParams.sourceIds) {
            this.sourceIds.add(sourceId);
        }
    }

    @Override
    public void init(XMLStructure parent, XMLCryptoContext context) throws InvalidAlgorithmParameterException {
        LOG.log(1, "init(parent,context)");
        LOG.log(1, "parent java type: " + parent.getClass().getName());
        DOMStructure domParent = (DOMStructure)parent;
        Node parentNode = domParent.getNode();
        try {
            TransformDocument transDoc = TransformDocument.Factory.parse((Node)parentNode);
            XmlObject[] xoList = transDoc.getTransform().selectChildren(RelationshipReferenceDocument.type.getDocumentElementName());
            if (xoList.length == 0) {
                LOG.log(5, "no RelationshipReference/@SourceId parameters present");
            }
            for (XmlObject xo : xoList) {
                String sourceId = ((CTRelationshipReference)xo).getSourceId();
                LOG.log(1, (Object)"sourceId: ", sourceId);
                this.sourceIds.add(sourceId);
            }
        }
        catch (XmlException e) {
            throw new InvalidAlgorithmParameterException(e);
        }
    }

    @Override
    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        LOG.log(1, "marshallParams(parent,context)");
        DOMStructure domParent = (DOMStructure)parent;
        Element parentNode = (Element)domParent.getNode();
        Document doc = parentNode.getOwnerDocument();
        for (String sourceId : this.sourceIds) {
            RelationshipReferenceDocument relRef = RelationshipReferenceDocument.Factory.newInstance();
            relRef.addNewRelationshipReference().setSourceId(sourceId);
            Node n = relRef.getRelationshipReference().getDomNode();
            n = doc.importNode(n, true);
            parentNode.appendChild(n);
        }
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec() {
        LOG.log(1, "getParameterSpec");
        return null;
    }

    @Override
    public Data transform(Data data, XMLCryptoContext context) throws TransformException {
        RelationshipsDocument relDoc;
        LOG.log(1, "transform(data,context)");
        LOG.log(1, "data java type: " + data.getClass().getName());
        OctetStreamData octetStreamData = (OctetStreamData)data;
        LOG.log(1, "URI: " + octetStreamData.getURI());
        InputStream octetStream = octetStreamData.getOctetStream();
        try {
            relDoc = RelationshipsDocument.Factory.parse((InputStream)octetStream);
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
        LOG.log(1, (Object)"relationships document", relDoc);
        CTRelationships rels = relDoc.getRelationships();
        List relList = rels.getRelationshipList();
        Iterator relIter = rels.getRelationshipList().iterator();
        while (relIter.hasNext()) {
            CTRelationship rel = (CTRelationship)relIter.next();
            if (!this.sourceIds.contains(rel.getId())) {
                LOG.log(1, "removing element: " + rel.getId());
                relIter.remove();
                continue;
            }
            if (rel.isSetTargetMode()) continue;
            rel.setTargetMode(STTargetMode.INTERNAL);
        }
        LOG.log(1, (Object)"# Relationship elements", relList.size());
        XmlSort.sort((XmlObject)rels, new Comparator<XmlCursor>(){

            @Override
            public int compare(XmlCursor c1, XmlCursor c2) {
                String id1 = ((CTRelationship)c1.getObject()).getId();
                String id2 = ((CTRelationship)c2.getObject()).getId();
                return id1.compareTo(id2);
            }
        });
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XmlOptions xo = new XmlOptions();
            xo.setSaveNoXmlDecl();
            relDoc.save((OutputStream)bos, xo);
            return new OctetStreamData(new ByteArrayInputStream(bos.toByteArray()));
        }
        catch (IOException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    @Override
    public Data transform(Data data, XMLCryptoContext context, OutputStream os) throws TransformException {
        LOG.log(1, "transform(data,context,os)");
        return null;
    }

    @Override
    public boolean isFeatureSupported(String feature) {
        LOG.log(1, "isFeatureSupported(feature)");
        return false;
    }

    public static class RelationshipTransformParameterSpec
    implements TransformParameterSpec {
        List<String> sourceIds = new ArrayList<String>();

        public void addRelationshipReference(String relationshipId) {
            this.sourceIds.add(relationshipId);
        }

        public boolean hasSourceIds() {
            return !this.sourceIds.isEmpty();
        }
    }
}

